pkgbase=intel-media-sdk
pkgname=('intel-media-sdk' 'libmfx')
pkgver=21.2.3
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Daniel Bermond <dbermond@archlinux.org>

patch -d "MediaSDK-intel-mediasdk-${pkgver}" -Np1 -i "${srcdir}/010-intel-media-sdk-fix-reproducible-build.patch"

cmake -B build -S "MediaSDK-intel-mediasdk-${pkgver}" \
  -DBUILD_ALL:BOOL='ON' \
  -DBUILD_TOOLS:BOOL='ON' \
  -DCMAKE_BUILD_TYPE:STRING='None' \
  -DCMAKE_INSTALL_PREFIX:PATH='/usr' \
  -DCMAKE_INSTALL_LIBDIR:STRING='lib' \
  -DENABLE_ITT:BOOL='OFF' \
  -DENABLE_OPENCL:BOOL='OFF' \
  -DENABLE_WAYLAND:BOOL='ON' \
  -DENABLE_X11_DRI3:BOOL='ON' \
  -DMFX_APPS_DIR='/usr/lib/mfx' \
  -Wno-dev
make -C build

make -C build test

#package_intel-media-sdk()
pkgdir=$srcdir/../build/intel-media-sdk
make -C build DESTDIR="$pkgdir" install
ln -s mfx/samples/libcttmetrics.so "${pkgdir}/usr/lib/libcttmetrics.so"
install -D -m644 "MediaSDK-intel-mediasdk-${pkgver}/LICENSE" -t "${pkgdir}/usr/share/licenses/${pkgname}"

# remove core component libmfx
[ -d 'libmfx' ] && rm -rf libmfx
mkdir -p libmfx/{include,lib/pkgconfig}
mv "${pkgdir}/usr/include/mfx" libmfx/include
mv "${pkgdir}/usr/lib/libmfx.so"* libmfx/lib
mv "${pkgdir}/usr/lib/pkgconfig/"{,lib}mfx.pc libmfx/lib/pkgconfig
rm -d "${pkgdir}/usr/include"

#package_libmfx()
pkgdir=$srcdir/../build
mv libmfx "${pkgdir}/usr"
install -D -m644 "MediaSDK-intel-mediasdk-${pkgver}/LICENSE" -t "${pkgdir}/usr/share/licenses/${pkgname}"
