pkgbase="sqlite"
pkgname=('sqlite' 'sqlite-tcl' 'sqlite-analyzer' 'lemon' 'sqlite-doc')
_srcver=3360000
_docver=${_srcver}
#_docver=3330000
pkgver=3.36.0
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Andreas Radke <andyrtr@archlinux.org>
# and contributor Tom Newsom <Jeepster@gmx.co.uk>

cd sqlite-src-$_srcver

# patch taken from Fedora
# https://src.fedoraproject.org/rpms/sqlite/blob/master/f/sqlite.spec
patch -Np1 -i ../sqlite-lemon-system-template.patch

autoreconf -vfi

cd $srcdir
export CPPFLAGS="$CPPFLAGS \
  -DSQLITE_ENABLE_COLUMN_METADATA=1 \
  -DSQLITE_ENABLE_UNLOCK_NOTIFY \
  -DSQLITE_ENABLE_DBSTAT_VTAB=1 \
  -DSQLITE_ENABLE_FTS3_TOKENIZER=1 \
  -DSQLITE_SECURE_DELETE \
  -DSQLITE_ENABLE_STMTVTAB \
  -DSQLITE_MAX_VARIABLE_NUMBER=250000 \
  -DSQLITE_MAX_EXPR_DEPTH=10000 \
  -DSQLITE_ENABLE_MATH_FUNCTIONS"

# build sqlite
cd sqlite-src-$_srcver
./configure --prefix=/usr \
  --disable-static \
  --disable-amalgamation \
  --enable-fts3 \
  --enable-fts4 \
  --enable-fts5 \
  --enable-rtree \
  --enable-json1 \
  TCLLIBDIR=/usr/lib/sqlite$pkgver

sed -i -e 's/ -shared / -Wl,-O1,--as-needed\0/g' libtool
make
# build additional tools
make showdb showjournal showstat4 showwal sqldiff sqlite3_analyzer

cd $srcdir
cd sqlite-src-$_srcver
make DESTDIR="${pkgdir}" install

install -m755 showdb showjournal showstat4 showwal sqldiff "${pkgdir}"/usr/bin/

# install manpage
install -m755 -d "${pkgdir}"/usr/share/man/man1
install -m644 sqlite3.1 "${pkgdir}"/usr/share/man/man1/

# license - no linking required because pkgbase=pkgname
install -D -m644 "${srcdir}"/license.txt "${pkgdir}"/usr/share/licenses/${pkgbase}/license.txt

# split out tcl extension
mkdir "$srcdir"/tcl
mv "$pkgdir"/usr/lib/sqlite* "$srcdir"/tcl

cd $srcdir
pkgdir=$PWD/../build/sqlite-tcl
#package_sqlite-tcl() {
#
#pkgdesc="sqlite Tcl Extension Architecture (TEA)"
#depends=('sqlite')
#provides=("sqlite3-tcl=$pkgver")
#replaces=("sqlite3-tcl")

install -m755 -d "${pkgdir}"/usr/lib
mv "$srcdir"/tcl/* "${pkgdir}"/usr/lib

# install manpage
install -m755 -d "${pkgdir}"/usr/share/man/mann
install -m644 "${srcdir}"/sqlite-src-$_srcver/autoconf/tea/doc/sqlite3.n "${pkgdir}"/usr/share/man/mann/

# link license
install -m755 -d "${pkgdir}"/usr/share/licenses
ln -sf /usr/share/licenses/${pkgbase} "${pkgdir}/usr/share/licenses/${pkgname}"
#}

cd $srcdir
pkgdir=$PWD/../build/sqlite-analyzer
#package_sqlite-analyzer() {

#pkgdesc="An analysis program for sqlite3 database files"
#depends=('sqlite' 'tcl')

cd sqlite-src-$_srcver
install -m755 -d "${pkgdir}"/usr/bin
install -m755 sqlite3_analyzer "${pkgdir}"/usr/bin/
#}

cd $srcdir
pkgdir=$PWD/../build/lemon
#package_lemon() {

# https://www.sqlite.org/lemon.html
#pkgdesc="A parser generator"
#depends=('glibc')

#cd sqlite-src-$_srcver
# ELF file ('usr/bin/lemon') lacks FULL RELRO, check LDFLAGS. - no fix found so far
#install -Dm755 lemon ${pkgdir}/usr/bin/lemon
#install -Dm644 lempar.c ${pkgdir}/usr/share/lemon/lempar.c

#mkdir -p "${pkgdir}"/usr/share/doc/${pkgname}
#cp ../sqlite-doc-${_docver}/lemon.html  "${pkgdir}"/usr/share/doc/${pkgname}/
#install -m755 -d "${pkgdir}"/usr/share/licenses
#ln -sf /usr/share/licenses/${pkgbase} "${pkgdir}/usr/share/licenses/${pkgname}"

#}

cd $srcdir
pkgdir=$PWD/../build/sqlite-doc
#package_sqlite-doc() {

#pkgdesc="most of the static HTML files that comprise this website, including all of the SQL Syntax and the C/C++ interface specs and other miscellaneous documentation"
#arch=('any') - not yet supported
#provides=("sqlite3-doc=$pkgver")
#replaces=("sqlite3-doc")

#cd sqlite-doc-${_docver}
#mkdir -p "${pkgdir}"/usr/share/doc/${pkgbase}
#cp -R *  "${pkgdir}"/usr/share/doc/${pkgbase}/

#rm "${pkgdir}"/usr/share/doc/${pkgbase}/lemon.html
