pkgbase=aom
pkgname=aom
pkgdir=$PWD/../build
srcdir=$PWD
pkgver=3.1.1

# Borrowed from arch linux and maintainer Jan Alexander Steffens (heftig) <heftig@archlinux.org>
# and contributor Chocobo1 <chocobo1 AT archlinux DOT net>

cmake -S $pkgbase -B build -G Ninja \
  -DCMAKE_INSTALL_PREFIX=/usr \
  -DCMAKE_INSTALL_LIBDIR=lib \
  -DBUILD_SHARED_LIBS=1 \
  -DENABLE_TESTS=0
cmake --build build

# Packaging aom
DESTDIR="$pkgdir" cmake --install build

install -Dt "$pkgdir/usr/share/licenses/$pkgname" -m644 $pkgbase/{LICENSE,PATENTS}

# Packaging docs separately
mkdir -p "$pkgdir/aom-docs/usr/share/doc"
cp -r build/docs/html "$pkgdir/aom-docs/usr/share/doc/$pkgbase"

install -Dt "$pkgdir/aom-docs/usr/share/licenses/$pkgname" -m644 $pkgbase/{LICENSE,PATENTS}
