local colors = {
	{'Red', 'red', 'breakable', 'water', 'water'},
	{'Scarlet', 'red', 'normal', 'breakable', 'water'},
	{'Chocolate', '!torch', 'breakable', 'water', 'water'},
	{'Brown', '!torch', 'normal', 'breakable', 'water'},
	{'Corn', 'yellow', 'breakable', 'water', 'water'},
	{'Yellow', 'yellow', 'normal', 'breakable', 'water'},
	{'Forest Green', '!forest', 'breakable', 'normal', 'normal'},
	{'Jade', '!forest', 'water', 'breakable', 'normal'},
	{'Green', 'green', 'breakable', 'water', 'water'},
	{'Lime', 'green', 'normal', 'breakable', 'water'},
	{'Prussian Blue', '!ammo', 'breakable', 'water', 'water'},
	{'Teal', '!ammo', 'normal', 'breakable', 'water'},
	{'Cyan', 'cyan', 'breakable', 'water', 'water'},
	{'Turquoise', 'cyan', 'normal', 'breakable', 'water'},
	{'Blue', 'blue', 'breakable', 'water', 'water'},
	{'Azure', 'blue', 'normal', 'breakable', 'water'},
	{'Indigo', '!energizer', 'breakable', 'water', 'water'},
	{'Grape', '!energizer', 'normal', 'breakable', 'water'},
	{'Purple', 'purple', 'breakable', 'water', 'water'},
	{'Pink', 'purple', 'normal', 'breakable', 'water'},
	{'Iron', '!shark', 'breakable', 'water', 'water'},
	{'Gray', '!shark', 'normal', 'breakable', 'water'},
	{'White', 'white', 'normal', 'breakable', 'water'}
}

function to_label(i)
	return string.char((i - 1) + 97)
end

function emit_change(from_col, from_type, to_col, to_type, prefix)
	if to_col:sub(1,1) == '!' then
		if from_col:len() <= 0 then
			print('#'..prefix..'change ' .. from_type .. ' ' .. to_col:sub(2))
		else
			print('#'..prefix..'change ' .. from_col .. ' ' .. from_type .. ' ' .. to_col:sub(2))
		end
		print('#change ' .. to_col:sub(2) .. ' ' .. to_type)
	elseif from_col:len() <= 0 then
		print('#'..prefix..'change ' .. from_type .. ' ' .. to_col .. ' ' .. to_type)
	elseif (to_col:len() <= 0) or (from_col == to_col) then
		print('#'..prefix..'change ' .. from_col .. ' ' .. from_type .. ' ' .. to_type)
	else
		print('#'..prefix..'change ' .. from_col .. ' ' .. from_type .. ' ' .. to_col .. ' ' .. to_type)
	end
end

local mode = "body_color"
local color_loop_label = "touch"

function emit_delete_wings()
	print('#change purple invisible empty')
end

function emit_add_wings()
	print('#change cyan invisible blue invisible')
	print('#change red invisible green invisible')
end

function emit_add_horn()
	print('#change yellow invisible blue invisible')
	print('#change white invisible green invisible')
end

-- ML - mane long
-- replace body colors for pegasus/unicorn (least cost)
-- remove tail colors (least cost)

print('@Pony Maker')
print('#end')
print(':touch')
print('#zap touch')
if mode == "body_color" then
	print(':tt')
	print('What kind of pony do you want to make?')
	print('!ta;I\'d like an earth pony.')
	print('!tb;A pegasus! Flying is cool!')
	print('!tc;I choose the unicorn.')
	print('!td;GIVE ME AN ALICORN YES')
	print('/i#send tt')

	print(':td')
	print('Not one of *those* alicorn OCs, right?')
	print('!tf;I promise!')
	print('!tt;... Good point.')
	print('/i#send td')

	print(':ta')
	-- emit_delete_horn()
	emit_delete_wings()
	print('#ty')
	print(':tc')
	emit_add_horn()
	emit_delete_wings()
	print('#ty')
	print(':tf')
	emit_add_horn()
	print(':tb')
	emit_add_wings()
	print('#ty')

	print(':ty')
	print('What is your horse\'s style?')
	print('!gm;A bit more masculine.')
	print('!gf;A bit more feminine.')
	print('/i#send ty')

	print(':gf')
	print('#send Style:cf')
	print('#play i2x4x')
	print('/i/i/i/i/i/i/i#tz')
	print(':gm')
	print('#send Style:cm')
	print('#play i2x4x')
	print('/i/i/i/i/i/i/i')

	print(':tz')
	print('How long is this pony\'s mane?')
	print('!mx;Short and serene!')
	print('!ml;Long and lavish.')
	print('/i#send tz')

	print(':ml')
	print('#set ml')
	print(':mx')
	print('How long is this equine\'s tail?')
	print('!ts;Short and stunning!')
	print('!tm;About medium length, I think.')
	print('!tx;Long and luxurious.')
	print('/i#send mx')

	print(':ts')
	print('#change key empty')
	print(':tm')
	print('#change fake empty')

	print(':tx')
	print('Smile?')
	print('!wb;Big smile for me, please!')
	print('!ws;Just a little.')
	print('!wc;No way!')
	print('/i#send tx')

	print(':wb')
	print('#send Smile:cb')
	print('#play i2x4x')
	print('/i/i/i/i/i/i/i#wx')
	print(':ws')
	print('#send Smile:cs')
	print('#play i2x4x')
	print('/i/i/i/i/i/i/i#wx')
	print(':wc')
	print('#send Smile:cc')
	print(':wx')
	print('What color do you want your equine to be?')
	color_loop_label = "wx"
end
if mode == "mane_color" then
	print('What color should the mane be?')
end
if mode == "eye_color" then
	print('#change sliderew white solid')
	print('What color should the eyes be?')
end
if mode == "hat_color" then
	print('Hat?')
	print('!y;Ok.')
	print('!yn;No way!')
	print('/i#send touch')
	print(':yn')
	print('#send Hat:cn')
	print('#z')
	print(':y')
	print('#send Hat:cy')
	print('#play i2x4x2x4x2x4x')
	print('/i/i/i/i/i/i')
	print('/i/i/i/i/i/i')
	print('/i/i/i/i/i/i')
	print('/i/i/i/i/i/i')
	color_loop_label = 'y'
end
for i, color in ipairs(colors) do
	label = to_label(i)
	print('!' .. label .. ';' .. color[1] .. '.')
end
print('/i#send ' .. color_loop_label)

for i, color in ipairs(colors) do
	label = to_label(i)
	print(':' .. label)

	if mode == "body_color" then
		emit_change('blue', 'invisible', color[2], color[3], '')
		emit_change('', 'counter', color[2], color[3], '')
		emit_change('green', 'invisible', color[2], color[4], '')
		emit_change('purple', 'invisible', color[2], color[5], '')
		emit_change('', 'ricochet', color[2], color[3], 'if not ml ')
	end

	if mode == "mane_color" then
		emit_change('', 'gem', color[2], color[3], '')
		emit_change('', 'ricochet', color[2], color[4], '') -- no prefix (removed in body_color)
		emit_change('', 'key', color[2], color[4], '') -- no prefix (removed in body_color)
		emit_change('', 'fake', color[2], color[5], '') -- no prefix (removed in body_color)
	end

	if mode == "eye_color" then
		emit_change('', 'sliderns', color[2], color[3], '')
	end

	if mode == "hat_color" then
		emit_change('red', 'invisible', color[2], color[3], '')
	end

	if i < #colors then
		print('#z')
	end
end

print(':z')
print('#die')
