local colors = {
	{'Blue', 'blue'},
	{'Green', 'green'},
	{'Cyan', 'cyan'},
	{'Red', 'red'},
	{'Purple', 'purple'},
	{'Yellow', 'yellow'},
	{'White', 'white'},
}
local chars = {
	{'Alpha', 224},
	{'Ampersand', 38},
	{'Arrow (Up)', 24},
	{'Arrow (Down)', 25},
	{'Arrow (Up/Down)', 18},
	{'Arrow (Left)', 27},
	{'Arrow (Right)', 26},
	{'Arrow (Left/Right)', 29},
	{'At sign', 64},
	{'Backslash', 92},
	{'Ball', 7},
	{'Bar', 22},
	{'Beta', 225},
	{'Bomb', 11},
	{'Bullet', 248},
	{'Cent', 155},
	{'Colon', 58},
	{'Comma', 44},
	{'Dash', 43},
	{'Diamond', 4},
	{'Dollar', 36},
	{'Door', 9},
	{'Dot', 46},
	{'Dragon', 235},
	{'Energizer', 127},
	{'Equals sign', 61},
	{'Exclamation', 33},
	{'Exclamation (Double)', 19},
	{'Exclamation (Reverse)', 173},
	{'Face', 2},
	{'Face Outline', 1},
	{'Gamma', 226},
	{'Greater than sign', 60},
--	{'Half sign', 171},
	{'Hat', 94},
	{'Heart', 3},
	{'Key', 12},
	{'Less than sign', 60},
	{'Lion', 232},
	{'Note', 14},
	{'Passage', 240},
	{'Percent sign', 37},
	{'Pilcrow', 20},
	{'Plus sign', 43},
	{'Pound', 35},
	{'Pound (British)', 156},
--	{'Quarter sign', 172},
	{'Question mark', 63},
	{'Question mark (Reverse)', 168},
	{'Right angle', 28},
	{'Scroll', 232},
	{'Section', 21},
	{'Semicolon', 59},
	{'Sigma', 228},
	{'Slash', 47},
	{'Square (Small)', 249},
	{'Square (Large)', 254},
	{'Square Root', 251},
	{'Star', 15},
	{'Tiger', 227},
	{'Torch', 157},
	{'Tree', 5},
	{'Oak Tree', 6},
	{'Triangle (Up)', 30},
	{'Triangle (Down)', 31},
	{'Triangle (Left)', 17},
	{'Triangle (Right)', 16},
	{'WiL', 154}
}

function to_label(i)
	if i > 26 then
		ia = ((i - 1) % 26)
		ib = math.floor((i - 1) / 26)
		return string.char((ib - 1) + 97) .. string.char(ia + 97)
	else
		return string.char((i - 1) + 97)
	end
end

local mode = '2'

if mode == '1' then
	print('@Pony Maker')
	print('#end')
	print(':touch')
	print('#zap touch')

	print('What cutie mark shall the pony have?')

	for i, ch in ipairs(chars) do
		label = to_label(i)
		print('!' .. label .. ';' .. ch[1] .. '.')
	end
	print('/i#send touch')

	for i, ch in ipairs(chars) do
		label = to_label(i)
		print(':' .. label)
		print('#C:' .. label)

		if i < #chars then
			print('#caa')
		end
	end

	print(':caa')

	print('Which color?')

	for i, co in ipairs(colors) do
		label = to_label(i)
		print('!cb' .. label .. ';' .. co[1] .. '.')
	end
	print('/i#send z')
	

	for i, co in ipairs(colors) do
		label = to_label(i)
		print(':cb' .. label)
		if co[2] == 'blue' then
		else
			print('#change blue object ' .. co[2] .. ' object')
		end

		if i < #chars then
			print('#ccc')
		end
	end

	print(':ccc')
	print('#die')
elseif mode == '2' then
	print('@C')
	print('#end')

	for i, ch in ipairs(chars) do
		label = to_label(i)
		print(':' .. label)
		print('#char ' .. ch[2])
		print('#end')
	end
end
