pkgbase=audit
pkgname=audit
pkgdir=$PWD/../build
srcdir=$PWD
pkgver=3.0.2

# Borrowed from arch linux and maintainer Levente Polyak <anthraxx[at]archlinux[dot]org>
# and maintainer Christian Rebischke <Chris.Rebischke@archlinux.org>
# and contributor Daniel Micay <danielmicay@gmail.com>
# and contributor <kang@insecure.ws>
# and contributor Massimiliano Torromeo <massimiliano.torromeo@gmail.com>
# and contributor Connor Behan <connor.behan@gmail.com>
# and contributor henning mueller <henning@orgizm.net>

cd ${pkgbase}-${pkgver}
sed 's|/var/run/auditd.pid|/run/auditd.pid|' -i init.d/auditd.service

./configure \
  --prefix=/usr \
  --sbindir=/usr/bin \
  --sysconfdir=/etc \
  --libexecdir=/usr/lib/audit \
  --enable-gssapi-krb5=yes \
  --enable-systemd=yes \
  --with-libcap-ng=yes
make
[ -n "${SOURCE_DATE_EPOCH}" ] && touch -h -d @$SOURCE_DATE_EPOCH bindings/swig/python/audit.py

make DESTDIR="${pkgdir}" INSTALL='install -p' install

cd "${pkgdir}"
install -d -m 0700 var/log/audit
rm -rf etc/rc.d \
  etc/sysconfig \
  usr/lib/audit \
  usr/lib/python*

sed -ri 's|/sbin|/usr/bin|' \
  etc/audit/*.conf \
  etc/audit/plugins.d/*.conf \
  usr/lib/systemd/system/auditd.service

chmod 644 usr/lib/systemd/system/auditd.service

# Package python library
cd ${srcdir}
cd ${pkgbase}-${pkgver}
make -C bindings DESTDIR="${pkgdir}" INSTALL='install -p' install
