{
	Copyright (c) 2020 Adrian Siekierka

	Based on a reconstruction of code from ZZT,
	Copyright 1991 Epic MegaGames, used with permission.

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in all
	copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
	SOFTWARE.
}

unit Keys;

interface
	var
		KeysRightShiftHeld: Boolean;
		KeysLeftShiftHeld: Boolean;
		KeysShiftHeld: Boolean;
		KeysCtrlHeld: Boolean;
		KeysAltHeld: Boolean;
		KeysNumLockHeld: Boolean;
	procedure KeysUpdateModifiers;

implementation
uses Dos;

procedure KeysUpdateModifiers;
	var
		regs: Registers;
	begin
		regs.AH := $02;
		Intr($18, regs);
		KeysRightShiftHeld := false;
		KeysLeftShiftHeld := (regs.AL and 1) <> 0;
		KeysCtrlHeld := (regs.AL and 16) <> 0;
		KeysAltHeld := (regs.AL and 8) <> 0; { GRPH on PC-98 }
		KeysNumLockHeld := false;
		KeysShiftHeld := KeysRightShiftHeld or KeysLeftShiftHeld;
	end;

end.
