import type { CommonDataTypes, Script } from '../../../protocol/protocol.js';
import { ChannelProxy } from '../script/channelProxy.js';
import type { CdpTarget } from './cdpTarget.js';
/**
 * BiDi IDs are generated by the server and are unique within the context.
 *
 * CDP preload script IDs are generated by the client and are unique
 * within the session.
 *
 * The mapping between BiDi and CDP preload script IDs is 1:many.
 * BiDi IDs are needed by the mapper to keep track of potential multiple CDP IDs
 * in the client.
 */
export declare class BidiPreloadScript {
    #private;
    get id(): string;
    get contextId(): CommonDataTypes.BrowsingContext | null;
    get targetIds(): Set<string>;
    constructor(params: Script.AddPreloadScriptParameters);
    /** Channels of the preload script. */
    get channels(): ChannelProxy[];
    /**
     * Adds the script to the given CDP targets by calling the
     * `Page.addScriptToEvaluateOnNewDocument` command.
     */
    initInTargets(cdpTargets: Iterable<CdpTarget>): Promise<void>;
    /**
     * Adds the script to the given CDP target by calling the
     * `Page.addScriptToEvaluateOnNewDocument` command.
     */
    initInTarget(cdpTarget: CdpTarget): Promise<void>;
    /**
     * Schedules the script to be run right after
     * `Runtime.runIfWaitingForDebugger`, but does not wait for result.
     */
    scheduleEvaluateInTarget(cdpTarget: CdpTarget): void;
    /**
     * Removes this script from all CDP targets.
     */
    remove(): Promise<void>;
    /**
     * Removes the provided cdp target from the list of cdp preload scripts.
     */
    cdpTargetIsGone(cdpTargetId: string): void;
}
