
{ This program is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
Use this software AT YOUR OWN RISK. }

{ Level Editor for game Ra, (c) 1997 by George M. Tzoumas }
program Level_Editor; { LED.PAS }

uses Crt, Graph, Advanced, Keyb2;

const

{ Graphics Images  (16x16) }
  Blank = 0;
  Block = 1;
  Block_Fork_Left  = 2;
  Block_Fork_Right = 3;
  ArtBlock1 = 4;
  ArtBlock2 = 5;
  AKey = 6;
  AKeyHole = 7;
  ADiamond = 8;
  ABall = 9;

var
   gd, gm: Integer;
   ch, cf: Char;
   Matrix: Array[0..19, 0..11] of Byte;
   Images: Array[0..9] of Pointer;
   FocusC, UnFocusC: Word;
   ci : Byte; { current image }
   bi : Byte; { blank image }
   cx, cy: Byte;

procedure InitGraphics;
begin
  gd := Cga;
  gm := CgaC3;
  InitGraph(gd, gm, '');
  FocusC := 3;
  UnFocusC := 0;
end;

procedure LoadGraphics;
begin
  Bload('BLOCK2', Images[Blank]);
  Bload('BLOCK1', Images[Block]);
  Bload('BRFL', Images[Block_Fork_Left]);
  Bload('BRFR', Images[Block_Fork_Right]);
  Bload('ART1', Images[ArtBlock1]);
  Bload('ART2', Images[ArtBlock2]);
  Bload('KEY', Images[AKey]);
  Bload('KEYHOLE', Images[AKeyHole]);
  Bload('DIAMOND', Images[ADiamond]);
  Bload('BALL', Images[ABall]);
end;

procedure DrawCell(x, y, pic: Byte);
begin
  PutImage(x shl 4, y shl 4, Images[pic]^, CopyPut);
end;

procedure FocusCell(x, y: Byte);
var sx, sy : word;
begin
  DrawCell(x,y, ci);
  sx := x shl 4;
  sy := y shl 4;
  SetColor(FocusC);
  Rectangle(sx, sy, sx + 15, sy + 15);
end;

procedure UnFocusCell(x, y: Byte);
begin
{  sx := x shl 4;
  sy := y shl 4;
  SetColor(UnFocusC);
  Rectangle(sx, sy, sx + 15, sy + 15);}
  DrawCell(x, y, Matrix[x, y]);
end;

procedure DrawLevel;
var i, j: byte;
begin
  for j:=0 to 11 do for i:=0 to 19 do DrawCell(i, j, Matrix[i, j]);
  FocusCell(cx, cy);
end;

procedure SaveAs;
var f : file;
    fn: string;
begin
  RestoreCrtMode;
  write('Enter file name to save : ');
  readln(fn);
  assign(f, fn);
  rewrite(f, 1);
  blockwrite(f, Matrix, sizeof(Matrix));
  close(f);
  SetGraphMode(GetGraphMode);
  DrawLevel;
end;

procedure Load;
var f : file;
    fn: string;
begin
  RestoreCrtMode;
  write('Enter file name to load : ');
  readln(fn);
  assign(f, fn);
  reset(f, 1);
  blockread(f, Matrix, sizeof(Matrix));
  close(f);
  SetGraphMode(GetGraphMode);
  DrawLevel;
end;

procedure ClearLevel;
begin
  FillChar(Matrix, SizeOf(Matrix), 0);
  ClearDevice;
  FocusCell(cx, cy);
end;

procedure RandomLevel;
var i: byte;
begin
  for i:= 0 to 19 do Matrix[i,11] := Block;
  for i:= 0 to 40 do Matrix[Random(20), Random(12)] := Block;
  for i:= 0 to 5 do Matrix[Random(20), Random(12)] := ArtBlock1;
  for i:= 0 to 5 do Matrix[Random(20), Random(12)] := ArtBlock2;
  for i:= 0 to 5 do Matrix[Random(20), Random(12)] := ADiamond;
  Matrix[Random(20), Random(12)] := AKey;
  Matrix[0,0] := Blank;
  DrawLevel;
end;

begin
  InitGraphics;
  LoadGraphics;
  Randomize;
  FillChar(Matrix, SizeOf(Matrix), 0);
  cx :=0;
  cy :=0;
  ci := 1;
  bi := 0;
  FocusCell(cx, cy);
  repeat
    ch := readkey;
    if Caps_Lock then Matrix[cx, cy]:=ci;
    case ch of
    #32: Matrix[cx, cy]:=ci;
    #13: Matrix[cx, cy]:=bi;
    '+': if ci<9 then inc(ci) else ci:=1;
    '-': if ci>1 then dec(ci) else ci:=9;
    #12: ClearLevel;
    #00: begin
           cf := readkey;
           if cf in [#72..#80] then UnFocusCell(cx, cy);
           case cf of
           #75: if cx>0 then Dec(cx);
           #77: if cx<19 then Inc(cx);
           #80: if cy<11 then Inc(cy);
           #72: if cy>0 then Dec(cy);
           #60: SaveAs;
           #61: Load;
           #19: RandomLevel;
           end;
           if cf in [#72..#80] then FocusCell(cx, cy);
         end;
    end;
    if ch in ['+', '-'] then FocusCell(cx, cy);
  until ch = #27;
  CloseGraph
end.
