pkgname=tracer
pkgdir=$PWD/../build
srcdir=$PWD
pkgver=1.0

# Apply patches
cd trace-archiver
# No patches!
cd ..

# Build the 'uberjar'
cd trace-archiver/portals-crawler
mvn clean package -o || exit 1
mkdir -p $pkgdir/usr/share/tracer/target
cp target/stormcapture-0.2.jar $pkgdir/usr/share/tracer/target/stormcapture-0.2.jar
cd $srcdir

# Copy over needed files from the repository
cp -r trace-archiver/certs $pkgdir/usr/share/tracer/certs
cp -r trace-archiver/mysql $pkgdir/usr/share/tracer/mysql
cp -r trace-archiver/traces $pkgdir/usr/share/tracer/traces

# Remove all lines starting with '//' from tablesetup.sql
sed "s;^//.*;;" -i $pkgdir/usr/share/tracer/mysql/tablesetup.sql

# Copy over plain scripts
mkdir -p $pkgdir/usr/bin
cp run.sh $pkgdir/run.sh
cp tracer $pkgdir/usr/bin/tracer
cp schema.json $pkgdir/schema.json
cp wilkie.how.json $pkgdir/usr/share/tracer/.

# Copy configuration yaml file
cp crawler-conf.yaml $pkgdir/usr/share/tracer/crawler-conf.yaml
