/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// EVENTS - (C)1997  Nicosot (Valentini Domenico)

#include "std.hpp"
#include "events.hpp"
#include "fixed.h"

//#include "mm2.hpp"
#include "kaos.hpp"
#include "objects.hpp"	// solo per senddirect

char EventManager::get(TEvent &event) {
	if (num) {	// ready()
		event = eventlist[head];
		if (++head >= MAXEVENTS) head = 0;
		num--;
		return 1;
	}
	return 0;
};

char EventManager::put(TEvent &event) {
	if (num < MAXEVENTS) {
		register int idx;
		if ((idx = head+(num++)) >= MAXEVENTS) idx -= MAXEVENTS;
		eventlist[idx] = event;
		return 1;
	} // error("EventManager::put - overflow");
	return 0;
}

char EventManager::send(unsigned what, unsigned sorg,
						unsigned dest, int x, int y, int z,
						int a, int b) {
	TEvent evnt;
	evnt.what = what;
	evnt.source = sorg;
	evnt.data.msg.dest = dest;
	evnt.data.msg.x = x;
	evnt.data.msg.y = y;
	evnt.data.msg.z = z;
	evnt.data.msg.d1 = a;
	evnt.data.msg.d2 = b;
	return put(evnt);
}

char EventManager::sendshort(unsigned what, unsigned sorg,
							 unsigned dest, int x, int y) {
	TEvent evnt;
	evnt.what = what;
	evnt.source = sorg;
	evnt.data.msg.dest = dest;
	evnt.data.msg.x = x;
	evnt.data.msg.y = y;
	return put(evnt);
}

char EventManager::senddirect(unsigned what, unsigned sorg,
							  unsigned dest, int x, int y) {
	Object *obj = objectslist.get(dest);
	if (obj) {
		TEvent evnt;
		evnt.what = what;
		evnt.source = sorg;
		evnt.data.msg.dest = dest;
		evnt.data.msg.x = x;
		evnt.data.msg.y = y;
		//evnt.data.msg.z = z;
		obj->handle_event(evnt);
		return 1;
	} else return 0;
}

char EventManager::sendcom(unsigned what, unsigned sorg) {
	TEvent evnt;
	evnt.what = what;
	evnt.source = sorg;
	return put(evnt);
}

char EventManager::sendpos(unsigned what, unsigned sorg,
						   long x, long y, long z) {
	TEvent evnt;
	evnt.what = what;
	evnt.source = sorg;
	evnt.data.pos.x = x;
	evnt.data.pos.y = y;
	evnt.data.pos.z = z;
	return put(evnt);
}

EventManager eventmanager;