/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

#ifndef	__EVENTS__
#define __EVENTS__

#define MAXEVENTS       64

// Events:
/*
	Bit 7: 0 - system;
		   1 - broadcast;
	Bit 6: 0 - to all objects;
		   1 - only actors;
*/
// ***** System Events
#define EV_ACKTAKE		0x01 	// !!! WARNING !!!
#define	EV_ERASEACT		0x02   	// !!! NON deve mai essere >= 64
								// altrim. actorslist.erase in .animate !
								// NUOVA MODIFICA !
#define EV_UPDATEBAR	0x03	// con parametri
#define	EV_DEAD			0x04	// ???  davvero un system ???
#define	EV_RESURRECT	0x05	// non serve praticamente a niente...
#define	EV_ENDPLAYBACK	0x06	// ferma il gioco, subito !
#define	EV_CHGTEXTURE	0x07
#define	EV_ANTIKAOS		0x08	// ferma il Kaos countdown
#define EV_MESSAGE		0x09	// command: <n> = numero del messaggio
// ***** Direct Events
#define	EV_HIT			0x21   	// !!! WARNING !!!
								// Il Barile chiama MakeActor mentre si
								// esegue l'actorslist.handleevent !!!
#define	EV_GET			0x22
#define	EV_GOT			0x23
#define	EV_ADDSTAT		0x24	// x = type, y = num
#define	EV_ENDSOUND		0x25	// solo id
#define	EV_POISON		0x26	// ...come EV_HIT
#define	EV_ALERT		0x27	// sistema di avvertimento per Soldier
								// puntato da missile
// ***** Broadcast Object-Oriented Events
#define	EV_KILL			0x81
#define	EV_ACTIVATE		0x82
#define EV_PLACTIVATE	0x83
#define EV_SCODE		0x84
#define EV_BOOM			0x85
#define	EV_PLKILLED		0x86	// player ucciso da (dest)
#define EV_PLNOISE		0x87	// player (sorg) ha fatto rumore
// ***** Broadcast Actor-Oriented Events
#define EV_REQTAKE		0xC1

/*
NOTA:
tutti i messaggi spediti da un oggetto arrivano prima della sua morte,
anch'essa gestita da questa coda di eventi.
*/

typedef struct {                                    // 16=
			unsigned what;							//  2+
			int source;                             //  2+
			union {                                 // 12+
				struct {
					int dest, x, y, z, d1, d2;
				} msg;
				struct {
					long x, y, z;
				} pos;
			} data;
		} TEvent;

class EventManager
{
		TEvent eventlist[MAXEVENTS];
		unsigned char head, num;
	public:
		EventManager() { flush(); };
		char ready() { return num; };
		char get(TEvent &event);
		char put(TEvent &event);
		char send(unsigned what, unsigned sorg,
				  unsigned dest, int x, int y, int z,
				  int a, int b);
		char sendshort(unsigned what, unsigned sorg,
					   unsigned dest, int x, int y);
		char senddirect(unsigned what, unsigned sorg,
						unsigned dest, int x, int y);
		char sendcom(unsigned what, unsigned sorg);
		char sendpos(unsigned what, unsigned sorg,
					 long x, long y, long z);
		void flush() { head = 0; num = 0; };
};

extern EventManager eventmanager;

#endif	// __EVENTS__