/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// FASTMEM - (C)1997  Nicosot (Valentini Domenico)
// very very very fast memory tranfer routines

#include "std.hpp"

// Moves forward bytes
void fmove(void far *dest, void far *sorg, word bytes) {
asm {
	LDS SI, sorg
	LES DI, dest
	MOV CX, bytes
	CLD
	REP MOVSB
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
}}

// Moves forward words
void fwmove(void far *dest, void far *sorg, word bytes) {
asm {
	LDS SI, sorg
	LES DI, dest
	CLD
	MOV CX, bytes
	SHR CX, 1
	JNC _fmov
	MOVSB
} _fmov: asm {
	REP MOVSW
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
}}

// Moves forward dwords
void fdmove(void far *dest, void far *sorg, word bytes) {
asm {
	LDS SI, sorg
	LES DI, dest
	CLD
	MOV CX, bytes
	SHR CX, 1
	JNC _fgo2
	MOVSB
} _fgo2: asm {
	SHR CX, 1
	JNC _fmov
	MOVSW
} _fmov: asm {
	REP
	 DB 0x66; MOVSW
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
}}

// Fast Omnidirectional word move
void fowmove(void far *dest, void far *sorg, word bytes) {
// if (dest == sorg || !bytes) return;
if (!bytes) return;
if (dest < sorg) {
	asm {
		LDS SI, sorg
		LES DI, dest
		CLD
		MOV CX, bytes
		SHR CX, 1
		JNC _fcpy
		MOVSB
	} _fcpy: asm {
		REP MOVSW
		// !!! SS==DS !!!
		MOV BX, SS
		MOV DS, BX
	}
} else {
	asm {
		LDS SI, sorg
		LES DI, dest
		STD
		MOV CX, bytes
		ADD SI, CX
		DEC SI
		ADD DI, CX
		DEC DI
		SHR CX, 1
		JNC _bcpy
		MOVSB
	} _bcpy: asm {
		DEC SI
		DEC DI
		REP MOVSW
		CLD
		// !!! SS==DS !!!
		MOV BX, SS
		MOV DS, BX
	}
}}

// Fast Omnidirectional dword move
void fodmove(void far *dest, void far *sorg, word bytes) {
// if (dest == sorg || !bytes) return;
if (!bytes) return;
if (dest < sorg) {
	asm {
		LDS SI, sorg
		LES DI, dest
		CLD
		MOV CX, bytes
		SHR CX, 1
		JNC _fgo2
		MOVSB
	} _fgo2: asm {
		SHR CX, 1
		JNC _fcpy
		MOVSW
	} _fcpy: asm {
		REP
		DB 0x66; MOVSW
		// !!! SS==DS !!!
		MOV BX, SS
		MOV DS, BX
	}
} else {
	asm {
		LDS SI, sorg
		LES DI, dest
		STD
		MOV CX, bytes
		ADD SI, CX
		DEC SI
		ADD DI, CX
		DEC DI
		SHR CX, 1
		JNC _bgo2
		MOVSB
	} _bgo2: asm {
		SHR CX, 1
		JNC _bcpy
		DEC SI
		DEC DI
		MOVSW
		INC SI
		INC DI
	} _bcpy: asm {
		DEC SI
		DEC SI
		DEC SI
		DEC DI
		DEC DI
		DEC DI
		REP
		 DB 0x66; MOVSW
		CLD
		// !!! SS==DS !!!
		MOV BX, SS
		MOV DS, BX
	}
}}

// fills forward words
void fwfill(void far *dest, word val, word bytes) {
asm {
	LES DI, dest
	MOV AX, val
	CLD
	MOV CX, bytes
	SHR CX, 1
	JNC _fsto
	STOSB
} _fsto: asm {
	REP STOSW
}}

// fills forward dwords
void fdfill(void far *dest, long val, word bytes) {
asm {
	LES DI, dest
	DB 0x66; MOV AX, WORD PTR val	// MOV EAX, val
	CLD
	MOV CX, bytes
	SHR CX, 1
	JNC _fgo2
	STOSB
} _fgo2: asm {
	SHR CX, 1
	JNC _fsto
	STOSW
} _fsto: asm {
	REP
	DB 0x66; STOSW			// STOSD
}}

#pragma warn -rvl
char fwcomp(void far *s1, void far *s2, word len) {
asm {
	//PUSH DS
	LDS SI, s1
	LES DI, s2
	XOR AL, AL
	CLD
	MOV CX, len
	SHR CX, 1
	JNC wor
	CMPSB
	JNE end
} wor: asm {
	REP CMPSW
	JNE end
	INC AL
} end: asm {
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
	//POP DS
} /*return _AL;*/ }

char fdcomp(void far *s1, void far *s2, word len) {
asm {
	//PUSH DS
	LDS SI, s1
	LES DI, s2
	XOR AL, AL
	CLD
	MOV CX, len
	SHR CX, 1
	JNC wor2
	CMPSB
	JNE end
} wor2: asm {
	SHR CX, 1
	JNC wor
	CMPSW
	JNE end
} wor: asm {
	REP
	DB 0x66; CMPSW
	JNE end
	INC AL
} end: asm {
	// !!! SS==DS !!!
	MOV BX, SS
	MOV DS, BX
	//POP DS
} /*return _AL;*/ }
#pragma warn +rvl