/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

#include "fixed.h"

// pu servire ?
// #pragma inline

#pragma warn -rvl

long lshr6(long x) {
asm {
	MOV AX, WORD PTR x
	MOV DX, WORD PTR x[2]
	SHR AX, 6
	MOV BL, DL
	SHL BL, 2
	OR AH, BL
	SAR DX, 6	// SAR... ma il numero serve positivo !
}}

long lshl6(long x) {
asm {
	MOV AX, WORD PTR x
	MOV DX, WORD PTR x[2]
	SHL DX, 6
	MOV BL, AH
	SHR BL, 2
	OR DL, BL
	SHL AX, 6
}}

long lshr8(long x) {
asm {
	MOV AX, WORD PTR x
	MOV DX, WORD PTR x[2]
	MOV AL, AH
	MOV AH, DL
	MOV DL, DH
	XOR DH, DH
	TEST DL, 0x80
	JZ fine
	NOT DH
} fine:; }

long lshl8(long x) {
asm {
	MOV AX, WORD PTR x
	MOV DX, WORD PTR x[2]
	MOV DH, DL
	MOV DL, AH
	MOV AH, AL
	XOR AL, AL
}}

int lshr16(fixed x) {
asm MOV AX, WORD PTR x[2]
}

fixed lshl16(int x) {
asm {
	MOV DX, x
	XOR AX, AX
}}

#pragma warn -par
//	A Nicosoft's hack !  (It will be only one !)
fixed fixmul(fixed a, fixed b) {
asm {
	DB 0x66; DB 0x8B; DB 0x46; DB 0x06				// MOV EAX, [BP+6]
	DB 0x66; DB 0xF7; DB 0x6E; DB 0x0A 				// IMUL [BP+10]
   DB 0x66; DB 0x05; DB 0x00; DB 0x80; DB 0x00; DB 0x00 // ADD EAX, 0x8000
   ADC DX, 0
   //DB 0x66; DB 0x83; DB 0xD2; DB 0x00				// ADC EDX, 0
	DB 0x66; DB 0x0F; DB 0xAC; DB 0xD0; DB 0x10		// SHRD EAX, EDX, 16
	DB 0x66; DB 0x8B; DB 0xD0		 				// MOV EDX, EAX
	DB 0x66; DB 0xC1; DB 0xEA; DB 0x10				// SHR EDX, 16
} }

//	A Nicosoft's hack !  (It will be only one !)
fixed fixdiv(fixed a, fixed b) {
asm {
	DB 0x66; DB 0x8B; DB 0x46; DB 0x06	// MOV EAX, a
	DB 0x66; DB 0x99                   	// CDQ
	DB 0x66; DB 0xF7; DB 0x7E; DB 0x0A 	// IDIV b
	DB 0x66; DB 0x8B; DB 0xD0          	// MOV EDX, EAX
	DB 0x66; DB 0xC1; DB 0xEA; DB 0x10 	// SHR EDX, 16
}}

//	A Nicosoft's hack !  (It will be only one !)
fixed fixdiv64(fixed a_l,fixed a_h, fixed b) {
asm {
	DB 0x66; DB 0x8B; DB 0x46; DB 0x06	// MOV EAX, a_l
	DB 0x66; DB 0x8B; DB 0x56; DB 0x0A	// MOV EDX, a_h
	DB 0x66; DB 0xF7; DB 0x7E; DB 0x0E 	// IDIV b
	DB 0x66; DB 0x8B; DB 0xD0          	// MOV EDX, EAX
	DB 0x66; DB 0xC1; DB 0xEA; DB 0x10 	// SHR EDX, 16
}}

//	A Nicosoft's hack !  (It will be only one !)
fixed fixdiv64shl16(fixed a, fixed b) {
asm {
	DB 0x66; DB 0x8B; DB 0x46; DB 0x06	// MOV EAX, a
	DB 0x66; DB 0x99                   	// CDQ
	DB 0x66; DB 0x0F; DB 0xA4; DB 0xC2; DB 0x10		// SHLD EDX, EAX, 16
	DB 0x66; DB 0xF7; DB 0x7E; DB 0x0A 	// IDIV b
	DB 0x66; DB 0x8B; DB 0xD0          	// MOV EDX, EAX
	DB 0x66; DB 0xC1; DB 0xEA; DB 0x10 	// SHR EDX, 16
}}

//	A Nicosoft's hack !  (It will be only one ! OOOOOhhh )
fixed fixmuldiv64(fixed a, fixed b, fixed c) {
asm {
	// a*b
	DB 0x66; DB 0x8B; DB 0x46; DB 0x06				// MOV EAX, [BP+6]
	DB 0x66; DB 0xF7; DB 0x6E; DB 0x0A 				// IMUL [BP+10]
   DB 0x66; DB 0x05; DB 0x00; DB 0x80; DB 0x00; DB 0x00 // ADD EAX, 0x8000
   DB 0x66; DB 0x83; DB 0xD2; DB 0x00				// ADC EDX, 0
	// /c
	DB 0x66; DB 0xF7; DB 0x7E; DB 0x0e 	// IDIV c
	DB 0x66; DB 0x8B; DB 0xD0          	// MOV EDX, EAX
	DB 0x66; DB 0xC1; DB 0xEA; DB 0x10 	// SHR EDX, 16
}}

fixed fixsqrt(fixed a) {
asm {
	DB 0x66; MOV CX, WORD PTR a        		// MOV ECX, a
	DB 0x66; XOR AX, AX						// XOR EAX, EAX
	DB 0x66; MOV BX, 0x0000; DW 0x4000  	// MOV EBX, 0x40000000l
} sq1: asm {
	DB 0x66; MOV DX, CX						// MOV EDX, ECX
	DB 0x66; SUB DX, BX						// SUB EDX, EBX
	JB sq2
	DB 0x66; SUB DX, AX						// SUB EDX, EAX
	JB sq2
	DB 0x66; MOV CX, DX						// MOV ECX, EDX
	DB 0x66; SHR AX, 1						// SHR EAX, 1
	DB 0x66; OR AX, BX						// OR EAX, EBX
	DB 0x66; SHR BX, 2						// SHR EBX, 2
	JNZ sq1
	JZ sq5
} sq2: asm {
	DB 0x66; SHR AX, 1                      // SHR EAX, 1
	DB 0x66; SHR BX, 2						// SHR EBX, 2
	JNZ sq1
} sq5: asm {
	DB 0x66; MOV BX, 0x4000; DW 0x0000      // MOV EBX, 0x00004000l
	DB 0x66; SHL AX, 16                     // SHL EAX, 16
	DB 0x66; SHL CX, 16						// SHL ECX, 16
} sq3: asm {
	DB 0x66; MOV DX, CX						// MOV EDX, ECX
	DB 0x66; MOV DX, BX						// MOV EDX, EBX
	JB sq4
	DB 0x66; SUB DX, AX						// SUB EDX, EAX
	JB sq4
	DB 0x66; MOV CX, DX						// MOV ECX, EDX
	DB 0x66; SHR AX, 1						// SHR EAX, 1
	DB 0x66; OR AX, BX						// OR EAX, EBX
	DB 0x66; SHR BX, 2						// SHR EBX, 2
	JNZ sq3
	//DB 0x66; SHR AX, 1						// SHR EAX, 1
	JMP sq6
} sq4: asm {
	DB 0x66; SHR AX, 1						// SHR EAX, 1
	DB 0x66; SHR BX, 2						// SHR EBX, 2
	JNZ sq3
	//DB 0x66; SHR AX, 1						// SHR EAX, 1
} sq6: asm {
	DB 0x66; MOV DX, AX						// MOV EDX, EAX
	DB 0x66; SHR DX, 16						// SHR EDX, 16
}}

fixed fixdist(fixed dex, fixed dey) {
	if (LABS(dex)>255l<<16) dex=255l<<16;
	if (LABS(dey)>255l<<16) dey=255l<<16;
asm {
	// dex**2
	DB 0x66; MOV AX, WORD PTR dex			// MOV EAX, dx
	DB 0x66; IMUL AX						// IMUL EAX
   DB 0x66; DB 0x05; DB 0x00; DB 0x80; DB 0x00; DB 0x00 // ADD EAX, 0x8000
   DB 0x66; DB 0x83; DB 0xD2; DB 0x00				// ADC EDX, 0
	DB 0x66; DB 0x0F; DB 0xAC; DB 0xD0; DB 0x10		// SHRD EAX, EDX, 16
	// dey**2
	DB 0x66; MOV CX, AX						// MOV EBX, EAX
	DB 0x66; MOV AX, WORD PTR dey			// MOV EAX, dy
	DB 0x66; IMUL AX						// IMUL EAX
   DB 0x66; DB 0x05; DB 0x00; DB 0x80; DB 0x00; DB 0x00 // ADD EAX, 0x8000
   DB 0x66; DB 0x83; DB 0xD2; DB 0x00				// ADC EDX, 0
	DB 0x66; DB 0x0F; DB 0xAC; DB 0xD0; DB 0x10		// SHRD EAX, EDX, 16
	// ECX = dex**2 + dey**2
	DB 0x66; ADD CX, AX						// ADD ECX, EAX
	JNC calc
	DB 0x66; MOV CX, 0xffff; DW 0x7fff		// MOV ECX, 0x7fffffffl
	JMP sq6
} calc: asm {
	DB 0x66; XOR AX, AX						// XOR EAX, EAX
	DB 0x66; MOV BX, 0x0000; DW 0x4000  	// MOV EBX, 0x40000000l
} sq1: asm {
	DB 0x66; MOV DX, CX						// MOV EDX, ECX
	DB 0x66; SUB DX, BX						// SUB EDX, EBX
	JB sq2
	DB 0x66; SUB DX, AX						// SUB EDX, EAX
	JB sq2
	DB 0x66; MOV CX, DX						// MOV ECX, EDX
	DB 0x66; SHR AX, 1						// SHR EAX, 1
	DB 0x66; OR AX, BX						// OR EAX, EBX
	DB 0x66; SHR BX, 2						// SHR EBX, 2
	JNZ sq1
	JMP sq5
} sq2: asm {
	DB 0x66; SHR AX, 1                      // SHR EAX, 1
	DB 0x66; SHR BX, 2						// SHR EBX, 2
	JNZ sq1
} sq5: asm {
	DB 0x66; MOV BX, 0x4000; DW 0x0000      // MOV EBX, 0x00004000l
	DB 0x66; SHL AX, 16                     // SHL EAX, 16
	DB 0x66; SHL CX, 16						// SHL ECX, 16
} sq3: asm {
	DB 0x66; MOV DX, CX						// MOV EDX, ECX
	DB 0x66; MOV DX, BX						// MOV EDX, EBX
	JB sq4
	DB 0x66; SUB DX, AX						// SUB EDX, EAX
	JB sq4
	DB 0x66; MOV CX, DX						// MOV ECX, EDX
	DB 0x66; SHR AX, 1						// SHR EAX, 1
	DB 0x66; OR AX, BX						// OR EAX, EBX
	DB 0x66; SHR BX, 2						// SHR EBX, 2
	JNZ sq3
	//DB 0x66; SHR AX, 1						// SHR EAX, 1
	JMP sq6
} sq4: asm {
	DB 0x66; SHR AX, 1						// SHR EAX, 1
	DB 0x66; SHR BX, 2						// SHR EBX, 2
	JNZ sq3
	//DB 0x66; SHR AX, 1						// SHR EAX, 1
} sq6: asm {
	DB 0x66; MOV DX, AX						// MOV EDX, EAX
	DB 0x66; SHR DX, 16						// SHR EDX, 16
}}

int intdist(int dex, int dey) {
	if (ABS(dex)>255l) dex=255l;
	if (ABS(dey)>255l) dey=255l;
asm {
			 MOV AX, dex
	DB 0x66; CBW
	DB 0x66; IMUL AX
	DB 0x66; MOV CX, AX
			 MOV AX, dey
	DB 0x66; CBW
	DB 0x66; IMUL AX
	DB 0x66; ADD CX, AX

	DB 0x66; XOR AX, AX						// XOR EAX, EAX
	DB 0x66; MOV BX, 0x0000; DW 0x4000      // MOV EBX, 0x4000000l
} sq1: asm {
	DB 0x66; MOV DX, CX
	DB 0x66; SUB DX, BX
	JL sq2
	DB 0x66; SUB DX, AX
	JL sq2
	DB 0x66; MOV CX, DX
	DB 0x66; SHR AX, 1
	DB 0x66; OR AX, BX
	DB 0x66; SHR BX, 2
	JNZ sq1
	//DB 0x66; SHL AX, 7
	JMP sq3
} sq2: asm {
	DB 0x66; SHR AX, 1
	DB 0x66; SHR BX, 2
	JNZ sq1
	//DB 0x66; SHL AX, 7
} sq3:; }
#pragma warn +par

#pragma warn +rvl
