/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// KEY - (C)1997  Nicosot (Valentini Domenico)

#include <dos.h>
#include <conio.h>
#include "std.hpp"
#include "fastmem.hpp"
#include "key.hpp"

char Key[129], CodeAr[6];
static char KeyP[129];
const char TMat[50] = "1234567890    QWERTYUIOP    ASDFGHJKL     ZXCVBNM";
static void interrupt (*oldhandler)(...);
char key_installed = 0,
	 key_pause = 0,
	 key_extended = 0,
	 oldcall = 0;

static void interrupt newkeyISR(...) {
	register word data, scan, x;
	scan = (data = inportb(0x60)) & 0x7F;
	outportb(0x61,(x=inportb(0x61))|0x80);
	outportb(0x61,x);
	if (data==0xe1) key_pause=1; else
	if (data==0xe0) key_extended=1; else {
		KeyP[scan] |= Key[scan] = (data<128);
		/*
		if (scan==KB_LSHIFT || scan==KB_RSHIFT)
			Key[KB_SHIFT] = Key[KB_LSHIFT]|Key[KB_RSHIFT];
		*/
		if (data!=KB_F4 && data<51 && data>=2) {
			for (x=0; x<5; x++) CodeAr[x] = CodeAr[x+1]-1;
			CodeAr[5] = TMat[data-2]+5;
		}
		key_extended=0;
	}
	if (oldcall)
		oldhandler();
	else
		outportb(0x20,0x20);
}

char kb_pressed(byte c) {
	if (c) {
		char press = KeyP[c] | Key[c];
		KeyP[c] = 0;
		return press;
	}
	return 0;
}

char kb_onepressed(byte c) {
	char press = KeyP[c];
	KeyP[c] = 0;
	return press;
}

void kb_presskey(byte c) {
	if (c<128) {
		KeyP[c]=Key[c]=1;
	}
}

void kb_releasekey(byte c) {
	if (c<128) {
		Key[c]=0;
	}
}

void kb_reset() {
	fwfill(Key,0,sizeof(Key));
	fwfill(KeyP,0,sizeof(KeyP));
	if (oldcall)
		while(kbhit()) getch();
}

void kb_initkey() {
	if (key_installed) return;
	key_installed++;
	oldcall=0;
	disable();
	oldhandler = getvect(0x09);
	setvect(0x09, newkeyISR);
	enable();
	kb_reset();
	// Rallenta la tastiera (cos diminuiscono le interruzioni)
	asm {
		MOV AX, 0x0305
		MOV BX, 0x031f
		INT 0x16
	}
}

void kb_enablestd() {
	if (key_installed && !oldcall) {
		oldcall=1;
		kb_reset();
	}
}

void kb_disablestd() {
	if (key_installed && oldcall) {
		oldcall=0;
		kb_reset();
	}
}

void kb_donekey(void) {
	if (!key_installed) return;
	key_installed--;
	disable();
	setvect(0x09, oldhandler);
	enable();
	//oldcall=1;
	// Respeed-up ...
	asm {
		MOV AX, 0x0305
		MOV BX, 0x0000
		INT 0x16
	}
}

#pragma exit kb_donekey 100