/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

#define	FIRSTCHAR	(unsigned char)'!'
#define	LASTCHAR	(unsigned char)''
#define	NUMCHAR		(LASTCHAR-FIRSTCHAR+1)

typedef struct {
			byte dx, dy;
			char far *data;
		} TCharFig;

typedef	TCharFig TAlphabet[NUMCHAR];

class Font
{
		TAlphabet font;
		unsigned char height, spacelen;
		char displx, disply;
		/*
		void scanlen(unsigned sorg, int x, int y, int dx, int dy,
					 int *rdx, int *rdy);
		*/
		int charidx(unsigned char c);
	public:
		Font(unsigned char h = 1, unsigned char slen = 1,
			 char dx = 0, char dy = 0)
			 : height(h), spacelen(slen), displx(dx), disply(dy)
				{ fdfill(font,0l,sizeof font); };
		Font(const char *filename);
		void setspacelen(unsigned char splen)
			{ spacelen = splen; };
		void setdispl(char dx, char dy)
			{ displx = dx; disply = dy; };
		void getcharfig(char c, int x, int y, int mdx, int mdy);
		void freechar(char idx);
		void write(int x, int y, char col1, char col2, const char *str);
		void writeclip(int x, int y, char col1, char col2, const char *str);
		void colorwrite(int x, int y, byte shade, const char *str);
		int writelen(const char *str);
		/*
		void writeclip(unsigned dest, int x, int y,
					char col1, char col2,
					unsigned maxlen, char center, const char *str);
		*/
		void save(const char *filename);
		void packdata();
		void unpackdata();
		~Font();
};