/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// LMOUSE.CPP (LMode Mouse Engine) - (C)1997  NicoSot (Valentini Domenico)

#include "std.hpp"
#include "lgraph.hpp"
#include "lmouse.hpp"

Mouse mouse;

byte mousedata[9] = {  0, 255,   0,
					 255, 255, 255,
					   0, 255,   0};
byte underdata[9];

void far _saveregs _loadds mousehandler() {
	byte action = _AL;
	int newx = _CX >> 1,
		newy = _DX;
	byte buts = _BL;

	if (action & MA_MOVES) {
		mouse.undraw();
		mouse.refresh(newx,newy,buts);
		mouse.draw();
	} else mouse.buttons = buts;
}

void Mouse::getmouserect(int &x1, int &y1, int &x2, int &y2) {
	x1 = curx-cursor.hotx;
	y1 = cury-cursor.hoty;
	x2 = x1+cursor.dx-1;
	y2 = y1+cursor.dy-1;
}

void Mouse::refresh(int x, int y, byte butt) {
	curx = x;
	cury = y;
	buttons = butt;
}

void Mouse::draw() {
	if (!invisible) {
		void far *app = vbuff;
		vbuff = VMEMPTR;
		asm PUSH DS;
		getlvfig(curx-cursor.hotx,cury-cursor.hoty,
				 under.dx,under.dy,under.data);
		asm POP DS;
		asm PUSH DS;
		putlcfig(curx-cursor.hotx,cury-cursor.hoty,
				 cursor.dx,cursor.dy,cursor.data);
		asm POP DS;
		vbuff = app;
	}
}

void Mouse::undraw() {
	if (!invisible) {
		void far *app = vbuff;
		vbuff = VMEMPTR;
		asm PUSH DS;
		storelcfig(curx-cursor.hotx,cury-cursor.hoty,
				   under.dx,under.dy,under.data);
		asm POP DS;
		vbuff = app;
	}
}

Mouse::Mouse() {
	invisible = 1;
	installed = 0;
}

char Mouse::install() {
	if (installed) return 0;
	if (!reset()) return 0;
	// Really Hides the mouse
	asm {
		MOV AX, 2
		INT 0x33
	}
	// Install handler
	void (far *handler)() = mousehandler;	// NECESSARIO !!!???
	asm {
		PUSH ES
		MOV AX, 0x0c
		MOV CX, MA_ALWAYS
		LES DX, DWORD PTR handler
		INT 0x33
		POP ES
	}
	setvrect(0,0,320,200);
	setrange(0,0,319,199);
	go(160,100);
	under.data = NULL;
	setcursor(NULL);
	installed++;
	return 1;
}

char Mouse::reset() {
	asm {
		XOR AX, AX
		INT 0x33
	}
	if (_BX == 0xffff) butnum = 2;
				  else butnum = 3;
	return _AH;
}

void Mouse::show() {
	if (invisible) {
		asm cli;
		invisible--;
		draw();
		asm sti;
	}
}

void Mouse::hide() {
	if (invisible<0xff) {
		asm cli;
		undraw();
		invisible++;
		asm sti;
	}
}

void Mouse::get(int &x, int &y, byte &butt) {
	x = curx;
	y = cury;
	butt = buttons;
}

void Mouse::getpos(int &x, int &y) {
	x = curx;
	y = cury;
}

byte Mouse::getbuttons() {
	return buttons;
}

void Mouse::go(int x, int y) {
	curx = x;
	cury = y;
asm {
		MOV AX, 4
		MOV CX, x
		SHL CX, 1
		MOV DX, y
		INT 0x33
} }

void Mouse::setxrange(int x1, int x2) {
	if (curx<x1 || curx>x2) go((x1+x2)>>1,cury);
	asm {
		MOV AX, 7
		MOV CX, x1
		SHL CX, 1
		MOV DX, x2
		SHL DX, 1
		INT 0x33
	}
}

void Mouse::setyrange(int y1, int y2) {
	if (cury<y1 || cury>y2) go(curx,(y1+y2)>>1);
	asm {
		MOV AX, 8
		MOV CX, y1
		MOV DX, y2
		INT 0x33
	}
}

void Mouse::setrange(int x1, int y1, int x2, int y2) {
	setxrange(x1,x2);
	setyrange(y1,y2);
}

void Mouse::setcursor(MouseCursor *newcurs) {
	hide();
	if (under.data != NULL && under.data != underdata) delete under.data;
	if (newcurs == NULL) {
		cursor.hotx = 1;
		cursor.hoty = 1;
		under.dx = cursor.dx = 3;
		under.dy = cursor.dy = 3;
		cursor.data = /*(char far *)&*/mousedata;
		under.data = (char far *)&underdata;
	} else {
		cursor = *newcurs;
		under.dx = cursor.dx;
		under.dy = cursor.dy;
		under.data = new char[under.dx*under.dy];
	  }
	show();
}

void Mouse::setcursormem(MouseCursor *newcurs, void far *undr) {
	hide();
	if (newcurs == NULL) {
		cursor.hotx = 1;
		cursor.hoty = 1;
		under.dx = cursor.dx = 3;
		under.dy = cursor.dy = 3;
		cursor.data = (char far *)&mousedata;
		under.data = (char far *)&underdata;
	} else {
		cursor = *newcurs;
		under.dx = cursor.dx;
		under.dy = cursor.dy;
		under.data = undr;
	  }
	show();
}

void Mouse::update(int x1, int y1, int dx, int dy) {
	int _x1, _y1, _x2, _y2,
		x2 = x1+dx-1,
		y2 = y1+dy-1;
	getmouserect(_x1,_y1,_x2,_y2);
	// Questa routine di collisione funziona solo se il rettangolo
	// del mouse  pi piccolo di quello da aggiornare
	if ((_x1>=x1 && _x1<=x2 || _x2>=x1 && _x2<=x2) &&
		(_y1>=y1 && _y1<=y2 || _y2>=y1 && _y2<=y2)) hide();
}

void Mouse::uninstall() {
	if (!installed) return;
	asm {
		CLI
		PUSH ES
		MOV AX, 0x0c
		MOV CX, 0
		XOR DX, DX
		MOV ES, DX
		INT 0x33
		POP ES
		STI
	}
	hide();
	reset();
	installed--;
}

Mouse::~Mouse() {
	uninstall();
}