/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 ************************************************************************/

// Boom types
#define BOOM_PALLOT		0	// pallottola
#define	BOOM_MISSIL		1   // missile expl.
#define	BOOM_BLOOD		2   // sangue
#define	BOOM_SLIMER		3   // slimer slime
#define	BOOM_SPIDER		4	// spider venom
#define	BOOM_ASCIA		5	// ascia
#define	BOOM_SMOG		6	// fumo

class Ossa : public Actor
{
		int animtrig;
		void launch(int angle, int strong);
	protected:
		virtual void setid(int the_id)
			{Object::setid(the_id);};
	public:
		Ossa(fixed px, fixed py, int type);
		Ossa(int handle);
		virtual void animate();
		virtual void handle_event(TEvent &event);
};

class FlOssa : public Actor
{
		int speed, bang;
	public:
		FlOssa(fixed px, fixed py, int angle, int _speed);
		FlOssa(int handle);
		virtual void save(int handle);
		virtual void animate();
};

class ObjMover : public Actor
{
		int speed, bounceang;
		int objlinkID;
	public:
		ObjMover(int _objlinkID, int angle, int _speed);
		ObjMover(int handle);
		//~ObjMover();
		virtual void save(int handle);
		virtual void animate();
		virtual void handle_event(TEvent &event);
};

class Bonus : public LightActor
{
		int animtrig, animang;
	public:
		Bonus(fixed px, fixed py);
		Bonus(int handle);
		virtual void animate();
		virtual int getlightfig();
		//virtual void handle_event(TEvent &event);
};

class AntiKaos : public LightActor
{
		int animtrig, animang;
	public:
		AntiKaos(fixed px, fixed py);
		AntiKaos(int handle);
		virtual void animate();
		virtual int getlightfig();
		virtual void handle_event(TEvent &event);
};

class Enemy : public Actor
{
	protected:
		int posneg;
		int animtrig, animstate;
		int firstfig, walkspeed, speed, hitangle;
	public:
		Enemy(fixed px, fixed py, byte type);
		virtual void animate();
		virtual void handle_event(TEvent &event);
};

class Slimer : public Actor
{
	protected:
		int animtrig, animstate;
		int speed, hitangle;
		int objlink;
		int cannoncharge, scanangle, mysound, floatangle;
		char objseen,  posneg, sndcount;
		char turnnum, turning, turnable;
	public:
		Slimer(fixed px, fixed py);
		Slimer(int handle);
		virtual void save(int handle);
		virtual void animate();
		virtual void handle_event(TEvent &event);
};

class Spider : public Actor
{
	protected:
		int animtrig, animstate;
		int speed, hitangle;
		int scanangle, objlink;
		int mysound, cannoncharge;
	public:
		Spider(fixed px, fixed py);
		Spider(int handle);
		virtual void save(int handle);
		virtual void animate();
		virtual void handle_event(TEvent &event);
};

class Soldier : public Actor
{
	protected:
		int animstate, animtrig;
		int speed, hitangle;
		int scanangle, zigzagang, objlink;
		char objseen, recover;
		int turncount,havetoturn;
		fixed oldobjx,oldobjy;
	public:
		Soldier(fixed px, fixed py);
		Soldier(int handle);
		virtual void save(int handle);
		virtual void animate();
		virtual void handle_event(TEvent &event);
};

class Mouse : public Actor
{
	protected:
		int animstate, animtrig;
	public:
		Mouse(fixed px, fixed py);
		Mouse(int handle);
		virtual void save(int handle);
		virtual void animate();
		virtual void handle_event(TEvent &event);
};

class FireBoom : public LightActor
{
		int animtrig;
		byte type;
		fixed decay, decayspd;
	public:
		FireBoom(fixed px, fixed py, fixed h, int angle, byte boomtype);
		FireBoom(int handle);
		virtual void save(int handle);
		virtual void animate();
		virtual int getlightfig();
};

class Fireball : public LightActor
{
		int ownerid;
		fixed deh;
		char sendsound, animtrig;
		int /*vangle,*/ shspeed, boomcount;
	public:
		Fireball(fixed px, fixed py, int fireangle, /*int _vangle,*/ int type,
				 fixed h1, fixed h2, fixed dist, int _ownerid);
		Fireball(int handle);
		virtual void save(int handle);
		virtual void animate();
		virtual void handle_event(TEvent &evnt);
		virtual int getlightfig();
};

class Bomb : public Actor
{
		int ownerid, timer, animtrig, strenght;
		fixed decay;
	public:
		Bomb(fixed px, fixed py, fixed h, int angle, int strng,
			int _ownerid);
		Bomb(int handle);
		virtual void save(int handle);
		virtual void animate();
		virtual void handle_event(TEvent &evnt);
		int getownerid() { return ownerid; }
};

class Torcia : public LightActor
{
		char animtrig;
		int fireid;
	public:
		Torcia(fixed px, fixed py, int fig);
		Torcia(int handle);
		virtual void animate();
		virtual void handle_event(TEvent &event);
		virtual int getlightfig();
};

class Lampadario : public LightActor
{
		char animtrig;
		fixed decay;
	public:
		Lampadario(fixed px, fixed py, int fig);
		Lampadario(int handle);
		virtual void animate();
		virtual void handle_event(TEvent &event);
		virtual int getlightfig();
};

class Barile : public LightActor
{
		int animtrig, speed;
		int ownerid;
	protected:
		virtual void setid(int the_id)
			{Object::setid(the_id);};
	public:
		Barile(fixed px, fixed py);
		Barile(int handle);
		virtual void save(int handle);
		virtual void animate();
		virtual void handle_event(TEvent &event);
};

class Vaso : public Actor
{
		int animtrig, speed;
		byte whatin;
	protected:
		virtual void setid(int the_id)
			{Object::setid(the_id);};
	public:
		Vaso(fixed px, fixed py, int fig, byte objin);
		Vaso(int handle);
		virtual void save(int handle);
		virtual void animate();
		virtual void handle_event(TEvent &event);
};