pkgname=kbd
pkgver=2.4.0
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Tobias Powalowski <tpowa@archlinux.org>

cd ${pkgname}
# rename keymap files with the same names
# this is needed because when only name of keymap is specified
# loadkeys loads the first keymap it can find, which is bad (see FS#13837)
# this should be removed when upstream adopts the change
mv data/keymaps/i386/qwertz/cz{,-qwertz}.map
mv data/keymaps/i386/olpc/es{,-olpc}.map
mv data/keymaps/i386/olpc/pt{,-olpc}.map
mv data/keymaps/i386/fgGIod/trf{,-fgGIod}.map
mv data/keymaps/i386/colemak/{en-latin9,colemak}.map
# fix euro2 #28213
patch -Np1 -i ../fix-euro2.patch
autoreconf -if

./configure --prefix=/usr --sysconfdir=/etc --datadir=/usr/share/kbd --mandir=/usr/share/man
make KEYCODES_PROGS=yes RESIZECONS_PROGS=yes

make KEYCODES_PROGS=yes RESIZECONS_PROGS=yes DESTDIR="${pkgdir}" install
install -Dm644 ../vlock.pam "${pkgdir}"/etc/pam.d/vlock
