pkgname=libbluray
pkgver=1.3.0
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Maxime Gauduin <alucryd@archlinux.org>
# and contributor Ionut Biru <ibiru@archlinux.org>
# and contributor Bartłomiej Piotrowski <bpiotrowski@archlinux.org>
# and contributor Andrew Cook <ariscop@gmail.com>

cd libbluray

for submodule in contrib/libudfread; do
  git submodule init ${submodule}
  git config submodule.${submodule}.url ../${submodule#*/}
  git submodule update ${submodule}
done

autoreconf -fiv

./configure \
  --prefix=/usr
make
cd ..

make DESTDIR="${pkgdir}" -C libbluray install
