"use strict";
/**
 * Copyright 2023 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Frame = void 0;
const Frame_js_1 = require("../../api/Frame.js");
/**
 * @internal
 */
class Frame extends Frame_js_1.Frame {
    /**
     * @internal
     */
    constructor(frameManager, context) {
        var _a;
        super();
        this._frameManager = frameManager;
        this._context = context;
        this._id = context.id;
        this._parentId = (_a = context.parentId) !== null && _a !== void 0 ? _a : undefined;
    }
    page() {
        return this._frameManager.page();
    }
    async goto(url, options) {
        return this._context.goto(url, options);
    }
    async waitForNavigation() {
        throw new Error('Not implemented');
    }
    async evaluateHandle(pageFunction, ...args) {
        return this._context.evaluateHandle(pageFunction, ...args);
    }
    async evaluate(pageFunction, ...args) {
        return this._context.evaluate(pageFunction, ...args);
    }
    async content() {
        return this._context.content();
    }
    async setContent(html, options) {
        return this._context.setContent(html, options);
    }
    name() {
        return this._name || '';
    }
    url() {
        return this._context.url();
    }
    parentFrame() {
        var _a;
        return (_a = this._frameManager._frameTree.parentFrame(this._id)) !== null && _a !== void 0 ? _a : null;
    }
    childFrames() {
        return this._frameManager._frameTree.childFrames(this._id);
    }
    isDetached() {
        throw new Error('Not implemented');
    }
    async title() {
        throw new Error('Not implemented');
    }
}
exports.Frame = Frame;
//# sourceMappingURL=Frame.js.map