"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _FrameManager_instances, _FrameManager_page, _FrameManager_connection, _FrameManager_subscribedEvents, _FrameManager_handleFrameTree, _FrameManager_onFrameAttached, _FrameManager_onFrameNavigated, _FrameManager_onFrameDetached, _FrameManager_removeFramesRecursively;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrameManager = void 0;
const assert_js_1 = require("../../util/assert.js");
const EventEmitter_js_1 = require("../EventEmitter.js");
const FrameManager_js_1 = require("../FrameManager.js");
const FrameTree_js_1 = require("../FrameTree.js");
const Context_js_1 = require("./Context.js");
const Frame_js_1 = require("./Frame.js");
/**
 * A frame manager manages the frames for a given {@link Page | page}.
 *
 * @internal
 */
class FrameManager extends EventEmitter_js_1.EventEmitter {
    get client() {
        return __classPrivateFieldGet(this, _FrameManager_connection, "f");
    }
    constructor(connection, page, info, timeoutSettings) {
        super();
        _FrameManager_instances.add(this);
        _FrameManager_page.set(this, void 0);
        _FrameManager_connection.set(this, void 0);
        this._frameTree = new FrameTree_js_1.FrameTree();
        // TODO: switch string to (typeof Browser.events)[number]
        _FrameManager_subscribedEvents.set(this, new Map([
            ['browsingContext.contextCreated', __classPrivateFieldGet(this, _FrameManager_instances, "m", _FrameManager_onFrameAttached).bind(this)],
            ['browsingContext.contextDestroyed', __classPrivateFieldGet(this, _FrameManager_instances, "m", _FrameManager_onFrameDetached).bind(this)],
            ['browsingContext.fragmentNavigated', __classPrivateFieldGet(this, _FrameManager_instances, "m", _FrameManager_onFrameNavigated).bind(this)],
        ]));
        __classPrivateFieldSet(this, _FrameManager_connection, connection, "f");
        __classPrivateFieldSet(this, _FrameManager_page, page, "f");
        this._contextId = info.context;
        this._timeoutSettings = timeoutSettings;
        __classPrivateFieldGet(this, _FrameManager_instances, "m", _FrameManager_handleFrameTree).call(this, info);
        for (const [event, subscriber] of __classPrivateFieldGet(this, _FrameManager_subscribedEvents, "f")) {
            __classPrivateFieldGet(this, _FrameManager_connection, "f").on(event, subscriber);
        }
    }
    page() {
        return __classPrivateFieldGet(this, _FrameManager_page, "f");
    }
    mainFrame() {
        const mainFrame = this._frameTree.getMainFrame();
        (0, assert_js_1.assert)(mainFrame, 'Requesting main frame too early!');
        return mainFrame;
    }
    frames() {
        return Array.from(this._frameTree.frames());
    }
    frame(frameId) {
        return this._frameTree.getById(frameId) || null;
    }
    dispose() {
        this.removeAllListeners();
        for (const [event, subscriber] of __classPrivateFieldGet(this, _FrameManager_subscribedEvents, "f")) {
            __classPrivateFieldGet(this, _FrameManager_connection, "f").off(event, subscriber);
        }
    }
}
exports.FrameManager = FrameManager;
_FrameManager_page = new WeakMap(), _FrameManager_connection = new WeakMap(), _FrameManager_subscribedEvents = new WeakMap(), _FrameManager_instances = new WeakSet(), _FrameManager_handleFrameTree = function _FrameManager_handleFrameTree(info) {
    if (info) {
        __classPrivateFieldGet(this, _FrameManager_instances, "m", _FrameManager_onFrameAttached).call(this, info);
    }
    if (!info.children) {
        return;
    }
    for (const child of info.children) {
        __classPrivateFieldGet(this, _FrameManager_instances, "m", _FrameManager_handleFrameTree).call(this, child);
    }
}, _FrameManager_onFrameAttached = function _FrameManager_onFrameAttached(info) {
    var _a;
    if (!this.frame(info.context) &&
        (this.frame((_a = info.parent) !== null && _a !== void 0 ? _a : '') || !this._frameTree.getMainFrame())) {
        const context = new Context_js_1.Context(__classPrivateFieldGet(this, _FrameManager_connection, "f"), this, info);
        __classPrivateFieldGet(this, _FrameManager_connection, "f").registerContext(context);
        const frame = new Frame_js_1.Frame(this, context);
        this._frameTree.addFrame(frame);
        this.emit(FrameManager_js_1.FrameManagerEmittedEvents.FrameAttached, frame);
    }
}, _FrameManager_onFrameNavigated = async function _FrameManager_onFrameNavigated(info) {
    const frameId = info.context;
    let frame = this._frameTree.getById(frameId);
    // Detach all child frames first.
    if (frame) {
        for (const child of frame.childFrames()) {
            __classPrivateFieldGet(this, _FrameManager_instances, "m", _FrameManager_removeFramesRecursively).call(this, child);
        }
    }
    frame = await this._frameTree.waitForFrame(frameId);
    // frame._navigated(info);
    this.emit(FrameManager_js_1.FrameManagerEmittedEvents.FrameNavigated, frame);
}, _FrameManager_onFrameDetached = function _FrameManager_onFrameDetached(info) {
    const frame = this.frame(info.context);
    if (frame) {
        __classPrivateFieldGet(this, _FrameManager_instances, "m", _FrameManager_removeFramesRecursively).call(this, frame);
    }
}, _FrameManager_removeFramesRecursively = function _FrameManager_removeFramesRecursively(frame) {
    for (const child of frame.childFrames()) {
        __classPrivateFieldGet(this, _FrameManager_instances, "m", _FrameManager_removeFramesRecursively).call(this, child);
    }
    __classPrivateFieldGet(this, _FrameManager_connection, "f").unregisterContext(frame._context);
    this._frameTree.removeFrame(frame);
    this.emit(FrameManager_js_1.FrameManagerEmittedEvents.FrameDetached, frame);
};
//# sourceMappingURL=FrameManager.js.map