srcdir=$PWD
pkgdir=$PWD/../build
pkgname=perl
pkgver=5.26.2
_baseversion="${pkgver%.*}"
CARCH="x86_64"

ln /usr/bin/gcc /usr/bin/cc

cd "${srcdir}"
cd ${srcdir}/${pkgname}-${pkgver}
# test broken with gdbm 1.15. See: https://rt.perl.org/Public/Bug/Display.html?id=133295
sed -i 's|BEGIN {|BEGIN { plan(skip_all => "fatal test unsupported with gdbm 1.15");|' ext/GDBM_File/t/fatal.t

cd "${srcdir}"
cd ${srcdir}/${pkgname}-${pkgver}

if [ "${CARCH}" = "x86_64" ]; then
  # for x86_64
  arch_opts="-Dcccdlflags='-fPIC'"
else
  # for i686
  arch_opts=""
fi

./Configure -des -Dusethreads -Duseshrplib -Doptimize="${CFLAGS}" \
  -Dprefix=/usr -Dvendorprefix=/usr \
  -Dprivlib=/usr/share/perl5/core_perl \
  -Darchlib=/usr/lib/perl5/$_baseversion/core_perl \
  -Dsitelib=/usr/share/perl5/site_perl \
  -Dsitearch=/usr/lib/perl5/$_baseversion/site_perl \
  -Dvendorlib=/usr/share/perl5/vendor_perl \
  -Dvendorarch=/usr/lib/perl5/$_baseversion/vendor_perl \
  -Dscriptdir=/usr/bin/core_perl \
  -Dsitescript=/usr/bin/site_perl \
  -Dvendorscript=/usr/bin/vendor_perl \
  -Dinc_version_list=none \
  -Dman1dir=/usr/share/man/man1 \
  -Dman3dir=/usr/share/man/man3 \
  -Dman1ext=1perl -Dman3ext=3perl ${arch_opts} \
  -Dlddlflags="-shared ${LDFLAGS}" -Dldflags="${LDFLAGS}"
make || exit -1

cd "${srcdir}"
cd ${srcdir}/${pkgname}-${pkgver}
make DESTDIR="$pkgdir" install || exit -1

for template in "$srcdir/"*.template; do
  install -Dm644 "$template" "$pkgdir/usr/share/makepkg-template/${template##*/}"
done
ln -s perl-binary-module-dependency-1.template "$pkgdir/usr/share/makepkg-template/"perl-binary-module-dependency.template

### Perl Settings ###
# Change man page extensions for site and vendor module builds.
# Set no mail address since bug reports should go to the bug tracker
# and not someone's email.
sed -e '/^man1ext=/ s/1perl/1p/' -e '/^man3ext=/ s/3perl/3pm/' \
  -e "/^cf_email=/ s/'.*'/''/" \
  -e "/^perladmin=/ s/'.*'/''/" \
  -i ${pkgdir}/usr/lib/perl5/$_baseversion/core_perl/Config_heavy.pl

### CPAN Settings ###
# Set CPAN default config to use the site directories.
sed -e '/(makepl_arg =>/   s/""/"INSTALLDIRS=site"/' \
  -e '/(mbuildpl_arg =>/ s/""/"installdirs=site"/' \
  -i ${pkgdir}/usr/share/perl5/core_perl/CPAN/FirstTime.pm

# Profile script to set paths to perl scripts.
install -D -m644 ${srcdir}/perlbin.sh \
  ${pkgdir}/etc/profile.d/perlbin.sh
# Profile script to set paths to perl scripts on csh. (FS#22441)
install -D -m644 ${srcdir}/perlbin.csh \
  ${pkgdir}/etc/profile.d/perlbin.csh
# Profile script to set paths to perl scripts on fish. (FS#51191)
install -D -m 755 "$srcdir/perlbin.fish" \
  "$pkgdir/usr/share/fish/vendor_conf.d/perlbin.fish"

# Add the dirs so new installs will already have them in PATH once they
# install their first perl programm
install -d -m755 "$pkgdir/usr/bin/vendor_perl"
install -d -m755 "$pkgdir/usr/bin/site_perl"

#(cd ${pkgdir}/usr/bin; mv perl${pkgver} perl)
rm "$pkgdir/usr/bin/perl$pkgver"

install -D -m755 -t "$pkgdir/usr/share/libalpm/scripts" "$srcdir/detect-old-perl-modules.sh"
install -D -m644 -t "$pkgdir/usr/share/libalpm/hooks" "$srcdir/detect-old-perl-modules.hook"

find $pkgdir -name perllocal.pod -delete
find $pkgdir -name .packlist -delete
