cd ghostscript-9.22
patch -Np1 -i ../ghostscript-sys-zlib.patch
sed -E "s/FT_CALLBACK_DEF\(([^\)]+)\)/static \1/g" -i base/fapi_ft.c
rm -rfv cups/libs freetype jbig2dec jpeg lcms2 libpng tiff zlib
autoconf --force

./configure --prefix=/usr \
  --enable-dynamic \
  --with-ijs \
  --with-jbig2dec \
  --without-omni \
  --with-x \
  --with-drivers=ALL\
  --with-fontpath=/usr/share/fonts/Type1:/usr/share/fonts \
  --enable-fontconfig \
  --enable-freetype \
  --enable-openjpeg \
  --without-luratech \
  --with-system-libtiff \
  --with-libpaper \
  --disable-compile-inits #--help # needed for linking with system-zlib
make so
make

make DESTDIR=$PWD/../../build \
     cups_serverroot=$PWD/../../build/etc/cups \
     cups_serverbin=$PWD/../../build/usr/lib/cups install install-so

# drop full libs linked gs, prefer gsc dynamically linked against libgs; FS#50422
ln -sf /usr/bin/gsc $PWD/../../build/usr/bin/gs

# install missing doc files # http://bugs.archlinux.org/task/18023
install -m 644 doc/{VectorDevices.htm,gs-vms.hlp,gsdoc.el,pscet_status.txt} $PWD/../../build/usr/share/ghostscript/9.22/doc/
