pkgname=zita-alsa-pcmi
pkgver=0.3.2
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Andrea Scarpino <andrea@archlinux.org>
# and contributor Tobias Powalowski <tpowa@archlinux.org>

cd "$pkgname-$pkgver"
# remove optimization
# call ldconfig in local context
sed -e '/native/d' \
  -e 's/ldconfig/& -N $(DESTDIR)\/$(LIBDIR)/' \
  -i source/Makefile

# fix use of BINDIR without preceeding DESTDIR
sed -e 's/\ $(BINDIR)/\ $(DESTDIR)$(BINDIR)/' \
  -i apps/Makefile

make -C source
# create lib link for building apps
ln -sv lib$pkgname.so.$pkgver source/lib$pkgname.so
CXXFLAGS+=" -I../source" \
  LDFLAGS+=" -L../source" \
  make -C apps

rm -v source/lib$pkgname.so

# libs
make -C source DESTDIR="$pkgdir/" PREFIX=/usr SUFFIX="" install
install -vDm 644 {AUTHORS,README} -t "${pkgdir}/usr/share/doc/${pkgname}"
# apps
make -C apps DESTDIR="$pkgdir/" PREFIX=/usr install
