{
  An arcade game, written in Turbo Pascal 7.0, (c) 1997 by George M. Tzoumas
  Version 1.1
}

{ This program is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
Use this software AT YOUR OWN RISK. }

program Ra;
{ 65520,0,125000}
uses Objects, Graph, Crt, Keyb2, Advanced, Fade, Basic{, AdvOpl};

const
  Right = 1;
  Left  = 2;
  Up = 3;
  Down = 4;
  Standing = 0;
  Jumping = Up;
  Falling = Down;
  DontGo = $FFFF;

  MaxLevels = 6;
  DelayFactor = 25;

{ Graphics Images  (16x16) }
  Blank = 0;
  Block = 1;
  Block_Fork_Left  = 2;
  Block_Fork_Right = 3;
  ArtBlock1 = 4;
  ArtBlock2 = 5;
  AKey = 6;
  AKeyHole = 7;
  ADiamond = 8;
  ABall = 9;
  Fork = 10;
  Tons = 11;
  Life = 12;            { 12x6 }
  GameOver_ = 13;       { 36x24 }
  LevelExit = 14;

type

  PFrameRec = ^TFrameRec;
  TFrameRec = record
    RightLeft : array[1..2,0..4] of Pointer;
    Jump : array[1..2] of Pointer;
    Dead : array[0..1] of Pointer;
  end;

  BPoint = record X, Y : Byte end;

  TOrigin = record X, Y, wdr : Byte end;

  TSurround = array[1..4] of BPoint;

  PImages = ^TImages;
  TImages = array[0..13] of Pointer;

  PMatrix = ^TMatrix;
  TMatrix = Array[0..19, 0..11] of Byte;


  PTrapCollection = ^TTrapCollection;
  TTrapCollection = object(TCollection)
     procedure FreeItem(Item: Pointer); virtual;
     procedure MoveAll; virtual;
     procedure DrawAll; virtual;
  end;

  PLevel = ^TLevel;
  TLevel = object
    Table : PMatrix;
    Images : PImages;
    Traps : PTrapCollection;
    LevelEnd : Boolean;
    Origin : TOrigin;
    SongName   : String;
    constructor Init(ATraps : PTrapCollection; ANo, AXt, AYt, Awdr: Byte);
    procedure DrawCell(cx, cy : Byte);
    procedure Draw;
    procedure Move;
    procedure Run;
    destructor Done;
  end;

  PLive = ^TLive; { Any moving sprite, trap, enemy, player, everything. }
  TLive = object
    Level : PLevel;
    X, Y : Integer;
    cX : LongInt;
    Obstacles : Set of Byte;
    procedure Draw; virtual;
    procedure Walk; virtual;
    procedure CheckAround; virtual;
    procedure GetSurround(var d : TSurround);
    procedure GetItem(AXt, AYt : Byte);
    function GetClose(Direction : Byte) : Word;
    function IsObstacle(AClose : Word) : Boolean;
    function ExactX : Boolean;
    function ExactY : Boolean;
    destructor Done;
  end;

  PPlayer = ^TPlayer;
  TPlayer = object(TLive)
    Frames : PFrameRec;
    cwf, wdr : Byte;  { Current Walking Frame, Walking Direction }
    jf : Byte; { Jumping or Falling }
    jc : Byte; { Jumping Counter }
    jl : Byte; { Jump Length }
    Coins : Byte;
    Lives : ShortInt;
    HasKey : Boolean;
    DeadBlink : Byte;
    Dead : Boolean;
    constructor Init(ALives: ShortInt; ACoins: Byte);
    procedure Draw; virtual;
    procedure ShowStatus; virtual;
    procedure Walk; virtual;
    procedure CheckAround; virtual;
    procedure Die; virtual;
    procedure SetLevel(ALevel: PLevel); virtual;
  end;

  PTrap = ^TTrap;
  TTrap = object(TLive)
    Pic : Byte;
    Frame : Pointer;
    wdr : Byte; { walking direction }
    Xt, Yt : Word;
    Ys, Yt2 : Word;
    constructor Init(APic, AXt, AYt : Byte; ALevel: PLevel);
    procedure Draw; virtual;
    procedure Walk; virtual;
  end;

var
   DefaultFrameRec : PFrameRec;
   DefaultImages : PImages;
   DefaultMatrixes : array[1..MaxLevels] of PMatrix;
   clv : Byte; { current level }
   Player : TPlayer;
   Bye : Boolean;
   GameIsOver : Boolean;
   SysTimer : Word absolute $40:$6C;
   Levels : Array[1..MaxLevels] of TLevel;

procedure Retrace; assembler;
asm
        mov dx,3dah;
@l1:    in al,dx;
        test al,8;
        jnz @l1;
@l2:    in al,dx;
        test al,8;
        jz @l2;
end;

procedure GameOver;
var c: byte;
begin
  c:=0;
  repeat
    Inc(c);
    Retrace;
    Delay(DelayFactor);
    Levels[clv].Move;
    PutImage(142, 88, DefaultImages^[GameOver_]^, CopyPut);
  until c = 255;
  GameIsOver := True;
end;

procedure TTrapCollection.FreeItem(Item: Pointer);
begin
  if Item <> nil then Dispose(PTrap(Item), Done);
end;

procedure TTrapCollection.MoveAll;
  procedure MoveItem(Item: Pointer); far;
  begin
    PTrap(Item)^.Walk;
  end;
begin
  ForEach(@MoveItem);
end;

procedure TTrapCollection.DrawAll;
  procedure DrawItem(Item: Pointer); far;
  begin
    PTrap(Item)^.Draw;
  end;
begin
  ForEach(@DrawItem);
end;

constructor TLevel.Init(ATraps : PTrapCollection; ANo, AXt, AYt, Awdr: Byte);
begin
  Images := DefaultImages;
  Traps := ATraps;
  LevelEnd := False;
  Table := DefaultMatrixes[ANo];
  Origin.X := AXt;
  Origin.Y := AYt;
  Origin.wdr := Awdr;
end;

procedure TLevel.DrawCell(cx, cy : Byte);
begin
  PutImage(cx shl 4, cy shl 4, Images^[Table^[cx, cy]]^, CopyPut);
end;

procedure TLevel.Draw;
var i, j: Byte;
begin
  for i := 0 to 11 do for j := 0 to 19 do
    DrawCell(j, i);
  if Traps <> nil then Traps^.DrawAll;
end;

procedure TLevel.Move;
begin
  if Traps <> nil then Traps^.MoveAll;
end;

procedure TLevel.Run;
var ch: Char;
begin
  Draw;
  Player.Draw;
  repeat
    Retrace;
{    PollD00;}
    Delay(DelayFactor);
    Move;
    Player.Walk;
  if keypressed then
  begin
    ch := readkey;
    if ch=#252 then Inc(Player.Lives, 4) else       { Let's cheat ! -- life}
    if ch=#253 then LevelEnd := True else           { -- level }
    if Upcase(ch) = 'K' then Player.Die;            { commit suicide }
  end;
  until (ch = #27) or LevelEnd or GameIsOver;
  if ch=#27 then Bye := True;
end;


destructor TLevel.Done;
begin
  if Traps <> nil then Dispose(Traps, Done);
end;

procedure TLive.Walk; begin  end;

procedure TLive.Draw; begin end;

procedure TLive.CheckAround; begin end;

procedure TLive.GetSurround(var d : TSurround);
var xt, yt : Byte;
begin                                            {  +----+--+  }
  Xt := X shr 4;                                 {  | 1 | 2 |  }
  Yt := Y shr 4;                                 {  +---+---+  }
  d[1].X := Xt; d[1].Y := Yt;                    {  | 3 | 4 |  }
  d[2].X := Xt + Byte(not ExactX); d[2].Y := Yt; {  +-------+  }
  d[3].X := Xt; d[3].Y := Yt + Byte(not ExactY);
  d[4].X := d[2].X; d[4].Y := d[3].Y;
end;

procedure TLive.GetItem(AXt, AYt : Byte);
begin
  Level^.Table^[AXt, AYt] := Blank;
  Level^.DrawCell(AXt, AYt);
  Draw;
end;

function TLive.GetClose(Direction : Byte) : Word;
var Xt, Yt : Byte;
    Invalid, ex, ey : Boolean;
begin
  ex := ExactX;
  ey := ExactY;
  Xt := X shr 4;
  Yt := Y shr 4;
  case Direction of
    Right: Invalid := (Xt = 19) and ex;
    Left : Invalid := (Xt = 00) and ex;
    Up   : Invalid := (Yt = 00) and ey;
    Down : Invalid := (Yt = 11) and ey;
  end;
  if Invalid then GetClose := DontGo else
  case Direction of
    Right :
      GetClose := Level^.Table^[Xt + 1, Yt] shl 8 +
        Level^.Table^[Xt + 1, Yt + Byte(not(ey))];
    Left :
      GetClose := Level^.Table^[Xt - Byte(ex), Yt] shl 8 +
        Level^.Table^[Xt - Byte(ex), Yt + Byte(not(ey))];
    Up :
      GetClose := Level^.Table^[Xt, Yt - Byte(ey)] shl 8 +
        Level^.Table^[Xt + Byte(not(ex)), Yt - Byte(ey)];
    Down :
      GetClose := Level^.Table^[Xt, Yt + 1] shl 8 +
        Level^.Table^[Xt + Byte(not(ex)), Yt + 1];
  end
end;

function TLive.IsObstacle(AClose : Word) : Boolean;
begin
   IsObstacle := (Lo(AClose) in Obstacles) or (Hi(AClose) in Obstacles);
end;

function TLive.ExactX : Boolean;
begin
  ExactX := (X mod 16 = 0);
end;

function TLive.ExactY : Boolean;
begin
  ExactY := (Y mod 16 = 0);
end;

destructor TLive.Done; begin end;

constructor TPlayer.Init(ALives: ShortInt; ACoins: Byte);
begin
  Frames := DefaultFrameRec;
  cwf := 0;
  jf := Standing;
  jc := 0;
  jl := 16;
  Lives := ALives;
  Coins := 0;
  HasKey := False;
  cX := 0;
  Obstacles := [Block, ArtBlock1, ArtBlock2, $FF];
  ShowStatus;
end;

procedure TPlayer.Draw;
begin
  if Dead then
  begin
    if DeadBlink > 0 then PutImage(x, y, Frames^.Dead[Byte(Odd(DeadBlink))]^, CopyPut)
    else PutImage(x, y, Frames^.Dead[1]^, XorPut)
  end else
  if jf = standing then PutImage(x, y, Frames^.RightLeft[wdr, cwf]^, CopyPut)
  else PutImage(x, y, Frames^.Jump[wdr]^, CopyPut);
{  PutPixel(0,0,Random(4));}
end;

procedure TPlayer.ShowStatus;
var i: ShortInt;
begin
  PutImage(Lives*12, 194, DefaultImages^[Life]^, CopyPut);
  PutImage(Lives*12, 194, DefaultImages^[Life]^, XorPut);
  for i:=0 to Lives-1 do PutImage(i*12, 194, DefaultImages^[Life]^, CopyPut);
end;

procedure TPlayer.Walk;
var ch  : Char;
    kd  : Byte;  { keydown }
    odr : Byte;  { old direction }
    ojf : Byte;  { old jf }
    obw : Word;  { obstacle on walking direction }
    isobw : Boolean; { is obstacle on wdr }
    obd, obu : Word; { obstacle down, up }
    isobd, isobu : Boolean; { is obstacle up, down }
begin
{  if cX = SysTimer then Exit else cX := SysTimer;}
  CheckAround;
  if Bye or GameIsOver then Exit;
  Dead := False;
  ojf := jf;
  obd := GetClose(Down);
  obu := GetClose(Up);
  isobd := IsObstacle(obd);
  isobu := IsObstacle(obu);
  if jf <> Jumping then
    begin
      if isobd then jf := Standing else jf := Falling;
    end;
  if (port[$60] = 57) and (jf = Standing) then
    if not isobu then jf := Jumping;
  if isobu and (jf = Jumping) then jf := Falling;
  if ojf <> jf then Draw;
  if jf = Jumping then
    begin
      if ojf <> jf then jc := 0;
      Dec(Y); Draw; Dec(Y);
      Inc(jc);
      if jc = jl then jc := 0;
      if jc = 0 then jf := Falling;
    end;
  if (jf = Falling) and (ojf <> Jumping) then begin Inc(Y); Draw; Inc(Y) end;
{  if jf = Falling then Inc(Y, 2);}
  kd := 0;
  if LShift then kd := Left;
  if RShift then kd := Right;
  if ((kd = 0) and (jf <> Standing)) or (ojf <> jf) then Draw;
  if kd = 0 then Exit;
  odr := wdr;
  wdr := kd;
  obw := GetClose(wdr);
  isobw := IsObstacle(obw);
  Inc(cX);
  if not isobw then
    begin
      if not Odd(cX) then Inc(cwf);
      if cwf > 4 then cwf := 1;
      if odr<>wdr then cwf := 0;
      if odr = wdr then if wdr = Left then Dec(X, 2) else Inc(X, 2);
    end;
  Draw;
end;

procedure TPlayer.CheckAround;
var d : TSurround;
    i : Byte;
begin
  GetSurround(d);
  for i := 1 to 4 do if not Dead then case Level^.Table^[d[i].X, d[i].Y] of
    ADiamond, ABall :
      begin
        GetItem(d[i].X, d[i].Y);
        Inc(Coins);
      end;
    Block_Fork_Left, Block_Fork_Right: Die;
    AKey :
      begin
        GetItem(d[i].X, d[i].Y);
        HasKey := True;
        Exclude(Obstacles, AKeyHole);
      end;
    AKeyHole :
      begin
        GetItem(d[i].X, d[i].Y);
        Level^.Table^[d[i].X, d[i].Y]:=LevelExit;
      end;
    LevelExit : if (ExactX and ExactY) then Level^.LevelEnd := True;
    end;        { case }
end;

procedure TPlayer.Die;
var c: byte;
begin
  Dead := True;
  for c := 4 downto 0 do begin DeadBlink := c; Draw; delay(500); end;
  X := Level^.Origin.X shl 4;
  Y := Level^.Origin.Y shl 4;
  wdr := Level^.Origin.wdr;
  if Lives = 0 then GameOver;
  if Lives > 0 then
  begin
    Dead := False;
    Draw;
    Dead := True;
    Level^.Traps^.DrawAll;
    Dec(Lives);
  end;
  ShowStatus;
end;

procedure TPlayer.SetLevel(ALevel: PLevel);
begin
  Level := ALevel;
  X := Level^.Origin.X shl 4;
  Y := Level^.Origin.Y shl 4;
  wdr := Level^.Origin.wdr;
end;

constructor TTRap.Init(APic, AXt, AYt : Byte; ALevel: PLevel);
var i : Byte;
begin
  Pic := APic;
  Frame := DefaultImages^[Pic];
  Level := ALevel;
  Xt := AXt;
  Yt := AYt;
  X := Xt shl 4;
  Y := Yt shl 4;
  Ys  := Y;
  wdr := Down;
  Obstacles := [Block, Block_Fork_Left, Block_Fork_Right, ArtBlock1,
    ArtBlock2, AKey, AKeyHole, ADiamond, $FF];
  i:=Yt;
  while not (Level^.Table^[Xt, i] in Obstacles) do Inc(i);
  Yt2 := i;
  Level^.Table^[Xt, Yt] := Pic;
end;

procedure TTrap.Draw;
begin
  PutImage(X, Y, Frame^, CopyPut);
end;

procedure TTrap.Walk;
var isobd : Boolean;  { is obstacle down }
    tmpYt, i : Byte;
begin
{  if cX = SysTimer then Exit else cX := SysTimer;}
  i:=Yt;
  while not (Level^.Table^[Xt, i] in Obstacles) do Inc(i);
  Yt2 := i;
  Yt := Y shr 4;
  if Yt < Yt2 then
  begin
    Level^.Table^[Xt, Yt] := Pic;
    if not ExactY then  Level^.Table^[Xt, Yt+1] := Pic;
  end;
  if ExactY and (Yt < Yt2-1) then Level^.Table^[Xt, Yt + 1] := Blank;
  if ExactY and (Y > Ys) then Level^.Table^[Xt, Yt - 1] := Block;
  isobd := IsObstacle(GetClose(Down));
  if (Y = Ys) and isobd then Exit;
  if isobd then wdr := Up;
  if Y = Ys then wdr := Down;
  if wdr = Down then Inc(Y, 2) else Dec(Y, 2);
  Draw;
  if (Abs(Player.X - X) < 16) and (Abs(Player.Y - Y) < 16) then Player.Die ;
end;

procedure LoadDefaultFrameRec;
begin
  New(DefaultFrameRec);
  BLoad('WR1', DefaultFrameRec^.RightLeft[Right, 1]);
  BLoad('WR2', DefaultFrameRec^.RightLeft[Right, 2]);
  BLoad('WR3', DefaultFrameRec^.RightLeft[Right, 3]);
  BLoad('WR4', DefaultFrameRec^.RightLeft[Right, 4]);
  BLoad('WL1', DefaultFrameRec^.RightLeft[Left, 1]);
  BLoad('WL2', DefaultFrameRec^.RightLeft[Left, 2]);
  BLoad('WL3', DefaultFrameRec^.RightLeft[Left, 3]);
  BLoad('WL4', DefaultFrameRec^.RightLeft[Left, 4]);
  BLoad('WF', DefaultFrameRec^.RightLeft[Right, 0]);
  DefaultFrameRec^.RightLeft[Left, 0] := DefaultFrameRec^.RightLeft[Right, 0];
  BLoad('WJR', DefaultFrameRec^.Jump[Right]);
  BLoad('WJL', DefaultFrameRec^.Jump[Left]);
  BLoad('DEAD1', DefaultFrameRec^.Dead[0]);
  BLoad('DEAD2', DefaultFrameRec^.Dead[1]);
end;

procedure LoadDefaultImages;
begin
  New(DefaultImages);
  Bload('BLOCK2', DefaultImages^[Blank]);
  Bload('BLOCK1', DefaultImages^[Block]);
  Bload('BRFL', DefaultImages^[Block_Fork_Left]);
  Bload('BRFR', DefaultImages^[Block_Fork_Right]);
  Bload('ART1', DefaultImages^[ArtBlock1]);
  Bload('ART2', DefaultImages^[ArtBlock2]);
  Bload('KEY', DefaultImages^[AKey]);
  Bload('KEYHOLE', DefaultImages^[AKeyHole]);
  Bload('DIAMOND', DefaultImages^[ADiamond]);
  Bload('BALL', DefaultImages^[ABall]);
  Bload('FORK', DefaultImages^[Fork]);
  Bload('TONS', DefaultImages^[Tons]);
  Bload('LIFE', DefaultImages^[Life]);
  Bload('GAMEOVER', DefaultImages^[GameOver_]);
end;

procedure LoadGraphics;
begin
  LoadDefaultFrameRec;
  LoadDefaultImages;
  Bload('LEVEL1', Pointer(DefaultMatrixes[1]));
  Bload('LEVEL2', Pointer(DefaultMatrixes[2]));
  Bload('LEVEL3', Pointer(DefaultMatrixes[3]));
  Bload('LEVEL4', Pointer(DefaultMatrixes[4]));
  Bload('LEVEL5', Pointer(DefaultMatrixes[5]));
  Bload('LEVEL6', Pointer(DefaultMatrixes[6]));
end;

procedure Intro;
var ch : Char;
begin
  HideCursor;
  GrabPal;
  FadeOut;
  Clrscr;
  TextAttr := 15;
  Frame(1, 1, 80, 24, 2);
  TextAttr := 15;
  Center(3, 'The Secret of the Pyramid');
  Gotoxy(20, 12);
  TextAttr := 9;
  Write(DecodeStr(Copyright) + ' 1997 by ' + DecodeStr(Programmer));
  Center(14, 'Beta Version, Demostration');
  TextAttr := 3;
  Center(22, 'Press SPACE to start a new game');
  TextAttr := 7;
  FadeIn;
  repeat
    ch := ReadKey;
  until ch in [#32, #27];
  if ch = #27 then begin ClrScr; ShowCursor; Halt; end;
  FadeOut;
end;

var
  gd, gm : Integer;
  Traps  : PTrapCollection;
begin
  Randomize;
  LoadGraphics;
  Intro;
  gd := CGA;
  gm := 1;
  DirectVideo := False;
  InitGraph(gd, gm, '');
{  LoadSong('SCORE4.MT1');
  playsong;}
  clv := 1;
  Bye := False;

  Levels[1].Init(New(PTrapCollection, Init(3,0)), 1, 0, 0, Right);
  Levels[1].Traps^.Insert(New(PTrap, Init(Fork, 12, 0, @Levels[1])));
  Levels[1].Traps^.Insert(New(PTrap, Init(Fork, 18, 7, @Levels[1])));
  Levels[1].Traps^.Insert(New(PTrap, Init(Tons, 14, 0, @Levels[1])));

  Levels[2].Init(New(PTrapCollection, Init(1,0)), 2, 0, 0, Right);
  Levels[2].Traps^.Insert(New(PTrap, Init(Fork, 6, 1, @Levels[2])));

  Levels[3].Init(New(PTrapCollection, Init(3,0)), 3, 0, 1, Right);
  Levels[3].Traps^.Insert(New(PTrap, Init(Fork, 1, 7, @Levels[3])));
  Levels[3].Traps^.Insert(New(PTrap, Init(Fork, 6, 7, @Levels[3])));
  Levels[3].Traps^.Insert(New(PTrap, Init(Tons, 19, 1, @Levels[3])));

  Levels[4].Init(New(PTrapCollection, Init(2,0)), 4, 0, 0, Right);
  Levels[4].Traps^.Insert(New(PTrap, Init(Fork, 0, 5, @Levels[4])));
  Levels[4].Traps^.Insert(New(PTrap, Init(Tons, 19, 2, @Levels[4])));

  Levels[5].Init(New(PTrapCollection, Init(1,0)), 5, 0, 10, Right);
  Levels[5].Traps^.Insert(New(PTrap, Init(Tons, 6, 3, @Levels[5])));

  Levels[6].Init(New(PTrapCollection, Init(1,0)), 6, 0, 0, Right);
  Levels[6].Traps^.Insert(New(PTrap, Init(Tons, 19, 5, @Levels[6])));

  Player.Init(2, 0);
  repeat
    Player.SetLevel(@Levels[clv]);
    Player.HasKey:=False;
    Include(Player.Obstacles, AKeyHole);
    Levels[clv].Run;
    Inc(clv);
  until (clv = MaxLevels + 1) or Bye or GameIsOver;
{  stopsong;
  clearmem;}
  CloseGraph;
  BlackOut;
  writeln('Thank you for playing RA.');
  FadeIn;
end.