/*==========================================================================

     attack.cpp  -  Copyright (C) 1993-1996 by Don Cross
     email: dcross@intersrv.com
     WWW:   http://www.intersrv.com/~dcross/

     Contains code to see if a given square on a ChessBoard
     is attacked by a given side.

     Revision history:

1993 October 15 [Don Cross]
     Fixed bug where I had a 'SOUTHEAST' where I meant to have
     a 'SOUTHWEST'.

1994 February 10 [Don Cros]
     Modified to support piece indexes.

1996 July 28 [Don Cross]
     Adding optimizations based on piece inventory.
     Should help out a lot in endgame positions.

==========================================================================*/

#include "chess.h"
#include "profiler.h"


cBOOLEAN ChessBoard::IsAttackedByWhite ( int offset ) const
{
   PROFILER_ENTER (PX_ATTACK);
   const SQUARE * const base = board + offset;
   const SQUARE *disp;

   // Look for knight attacks...

   if ( inventory[WN_INDEX] > 0 )
   {
       if ( (base [ OFFSET(1,2)   ] & WN_MASK) ||
            (base [ OFFSET(1,-2)  ] & WN_MASK) ||
            (base [ OFFSET(-1,2)  ] & WN_MASK) ||
            (base [ OFFSET(-1,-2) ] & WN_MASK) ||
            (base [ OFFSET(2,1)   ] & WN_MASK) ||
            (base [ OFFSET(2,-1)  ] & WN_MASK) ||
            (base [ OFFSET(-2,1)  ] & WN_MASK) ||
            (base [ OFFSET(-2,-1) ] & WN_MASK) )
       {
	      PROFILER_EXIT();
          return cTRUE;
       }
   }

   const int queensAndBishops = inventory[WQ_INDEX] + inventory[WB_INDEX];

   //-------------------------------------- SOUTHEAST
   if ( base[SOUTHEAST] == EMPTY )
   {
      if ( queensAndBishops > 0 )
      {
          for ( disp = base + 2*SOUTHEAST; *disp == EMPTY; disp += SOUTHEAST );
          if ( *disp & (WQ_MASK | WB_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[SOUTHEAST] & (WP_MASK | WB_MASK | WQ_MASK | WK_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- SOUTHWEST
   if ( base[SOUTHWEST] == EMPTY )
   {
      if ( queensAndBishops > 0 )
      {
          for ( disp = base + 2*SOUTHWEST; *disp == EMPTY; disp += SOUTHWEST );
          if ( *disp & (WQ_MASK | WB_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[SOUTHWEST] & (WP_MASK | WB_MASK | WQ_MASK | WK_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- SOUTH
   const int queensAndRooks = inventory[WQ_INDEX] + inventory[WR_INDEX];

   if ( base[SOUTH] == EMPTY )
   {
      if ( queensAndRooks > 0 )
      {
          for ( disp = base + 2*SOUTH; *disp == EMPTY; disp += SOUTH );
          if ( *disp & (WQ_MASK | WR_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[SOUTH] & (WQ_MASK | WK_MASK | WR_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- EAST
   if ( base[EAST] == EMPTY )
   {
      if ( queensAndRooks > 0 )
      {
          for ( disp = base + 2*EAST; *disp == EMPTY; disp += EAST );
          if ( *disp & (WQ_MASK | WR_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[EAST] & (WQ_MASK | WK_MASK | WR_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- WEST
   if ( base[WEST] == EMPTY )
   {
      if ( queensAndRooks > 0 )
      {
          for ( disp = base + 2*WEST; *disp == EMPTY; disp += WEST );
          if ( *disp & (WQ_MASK | WR_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[WEST] & (WQ_MASK | WK_MASK | WR_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- NORTHEAST
   if ( base[NORTHEAST] == EMPTY )
   {
      if ( queensAndBishops > 0 )
      {
          for ( disp = base + 2*NORTHEAST; *disp == EMPTY; disp += NORTHEAST );
          if ( *disp & (WQ_MASK | WB_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[NORTHEAST] & (WQ_MASK | WK_MASK | WB_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- NORTHWEST
   if ( base[NORTHWEST] == EMPTY )
   {
      if ( queensAndBishops > 0 )
      {
          for ( disp = base + 2*NORTHWEST; *disp == EMPTY; disp += NORTHWEST );
          if ( *disp & (WQ_MASK | WB_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[NORTHWEST] & (WQ_MASK | WK_MASK | WB_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- NORTH
   if ( base[NORTH] == EMPTY )
   {
      if ( queensAndRooks > 0 )
      {
          for ( disp = base + 2*NORTH; *disp == EMPTY; disp += NORTH );
          if ( *disp & (WQ_MASK | WR_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[NORTH] & (WQ_MASK | WK_MASK | WR_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   PROFILER_EXIT();
   return cFALSE;
}


//--------------------------------------------------------------------------


cBOOLEAN ChessBoard::IsAttackedByBlack ( int offset ) const
{
   PROFILER_ENTER (PX_ATTACK);
   const SQUARE * const base = board + offset;
   const SQUARE *disp;

   // Look for knight attacks...

   if ( inventory[BN_INDEX] > 0 )
   {
       if ( (base [ OFFSET(1,2)   ] & BN_MASK) ||
            (base [ OFFSET(1,-2)  ] & BN_MASK) ||
            (base [ OFFSET(-1,2)  ] & BN_MASK) ||
            (base [ OFFSET(-1,-2) ] & BN_MASK) ||
            (base [ OFFSET(2,1)   ] & BN_MASK) ||
            (base [ OFFSET(2,-1)  ] & BN_MASK) ||
            (base [ OFFSET(-2,1)  ] & BN_MASK) ||
            (base [ OFFSET(-2,-1) ] & BN_MASK) )
       {
	      PROFILER_EXIT();
          return cTRUE;
       }
   }

   const int queensAndBishops = inventory[BQ_INDEX] + inventory[BB_INDEX];

   //-------------------------------------- NORTHEAST
   if ( base[NORTHEAST] == EMPTY )
   {
      if ( queensAndBishops > 0 )
      {
          for ( disp = base + 2*NORTHEAST; *disp == EMPTY; disp += NORTHEAST );
          if ( *disp & (BQ_MASK | BB_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[NORTHEAST] & (BQ_MASK | BK_MASK | BB_MASK | BP_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- NORTHWEST
   if ( base[NORTHWEST] == EMPTY )
   {
      if ( queensAndBishops > 0 )
      {
          for ( disp = base + 2*NORTHWEST; *disp == EMPTY; disp += NORTHWEST );
          if ( *disp & (BQ_MASK | BB_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[NORTHWEST] & (BQ_MASK | BK_MASK | BB_MASK | BP_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- NORTH
   const int queensAndRooks = inventory[BQ_INDEX] + inventory[BR_INDEX];

   if ( base[NORTH] == EMPTY )
   {
      if ( queensAndRooks > 0 )
      {
          for ( disp = base + 2*NORTH; *disp == EMPTY; disp += NORTH );
          if ( *disp & (BQ_MASK | BR_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[NORTH] & (BQ_MASK | BK_MASK | BR_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- EAST
   if ( base[EAST] == EMPTY )
   {
      if ( queensAndRooks > 0 )
      {
          for ( disp = base + 2*EAST; *disp == EMPTY; disp += EAST );
          if ( *disp & (BQ_MASK | BR_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[EAST] & (BQ_MASK | BK_MASK | BR_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- WEST
   if ( base[WEST] == EMPTY )
   {
      if ( queensAndRooks > 0 )
      {
          for ( disp = base + 2*WEST; *disp == EMPTY; disp += WEST );
          if ( *disp & (BQ_MASK | BR_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[WEST] & (BQ_MASK | BK_MASK | BR_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- SOUTHEAST
   if ( base[SOUTHEAST] == EMPTY )
   {
      if ( queensAndBishops > 0 )
      {
          for ( disp = base + 2*SOUTHEAST; *disp == EMPTY; disp += SOUTHEAST );
          if ( *disp & (BQ_MASK | BB_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[SOUTHEAST] & (BB_MASK | BQ_MASK | BK_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- SOUTHWEST
   if ( base[SOUTHWEST] == EMPTY )
   {
      if ( queensAndBishops > 0 )
      {
          for ( disp = base + 2*SOUTHWEST; *disp == EMPTY; disp += SOUTHWEST );
          if ( *disp & (BQ_MASK | BB_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[SOUTHWEST] & (BB_MASK | BQ_MASK | BK_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   //-------------------------------------- SOUTH
   if ( base[SOUTH] == EMPTY )
   {
      if ( queensAndRooks > 0 )
      {
          for ( disp = base + 2*SOUTH; *disp == EMPTY; disp += SOUTH );
          if ( *disp & (BQ_MASK | BR_MASK) )
          {
		     PROFILER_EXIT();
             return cTRUE;
          }
      }
   }
   else if ( base[SOUTH] & (BQ_MASK | BK_MASK | BR_MASK) )
   {
      PROFILER_EXIT();
      return cTRUE;
   }

   PROFILER_EXIT();
   return cFALSE;
}



/*--- end of file attack.cpp ---*/