/*==========================================================================

      crand.cpp  -  Copyright (C) 1993-1996 by Don Cross
      email: dcross@intersrv.com
      WWW:   http://www.intersrv.com/~dcross/

      Contains random number generator for chess.

==========================================================================*/

#include <stdlib.h>
#include <time.h>
#include "chess.h"


#define MULTIPLIER      0x015a4e35L
#define INCREMENT       1

static  INT32    Seed = 1;


static INT16 _ChessRandom ()
{
   Seed = MULTIPLIER * Seed + INCREMENT;
   return INT16(Seed >> 16) & 0x7fff;
}


int ChessRandom ( int n )
{
   return int(_ChessRandom()) % n;
}


class ChessRandomizer
{
public:
   ChessRandomizer()
   {
      Seed = INT32 ( time(NULL) );
   }
};


static ChessRandomizer Fred;


/*--- end of file crand.cpp ---*/