/*=========================================================================

	  doscga.cpp  -  Copyright (C) 1993-1997 by Don Cross
	  email: dcross@intersrv.com
	  WWW:   http://www.intersrv.com/~dcross/

	  Contains main() for MS-DOS CGA version of Chenard.

	 Revision history:

1996 February 28 [Don Cross]
	 Put in my new e-mail address, etc.

1993 August 30 [Don Cross]
	 Changing pointers to references in the interfaces where
	 appropriate.

=========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#include "chess.h"
#include "uicga.h"

unsigned _stklen = 0x6000;

#pragma argsused
int main ( int argc, char *argv[] )
{
   extern cBOOLEAN sound_flag;
   sound_flag = cFALSE;

   printf ( "\n"
			"Chenard / MS-DOS CGA version (27 March 1997)\n"
			"A chess program by Don Cross <dcross@intersrv.com>\n"
			"http://www.intersrv.com/~dcross\n\n" );

   ChessBoard       theBoard;
   ChessUI_dos_cga  theUserInterface;
   ChessGame theGame ( theBoard, theUserInterface );
   theGame.Play();

   return 0;
}


void ChessFatal ( const char *message )
{
   fprintf ( stderr, "Chess fatal:\n%s\n", message );

   FILE *errorLog = fopen ( "doscga.err", "wt" );
   if ( errorLog )
   {
      fprintf ( errorLog, "Chess fatal:\n%s\n", message );
      fclose ( errorLog );
   }

   exit(1);
}


/*--- end of file doscga.cpp ---*/