/*=========================================================================

      dosvga.cpp  -  Copyright (C) 1993-1996 by Don Cross
      email: dcross@intersrv.com
      WWW:   http://www.intersrv.com/~dcross/

      Contains main() for MS-DOS VGA version of Chenard.

     Revision history:

1996 March 6 [Don Cross]
     Added code to preserve original video mode upon exit.

1996 March 2 [Don Cross]
     Copied from doscga.cpp to make a new VGA version of Chenard.

1996 February 28 [Don Cross]
     Put in my new e-mail address, etc.

1993 August 30 [Don Cross]
     Changing pointers to references in the interfaces where
     appropriate.

=========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#include "chess.h"
#include "uivga.h"

unsigned _stklen = 0x6000;

text_info StartupTextInfo;

void Advertise()
{
   printf ( "\n"
			"Chenard / MS-DOS VGA version (9 May 1997)\n"
            "A chess program by Don Cross <dcross@intersrv.com>\n"
            "http://www.intersrv.com/~dcross\n\n" );
}


void ExitCode()
{
    textmode ( StartupTextInfo.currmode );
    Advertise();
}


#pragma argsused
int main ( int argc, char *argv[] )
{
   gettextinfo ( &StartupTextInfo );
   atexit ( ExitCode );

   extern cBOOLEAN sound_flag;
   sound_flag = cFALSE;

   extern int Learn_Output;
   Learn_Output = 0;
   Advertise();

   ChessBoard       theBoard;
   ChessUI_dos_vga  theUserInterface;
   ChessGame theGame ( theBoard, theUserInterface );
   theGame.Play();

   Advertise();

   return 0;
}


void ChessFatal ( const char *message )
{
   fprintf ( stderr, "Chess fatal:\n%s\n", message );

   FILE *errorLog = fopen ( "doscga.err", "wt" );
   if ( errorLog )
   {
      fprintf ( errorLog, "Chess fatal:\n%s\n", message );
      fclose ( errorLog );
   }

   exit(1);
}


/*--- end of file dosvga.cpp ---*/