#include <stdio.h>
#include <iostream.h>
#include "chess.h"
#include "lrntree.h"

int main ( int argc, char *argv[] )
{
	const char *treeFilename = "chenard.tre";
	if ( argc > 1 )
		treeFilename = argv[1];

	LearnTree tree;
	if ( !tree.open(treeFilename) )
	{
		cerr << "Cannot open input file '" << treeFilename << "'" << endl;
		return 1;
	}

	cout << "Successfully opened input file '" << treeFilename << "'" << endl;

	const char *listFilename = "dumptree.txt";
	FILE *f = fopen (listFilename, "wt");
	if ( !f )
	{
		cerr << "Cannot open output list file '" << listFilename << "'" << endl;
		return 1;
	}

	LearnBranch branch;
	for ( INT32 offset=0; tree.read(offset,branch); offset++ )
	{
		fprintf ( f,
			"%10ld:  m=[%3u,%3u,%6d] t=%-6.2lf wl=%-3ld  c=%-9ld  s=%-9ld\n",
			long (offset),
			unsigned (branch.move.source),
			unsigned (branch.move.dest),
			int (branch.move.score),
			double (branch.timeAnalyzed / 100.0),
			long (branch.winsAndLosses),
			long (branch.child),
			long (branch.sibling) );
	}

	fclose (f);
	tree.close();

	return 0;
}