#include <stdio.h>
#include <stdlib.h>
#include "chess.h"
#include "lrntree.h"

int main()
{
    LearnTree tree;
    tree.open ( "chenard.tre" );
    LearnBranch branch;

    for ( INT32 offset=0; tree.read(offset,branch); offset++ )
    {
        if ( branch.child == 0xffff )
            branch.child = -1;

        if ( branch.sibling == 0xffff )
            branch.sibling = -1;

        if ( branch.winsAndLosses & 0x8000 )
            branch.winsAndLosses |= 0xffff0000;

        tree.write ( offset, branch );
    }

    return 0;
}

void ChessFatal ( const char *msg )
{
    fprintf ( stderr, "%s\n", msg );
    exit(1);
}