/*=========================================================================

     human.cpp  -  Copyright (C) 1993-1996 by Don Cross
     email: dcross@intersrv.com
     WWW:   http://www.intersrv.com/~dcross/

     Contains the class HumanChessPlayer.

     Revision history:

1993 August 30 [Don Cross]
     Changing pointers to references in the interfaces where
     appropriate.

1994 January 15 [Don Cross]
     Added check for SPECIAL_MOVE_NULL in HumanChessPlayer::GetMove().

1994 January 30 [Don Cross]
     Added check for SPECIAL_MOVE_EDIT.

=========================================================================*/

#include "chess.h"


HumanChessPlayer::HumanChessPlayer ( ChessUI &ui ):
   ChessPlayer(ui)
{
}


HumanChessPlayer::~HumanChessPlayer()
{
}


cBOOLEAN HumanChessPlayer::GetMove ( ChessBoard &board,
                                     Move       &move,
                                     INT32      &timeSpent )
{
   MoveList legalMoves;
   int      i;
   int      source, dest;
   INT32    startTime = ChessTime();

   board.GenMoves ( legalMoves );

   for(;;)
   {
      if ( !userInterface.ReadMove ( board, source, dest ) )
      {
         timeSpent = ChessTime() - startTime;
         return cFALSE;
      }

      // Regenerate legal moves in case they edited the board.
      board.GenMoves ( legalMoves );

      // The following check allows certain UI tricks to work...
      if ( dest == SPECIAL_MOVE_NULL ||
           (dest & SPECIAL_MOVE_MASK) == SPECIAL_MOVE_EDIT )
      {
         move.source = source;
         move.dest = dest;
         move.score = 0;
         timeSpent = ChessTime() - startTime;
         return cTRUE;
      }

      // This checks for pawn promotion and stuff like that.
      move.Fix ( board, source, dest, userInterface );

      // See if the move we just read is legal!
      for ( i=0; i < legalMoves.num; i++ )
      {
         if ( move == legalMoves.m[i] )
         {
            // We found the move in the list of legal moves.
            // Therefore, the move must be legal.
            timeSpent = ChessTime() - startTime;
            return cTRUE;
         }
      }
   }
}


/*--- end of file human.cpp ---*/
