/*===============================================================================

    lrntree.h  -  Copyright (C) 1996 by Don Cross
    email: dcross@intersrv.com
    WWW:   http://www.intersrv.com/~dcross/

    This is a new module for learning new openings.
    This file replaces the old file 'learn.cpp'.
    Now, instead of reading the entire tree into memory, we encapsulate
    direct I/O to a binary file which contains the tree.  This saves
    a lot of dynamic memory and prevents us from having to read and write
    the entire tree all at once.

    Revision history:

1996 August 22 [Don Cross]
     Started writing this code.

=============================================================================*/
#ifndef __ddc_chenard_lrntree_h
#define __ddc_chenard_lrntree_h


struct LearnBranch
{
    Move   move;           // The move source, dest, and score of this branch
    INT32  timeAnalyzed;   // Amount of time move was analyzed in centiseconds
    INT32  winsAndLosses;  // +1 for every White win, -1 for every Black win
    INT32  child;          // first branch which is a child of this one
    INT32  sibling;        // immediate sibling to this branch
    INT32  reserved [4];   // ... and some room to grow

    LearnBranch():
        timeAnalyzed (0),
        winsAndLosses (0),
        child (-1),
        sibling (-1)
    {
        move.source = 0;
        move.dest = 0;
        move.score = 0;
        reserved[0] = 0;
        reserved[1] = 0;
        reserved[2] = 0;
        reserved[3] = 0;
    }
};


const long LearnBranchFileSize = 9*4;   // number of bytes per file record


class LearnTree
{
public:
    LearnTree():  f(0) {}
    ~LearnTree();

    // NOTE:  All functions return 0 on failure, 1 on success.

    int  open ( const char *filename );
    int  create ( const char *filename );
    int  flush();
    int  close();

    // Low-level functions...

    int read  ( INT32 offset, LearnBranch & );
    int write ( INT32 offset, const LearnBranch & );
    int append ( INT32 &offset, const LearnBranch & );
    INT32  numNodes();

    int insert ( LearnBranch &branch, INT32 parent, INT32 &offset );

    // High-level functions...

    cBOOLEAN familiarPosition (
        ChessBoard &board,
        Move &bestmove,
        long timeLimit,
        const MoveList & );   // legal moves: included so we can do sanity check

    // Returns the following values:
    //    0 = Tree not changed
    //    1 = Modified an existing branch
    //    2 = Added a new branch

    int rememberPosition (
        ChessBoard &board,
        Move bestmove,
        long timeLimit );

    void learnFromGame (
        ChessBoard &board,
        ChessSide winner );

    void trainer (
        ComputerChessPlayer *whitePlayer,
        ComputerChessPlayer *blackPlayer,
        ChessBoard &board,
        ChessUI &ui,
        INT32 timeLimit );

protected:
    int  write ( INT32 );
    int  read  ( INT32 & );
    int  write ( Move );
    int  read  ( Move & );

    INT32  numNodesAtDepth (
        INT32 root,
        int targetDepth,
        int currentDepth,
        INT32 searchTime );

    void trainDepth (
		INT32 offset,
        INT32 timeLimit,
        ChessUI &ui,
        ComputerChessPlayer *whitePlayer,
        ComputerChessPlayer *blackPlayer,
        ChessBoard &board,
        int targetDepth,
        int currentDepth );

private:
    FILE *f;
};


#endif // __ddc_chenard_lrntree_h
/*--- end of file lrntree.h ---*/
