// os2pmch.h  -  Don Cross, August 1993
// Contains special stuff for the OS/2 PM version of NewChess.

#define CHESS_PROGRAM_NAME  "Dr. Chenard"

extern char TitleBarText_WhitesTurn[];
extern char TitleBarText_BlacksTurn[];
extern char TitleBarText_GameOver[];

extern cBOOLEAN Global_ResetGameFlag;
extern cBOOLEAN Global_ClearBoardFlag;

extern char GameSave_filename[];

extern int Global_button2click;

// Width and length of a chess square bitmap...
#define  CHESS_BITMAP_DX   40
#define  CHESS_BITMAP_DY   40

#define  CHESS_BOARD_BORDER_DX   2
#define  CHESS_BOARD_BORDER_DY   2

#define  CHESS_WINDOW_DX  (8*CHESS_BITMAP_DX + 2*CHESS_BOARD_BORDER_DX)
#define  CHESS_WINDOW_DY  (8*CHESS_BITMAP_DX + 2*CHESS_BOARD_BORDER_DY)

#define  SQUARE_SCREENX1(x)    ((x)*CHESS_BITMAP_DX + CHESS_BOARD_BORDER_DX)
#define  SQUARE_SCREENY1(y)    ((y)*CHESS_BITMAP_DY + CHESS_BOARD_BORDER_DY)
#define  SQUARE_SCREENX2(x)    (SQUARE_SCREENX1((x)+1) - 1)
#define  SQUARE_SCREENY2(y)    (SQUARE_SCREENY1((y)+1) - 1)

#define  SQUARE_MIDX(x)  ((SQUARE_SCREENX1(x)+SQUARE_SCREENX2(x))/2)
#define  SQUARE_MIDY(y)  ((SQUARE_SCREENY1(y)+SQUARE_SCREENY2(y))/2)

#define  SQUARE_CHESSX(x)    (((x)-CHESS_BOARD_BORDER_DX)/CHESS_BITMAP_DX)
#define  SQUARE_CHESSY(y)    (((y)-CHESS_BOARD_BORDER_DY)/CHESS_BITMAP_DY)

// Width of the text debug display area in the client window...
#define  DEBUG_WINDOW_DX   200

// Static text control IDs that I use in the debug area...
#define  STATIC_ID_WHITES_MOVE        ULONG(1)
#define  STATIC_ID_BLACKS_MOVE        ULONG(2)
#define  STATIC_ID_CURRENT_MOVE       ULONG(4)
#define  STATIC_ID_BEST_SO_FAR        ULONG(5)
#define  STATIC_ID_NODES_VISITED      ULONG(6)
#define  STATIC_ID_NODES_EVALUATED    ULONG(7)
#define  STATIC_ID_FWPR               ULONG(8)
#define  STATIC_ID_VIS_PER_SECOND     ULONG(9)
#define  STATIC_ID_EVAL_PER_SECOND    ULONG(10)

#define  FIRST_DEBUG_STATIC_ID    STATIC_ID_WHITES_MOVE
#define  LAST_DEBUG_STATIC_ID     STATIC_ID_EVAL_PER_SECOND

// User-defined window message types....

#define  WM_DDC_FATAL              (WM_USER + 100)
#define  WM_DDC_PROMOTE_PAWN       (WM_USER + 101)
#define  WM_DDC_GAME_RESULT        (WM_USER + 102)
#define  WM_DDC_PREDICT_MATE       (WM_USER + 103)
#define  WM_DDC_ENTER_HUMAN_MOVE   (WM_USER + 104)
#define  WM_DDC_LEAVE_HUMAN_MOVE   (WM_USER + 105)

extern HWND global_hwndClient;   // client area of chess board display

void ChessBeep ( int freq, int milliseconds );

class BoardDisplayBuffer
{
public:
   BoardDisplayBuffer();
   ~BoardDisplayBuffer();

   void freshenSquare ( int x, int y );
   void freshenBoard();

   //------------------- display stuff ---------------------

   void loadBitmaps ( HPS );

   void draw ( HPS,
               int minx = 0, int maxx = 7,
               int miny = 0, int maxy = 7 );

   void drawSquare ( HPS, SQUARE, int x, int y );

   void update ( const ChessBoard & );
   void setSquareContents ( int x, int y, SQUARE );

   void setView ( int newWhiteView );
   void toggleView()   {whiteViewFlag = !whiteViewFlag;}
   int  queryWhiteView() const  {return whiteViewFlag;}

   cBOOLEAN isChanged ( int x, int y ) const
   {
      if ( x>=0 && x<=7 && y>=0 && y<=7 )
      {
         return changed[x][y];
      }
      else
      {
         return cFALSE;
      }
   }

   //------------------- read move stuff ---------------------

   //Things called by chess thread...

   void       startReadingMove ( cBOOLEAN whiteIsMoving );
   cBOOLEAN   isReadingMove() const;
   void       copyMove ( int &source, int &dest );

   //Things called by main thread...
   void squareSelectedNotify ( int x, int y );

   // Called by chess thread's UI to select/deselect squares
   void selectSquare ( int x, int y );
   void deselectSquare()   {selectSquare(-1,-1);}

private:
   SQUARE    board [8] [8];
   cBOOLEAN  changed [8] [8];

   int  selX, selY;   // square currently selected

   HBITMAP  wpw, wnw, wbw, wrw, wqw, wkw;
   HBITMAP  wpb, wnb, wbb, wrb, wqb, wkb;
   HBITMAP  bpw, bnw, bbw, brw, bqw, bkw;
   HBITMAP  bpb, bnb, bbb, brb, bqb, bkb;
   HBITMAP  eb, ew, qmb, qmw;

   int bitmapsLoadedFlag;
   int whiteViewFlag;

   cBOOLEAN  readingMoveFlag;
   cBOOLEAN  gotSource;
   cBOOLEAN  moverIsWhite;
   int       moveSource, moveDest;
};


extern BoardDisplayBuffer TheBoardDisplayBuffer;


struct DefPlayerInfo
{
   enum Type
   {
      computerPlayer,
      humanPlayer
   };

   Type   whiteType;
   Type   blackType;

   long   whiteThinkTime;
   long   blackThinkTime;

   int    whiteUseSeconds;   // search in seconds or plies?
   int    blackUseSeconds;   // search in seconds or plies?

   int    whiteSearchBias;
   int    blackSearchBias;

   int    restoreGameFlag;
};


// Special UI for OS/2 PM

#define CHESSUI_OS2_PM

class ChessUI_os2_pm: public ChessUI
{
public:
   ChessUI_os2_pm ( HWND client, HWND frame );
   ~ChessUI_os2_pm();

   ChessPlayer *CreatePlayer ( ChessSide );
   cBOOLEAN ReadMove ( ChessBoard &, int &source, int &dest );
   SQUARE PromotePawn ( int PawnDest, ChessSide );
   void DisplayMove ( ChessBoard &, Move );
   void RecordMove ( ChessBoard &, Move, INT32 thinkTime );
   void DrawBoard ( const ChessBoard & );
   void ReportEndOfGame ( ChessSide winner );
   void Resign ( ChessSide iGiveUp );

   void DisplayBestMoveSoFar ( const ChessBoard &, Move, int level );
   void DisplayCurrentMove ( const ChessBoard &, Move, int level );
   void PredictMate ( int numMovesFromNow );

   void ReportComputerStats ( INT32   thinkTime,
                              UINT32  nodesVisited,
                              UINT32  nodesEvaluated,
                              UINT32  nodesGenerated,
                              int     fwSearchDepth,
                              UINT32  visnodes [NODES_ARRAY_SIZE],
                              UINT32  gennodes [NODES_ARRAY_SIZE] );

   struct gameReport
   {
      ChessSide   winner;
      cBOOLEAN    resignation;
   };

private:
   HWND hwnd;       // Handle of chess board client window for PM program
   HWND frameHwnd;  // Handle of entire frame window
};


struct BoardEditRequest
{
   cBOOLEAN   isValid;   // Set by WindProc, cleared by ChessUI
   int        x, y;      // coordinates to be edited
   SQUARE     square;    // what to put in square

   BoardEditRequest():  isValid(cFALSE), x(0), y(0), square(EMPTY) {}
};

extern BoardEditRequest Global_BoardEditRequest;
extern DefPlayerInfo    DefPlayer;


// end of file os2pmch.h
