/*=======================================================================

	profiler.cpp  -  Copyright (C) 1997 by Don Cross

	Contains an execution profiler for Chenard.
	This should help me figure out which parts of the code
	need to be optimized.

	Revision history:

1997 June 10 [Don Cross]
	Started writing.

=======================================================================*/
#include <windows.h>

#include "chess.h"
#include "winguich.h"
#include "profiler.h"

#define PROFILE_ARRAY_SIZE 64
int ProfilerHitCount [PROFILE_ARRAY_SIZE];
int ProfilerCallCount [PROFILE_ARRAY_SIZE];
int ProfilerIndex = PX_UNDEFINED;
static int TimerEnabledFlag = 0;

#ifdef CHENARD_PROFILER

void StartProfiler()
{
	// reset the table of counters...

	for ( int i=0; i<PROFILE_ARRAY_SIZE; i++ )
		ProfilerHitCount[i] = ProfilerCallCount[i] = 0;

	ProfilerIndex = PX_UNDEFINED;		

	// start the Win32 timer...
	
	TimerEnabledFlag = (SetTimer(HwndMain,1,55,NULL) != NULL);
}


void StopProfiler()
{
	if ( TimerEnabledFlag )
	{
		KillTimer ( HwndMain, 1 );
	}
}

#endif

/*--- end of file profiler.h ---*/