/*=======================================================================

	profiler.h  -  Copyright (C) 1997 by Don Cross

	Contains an execution profiler for Chenard.
	This should help me figure out which parts of the code
	need to be optimized.

	Revision history:

1997 June 10 [Don Cross]
	Started writing.

=======================================================================*/
#ifndef __ddc_chenard_profiler_h
#define __ddc_chenard_profiler_h

#define  PX_UNDEFINED	 0
#define  PX_SEARCH		 1
#define  PX_EVAL		 2
#define  PX_GENMOVES	 3
#define  PX_GENCAPS      4
#define  PX_MAKEMOVE	 5
#define  PX_UNMOVE       6
#define  PX_CANMOVE      7
#define  PX_MOVEORDER    8
#define  PX_ATTACK       9

#ifdef CHENARD_PROFILER
	void StartProfiler();
	void StopProfiler();

	// all of the PX_... symbols are indices into the profiler array.

	extern int ProfilerHitCount[];
	extern int ProfilerCallCount[];
	extern int ProfilerIndex;

	#define PROFILER_ENTER(newIndex)  \
		int ___oldIndex=ProfilerIndex; ProfilerIndex=(newIndex); ++ProfilerCallCount[newIndex];

	#define PROFILER_EXIT()  \
		ProfilerIndex = ___oldIndex;

#else   // INCLUDE_PROFILER
	inline void StartProfiler() {}
	inline void StopProfiler() {}

	#define PROFILER_ENTER(newIndex) 
	#define PROFILER_EXIT() 
#endif  // INCLUDE_PROFILER


#endif // __ddc_chenard_profiler_h

/*--- end of file profiler.h ---*/