/*=========================================================================

	speak.cpp  -  Copyright (C) 1997 by Don Cross <dcross@intersrv.com>

	This file contains a C++ function for speaking my chess moves,
	using a set of stock wave files with known filenames.
	This code works only in the Win32 environment.

	Revision history:

1997 February 1 [Don Cross]
	Started writing.

=========================================================================*/

#include <string.h>
#include <windows.h>
#include <mmsystem.h>
#include "chess.h"


static void PlayWav ( const char *prefix )
{
	char filename [256];
	strcpy ( filename, prefix );
	strcat ( filename, ".wav" );
    BOOL playResult = PlaySound ( filename, NULL, SND_FILENAME|SND_SYNC );
}


static void PlayWav ( char c )
{
	char prefix[2];
	prefix[0] = c;
	prefix[1] = '\0';
	PlayWav ( prefix );
}


void Speak ( ChessBoard &, Move, const char *moveString )
{
	// Piece being moved...
	const char *p = moveString;
	char c = *p++;
	int castled = 0;
	switch ( c )
	{
		case 'N':	PlayWav("knight");		break;
		case 'B':	PlayWav("bishop");		break;
		case 'R':	PlayWav("rook");		break;
		case 'Q':	PlayWav("queen");		break;
		case 'K':	PlayWav("king");		break;
		case 'O':
		{
			castled = 1;
			// p now points to either "-O-O???" or "-O???"
			//                         01234
			if ( p[2] == '-' && p[3] == 'O' )
			{
				PlayWav ( "ooo" );
				p += 4;
			}
			else
			{
				PlayWav ( "oo" );
				p += 2;
			}
		}
		default:
		{
			if ( c >= 'a' && c <= 'h' )
			{
				PlayWav ( c );
				PlayWav ( *p++ );
			}
		}
	}

	if ( !castled )
	{
		if ( *p && *p!='-' && *p!='x' )
		{
			PlayWav ( "at" );
			while ( *p && *p!='-' && *p!='x' )
			{
				PlayWav ( *p++ );
			}
		}

		if ( *p == '-' )
		{
			PlayWav ( "movesto" );
			++p;
		}
		else if ( *p == 'x' )
		{
			PlayWav ( "takes" );
			++p;
		}

		switch ( c = *p++ )
		{
			case 'N':	PlayWav("knight");		break;
			case 'B':	PlayWav("bishop");		break;
			case 'R':	PlayWav("rook");		break;
			case 'Q':	PlayWav("queen");		break;
			case 'K':	PlayWav("king");		break;
			default:
			{
				if ( c >= 'a' && c <= 'h' )
				{
					PlayWav ( c );
					PlayWav ( *p++ );
				}
			}
		}
	}

	while ( *p )
	{
		if ( strcmp ( p, " mate" ) == 0 )
		{
			PlayWav ( "mate" );
			break;
		}
		else if ( strcmp ( p, " stale" ) == 0 )
		{
			PlayWav ( "stale" );
			break;
		}
		else if ( strcmp ( p, " e.p." ) == 0 )
		{
			PlayWav ( "ep" );
			break;
		}
		else switch ( c = *p++ )
		{
			case '/':	PlayWav ("prom");	break;
			case '+':	PlayWav ("check");	break;
			case 'N':	PlayWav ("knight");	break;
			case 'B':	PlayWav ("bishop"); break;
			case 'R':	PlayWav ("rook");	break;
			case 'Q':	PlayWav ("queen");	break;
		}
	}
}


/*--- end of file speak.cpp ---*/
