/*============================================================================

      uistdio.h  -  Copyright (C) 1993-1996 by Don Cross
      email: dcross@intersrv.com
      WWW:   http://www.intersrv.com/~dcross/

      This is a portable user interface class for my new chess code.

      Revision history:

============================================================================*/

#define CHENARD_RELEASE 1

class ChessUI_stdio: public ChessUI
{
public:
   ChessUI_stdio();
   ~ChessUI_stdio();

   ChessPlayer *CreatePlayer ( ChessSide );
   cBOOLEAN ReadMove ( ChessBoard &, int &source, int &dest );
   SQUARE PromotePawn ( int PawnDest, ChessSide );
   void DisplayMove ( ChessBoard &, Move );
   void RecordMove ( ChessBoard &, Move, INT32 thinkTime );
   void DrawBoard ( const ChessBoard & );
   void ReportEndOfGame ( ChessSide winner );
   void DisplayBestMoveSoFar ( const ChessBoard &, Move, int level );
   void DisplayCurrentMove ( const ChessBoard &, Move, int level );
   void DisplayBestPath ( const ChessBoard &, const BestPath & );
   void PredictMate ( int numMoves );

   void Resign ( ChessSide ) {}

   void ReportComputerStats ( INT32   thinkTime,
                              UINT32  nodesVisited,
                              UINT32  nodesEvaluated,
                              UINT32  nodesGenerated,
                              int     fwSearchDepth,
                              UINT32  vis [NODES_ARRAY_SIZE],
                              UINT32  gen [NODES_ARRAY_SIZE] );

   void SetScoreDisplay ( cBOOLEAN _showScores )
   {
       showScores = _showScores;
   }

   cBOOLEAN QueryScoreDisplay () const
   {
       return showScores;
   }

private:
   Move ConvertStringToMove ( const ChessBoard &,
                              const char from_to [4] );

   cBOOLEAN whiteIsHuman;
   cBOOLEAN blackIsHuman;
   cBOOLEAN showScores;   // should UI show moves' min-max scores?
   cBOOLEAN rotateBoard;  // TRUE when board should be shown opposite of "sensible" way

   int numPlayersCreated;

   ChessPlayer *whitePlayer;
   ChessPlayer *blackPlayer;
};


/*--- end of file uistdio.h ---*/
