/*=============================================================================

// winguich.h  -  Don Cross, July 1996
// Header file for Win32 GUI version of Chenard.

Revision history:

1997 March 3 [Don Cross]
	Changed cBOOLEAN Global_ViewDebugFlag into int Global_AnalysisType.
	Now the allowed values are 0=none, 1=bestpath, 2=currentpath.

1997 January 30 [Don Cross]
	Adding the class MoveUndoPath, which tracks moves made in the game.
	When the user does an Undo, this program backs up in the game two plies
	so that the user can play a different move in a previous position, but
	still remembers the moves already in the path until the user chooses a new
	move, in which case all "futures" are forgotten.

1996 July ?? [Don Cross]
	Started writing.

=============================================================================*/

#define CHESS_PROGRAM_NAME  "Chenard"
extern const char ChessProgramName[];

extern HWND HwndMain;    // Handle of main program window
extern HWND global_hInstance;


extern char TitleBarText_WhitesTurn[];
extern char TitleBarText_BlacksTurn[];
extern char TitleBarText_GameOver[];

extern cBOOLEAN Global_ResetGameFlag;
extern cBOOLEAN Global_ClearBoardFlag;
extern cBOOLEAN Global_AbortFlag;
extern cBOOLEAN Global_GameSaveFlag;
extern cBOOLEAN Global_GameOpenFlag;
extern cBOOLEAN Global_HaveFilename;
extern cBOOLEAN Global_GameModifiedFlag;
extern cBOOLEAN Global_GameOverFlag;
extern cBOOLEAN Global_TacticalBenchmarkFlag;
extern char Global_GameFilename[];
extern cBOOLEAN Global_UndoMoveFlag;
extern cBOOLEAN Global_RedoMoveFlag;

extern char GameSave_filename[];

extern int Global_button2click;

// Width and length of a chess square bitmap...
extern int BitmapScaleFactor, BitmapScaleDenom;
extern int RawBitmapDX, RawBitmapDY;
extern int ChessBoardSize;   // facilitates saving/loading option (0=small, 1=medium, 2=large)
void NewBoardSize ( int );

#define  CHESS_BITMAP_DX   ((RawBitmapDX*BitmapScaleFactor)/BitmapScaleDenom)
#define  CHESS_BITMAP_DY   ((RawBitmapDY*BitmapScaleFactor)/BitmapScaleDenom)

#define  CHESS_BOARD_BORDER_DX   4
#define  CHESS_BOARD_BORDER_DY   4
#define  MOVE_TEXT_DY  14

#define  CHESS_WINDOW_DX  (8*CHESS_BITMAP_DX + 2*CHESS_BOARD_BORDER_DX)
#define  CHESS_WINDOW_DY  (8*CHESS_BITMAP_DX + 2*CHESS_BOARD_BORDER_DY + MOVE_TEXT_DY)

#define  SQUARE_SCREENX1(x)    ((x)*CHESS_BITMAP_DX + CHESS_BOARD_BORDER_DX)
#define  SQUARE_SCREENY1(y)    ((7-(y))*CHESS_BITMAP_DY + CHESS_BOARD_BORDER_DY)
#define  SQUARE_SCREENX2(x)    (SQUARE_SCREENX1((x)+1) - 1)
#define  SQUARE_SCREENY2(y)    (SQUARE_SCREENY1((y)-1) - 1)

#define  SQUARE_MIDX(x)  ((SQUARE_SCREENX1(x) + SQUARE_SCREENX2(x))/2)
#define  SQUARE_MIDY(y)  ((SQUARE_SCREENY1(y) + SQUARE_SCREENY2(y))/2)

#define  SQUARE_CHESSX(x)    (((x)-CHESS_BOARD_BORDER_DX)/CHESS_BITMAP_DX)
#define  SQUARE_CHESSY(y)    (7-(((y)-CHESS_BOARD_BORDER_DY)/CHESS_BITMAP_DY))

// Width of the text debug display area in the client window...
#define  DEBUG_WINDOW_DX   200

// Static text control IDs that I use in the debug area.
// In Win32, these are not actual control window IDs but tags
// I use for updating a table of strings and redrawing them
// manually on the display.
#define  STATIC_ID_CURRENT_MOVE        1
#define  STATIC_ID_NODES_VISITED       2
#define  STATIC_ID_NODES_EVALUATED     3
#define  STATIC_ID_WHITES_MOVE         100
#define  STATIC_ID_BLACKS_MOVE         101

#define  MAX_BESTPATH_DISPLAY         30
#define  STATIC_ID_BESTPATH(depth)    (5+(depth))

#define  FIRST_RIGHT_TEXTID    STATIC_ID_CURRENT_MOVE
#define  LAST_RIGHT_TEXTID     STATIC_ID_BESTPATH(MAX_BESTPATH_DISPLAY)

#define MAX_CHESS_TEXT             128
#define CHESS_TEXT_FONT            ANSI_FIXED_FONT
#define CHESS_TEXT_COLOR           RGB(255,255,255)
#define CHESS_TEXT_COLOR2          RGB(255,255,0)
#define CHESS_BACKGROUND_COLOR     RGB(0,0,127)

cBOOLEAN ProcessChessCommands ( ChessBoard &board, int &source, int &dest );

class ChessDisplayTextBuffer
{
public:
    enum marginType
    {
	margin_none,
	margin_right,
	margin_bottom
    };

    ChessDisplayTextBuffer ( HWND, int _id, int _x, int _y, 
	    marginType _margin=margin_right, int _textFont=ANSI_FIXED_FONT,
		int _highlight = 0 );

    ~ChessDisplayTextBuffer();
    void setText ( const char *newText );
    void draw (HDC) const;   // should be called by window proc only.
    void calcRegion ( RECT & ) const;
    void reposition();

    static void SetText ( int _id, const char *newText );
    static ChessDisplayTextBuffer *Find ( int _id );
    static void DrawAll (HDC);
    static void DeleteAll();
    static void RepositionAll();

private:
    int id;
    int x, y;
    HWND hwnd;
    char *text;
    ChessDisplayTextBuffer *next;
    marginType margin;
    int textFont;
	int highlight;

    static ChessDisplayTextBuffer *All;
};

// User-defined window message types....

#define  WM_DDC_PROMOTE_PAWN       (WM_USER + 101)
#define  WM_DDC_GAME_RESULT        (WM_USER + 102)
#define  WM_DDC_PREDICT_MATE       (WM_USER + 103)
#define  WM_DDC_ENTER_HUMAN_MOVE   (WM_USER + 104)
#define  WM_DDC_LEAVE_HUMAN_MOVE   (WM_USER + 105)
#define  WM_DDC_GAME_OVER          (WM_USER + 106)
#define  WM_DDC_FATAL              (WM_USER + 107)
#define  WM_DDC_DRAW_VECTOR        (WM_USER + 108)

void ChessBeep ( int freq, int milliseconds );

#define  PIECE_FONT_ORIGINAL     0
#define  PIECE_FONT_TILBURG      1
#define  PIECE_FONT_SKAK         2
#define  NUM_PIECE_FONTS         3

extern int PieceFont_DX [NUM_PIECE_FONTS];
extern int PieceFont_DY [NUM_PIECE_FONTS];

class BoardDisplayBuffer
{
public:
   BoardDisplayBuffer();
   ~BoardDisplayBuffer();

   void freshenSquare ( int x, int y );
   void freshenBoard();

   //------------------- display stuff ---------------------

   void loadBitmaps ( HINSTANCE );
   void unloadBitmaps();
   void changePieceFont ( int newPieceFont );
   int  queryPieceFont() const { return pieceFont; }

   void draw ( HDC,
               int minx = 0, int maxx = 7,
               int miny = 0, int maxy = 7 );

   void drawSquare ( HDC, SQUARE, int x, int y );

   void update ( const ChessBoard & );
   void setSquareContents ( int x, int y, SQUARE );

   void setView ( int newWhiteView );
   void toggleView()   {whiteViewFlag = !whiteViewFlag;}
   int  queryWhiteView() const  {return whiteViewFlag;}

   cBOOLEAN isChanged ( int x, int y ) const
   {
      if ( x>=0 && x<=7 && y>=0 && y<=7 )
      {
         return changed[x][y];
      }
      else
      {
         return cFALSE;
      }
   }

   //------------------- read move stuff ---------------------

   //Things called by chess thread...

   void       startReadingMove ( cBOOLEAN whiteIsMoving );
   cBOOLEAN   isReadingMove() const;
   void       copyMove ( int &source, int &dest );

   //Things called by main thread...
   void squareSelectedNotify ( int x, int y );

   // Called by chess thread's UI to select/deselect squares
   void selectSquare ( int x, int y );
   void deselectSquare()   {selectSquare(-1,-1);}

   void showVector ( int x1, int y1, int x2, int y2 )
   {
       vx1 = x1;
	   vx2 = x2;
	   vy1 = y1;
	   vy2 = y2;
   }

   void hideVector() { vx1 = vx2 = vy1 = vy2 = -1; }

   void drawVector ( HDC );

private:
   int vx1, vx2, vy1, vy2;

   SQUARE    board [8] [8];
   cBOOLEAN  changed [8] [8];

   int  selX, selY;   // square currently selected

   HBITMAP  wpw, wnw, wbw, wrw, wqw, wkw;
   HBITMAP  wpb, wnb, wbb, wrb, wqb, wkb;
   HBITMAP  bpw, bnw, bbw, brw, bqw, bkw;
   HBITMAP  bpb, bnb, bbb, brb, bqb, bkb;
   HBITMAP  eb, ew, qmb, qmw;

   int bitmapsLoadedFlag;
   int whiteViewFlag;

   cBOOLEAN  readingMoveFlag;
   cBOOLEAN  gotSource;
   cBOOLEAN  moverIsWhite;
   int       moveSource, moveDest;

   int pieceFont;   // piece font index, 0 .. NUM_PIECE_FONTS-1

   HDC *tempHDC;
};


extern BoardDisplayBuffer TheBoardDisplayBuffer;


struct DefPlayerInfo
{
   enum Type
   {
      computerPlayer,
      humanPlayer
   };

   Type   whiteType;
   Type   blackType;

   long   whiteThinkTime;
   long   blackThinkTime;

   int    whiteUseSeconds;   // search in seconds or plies?
   int    blackUseSeconds;   // search in seconds or plies?

   int    whiteSearchBias;
   int    blackSearchBias;

   int    restoreGameFlag;
};


class ChessUI_win32_gui: public ChessUI
{
public:
   ChessUI_win32_gui ( HWND );
   ~ChessUI_win32_gui();

   ChessPlayer *CreatePlayer ( ChessSide );
   cBOOLEAN ReadMove ( ChessBoard &, int &source, int &dest );
   SQUARE PromotePawn ( int PawnDest, ChessSide );
   void DisplayMove ( ChessBoard &, Move );
   void RecordMove ( ChessBoard &, Move, INT32 thinkTime );
   void DrawBoard ( const ChessBoard & );
   void ReportEndOfGame ( ChessSide winner );
   void Resign ( ChessSide iGiveUp );

   void DisplayBestMoveSoFar ( const ChessBoard &, Move, int level );
   void DisplayCurrentMove ( const ChessBoard &, Move, int level );
   void DisplayBestPath ( const ChessBoard &, const BestPath & );
   void PredictMate ( int numMovesFromNow );
   void ReportSpecial ( const char *msg );

   void ReportComputerStats ( INT32   thinkTime,
                              UINT32  nodesVisited,
                              UINT32  nodesEvaluated,
                              UINT32  nodesGenerated,
                              int     fwSearchDepth,
                              UINT32  visnodes [NODES_ARRAY_SIZE],
                              UINT32  gennodes [NODES_ARRAY_SIZE] );

   // Force the computer to make a move NOW!
   void forceMove();

   struct gameReport
   {
      ChessSide   winner;
      cBOOLEAN    resignation;
   };

   double runTacticalBenchmark();   //returns elapsed time in seconds

   cBOOLEAN queryWhiteIsHuman() const { return whiteIsHuman; }
   cBOOLEAN queryBlackIsHuman() const { return blackIsHuman; }
   void setWhiteThinkTime ( INT32 hundredthsOfSeconds );
   void setBlackThinkTime ( INT32 hundredthsOfSeconds );
   INT32 queryWhiteThinkTime() const;
   INT32 queryBlackThinkTime() const;

   virtual void DebugPly ( int depth, ChessBoard &, Move );
   virtual void DebugExit ( int depth, ChessBoard &, SCORE );

private:
   HWND hwnd;
   ChessPlayer *whitePlayer;
   ChessPlayer *blackPlayer;
   cBOOLEAN whiteIsHuman;
   cBOOLEAN blackIsHuman;
   cBOOLEAN tacticalBenchmarkMode;
   cBOOLEAN enableMateAnnounce;
   cBOOLEAN speakMovesFlag;
   Move benchmarkExpectedMove;
   int vofs1[MAX_BESTPATH_DISPLAY];  // temporary offsets for display debug vectors on screen
   int vofs2[MAX_BESTPATH_DISPLAY];
   ComputerChessPlayer *benchmarkPlayer;
};


struct BoardEditRequest
{
   cBOOLEAN   isValid;   // Set by WindProc, cleared by ChessUI
   int        x, y;      // coordinates to be edited
   SQUARE     square;    // what to put in square

   BoardEditRequest():  isValid(cFALSE), x(0), y(0), square(EMPTY) {}
};


class MoveUndoPath
{
public:
	MoveUndoPath (): 
		moveList(0),
		size(0),
		current(0),
		length(0)
		{}
	~MoveUndoPath();
	void resetFromBoard ( const ChessBoard & );
	void undo ( ChessBoard & );
	void redo ( ChessBoard & );

private:
	int size;
	Move *moveList;   // dynamically allocated array of 'size'
	int current;      // index of current position in undo path
	int length;       // current total length of path
};


extern ChessBoard       GlobalBoard;
extern BoardEditRequest Global_BoardEditRequest;
extern DefPlayerInfo    DefPlayer;
extern ChessUI_win32_gui *Global_UI;
extern MoveUndoPath Global_MoveUndoPath;
extern cBOOLEAN Global_SpeakMovesFlag;

void Speak ( ChessBoard &, Move, const char *moveString );

/*--- end of file winguich.h ---*/
