pkgbase=openldap
pkgname=openldap
pkgdir=$PWD/../build
srcdir=$PWD
pkgver=2.4.59

cd ${pkgbase}-${pkgver}
sed -i 's|-m 644 $(LIBRARY)|-m 755 $(LIBRARY)|' libraries/{liblber,libldap,libldap_r}/Makefile.in
sed -i 's|#define LDAPI_SOCK LDAP_RUNDIR LDAP_DIRSEP "run" LDAP_DIRSEP "ldapi"|#define LDAPI_SOCK LDAP_DIRSEP "run" LDAP_DIRSEP "openldap" LDAP_DIRSEP "ldapi"|' include/ldap_defaults.h
sed -i 's|%LOCALSTATEDIR%/run|/run/openldap|' servers/slapd/slapd.{conf,ldif}
sed -i 's|-$(MKDIR) $(DESTDIR)$(localstatedir)/run|-$(MKDIR) $(DESTDIR)/run/openldap|' servers/slapd/Makefile.in

autoconf
CFLAGS="${CFLAGS} -DLDAP_CONNECTIONLESS" ./configure --prefix=/usr --libexecdir=/usr/lib \
  --sysconfdir=/etc --localstatedir=/var/lib/openldap --sbindir=/usr/bin \
  --enable-dynamic --enable-syslog --enable-ipv6 --enable-local \
  --enable-crypt --enable-spasswd --enable-modules \
  --enable-backends --disable-ndb --enable-overlays=mod \
  --with-cyrus-sasl --with-threads

sed -i -e 's/ -shared / -Wl,-O1,--as-needed\0/g' libtool

make depend

export LD_LIBRARY_PATH=${pkgdir}/usr/lib:${pkgdir}/libldap/usr/lib
export LD_RUN_PATH=${pkgdir}/usr/lib:${pkgdir}/libldap/usr/lib

make

make -C contrib/slapd-modules/nssov OPT="$CFLAGS $CPPFLAGS" prefix=/usr libexecdir=/usr/lib sysconfdir=/etc/openldap
make -C contrib/slapd-modules/autogroup OPT="$CFLAGS $CPPFLAGS" prefix=/usr libexecdir=/usr/lib sysconfdir=/etc/openldap
make -C contrib/slapd-modules/lastbind OPT="$CFLAGS $CPPFLAGS" prefix=/usr libexecdir=/usr/lib sysconfdir=/etc/openldap
make -C contrib/slapd-modules/passwd/sha2 OPT="$CFLAGS $CPPFLAGS" prefix=/usr libexecdir=/usr/lib sysconfdir=/etc/openldap

# Package libldap
pkgdir=$srcdir/../build/libldap
for dir in include libraries doc/man/man3 ; do
  pushd ${dir}
  make DESTDIR="${pkgdir}" install
  popd
done
install -Dm644 doc/man/man5/ldap.conf.5.tmp "${pkgdir}"/usr/share/man/man5/ldap.conf.5

# get rid of duplicate default conf files
rm "${pkgdir}"/etc/openldap/*.default

ln -sf liblber.so "${pkgdir}"/usr/lib/liblber.so.2
ln -sf libldap.so "${pkgdir}"/usr/lib/libldap.so.2

install -Dm644 LICENSE "${pkgdir}"/usr/share/licenses/${pkgname}/LICENSE

# Package libldap within the main package too
pkgdir=$srcdir/../build
for dir in include libraries doc/man/man3 ; do
  pushd ${dir}
  make DESTDIR="${pkgdir}" install
  popd
done
install -Dm644 doc/man/man5/ldap.conf.5.tmp "${pkgdir}"/usr/share/man/man5/ldap.conf.5

# get rid of duplicate default conf files
rm "${pkgdir}"/etc/openldap/*.default

ln -sf liblber.so "${pkgdir}"/usr/lib/liblber.so.2
ln -sf libldap.so "${pkgdir}"/usr/lib/libldap.so.2

install -Dm644 LICENSE "${pkgdir}"/usr/share/licenses/${pkgname}/LICENSE

# Package openldap
pkgdir=$srcdir/../build

for dir in clients servers doc/man/man{1,5,8}; do
  pushd ${dir}
  make DESTDIR="${pkgdir}" install
  popd
done

make -C contrib/slapd-modules/autogroup prefix=/usr libexecdir=/usr/lib sysconfdir=/etc/openldap DESTDIR="$pkgdir" install
make -C contrib/slapd-modules/lastbind prefix=/usr libexecdir=/usr/lib sysconfdir=/etc/openldap DESTDIR="$pkgdir" install
make -C contrib/slapd-modules/passwd/sha2 prefix=/usr libexecdir=/usr/lib sysconfdir=/etc/openldap DESTDIR="$pkgdir" install
make -C contrib/slapd-modules/nssov prefix=/usr libexecdir=/usr/lib sysconfdir=/etc/openldap DESTDIR="$pkgdir" install
install -m644 contrib/slapd-modules/nssov/slapo-nssov.5 "${pkgdir}"/usr/share/man/man5/slapo-nssov.5
install -m644 contrib/slapd-modules/autogroup/slapo-autogroup.5 "${pkgdir}"/usr/share/man/man5/slapo-autogroup.5
install -m644 contrib/slapd-modules/lastbind/slapo-lastbind.5 "${pkgdir}"/usr/share/man/man5/slapo-lastbind.5

rm "${pkgdir}"/usr/share/man/man5/ldap.conf.5
rm -r "${pkgdir}"/run

# get rid of duplicate default conf files
rm "${pkgdir}"/etc/openldap/*.default

ln -s ../lib/slapd "${pkgdir}"/usr/bin/slapd

chown root:439 "${pkgdir}"/etc/openldap/{slapd.{conf,ldif},DB_CONFIG.example}
chmod 640 "${pkgdir}"/etc/openldap/{slapd.{conf,ldif},DB_CONFIG.example}

install -dm700 -o 439 -g 439 "${pkgdir}"/var/lib/openldap
chown -R 439:439 "${pkgdir}"/var/lib/openldap

install -dm700 -o 439 -g 439 "${pkgdir}"/etc/openldap/slapd.d
install -Dm644 "${srcdir}"/slapd.service "${pkgdir}"/usr/lib/systemd/system/slapd.service
install -Dm644 "${srcdir}"/openldap.tmpfiles "${pkgdir}"/usr/lib/tmpfiles.d/openldap.conf
install -Dm644 "${srcdir}"/openldap.sysusers "${pkgdir}"/usr/lib/sysusers.d/openldap.conf
install -Dm644 LICENSE "${pkgdir}"/usr/share/licenses/${pkgname}/LICENSE
