import urllib.parse

from flask import Blueprint, request, render_template, current_app as app


help_bp = Blueprint('help_bp', __name__, url_prefix='/help',
                    template_folder='src/web/pages/help/views',
                    static_folder='static',
                    static_url_path='/static/home')

@help_bp.route('/', methods=['GET'])
def api_index():
    try:
        parsed_uri = urllib.parse(request.referrer)
        domain = '{uri.scheme}://{uri.netloc}/'.format(uri=parsed_uri)
    except:
        domain = app.config['BASE_URL'] + '/'

    return render_template("help_index.html", domain=domain)
