DECLARE SUB FireBossSecondary (GameObject() AS ANY, SecondaryWeapon%)
DECLARE FUNCTION GetBossSecondary% (BossType%)
DECLARE SUB InitBoss (GameObject() AS ANY, LevelNum%)
DECLARE SUB FlyBy (GameObject() AS ANY, TargetSpot%)
DECLARE SUB FireSeeker (GameObject() AS ANY, Destination%)
DECLARE FUNCTION FireACM% (GameObject() AS ANY, MissionPath() AS ANY)
DECLARE FUNCTION GetFreeRadarObject% (RadarItem() AS ANY)
DECLARE FUNCTION ChooseSeekerTarget% (GameObject() AS ANY)
DECLARE FUNCTION InSquare% (X1&, X2&, Z1&, Z2&, quota&)
DECLARE SUB MoveObject (TargetSpot%, GameObject() AS ANY, SineTab%(), CosineTab%(), AltSine%())
DECLARE FUNCTION IsLocked% (GameObject() AS ANY, KeyValue%)
DECLARE SUB RandomPowerDrop (GameObject() AS ANY, DropDown() AS ANY, TargetSpot%)
DECLARE SUB DropRewardedBonus (GameObject() AS ANY, TargetSpot%)
DECLARE SUB AddBonusObject (GameObject() AS ANY, BonusType%, Xp&, Yp&, Zp&)
DECLARE FUNCTION RandomPercentage% ()
DECLARE SUB CreateParticle (GameObject() AS ANY, X&, Y&, Z&, InitialHeadXZ%, InitialHeadY%, MaxLife%, MinVelo%, MaxVelo%)
DECLARE FUNCTION GetTargetingAngle% (X1&, X2&, Z1&, Z2&, Heading%)
DECLARE FUNCTION GetSoundAdd% (X1&, X2&, Y1&, Y2&, Z1&, Z2&)
DECLARE FUNCTION GetLock% (GameObject() AS ANY, TargetSpot%)
DECLARE SUB ShowHitSpark (GameObject() AS ANY, Xp&, Zp&, Yp&, Sparks%)
DECLARE SUB Explode (GameObject() AS ANY, ExploType%, SizeFlag%, Xp&, Yp&, Zp&)
DECLARE SUB FireProjectile (GameObject() AS ANY, X&, Y&, Z&, ProjectileType%, Heading%, Pitch%, Turn%, Roll%, GunOwner%)
DECLARE FUNCTION Collision% (GameObject() AS ANY, Object1%, Object2%)
DECLARE FUNCTION TotalActiveEnemies% (GameObject() AS ANY)
DECLARE SUB KillObject (TargetSpot%, GameObject() AS ANY)
DECLARE FUNCTION GetFreeObject% (GameObject() AS ANY)

'$INCLUDE: 'objtypes.bi'
DEFINT A-Z
'Externals
DECLARE FUNCTION CSVectorDot! (BYVAL Vec1Seg%, BYVAL Vec1Off&, BYVAL Vec2Seg%, BYVAL Vec2Off&)
DECLARE FUNCTION GetGroundY% (BumpMap&(), X&, Z&)
DECLARE FUNCTION ArcTangent% (Y&, X&)
DECLARE SUB SoundInterFace (Command%, Value1%, Value2%, Value3%, Value4%)
DECLARE SUB InitializeMessage (SEEDVALUE%, BigMessage%, BigMessageTime%)
DECLARE FUNCTION GetDistance& (X1&, Y1&, Z1&, X2&, Y2&, Z2&)
DECLARE FUNCTION CSPeek16% (BYVAL Segment%, BYVAL Offset&)
DECLARE SUB CSPoke16 (BYVAL Segment%, BYVAL Offset&, BYVAL Value&)

SUB AddBonusObject (GameObject() AS Object, BonusType, Xp&, Yp&, Zp&)
chunk = GetFreeObject(GameObject())
IF chunk = -1 THEN EXIT SUB
KillObject chunk, GameObject()
yAdd& = Yp&
IF yAdd& < 9000 THEN yAdd& = 9000
IF yAdd& > 199000 THEN yAdd& = 199000
GameObject(chunk).ObjectType = BonusType
GameObject(chunk).X = Xp&
GameObject(chunk).Y = yAdd&
GameObject(chunk).Z = Zp&
GameObject(chunk).Scale = DOUBLESIZE
GameObject(chunk).ObjectDrawClass = BITMAP
GameObject(chunk).Xsiz = 2000
GameObject(chunk).Zsiz = 2000
GameObject(chunk).Ysiz = 2250
END SUB

SUB AddFighter (TargetSpot, GameObject() AS Object, PlayerX&, PlayerZ&, PlayerY&, EnemyFighter() AS FighterSpawn)
xAdd& = 10000 + RND * 5000
zAdd& = 10000 + RND * 5000
yAdd& = GameObject(0).Y + (-5000 + RND * 10000)
IF yAdd& < 10000 THEN yAdd& = 10000
IF RandomPercentage < 50 THEN xAdd& = -xAdd&
IF RandomPercentage < 50 THEN zAdd& = -zAdd&
AddType = 1
IF RandomPercentage < 66 THEN AddType = 0

        KillObject TargetSpot, GameObject()
        GameObject(TargetSpot).X = GameObject(0).X + xAdd&
        GameObject(TargetSpot).Y = yAdd&
        GameObject(TargetSpot).Z = GameObject(0).Z + zAdd&
        GameObject(TargetSpot).ObjectType = EnemyFighter(AddType).FighterType
        GameObject(TargetSpot).HitPoints = EnemyFighter(AddType).HitPoints
        GameObject(TargetSpot).Velocity = EnemyFighter(AddType).Velocity
        GameObject(TargetSpot).ExtraFlag4 = EnemyFighter(AddType).TurnRate
        GameObject(TargetSpot).Weapon = EnemyFighter(AddType).Weapon
        GameObject(TargetSpot).WeaponCoolDown = EnemyFighter(AddType).WeaponCoolDown
        GameObject(TargetSpot).GunBurst = EnemyFighter(AddType).GunBurst
        GameObject(TargetSpot).Xsiz = 1024
        GameObject(TargetSpot).Ysiz = 1024
        GameObject(TargetSpot).Zsiz = 1024
        GameObject(TargetSpot).AIScript = FIGHTER
        GameObject(TargetSpot).ExtraFlag8 = FIGHTERSCRIPTCHASE
END SUB

SUB AddRadarObject (GameObject() AS Object, RadarItem() AS RadarObject, TargetSpot, ClearFlag)
IF ClearFlag = TRUE THEN
        FOR index = 0 TO 63
        RadarItem(index).X = 0
        RadarItem(index).Y = 0
        RadarItem(index).ObjectType = 0
        NEXT
EXIT SUB
END IF
                
        IF GameObject(TargetSpot).AIScript = FIGHTER OR GameObject(TargetSpot).AIScript = HELICOPTER THEN
                IF GameObject(TargetSpot).Y < GameObject(0).Y THEN RequestedObjectType = AIRTARGETBELOW ELSE RequestedObjectType = AIRTARGETABOVE
        ELSEIF GameObject(TargetSpot).AIScript = FLAKCANNON THEN
                RequestedObjectType = FLAKCANNON
        ELSEIF GameObject(TargetSpot).ExtraFlag8 = BUILDING THEN
                RequestedObjectType = BUILDING
        ELSE
                RequestedObjectType = -1
        END IF
IF RequestedObjectType = -1 THEN EXIT SUB
IF InSquare(GameObject(0).X, GameObject(TargetSpot).X, GameObject(0).Z, GameObject(TargetSpot).Z, 20000) = FALSE THEN EXIT SUB
        RadarNode = GetFreeRadarObject(RadarItem())
IF RadarNode = -1 THEN EXIT SUB
        RadarItem(RadarNode).ObjectType = RequestedObjectType
        RadarItem(RadarNode).X = (GameObject(TargetSpot).X - GameObject(0).X) \ 666
        RadarItem(RadarNode).Y = (GameObject(TargetSpot).Z - GameObject(0).Z) \ 333
END SUB

SUB AnimateBitMaps (GameObject() AS Object)
FOR index = 0 TO 379
        SELECT CASE GameObject(index).ObjectType
        CASE ION TO ION + 2
                GameObject(index).ObjectType = GameObject(index).ObjectType + 1
                IF GameObject(index).ObjectType = ION + 3 THEN GameObject(index).ObjectType = ION
        CASE PLASMA TO PLASMA + 2
                GameObject(index).ObjectType = GameObject(index).ObjectType + 1
                IF GameObject(index).ObjectType = PLASMA + 3 THEN GameObject(index).ObjectType = PLASMA
        CASE POWERUP1 TO POWERUP1 + 7
                GameObject(index).ObjectType = GameObject(index).ObjectType + 1
                IF GameObject(index).ObjectType = POWERUP1 + 8 THEN GameObject(index).ObjectType = POWERUP1
        CASE POWERUP2 TO POWERUP2 + 7
                GameObject(index).ObjectType = GameObject(index).ObjectType + 1
                IF GameObject(index).ObjectType = POWERUP2 + 8 THEN GameObject(index).ObjectType = POWERUP2
        CASE POWERUP3 TO POWERUP3 + 7
                GameObject(index).ObjectType = GameObject(index).ObjectType + 1
                IF GameObject(index).ObjectType = POWERUP3 + 8 THEN GameObject(index).ObjectType = POWERUP3
        CASE POWERUP4 TO POWERUP4 + 7
                GameObject(index).ObjectType = GameObject(index).ObjectType + 1
                IF GameObject(index).ObjectType = POWERUP4 + 8 THEN GameObject(index).ObjectType = POWERUP4
        CASE POWERUP5 TO POWERUP5 + 7
                GameObject(index).ObjectType = GameObject(index).ObjectType + 1
                IF GameObject(index).ObjectType = POWERUP5 + 8 THEN GameObject(index).ObjectType = POWERUP5
        CASE POWERUP6 TO POWERUP6 + 7
                GameObject(index).ObjectType = GameObject(index).ObjectType + 1
                IF GameObject(index).ObjectType = POWERUP6 + 8 THEN GameObject(index).ObjectType = POWERUP6
        CASE POWERUP7 TO POWERUP7 + 7
                GameObject(index).ObjectType = GameObject(index).ObjectType + 1
                IF GameObject(index).ObjectType = POWERUP7 + 8 THEN GameObject(index).ObjectType = POWERUP7
        CASE POWERUP8 TO POWERUP8 + 7
                GameObject(index).ObjectType = GameObject(index).ObjectType + 1
                IF GameObject(index).ObjectType = POWERUP8 + 8 THEN GameObject(index).ObjectType = POWERUP8
        END SELECT
NEXT
END SUB

SUB BigExplosion (GameObject() AS Object, TargetSpot)
GameObject(TargetSpot).ObjectType = GameObject(TargetSpot).ObjectType + 1
IF GameObject(TargetSpot).ObjectType = EXPLOSIONDIE THEN KillObject TargetSpot, GameObject(): EXIT SUB
IF GameObject(TargetSpot).ObjectType = MUSHROOMCLOUDDIE THEN KillObject TargetSpot, GameObject(): EXIT SUB
END SUB

SUB BuildingCrash (GameObject() AS Object)
IF GameObject(0).HitPoints = 0 OR GameObject(0).ExtraFlag5 > 0 THEN EXIT SUB
FOR index = 0 TO 379
        IF GameObject(index).ObjectType <> 0 AND GameObject(index).ExtraFlag8 = BUILDING THEN
                IF Collision(GameObject(), 0, index) = TRUE THEN
                GameObject(0).HitPoints = GameObject(0).HitPoints - 16
                SoundInterFace 2, 31, 0, 0, 0
                IF GameObject(0).HitPoints < 0 THEN GameObject(0).HitPoints = 0
                GameObject(0).ExtraFlag5 = 13
                EXIT SUB
                END IF
        END IF
NEXT
END SUB

SUB CheckPowerPick (GameObject() AS Object, Ammo(), BigMessage, BigMessageTime)
IF GameObject(0).HitPoints = 0 THEN EXIT SUB
FOR index = 0 TO 379
        SELECT CASE GameObject(index).ObjectType
        CASE IS < POWERUP1
        CASE POWERUP1 TO POWERUP1 + 7
        IF Collision(GameObject(), 0, index) = TRUE THEN
                GameObject(0).HitPoints = GameObject(0).HitPoints + 15
                IF GameObject(0).HitPoints > 50 THEN GameObject(0).HitPoints = 50
                InitializeMessage MESSAGEPOWERCORE, BigMessage, BigMessageTime
                KillObject index, GameObject()
        END IF
        CASE POWERUP2 TO POWERUP2 + 7
        IF Collision(GameObject(), 0, index) = TRUE THEN
                GameObject(0).HitPoints = 50
                InitializeMessage MESSAGEMEGAPOWERCORE, BigMessage, BigMessageTime
                KillObject index, GameObject()
        END IF
        CASE POWERUP3 TO POWERUP3 + 7
        IF Collision(GameObject(), 0, index) = TRUE THEN
                Ammo(1) = Ammo(1) + 100
                IF Ammo(1) > 999 THEN Ammo(1) = 999
                InitializeMessage MESSAGEION, BigMessage, BigMessageTime
                KillObject index, GameObject()
        END IF
        CASE POWERUP4 TO POWERUP4 + 7
        IF Collision(GameObject(), 0, index) = TRUE THEN
                Ammo(2) = Ammo(2) + 100
                IF Ammo(2) > 999 THEN Ammo(2) = 999
                CSPoke16 AmmoSeg, 4, Value
                InitializeMessage MESSAGETLA, BigMessage, BigMessageTime
                KillObject index, GameObject()
        END IF
        CASE POWERUP5 TO POWERUP5 + 7
        IF Collision(GameObject(), 0, index) = TRUE THEN
                Ammo(3) = Ammo(3) + 100
                IF Ammo(3) > 999 THEN Ammo(3) = 999
                InitializeMessage MESSAGEPDC, BigMessage, BigMessageTime
                KillObject index, GameObject()
        END IF
        CASE POWERUP6 TO POWERUP6 + 7
        IF Collision(GameObject(), 0, index) = TRUE THEN
                Ammo(4) = Ammo(4) + 40
                IF Ammo(4) > 999 THEN Ammo(4) = 999
                InitializeMessage MESSAGEDFM, BigMessage, BigMessageTime
                KillObject index, GameObject()
        END IF
        CASE POWERUP7 TO POWERUP7 + 7
        IF Collision(GameObject(), 0, index) = TRUE THEN
                Ammo(5) = Ammo(5) + 20
                IF Ammo(5) > 999 THEN Ammo(5) = 999
                InitializeMessage MESSAGESND, BigMessage, BigMessageTime
                KillObject index, GameObject()
        END IF
        CASE POWERUP8 TO POWERUP8 + 7
        IF Collision(GameObject(), 0, index) = TRUE THEN
                Ammo(6) = Ammo(6) + 20
                IF Ammo(6) > 999 THEN Ammo(6) = 999
                InitializeMessage MESSAGEACM, BigMessage, BigMessageTime
                KillObject index, GameObject()
        END IF
        END SELECT
NEXT
END SUB

FUNCTION ChooseSeekerTarget (GameObject() AS Object)
MaxDist& = 0
FOR index = 0 TO 379
        IF GameObject(index).AIScript = FIGHTER OR GameObject(index).AIScript = HELICOPTER OR GameObject(index).AIScript = TRANSPORT THEN
        Dist& = GetDistance&(GameObject(0).X, GameObject(0).Y, GameObject(0).Z, GameObject(index).X, GameObject(index).Y, GameObject(index).Z)
        IF Dist& < 60000 AND ((Dist& < MaxDist&) OR MaxDist& = 0) THEN MaxDist& = Dist&: Locked = index
        END IF
NEXT
IF MaxDist& = 0 THEN ChooseSeekerTarget = -1 ELSE ChooseSeekerTarget = Locked
END FUNCTION

FUNCTION Collision (GameObject() AS Object, Object1, Object2)
Cx& = GameObject(Object2).X - GameObject(Object1).X
Cy& = GameObject(Object2).Y - GameObject(Object1).Y
Cz& = GameObject(Object2).Z - GameObject(Object1).Z
IF ABS(Cx&) <= GameObject(Object2).Xsiz AND ABS(Cy&) <= GameObject(Object2).Ysiz AND ABS(Cz&) <= GameObject(Object2).Zsiz THEN
        Collision = TRUE
ELSE
        Collision = FALSE
END IF
END FUNCTION

SUB CreateEnemyProfiles (EnemyFighter() AS FighterSpawn, EnemyDrop() AS DropDownType, LevelNum)
SELECT CASE LevelNum
CASE 1
        EnemyFighter(0).FighterType = 8
        EnemyFighter(0).HitPoints = 3
        EnemyFighter(0).Velocity = 6
        EnemyFighter(0).TurnRate = 6
        EnemyFighter(0).Weapon = REDLASER
        EnemyFighter(0).WeaponCoolDown = 6
        EnemyFighter(0).GunBurst = 5
        EnemyFighter(1).FighterType = 9
        EnemyFighter(1).HitPoints = 4
        EnemyFighter(1).Velocity = 8
        EnemyFighter(1).TurnRate = 8
        EnemyFighter(1).Weapon = REDLASER
        EnemyFighter(1).WeaponCoolDown = 5
        EnemyFighter(1).GunBurst = 8
        EnemyDrop(0).DropDownClass = POWERUP1
        EnemyDrop(0).DropDownPossibility = 8
        EnemyDrop(1).DropDownClass = POWERUP1
        EnemyDrop(1).DropDownPossibility = 8
CASE 2
        EnemyFighter(0).FighterType = 20
        EnemyFighter(0).HitPoints = 3
        EnemyFighter(0).Velocity = 5
        EnemyFighter(0).TurnRate = 12
        EnemyFighter(0).Weapon = ION
        EnemyFighter(0).WeaponCoolDown = 4
        EnemyFighter(0).GunBurst = 5
        EnemyFighter(1).FighterType = 21
        EnemyFighter(1).HitPoints = 5
        EnemyFighter(1).Velocity = 10
        EnemyFighter(1).TurnRate = 10
        EnemyFighter(1).Weapon = REDLASER
        EnemyFighter(1).WeaponCoolDown = 4
        EnemyFighter(1).GunBurst = 9
        EnemyDrop(0).DropDownClass = POWERUP3
        EnemyDrop(0).DropDownPossibility = 4
        EnemyDrop(1).DropDownClass = POWERUP1
        EnemyDrop(1).DropDownPossibility = 8
CASE 3
        EnemyFighter(0).FighterType = 32
        EnemyFighter(0).HitPoints = 4
        EnemyFighter(0).Velocity = 8
        EnemyFighter(0).TurnRate = 10
        EnemyFighter(0).Weapon = BLUELASER
        EnemyFighter(0).WeaponCoolDown = 4
        EnemyFighter(0).GunBurst = 6
        EnemyFighter(1).FighterType = 33
        EnemyFighter(1).HitPoints = 5
        EnemyFighter(1).Velocity = 10
        EnemyFighter(1).TurnRate = 11
        EnemyFighter(1).Weapon = BLUELASER
        EnemyFighter(1).WeaponCoolDown = 4
        EnemyFighter(1).GunBurst = 10
        EnemyDrop(0).DropDownClass = POWERUP1
        EnemyDrop(0).DropDownPossibility = 8
        EnemyDrop(1).DropDownClass = POWERUP1
        EnemyDrop(1).DropDownPossibility = 8
CASE 4
        EnemyFighter(0).FighterType = 42
        EnemyFighter(0).HitPoints = 4
        EnemyFighter(0).Velocity = 10
        EnemyFighter(0).TurnRate = 9
        EnemyFighter(0).Weapon = GREENLASER
        EnemyFighter(0).WeaponCoolDown = 4
        EnemyFighter(0).GunBurst = 8
        EnemyFighter(1).FighterType = 43
        EnemyFighter(1).HitPoints = 6
        EnemyFighter(1).Velocity = 12
        EnemyFighter(1).TurnRate = 12
        EnemyFighter(1).Weapon = TLA
        EnemyFighter(1).WeaponCoolDown = 7
        EnemyFighter(1).GunBurst = 4
        EnemyDrop(0).DropDownClass = POWERUP1
        EnemyDrop(0).DropDownPossibility = 8
        EnemyDrop(1).DropDownClass = POWERUP4
        EnemyDrop(1).DropDownPossibility = 4
CASE 5
        EnemyFighter(0).FighterType = 54
        EnemyFighter(0).HitPoints = 5
        EnemyFighter(0).Velocity = 11
        EnemyFighter(0).TurnRate = 14
        EnemyFighter(0).Weapon = GREENLASER
        EnemyFighter(0).WeaponCoolDown = 2
        EnemyFighter(0).GunBurst = 8
        EnemyFighter(1).FighterType = 55
        EnemyFighter(1).HitPoints = 8
        EnemyFighter(1).Velocity = 8
        EnemyFighter(1).TurnRate = 8
        EnemyFighter(1).Weapon = PULSELASER
        EnemyFighter(1).WeaponCoolDown = 7
        EnemyFighter(1).GunBurst = 8
        EnemyDrop(0).DropDownClass = POWERUP1
        EnemyDrop(0).DropDownPossibility = 8
        EnemyDrop(1).DropDownClass = POWERUP1
        EnemyDrop(1).DropDownPossibility = 8
CASE 6
        EnemyFighter(0).FighterType = 65
        EnemyFighter(0).HitPoints = 6
        EnemyFighter(0).Velocity = 9
        EnemyFighter(0).TurnRate = 12
        EnemyFighter(0).Weapon = YELLOWLASER
        EnemyFighter(0).WeaponCoolDown = 4
        EnemyFighter(0).GunBurst = 8
        EnemyFighter(1).FighterType = 66
        EnemyFighter(1).HitPoints = 6
        EnemyFighter(1).Velocity = 11
        EnemyFighter(1).TurnRate = 14
        EnemyFighter(1).Weapon = REDLASER
        EnemyFighter(1).WeaponCoolDown = 4
        EnemyFighter(1).GunBurst = 10
        EnemyDrop(0).DropDownClass = POWERUP1
        EnemyDrop(0).DropDownPossibility = 8
        EnemyDrop(1).DropDownClass = POWERUP1
        EnemyDrop(1).DropDownPossibility = 8
CASE 7
        EnemyFighter(0).FighterType = 77
        EnemyFighter(0).HitPoints = 4
        EnemyFighter(0).Velocity = 15
        EnemyFighter(0).TurnRate = 15
        EnemyFighter(0).Weapon = GREENLASER
        EnemyFighter(0).WeaponCoolDown = 2
        EnemyFighter(0).GunBurst = 10
        EnemyFighter(1).FighterType = 78
        EnemyFighter(1).HitPoints = 6
        EnemyFighter(1).Velocity = 11
        EnemyFighter(1).TurnRate = 14
        EnemyFighter(1).Weapon = TLA
        EnemyFighter(1).WeaponCoolDown = 5
        EnemyFighter(1).GunBurst = 5
        EnemyDrop(0).DropDownClass = POWERUP1
        EnemyDrop(0).DropDownPossibility = 8
        EnemyDrop(1).DropDownClass = POWERUP4
        EnemyDrop(1).DropDownPossibility = 4
CASE 8
        EnemyFighter(0).FighterType = 88
        EnemyFighter(0).HitPoints = 6
        EnemyFighter(0).Velocity = 15
        EnemyFighter(0).TurnRate = 15
        EnemyFighter(0).Weapon = GREENLASER
        EnemyFighter(0).WeaponCoolDown = 2
        EnemyFighter(0).GunBurst = 12
        EnemyFighter(1).FighterType = 89
        EnemyFighter(1).HitPoints = 8
        EnemyFighter(1).Velocity = 10
        EnemyFighter(1).TurnRate = 12
        EnemyFighter(1).Weapon = PLASMA
        EnemyFighter(1).WeaponCoolDown = 6
        EnemyFighter(1).GunBurst = 6
        EnemyDrop(0).DropDownClass = POWERUP1
        EnemyDrop(0).DropDownPossibility = 8
        EnemyDrop(1).DropDownClass = POWERUP5
        EnemyDrop(1).DropDownPossibility = 4
END SELECT
EnemyDrop(0).ParentObject = EnemyFighter(0).FighterType
EnemyDrop(1).ParentObject = EnemyFighter(1).FighterType
END SUB

SUB CreateParticle (GameObject() AS Object, X&, Y&, Z&, InitialHeadXZ, InitialHeadY, MaxLife, MinVelo, MaxVelo)
        IF ABS(GameObject(0).X - X&) > 40000 OR ABS(GameObject(0).Z - Z&) > 40000 OR ABS(GameObject(0).Y - Y&) > 16000 THEN EXIT SUB
        chunk = GetFreeObject(GameObject())
        IF chunk = -1 THEN EXIT SUB
                KillObject chunk, GameObject()
                GameObject(chunk).X = X&
                GameObject(chunk).Y = Y&
                GameObject(chunk).Z = Z&
                GameObject(chunk).AIScript = PARTICLE
                GameObject(chunk).ObjectType = PARTICLEINIT
                GameObject(chunk).HeadXZ = InitialHeadXZ
                GameObject(chunk).HeadY = InitialHeadY
                GameObject(chunk).ExtraFlag4 = (RND * (MaxLife + 1))
                GameObject(chunk).Velocity = 2 + (MinVelo + (RND * (MaxVelo + 1)))
                GameObject(chunk).ObjectDrawClass = BITMAP
                GameObject(chunk).Scale = QUARTERSIZE
END SUB

SUB CrossHairCoords (StartX&, StartY&, StartZ&, FinalX&, FinalY&, FinalZ&, Heading, Pitch, BumpMap&(), SineTab(), CosineTab(), AltSine())
chx& = StartX&
chy& = StartY&
chz& = StartZ&
        HeadValue = Heading
        IF HeadValue > 1279 THEN
                HeadValue = HeadValue - 1280
        ELSEIF HeadValue < 0 THEN
                HeadValue = HeadValue + 1280
        END IF
        FOR index = 0 TO 799
                chx& = chx& - SineTab(HeadValue)
                chz& = chz& - CosineTab(HeadValue)
                chy& = chy& - AltSine(Pitch + 90)
        GroundLevel = GetGroundY(BumpMap&(), chx&, chz&)
                IF chy& < GroundLevel THEN EXIT FOR
        NEXT
FinalX& = chx&
FinalY& = chy&
FinalZ& = chz&
END SUB

SUB DropRewardedBonus (GameObject() AS Object, TargetSpot)
SELECT CASE GameObject(TargetSpot).ExtraFlag3
        CASE REWARDCORE
        AddBonusObject GameObject(), POWERUP1, GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z
        CASE REWARDMEGA
        AddBonusObject GameObject(), POWERUP2, GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z
        CASE REWARDION
        AddBonusObject GameObject(), POWERUP3, GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z
        CASE REWARDTLA
        AddBonusObject GameObject(), POWERUP4, GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z
        CASE REWARDPLASMA
        AddBonusObject GameObject(), POWERUP5, GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z
        CASE REWARDROCKET
        AddBonusObject GameObject(), POWERUP6, GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z
        CASE REWARDMISSILE
        AddBonusObject GameObject(), POWERUP7, GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z
        CASE REWARDCRUISER
        AddBonusObject GameObject(), POWERUP8, GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z
END SELECT
END SUB

SUB Explode (GameObject() AS Object, ExploType, SizeFlag, Xp&, Yp&, Zp&)
        SoundFlags = GetSoundAdd(Xp&, GameObject(0).X, Yp&, GameObject(0).Y, Zp&, GameObject(0).Z)
        IF SoundFlags <> -1 THEN SoundInterFace 2, 19 + SoundFlags, 0, 0, 0
SELECT CASE ExploType
        CASE MUSHROOMEXPLOSION
        StartType = MUSHROOMCLOUDINIT
                FOR index = 0 TO 15
                i = index * 80
                CreateParticle GameObject(), Xp&, Yp&, Zp&, i * 80, -20, 0, 7, 5
                NEXT
        Particles = 23
        YheadStart = -45
        CASE ELSE
        StartType = EXPLOSIONINIT
        Particles = 11
        YheadStart = 0
END SELECT
        FOR index = 0 TO Particles
        CreateParticle GameObject(), Xp&, Yp&, Zp&, RND * 1280, YheadStart - RND * 20, 1, 5, 6
        NEXT
        chunk = GetFreeObject(GameObject())
        IF chunk = -1 THEN EXIT SUB
        KillObject chunk, GameObject()
        GameObject(chunk).ObjectType = StartType
        GameObject(chunk).X = Xp&
        GameObject(chunk).Y = Yp&
        GameObject(chunk).Z = Zp&
        GameObject(chunk).Scale = SizeFlag
        GameObject(chunk).ObjectDrawClass = BITMAP
        GameObject(chunk).AIScript = EXPLOSION
END SUB

FUNCTION FireACM (GameObject() AS Object, MissionPath() AS MissionType)
        IF MissionPath(0).Node = NODEBOSS AND InSquare(GameObject(0).X, GameObject(1).X, GameObject(0).Z, GameObject(1).Z, 50000) = TRUE THEN
        FireSeeker GameObject(), 1
        FireACM = 1
        EXIT FUNCTION
        END IF
       
        IF MissionPath(0).Node = NODETARGET AND InSquare(GameObject(0).X, GameObject(MissionPath(0).NodeHook).X, GameObject(0).Z, GameObject(MissionPath(0).NodeHook).Z, 50000) = TRUE THEN
        FireSeeker GameObject(), MissionPath(0).NodeHook
        FireACM = 1
        EXIT FUNCTION
        END IF
MaxDist& = 0
        FOR index = 2 TO 379
                IF GameObject(index).AIScript = FLAKCANNON THEN
                Dist& = GetDistance&(GameObject(0).X, GameObject(0).Y, GameObject(0).Z, GameObject(index).X, GameObject(index).Y, GameObject(index).Z)
                IF Dist& < 60000 AND ((Dist& < MaxDist&) OR MaxDist& = 0) THEN MaxDist& = Dist&: Locked = index
                END IF
        NEXT
IF MaxDist& <> 0 THEN FireSeeker GameObject(), Locked: FireACM = 1: EXIT FUNCTION
FireACM = -1
END FUNCTION

SUB FireBossSecondary (GameObject() AS Object, SecondaryWeapon)
        px& = GameObject(0).X + 200000000
        pz& = GameObject(0).Z + 200000000
        objectx& = GameObject(1).X + 200000000
        objectz& = GameObject(1).Z + 200000000
        ShootingAngle = ArcTangent(objectx& - px&, objectz& - pz&)
        IF ShootingAngle < 0 THEN ShootingAngle = ShootingAngle + 1280
        IF ShootingAngle > 1280 THEN ShootingAngle = ShootingAngle - 1280
       
        Difference = ABS(GameObject(0).Y - GameObject(1).Y)
        IF GameObject(0).Y < GameObject(1).Y THEN Multi = -1 ELSE Multi = 1
        SELECT CASE Difference
        CASE IS < 1000
                HeadYstart = 0 - (RND * 25)
        CASE IS >= 3000 < 4000
                HeadYstart = -10 - (RND * 25)
        CASE IS >= 4000 < 7000
                HeadYstart = -20 - (RND * 25)
        CASE IS >= 7000 < 18000
                HeadYstart = -35 - (RND * 25)
        CASE ELSE
                HeadYstart = -45 - (RND * 25)
        END SELECT
                HeadYstart = HeadYstart * Multi
        FireProjectile GameObject(), GameObject(1).X, GameObject(1).Y, GameObject(1).Z, SecondaryWeapon, ShootingAngle, HeadYstart, 0, 0, ENEMYSHOT
END SUB

SUB FireProjectile (GameObject() AS Object, X&, Y&, Z&, ProjectileType, Heading, Pitch, Turn, Roll, GunOwner)
        SELECT CASE ProjectileType
                CASE PULSELASER
                        ShotType = PULSELASER
                        MeshClass = POLYGONAL
                        MeshSize = FULLSCALE
                        SoundNumber = 1
                        TotalShots = 1
                        Mess = 0
                CASE ION
                        ShotType = ION
                        MeshClass = BITMAP
                        MeshSize = QUARTERSIZE
                        SoundNumber = 4
                        TotalShots = 1
                        Mess = -10
                CASE TLA
                        ShotType = REDLASER
                        MeshClass = POLYGONAL
                        MeshSize = FULLSCALE
                        SoundNumber = 7
                        TotalShots = 3
                        Mess = -4
                CASE PLASMA
                        ShotType = PLASMA
                        MeshClass = BITMAP
                        MeshSize = QUARTERSIZE
                        SoundNumber = 10
                        TotalShots = 1
                        Mess = 0
                CASE MISSILE
                        ShotType = MISSILE
                        MeshClass = POLYGONAL
                        MeshSize = FULLSCALE
                        SoundNumber = 16
                        TotalShots = 1
                        Mess = 0
                CASE ELSE
                        ShotType = ProjectileType
                        MeshClass = POLYGONAL
                        MeshSize = FULLSCALE
                        SoundNumber = 13
                        TotalShots = 1
                        Mess = 0
        END SELECT
        SoundFlags = GetSoundAdd(X&, GameObject(0).X, Y&, GameObject(0).Y, Z&, GameObject(0).Z)
        IF SoundFlags <> -1 THEN SoundInterFace 2, SoundNumber + SoundFlags, 0, 0, 0
FOR index = 0 TO TotalShots - 1
        chunk = GetFreeObject(GameObject())
        IF chunk <> -1 THEN
                GameObject(chunk).ObjectType = ShotType
                GameObject(chunk).X = X&
                GameObject(chunk).Y = Y&
                GameObject(chunk).Z = Z&
                GameObject(chunk).Velocity = 34
                GameObject(chunk).ExtraFlag3 = GunOwner
                GameObject(chunk).ObjectDrawClass = MeshClass
                GameObject(chunk).Scale = MeshSize
                HeadValue = Heading + Turn + (Mess - (RND * (Mess * 2)) * 4)
                IF HeadValue < 0 THEN HeadValue = HeadValue + 1280
                IF HeadValue > 1279 THEN HeadValue = HeadValue - 1280
                GameObject(chunk).HeadXZ = HeadValue
                HeadValue = Pitch + (Mess - (RND * Mess))
                GameObject(chunk).HeadY = HeadValue
                GameObject(chunk).AIScript = PROJECTILE
        END IF
NEXT
END SUB

SUB FireSeeker (GameObject() AS Object, Destination)
chunk = GetFreeObject(GameObject())
IF chunk = -1 THEN EXIT SUB
                KillObject chunk, GameObject()
                GameObject(chunk).ObjectType = MISSILE
                GameObject(chunk).X = GameObject(0).X
                GameObject(chunk).Y = GameObject(0).Y
                GameObject(chunk).Z = GameObject(0).Z
                GameObject(chunk).Velocity = 31
                GameObject(chunk).ObjectDrawClass = POLYGONAL
                GameObject(chunk).HeadXZ = GameObject(0).HeadXZ
                GameObject(chunk).HeadY = GameObject(0).HeadY
                GameObject(chunk).AIScript = SEEKMISSILE
                GameObject(chunk).ExtraFlag8 = Destination
                SoundInterFace 2, 16, 0, 0, 0
END SUB

SUB FlakAI (GameObject() AS Object, TargetSpot, SineTab(), CosineTab(), BumpMap&())

IF InSquare(GameObject(0).X, GameObject(TargetSpot).X, GameObject(0).Z, GameObject(TargetSpot).Z, 40000) = FALSE THEN EXIT SUB

px& = GameObject(0).X + 200000000
pz& = GameObject(0).Z + 200000000
objectx& = GameObject(TargetSpot).X + 200000000
objectz& = GameObject(TargetSpot).Z + 200000000
TargetingAngle = GetTargetingAngle(px&, objectx&, pz&, objectz&, GameObject(TargetSpot).HeadXZ)
GunFlags = FALSE
GameObject(TargetSpot).ExtraFlag1 = GameObject(TargetSpot).ExtraFlag1 + 1

IF GameObject(TargetSpot).ExtraFlag1 >= GameObject(TargetSpot).WeaponCoolDown THEN
        GameObject(TargetSpot).ExtraFlag1 = 0: GunFlags = TRUE
        Difference = GameObject(0).Y - GameObject(TargetSpot).Y
        SELECT CASE Difference
        CASE IS < 1000
                HeadYstart = 0 - (RND * 25)
        CASE IS >= 3000 < 4000
                HeadYstart = -10 - (RND * 25)
        CASE IS >= 4000 < 7000
                HeadYstart = -20 - (RND * 25)
        CASE IS >= 7000 < 18000
                HeadYstart = -35 - (RND * 25)
        CASE ELSE
                HeadYstart = -45 - (RND * 25)
        END SELECT
END IF

IF GameObject(TargetSpot).ExtraFlag2 = UNROTATINGFLAK OR GameObject(TargetSpot).ExtraFlag2 = ROLLFLAK THEN
        ShootingAngle = ArcTangent(objectx& - px&, objectz& - pz&)
        IF ShootingAngle < 0 THEN ShootingAngle = ShootingAngle + 1280
        IF ShootingAngle > 1280 THEN ShootingAngle = ShootingAngle - 1280
        IF GameObject(TargetSpot).ExtraFlag2 = ROLLFLAK THEN
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ + 4
                IF GameObject(TargetSpot).HeadXZ > 1279 THEN GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ - 1280
        END IF
ELSE
IF RandomPercentage < 45 THEN
        IF TargetingAngle < 600 THEN
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ + GameObject(TargetSpot).ExtraFlag4
        ELSEIF TargetingAngle > 680 THEN
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ - GameObject(TargetSpot).ExtraFlag4
        ELSE
                IF (TargetingAngle - 640) < 0 THEN
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ + 1
                ELSE
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ - 1
                END IF
        END IF
END IF
        ShootingAngle = GameObject(TargetSpot).HeadXZ
END IF

        IF GunFlags = TRUE THEN
        FireProjectile GameObject(), GameObject(TargetSpot).X, GameObject(TargetSpot).Y + 1024, GameObject(TargetSpot).Z, GameObject(TargetSpot).Weapon, ShootingAngle, HeadYstart, 0, 0, ENEMYSHOT
        END IF

END SUB

SUB FlyBy (GameObject() AS Object, TargetSpot) STATIC
FlyByCounter = FlyByCounter + 1
IF FlyByCounter < 3 THEN EXIT SUB
FlyByCounter = 0
IF ABS(GameObject(0).Y - GameObject(TargetSpot).Y) > 1400 THEN EXIT SUB
SoundTriggered = FALSE
IF InSquare(GameObject(0).X, GameObject(TargetSpot).X, GameObject(0).Z, GameObject(TargetSpot).Z, 1750) THEN SoundTriggered = TRUE
        IF SoundTriggered = TRUE THEN
        HeadDiverse = ((GameObject(0).HeadXZ - GameObject(TargetSpot).HeadXZ) + 1280) MOD 1280
                SELECT CASE HeadDiverse
                CASE IS > 1200, IS < 80
                        SoundInterFace 2, 23, 0, 0, 0
                CASE 560 TO 740
                        SoundInterFace 2, 22, 0, 0, 0
                CASE 240 TO 400
                        SoundInterFace 2, 25, 0, 0, 0
                CASE 880 TO 1040
                        SoundInterFace 2, 24, 0, 0, 0
                END SELECT
        END IF
END SUB

SUB GenerateLevel (LevelNum, MissionPath() AS MissionType, CheckPoint() AS CheckPointType, GameObject() AS Object, ObjectDimensions() AS ObjectSizeDump, BumpMap&())
SELECT CASE LevelNum
        CASE 1
        FileString$ = "map001"
        CASE 2
        FileString$ = "map002"
        CASE 3
        FileString$ = "map003"
        CASE 4
        FileString$ = "map004"
        CASE 5
        FileString$ = "map005"
        CASE 6
        FileString$ = "map006"
        CASE 7
        FileString$ = "map007"
        CASE 8
        FileString$ = "map008"
END SELECT

OPEN FileString$ + ".db" FOR BINARY AS #1
SEEK #1, 1
FOR index = 0 TO 33
        GET #1, , MissionPath(index).Node
        GET #1, , MissionPath(index).NodeHook
NEXT
FOR index = 0 TO 15
        GET #1, , CheckPoint(index).X
        GET #1, , CheckPoint(index).Z
        GET #1, , CheckPoint(index).Active
        GET #1, , CheckPoint(index).Visited
NEXT
FOR index = 0 TO 379
        GET #1, , GameObject(index).X
        GET #1, , GameObject(index).Y
        GET #1, , GameObject(index).Z
        GET #1, , GameObject(index).Tilt
        GET #1, , GameObject(index).Velocity
        GET #1, , GameObject(index).HeadXZ
        GET #1, , GameObject(index).HeadY
        GET #1, , GameObject(index).ObjectType
        GET #1, , GameObject(index).ObjectDrawClass
        GET #1, , GameObject(index).Scale
        GET #1, , GameObject(index).AIScript
        GET #1, , GameObject(index).HitPoints
        GET #1, , GameObject(index).Weapon
        GET #1, , GameObject(index).WeaponCoolDown
        GET #1, , GameObject(index).GunBurst
        GET #1, , GameObject(index).Xsiz
        GET #1, , GameObject(index).Ysiz
        GET #1, , GameObject(index).Zsiz
        GET #1, , GameObject(index).ExtraFlag1
        GET #1, , GameObject(index).ExtraFlag2
        GET #1, , GameObject(index).ExtraFlag3
        GET #1, , GameObject(index).ExtraFlag4
        GET #1, , GameObject(index).ExtraFlag5
        GET #1, , GameObject(index).ExtraFlag6
        GET #1, , GameObject(index).ExtraFlag7
        GET #1, , GameObject(index).ExtraFlag8
        NEXT
        CLOSE #1

        FOR index = 0 TO 379
                IF GameObject(index).ObjectType THEN
                        SELECT CASE GameObject(index).Y
                        CASE 0
                        GroundPos = GetGroundY(BumpMap&(), GameObject(index).X, GameObject(index).Z)
                        GameObject(index).Y = GroundPos
                        CASE -32000
                        GroundPos = GetGroundY(BumpMap&(), GameObject(index).X, GameObject(index).Z)
                        GameObject(index).Y = GroundPos - 64
                        CASE 1
                        GameObject(index).Y = 8000
                        CASE 2
                        GameObject(index).Y = 13000
                        CASE 3
                        GameObject(index).Y = 22000
                        END SELECT
                END IF
                IF GameObject(index).AIScript = FLAKCANNON THEN
                GameObject(index).Xsiz = 1400
                GameObject(index).Ysiz = 4800
                GameObject(index).Zsiz = 1400
                ELSEIF GameObject(index).AIScript = HELICOPTER THEN
                GameObject(index).Xsiz = 1024
                GameObject(index).Ysiz = 1024
                GameObject(index).Zsiz = 1024
                ELSEIF GameObject(index).AIScript = TRANSPORT THEN
                GameObject(index).Xsiz = 1500
                GameObject(index).Ysiz = 3200
                GameObject(index).Zsiz = 1500
                ELSEIF GameObject(index).ObjectType = 13 THEN
                GameObject(index).Xsiz = ABS(ObjectDimensions(GameObject(index).ObjectType - 1).Xs)
                GameObject(index).Ysiz = ABS(ObjectDimensions(GameObject(index).ObjectType - 1).Ys) + 512
                GameObject(index).Zsiz = ABS(ObjectDimensions(GameObject(index).ObjectType - 1).Zs)
                ELSE
                GameObject(index).Xsiz = ABS(ObjectDimensions(GameObject(index).ObjectType - 1).Xs)
                GameObject(index).Ysiz = ABS(ObjectDimensions(GameObject(index).ObjectType - 1).Ys)
                GameObject(index).Zsiz = ABS(ObjectDimensions(GameObject(index).ObjectType - 1).Zs)
                END IF
        NEXT
        InitBoss GameObject(), LevelNum
END SUB

FUNCTION GetBossSecondary (BossType)
SELECT CASE BossType
CASE 40
        GetBossSecondary = ION
CASE 63
        GetBossSecondary = YELLOWLASER
CASE 75
        GetBossSecondary = ION
END SELECT
END FUNCTION

FUNCTION GetFreeObject (GameObject() AS Object)
        GetFreeObject = -1
FOR index = 2 TO 379
        IF GameObject(index).ObjectType = 0 THEN GetFreeObject = index: EXIT FUNCTION
NEXT
END FUNCTION

FUNCTION GetFreeRadarObject (RadarItem() AS RadarObject)
GetFreeRadarObject = -1
        FOR index = 0 TO 63
        IF RadarItem(index).ObjectType = 0 THEN GetFreeRadarObject = index: EXIT FUNCTION
        NEXT
END FUNCTION

FUNCTION GetLock (GameObject() AS Object, TargetSpot)
px& = GameObject(0).X + 200000000
pz& = GameObject(0).Z + 200000000
objectx& = GameObject(TargetSpot).X + 200000000
objectz& = GameObject(TargetSpot).Z + 200000000
TargetingAngle = GetTargetingAngle(px&, objectx&, pz&, objectz&, GameObject(0).HeadXZ)
TargetingAngle = TargetingAngle - 320
Yvalue& = ABS(GameObject(0).Y - GameObject(TargetSpot).Y)
IF TargetingAngle > 520 AND TargetingAngle < 760 AND Yvalue& < 3000 THEN GetLock = TRUE ELSE GetLock = FALSE
END FUNCTION

FUNCTION GetSoundAdd (X1&, X2&, Y1&, Y2&, Z1&, Z2&)
Distance = CINT(GetDistance(X1&, Y1&, Z1&, X2&, Y2&, Z2&) / 2)
IF Distance < 0 THEN Distance = 30000
SELECT CASE Distance
        CASE IS < 8000
        GetSoundAdd = 0
        CASE IS >= 8000 < 14000
        GetSoundAdd = 1
        CASE IS >= 14000 < 25000
        GetSoundAdd = 2
        CASE ELSE
        GetSoundAdd = -1
END SELECT
END FUNCTION

FUNCTION GetTargetingAngle (SourceX&, DestX&, SourceZ&, DestZ&, Heading)
       
        TargetingAngle = ArcTangent(SourceZ& - DestZ&, SourceX& - DestX&)
        'TargetingAngle = (CINT(CSNG(TargetingAngle) / 3.555556))
        TargetingAngle = (TargetingAngle + Heading + 320) MOD 1280
        TargetingAngle = (TargetingAngle + 640) MOD 1280
GetTargetingAngle = TargetingAngle

END FUNCTION

SUB HelicopterAI (GameObject() AS Object, TargetSpot, SineTab(), CosineTab(), BumpMap&())

IF InSquare(GameObject(0).X, GameObject(TargetSpot).X, GameObject(0).Z, GameObject(TargetSpot).Z, 60000) = FALSE THEN EXIT SUB

px& = GameObject(0).X + 200000000
pz& = GameObject(0).Z + 200000000
objectx& = GameObject(TargetSpot).X + 200000000
objectz& = GameObject(TargetSpot).Z + 200000000
TargetingAngle = GetTargetingAngle(px&, objectx&, pz&, objectz&, GameObject(TargetSpot).HeadXZ)
IF GameObject(TargetSpot).ExtraFlag7 = 0 THEN
        IF TargetingAngle < 640 THEN
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ + 10
                IF GameObject(TargetSpot).ExtraFlag5 > -35 THEN GameObject(TargetSpot).ExtraFlag5 = GameObject(TargetSpot).ExtraFlag5 - 2
        ELSEIF TargetingAngle > 680 THEN
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ - 10
                IF GameObject(TargetSpot).ExtraFlag5 < 35 THEN GameObject(TargetSpot).ExtraFlag5 = GameObject(TargetSpot).ExtraFlag5 + 2
        END IF
        Difference = GameObject(0).Y - GameObject(TargetSpot).Y
        IF Difference < 0 THEN
                GameObject(TargetSpot).Y = GameObject(TargetSpot).Y - 24
        ELSE
                GameObject(TargetSpot).Y = GameObject(TargetSpot).Y + 24
        END IF
        GameObject(TargetSpot).ExtraFlag5 = GameObject(TargetSpot).ExtraFlag5 - SGN(GameObject(TargetSpot).ExtraFlag5)
        GameObject(TargetSpot).Tilt = (GameObject(TargetSpot).ExtraFlag5 + 360) MOD 360
        IF GameObject(TargetSpot).HeadXZ < 0 THEN GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ + 1280
        IF GameObject(TargetSpot).HeadXZ > 1279 THEN GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ - 1280
        GameObject(TargetSpot).X = GameObject(TargetSpot).X - SineTab(GameObject(TargetSpot).HeadXZ) * GameObject(TargetSpot).Velocity
        GameObject(TargetSpot).Z = GameObject(TargetSpot).Z - CosineTab(GameObject(TargetSpot).HeadXZ) * GameObject(TargetSpot).Velocity
        GroundLevel& = GetGroundY(BumpMap&(), GameObject(TargetSpot).X, GameObject(TargetSpot).Z)
       
        IF GameObject(TargetSpot).Y < GroundLevel& + 4096 THEN GameObject(TargetSpot).Y = GroundLevel& + 4096
        GameObject(TargetSpot).ExtraFlag1 = GameObject(TargetSpot).ExtraFlag1 + 1
       
        IF GameObject(TargetSpot).ExtraFlag1 >= GameObject(TargetSpot).WeaponCoolDown AND (TargetingAngle > 580 AND TargetingAngle < 720) THEN
                GameObject(TargetSpot).ExtraFlag1 = 0
                ShootingAngle = (((GameObject(TargetSpot).HeadXZ - 40) + RND * 80) + 1280) MOD 1280
                IF ShootingAngle > 1279 THEN ShootingAngle = ShootingAngle - 1280
                FireProjectile GameObject(), GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z, GameObject(TargetSpot).Weapon, ShootingAngle, -10 + (RND * 20), 0, 0, ENEMYSHOT
                GameObject(TargetSpot).ExtraFlag6 = GameObject(TargetSpot).ExtraFlag6 + 1
                IF GameObject(TargetSpot).ExtraFlag6 >= 10 THEN
                        GameObject(TargetSpot).ExtraFlag6 = 0
                        GameObject(TargetSpot).ExtraFlag7 = 1
                        GameObject(TargetSpot).ExtraFlag8 = 0
                END IF
        END IF
ELSE
        GameObject(TargetSpot).X = GameObject(TargetSpot).X + SineTab(GameObject(TargetSpot).HeadXZ) * GameObject(TargetSpot).Velocity
        GameObject(TargetSpot).Z = GameObject(TargetSpot).Z + CosineTab(GameObject(TargetSpot).HeadXZ) * GameObject(TargetSpot).Velocity
        GameObject(TargetSpot).ExtraFlag8 = GameObject(TargetSpot).ExtraFlag8 + 1
        IF GameObject(TargetSpot).ExtraFlag8 >= 48 THEN GameObject(TargetSpot).ExtraFlag7 = 0
END IF

END SUB

SUB InitBoss (GameObject() AS Object, LevelNum)
        IF LevelNum > 2 THEN
        Xp& = GameObject(1).X
        Yp& = GameObject(1).Y
        Zp& = GameObject(1).Z
        Xs = GameObject(1).Xsiz
        Ys = GameObject(1).Ysiz
        Zs = GameObject(1).Zsiz
        BossType = GameObject(1).ObjectType
        KillObject 1, GameObject()
        GameObject(1).ObjectType = BossType
        GameObject(1).Xsiz = Xs
        GameObject(1).Ysiz = Ys
        GameObject(1).Zsiz = Zs
        GameObject(1).X = Xp&
        GameObject(1).Y = Yp&
        GameObject(1).Z = Zp&
        END IF
        SELECT CASE LevelNum
        CASE 1
                GameObject(1).HitPoints = 250
                GameObject(1).AIScript = STATICOBJECT
                GameObject(1).ExtraFlag8 = BUILDING
        CASE 2
                GameObject(1).HitPoints = 335
                GameObject(1).AIScript = STATICOBJECT
                GameObject(1).ExtraFlag8 = BUILDING
        CASE 3
                GameObject(1).HitPoints = 250
                GameObject(1).AIScript = FIGHTER
                GameObject(1).Velocity = 6
                GameObject(1).ExtraFlag4 = 16
                GameObject(1).Weapon = GREENLASER
                GameObject(1).WeaponCoolDown = 3
                GameObject(1).GunBurst = 20
                GameObject(1).ExtraFlag8 = FIGHTERSCRIPTCHASE
        CASE 4
                GameObject(1).HitPoints = 400
                GameObject(1).AIScript = FLAKCANNON
                GameObject(1).Velocity = 0
                GameObject(1).Weapon = MISSILE
                GameObject(1).WeaponCoolDown = 20
                GameObject(1).ExtraFlag2 = UNROTATINGFLAK
        CASE 5
                GameObject(1).HitPoints = 400
                GameObject(1).AIScript = FIGHTER
                GameObject(1).Velocity = 8
                GameObject(1).ExtraFlag4 = 18
                GameObject(1).Weapon = ION
                GameObject(1).WeaponCoolDown = 2
                GameObject(1).GunBurst = 25
                GameObject(1).ExtraFlag8 = FIGHTERSCRIPTCHASE
        CASE 6
                GameObject(1).HitPoints = 475
                GameObject(1).AIScript = FIGHTER
                GameObject(1).Velocity = 7
                GameObject(1).ExtraFlag4 = 24
                GameObject(1).Weapon = PLASMA
                GameObject(1).WeaponCoolDown = 9
                GameObject(1).GunBurst = 10
                GameObject(1).ExtraFlag8 = FIGHTERSCRIPTCHASE
        CASE 7
                GameObject(1).HitPoints = 550
                GameObject(1).AIScript = FLAKCANNON
                GameObject(1).Velocity = 0
                GameObject(1).Weapon = BLUELASER
                GameObject(1).WeaponCoolDown = 3
                GameObject(1).ExtraFlag2 = ROLLFLAK
        CASE 8
                GameObject(1).HitPoints = 800
                GameObject(1).AIScript = FLAKCANNON
                GameObject(1).Velocity = 0
                GameObject(1).Weapon = PLASMA
                GameObject(1).WeaponCoolDown = 5
                GameObject(1).ExtraFlag2 = ROLLFLAK
        END SELECT
END SUB

FUNCTION InSquare (X1&, X2&, Z1&, Z2&, quota&)
IF ABS(X1& - X2&) < quota& AND ABS(Z1& - Z2&) < quota& THEN InSquare = TRUE ELSE InSquare = FALSE
END FUNCTION

FUNCTION IsLocked (GameObject() AS Object, KeyValue)
FOR index = 0 TO 379
        IF GameObject(index).AIScript = SEEKMISSILE AND GameObject(index).ExtraFlag8 = KeyValue THEN IsLocked = TRUE: EXIT FUNCTION
NEXT
IsLocked = FALSE
END FUNCTION

SUB KillObject (TargetSpot, GameObject() AS Object)
GameObject(TargetSpot).ObjectType = 0
GameObject(TargetSpot).X = 0
GameObject(TargetSpot).Y = 0
GameObject(TargetSpot).Z = 0
GameObject(TargetSpot).Tilt = 0
GameObject(TargetSpot).Velocity = 0
GameObject(TargetSpot).HeadXZ = 0
GameObject(TargetSpot).HeadY = 0
GameObject(TargetSpot).ObjectDrawClass = POLYGONAL
GameObject(TargetSpot).Scale = FULLSCALE
GameObject(TargetSpot).AIScript = STATICOBJECT
GameObject(TargetSpot).HitPoints = 0
GameObject(TargetSpot).Weapon = 0
GameObject(TargetSpot).WeaponCoolDown = 0
GameObject(TargetSpot).GunBurst = 0
GameObject(TargetSpot).Xsiz = 0
GameObject(TargetSpot).Ysiz = 0
GameObject(TargetSpot).Zsiz = 0
GameObject(TargetSpot).ExtraFlag1 = 0
GameObject(TargetSpot).ExtraFlag2 = 0
GameObject(TargetSpot).ExtraFlag3 = 0
GameObject(TargetSpot).ExtraFlag4 = 0
GameObject(TargetSpot).ExtraFlag5 = 0
GameObject(TargetSpot).ExtraFlag6 = 0
GameObject(TargetSpot).ExtraFlag7 = 0
GameObject(TargetSpot).ExtraFlag8 = 0
END SUB

SUB MoveFighter (TargetSpot, GameObject() AS Object, BumpMap&(), SineTab(), CosineTab(), AltSine())
px& = GameObject(0).X + 200000000
pz& = GameObject(0).Z + 200000000
objectx& = GameObject(TargetSpot).X + 200000000
objectz& = GameObject(TargetSpot).Z + 200000000
TargetingAngle = GetTargetingAngle(px&, objectx&, pz&, objectz&, GameObject(TargetSpot).HeadXZ)
IF TargetSpot = 1 THEN
        FleeDistance& = 6144
        Distract1 = FIGHTERSCRIPTSTURN
        Distract2 = FIGHTERSCRIPTSTURN
ELSE
FleeDistance& = 2048
        Distract1 = FIGHTERSCRIPTEVADE
        Distract2 = FIGHTERSCRIPTSTURN
END IF
IF GameObject(TargetSpot).ExtraFlag8 = FIGHTERSCRIPTCHASE THEN
        IF TargetingAngle < 600 THEN
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ + GameObject(TargetSpot).ExtraFlag4
                IF GameObject(TargetSpot).ExtraFlag3 > -35 THEN GameObject(TargetSpot).ExtraFlag3 = GameObject(TargetSpot).ExtraFlag3 - 2
        ELSEIF TargetingAngle > 680 THEN
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ - GameObject(TargetSpot).ExtraFlag4
                IF GameObject(TargetSpot).ExtraFlag3 < 35 THEN GameObject(TargetSpot).ExtraFlag3 = GameObject(TargetSpot).ExtraFlag3 + 2
        ELSE
                IF (TargetingAngle - 640) < 0 THEN
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ + 1
                IF GameObject(TargetSpot).ExtraFlag3 > -35 THEN GameObject(TargetSpot).ExtraFlag3 = GameObject(TargetSpot).ExtraFlag3 - 1
                ELSE
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ - 1
                IF GameObject(TargetSpot).ExtraFlag3 < 35 THEN GameObject(TargetSpot).ExtraFlag3 = GameObject(TargetSpot).ExtraFlag3 + 1
                END IF
        END IF
        IF GameObject(TargetSpot).Y < GameObject(0).Y - 1024 THEN
                IF GameObject(TargetSpot).HeadY > -30 THEN GameObject(TargetSpot).HeadY = GameObject(TargetSpot).HeadY - 1
        ELSEIF GameObject(TargetSpot).Y > GameObject(0).Y + 1024 THEN
                IF GameObject(TargetSpot).HeadY < 30 THEN GameObject(TargetSpot).HeadY = GameObject(TargetSpot).HeadY + 1
                ELSE
                GameObject(TargetSpot).HeadY = GameObject(TargetSpot).HeadY - SGN(GameObject(TargetSpot).HeadY)
        END IF

        IF InSquare(GameObject(0).X, GameObject(TargetSpot).X, GameObject(0).Z, GameObject(TargetSpot).Z, FleeDistance&) = TRUE AND ABS(GameObject(0).Y - GameObject(TargetSpot).Y) < 2700 THEN
                IF RandomPercentage > 50 THEN
                GameObject(TargetSpot).ExtraFlag1 = 0
                GameObject(TargetSpot).ExtraFlag2 = 0
                GameObject(TargetSpot).ExtraFlag6 = 0
                GameObject(TargetSpot).ExtraFlag7 = 320 + INT(RND * 640) + 1
                GameObject(TargetSpot).ExtraFlag8 = Distract1
                GameObject(TargetSpot).HeadY = (GameObject(TargetSpot).HeadY - 3) + (RND * 6)
                ELSE
                GameObject(TargetSpot).ExtraFlag8 = Distract2
                GameObject(TargetSpot).ExtraFlag1 = 0
                GameObject(TargetSpot).ExtraFlag2 = 0
                GameObject(TargetSpot).ExtraFlag6 = 0
                GameObject(TargetSpot).HeadY = (GameObject(TargetSpot).HeadY - 3) + (RND * 6)
                SoundInterFace 2, 27, 0, 0, 0
                END IF
        END IF

ELSEIF GameObject(TargetSpot).ExtraFlag8 = FIGHTERSCRIPTEVADE THEN
        IF TargetingAngle > GameObject(TargetSpot).ExtraFlag7 THEN
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ + GameObject(TargetSpot).ExtraFlag4
                IF GameObject(TargetSpot).ExtraFlag3 > -35 THEN GameObject(TargetSpot).ExtraFlag3 = GameObject(TargetSpot).ExtraFlag3 - 2
        ELSE
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ - GameObject(TargetSpot).ExtraFlag4
                IF GameObject(TargetSpot).ExtraFlag3 < 35 THEN GameObject(TargetSpot).ExtraFlag3 = GameObject(TargetSpot).ExtraFlag3 + 2
        END IF
        GameObject(TargetSpot).HeadY = GameObject(TargetSpot).HeadY + SGN(GameObject(TargetSpot).HeadY)
        IF GameObject(TargetSpot).HeadY > 30 THEN GameObject(TargetSpot).HeadY = 30
        IF GameObject(TargetSpot).HeadY < -30 THEN GameObject(TargetSpot).HeadY = -30
ELSE
        IF GameObject(TargetSpot).ExtraFlag3 > 0 THEN
                GameObject(TargetSpot).ExtraFlag3 = GameObject(TargetSpot).ExtraFlag3 + 6
                IF GameObject(TargetSpot).ExtraFlag3 >= 360 THEN GameObject(TargetSpot).ExtraFlag3 = 0
        ELSEIF GameObject(TargetSpot).ExtraFlag3 < 0 THEN
                GameObject(TargetSpot).ExtraFlag3 = GameObject(TargetSpot).ExtraFlag3 - 6
                IF GameObject(TargetSpot).ExtraFlag3 <= -360 THEN GameObject(TargetSpot).ExtraFlag3 = 0
        END IF
        IF GameObject(TargetSpot).ExtraFlag6 <= 16 THEN
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ - GameObject(TargetSpot).ExtraFlag4
        ELSE
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ + GameObject(TargetSpot).ExtraFlag4
        END IF
        GameObject(TargetSpot).HeadY = GameObject(TargetSpot).HeadY + SGN(GameObject(TargetSpot).HeadY)
        IF GameObject(TargetSpot).HeadY > 30 THEN GameObject(TargetSpot).HeadY = 30
        IF GameObject(TargetSpot).HeadY < -30 THEN GameObject(TargetSpot).HeadY = -30
END IF
        GameObject(TargetSpot).ExtraFlag3 = GameObject(TargetSpot).ExtraFlag3 - SGN(GameObject(TargetSpot).ExtraFlag3)
        GameObject(TargetSpot).Tilt = (GameObject(TargetSpot).ExtraFlag3 + 360) MOD 360
       
IF GameObject(TargetSpot).HeadXZ < 0 THEN GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ + 1280
IF GameObject(TargetSpot).HeadXZ > 1279 THEN GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ - 1280

        IF GameObject(TargetSpot).ExtraFlag8 = FIGHTERSCRIPTCHASE THEN GameObject(TargetSpot).ExtraFlag1 = GameObject(TargetSpot).ExtraFlag1 + 1
       
        IF GameObject(TargetSpot).ExtraFlag1 >= GameObject(TargetSpot).WeaponCoolDown THEN
                GameObject(TargetSpot).ExtraFlag1 = 0
                IF InSquare(GameObject(0).X, GameObject(TargetSpot).X, GameObject(0).Z, GameObject(TargetSpot).Z, 18000) AND (TargetingAngle > 500 AND TargetingAngle < 780) AND ABS(GameObject(0).Y - GameObject(TargetSpot).Y) < 4096 AND ABS( _
GameObject(TargetSpot).HeadY) < 10 THEN
                        GameObject(TargetSpot).ExtraFlag2 = GameObject(TargetSpot).ExtraFlag2 + 1
                        IF GameObject(0).HitPoints <> 0 THEN FireProjectile GameObject(), GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z, GameObject(TargetSpot).Weapon, GameObject(TargetSpot).HeadXZ, GameObject( _
TargetSpot).HeadY, 0, GameObject(TargetSpot).Tilt, ENEMYSHOT
                        IF GameObject(TargetSpot).ExtraFlag2 = GameObject(TargetSpot).GunBurst THEN
                                IF RandomPercentage > 25 THEN
                                GameObject(TargetSpot).ExtraFlag2 = 0
                                GameObject(TargetSpot).ExtraFlag6 = 0
                                GameObject(TargetSpot).ExtraFlag7 = 320 + INT(RND * 640) + 1
                                GameObject(TargetSpot).ExtraFlag8 = Distract1
                                GameObject(TargetSpot).HeadY = (GameObject(TargetSpot).HeadY - 3) + (RND * 6)
                                ELSE
                                GameObject(TargetSpot).ExtraFlag8 = Distract2
                                GameObject(TargetSpot).ExtraFlag2 = 0
                                GameObject(TargetSpot).ExtraFlag6 = 0
                                GameObject(TargetSpot).HeadY = (GameObject(TargetSpot).HeadY - 3) + (RND * 6)
                                END IF
                        END IF
                END IF
        END IF
        IF GameObject(TargetSpot).ExtraFlag8 = FIGHTERSCRIPTEVADE OR GameObject(TargetSpot).ExtraFlag8 = FIGHTERSCRIPTSTURN THEN
                GameObject(TargetSpot).ExtraFlag6 = GameObject(TargetSpot).ExtraFlag6 + 1
                IF GameObject(TargetSpot).ExtraFlag6 > 64 THEN GameObject(TargetSpot).ExtraFlag8 = FIGHTERSCRIPTCHASE
        END IF

        MoveObject TargetSpot, GameObject(), SineTab(), CosineTab(), AltSine()
        GroundLevel& = GetGroundY(BumpMap&(), GameObject(TargetSpot).X, GameObject(TargetSpot).Z)
        IF GameObject(TargetSpot).Y < GroundLevel& + 6144 THEN GameObject(TargetSpot).Y = GroundLevel& + 6144
        FlyBy GameObject(), TargetSpot

        IF TargetSpot = 1 THEN
                IF RandomPercentage > 95 THEN
                        SecondaryWeapon = GetBossSecondary(GameObject(TargetSpot).ObjectType)
                        FireBossSecondary GameObject(), SecondaryWeapon
                END IF
        END IF
END SUB

SUB MoveObject (TargetSpot, GameObject() AS Object, SineTab(), CosineTab(), AltSine())
        GameObject(TargetSpot).X = GameObject(TargetSpot).X - SineTab(GameObject(TargetSpot).HeadXZ) * GameObject(TargetSpot).Velocity
        GameObject(TargetSpot).Z = GameObject(TargetSpot).Z - CosineTab(GameObject(TargetSpot).HeadXZ) * GameObject(TargetSpot).Velocity
        GameObject(TargetSpot).Y = GameObject(TargetSpot).Y - AltSine(GameObject(TargetSpot).HeadY + 90) * GameObject(TargetSpot).Velocity
END SUB

SUB MoveProjectile (TargetSpot, GameObject() AS Object, EnemyDrop() AS DropDownType, BumpMap&(), SineTab(), CosineTab(), AltSine())
        GameObject(TargetSpot).X = GameObject(TargetSpot).X - SineTab(GameObject(TargetSpot).HeadXZ) * GameObject(TargetSpot).Velocity
        GameObject(TargetSpot).Z = GameObject(TargetSpot).Z - CosineTab(GameObject(TargetSpot).HeadXZ) * GameObject(TargetSpot).Velocity
        GameObject(TargetSpot).Y = GameObject(TargetSpot).Y - AltSine(GameObject(TargetSpot).HeadY + 90) * GameObject(TargetSpot).Velocity
       
        GroundLevel& = GetGroundY(BumpMap&(), GameObject(TargetSpot).X, GameObject(TargetSpot).Z)
        IF GameObject(TargetSpot).Y > 220000 THEN KillObject TargetSpot, GameObject(): EXIT SUB
        IF GameObject(TargetSpot).Y < GroundLevel& THEN
                ShowHitSpark GameObject(), GameObject(TargetSpot).X, GameObject(TargetSpot).Z, GameObject(TargetSpot).Y, 1
                KillObject TargetSpot, GameObject()
                EXIT SUB
        END IF
       
        GameObject(TargetSpot).ExtraFlag7 = GameObject(TargetSpot).ExtraFlag7 + 1
        IF GameObject(TargetSpot).ExtraFlag7 >= 55 THEN KillObject TargetSpot, GameObject(): EXIT SUB

IF GameObject(TargetSpot).ExtraFlag3 = PLAYERSHOT THEN
        FOR index = 1 TO 379
        IF GameObject(index).ObjectType <> 0 AND GameObject(index).HitPoints <> 0 AND (TargetSpot <> index) AND (Collision(GameObject(), TargetSpot, index) = TRUE) THEN
                        SELECT CASE GameObject(TargetSpot).ObjectType
                        CASE PULSELASER, REDLASER
                        Damage = 1
                        CASE ION TO ION + 2
                        Damage = 2
                        CASE PLASMA TO PLASMA + 2
                        Damage = 4
                        CASE MISSILE
                        Damage = 8
                        END SELECT
                ShowHitSpark GameObject(), GameObject(TargetSpot).X, GameObject(TargetSpot).Z, GameObject(TargetSpot).Y, 2
                KillObject TargetSpot, GameObject()
                GameObject(index).HitPoints = GameObject(index).HitPoints - Damage
                        IF GameObject(index).HitPoints <= 0 THEN
                        GameObject(index).HitPoints = 0
                        DropDownFlags = TRUE
                                IF GameObject(index).AIScript = FIGHTER THEN
                                        IF index <> 1 THEN RandomPowerDrop GameObject(), EnemyDrop(), index
                                        DropDownFlags = FALSE
                                        IF RandomPercentage < 75 THEN
                                        Explode GameObject(), NORMALEXPLOSION, DOUBLESIZE, GameObject(index).X, GameObject(index).Y, GameObject(index).Z
                                        KillObject index, GameObject()
                                        ELSE
                                        GameObject(index).AIScript = DEATHSPIN
                                        END IF
                                ELSEIF GameObject(index).AIScript = FLAKCANNON THEN
                                        Explode GameObject(), MUSHROOMEXPLOSION, QUADSIZE, GameObject(index).X, GameObject(index).Y, GameObject(index).Z
                                ELSEIF GameObject(index).ExtraFlag8 = BUILDING THEN
                                        Explode GameObject(), MUSHROOMEXPLOSION, OCTASIZE, GameObject(index).X, GameObject(index).Y, GameObject(index).Z
                                ELSE
                                        Explode GameObject(), NORMALEXPLOSION, DOUBLESIZE, GameObject(index).X, GameObject(index).Y, GameObject(index).Z
                                END IF
                        IF DropDownFlags = TRUE THEN
                        DropRewardedBonus GameObject(), index
                        KillObject index, GameObject()
                        END IF
                        EXIT SUB
                        END IF
        END IF
        NEXT
ELSE
        IF Collision(GameObject(), TargetSpot, 0) = TRUE AND GameObject(0).ExtraFlag5 = 0 THEN
        SELECT CASE GameObject(TargetSpot).ObjectType
        CASE ION TO ION + 2
        Damage = 3
        CASE PLASMA TO PLASMA + 2
        Damage = 5
        CASE MISSILE
        Damage = 8
        CASE ELSE
        Damage = 2
        END SELECT
        ShowHitSpark GameObject(), GameObject(TargetSpot).X, GameObject(TargetSpot).Z, GameObject(TargetSpot).Y, 3
        SoundInterFace 2, 31, 0, 0, 0
        GameObject(0).HitPoints = GameObject(0).HitPoints - Damage
        GameObject(0).ExtraFlag5 = 13
        IF GameObject(0).HitPoints < 0 THEN GameObject(0).HitPoints = 0
        KillObject TargetSpot, GameObject()
        END IF
END IF

END SUB

SUB MoveSeeker (TargetSpot, GameObject() AS Object, EnemyDrop() AS DropDownType, BumpMap&(), SineTab(), CosineTab(), AltSine())
Destination = GameObject(TargetSpot).ExtraFlag8
missx& = GameObject(TargetSpot).X + 200000000
missz& = GameObject(TargetSpot).Z + 200000000
objectx& = GameObject(Destination).X + 200000000
objectz& = GameObject(Destination).Z + 200000000
TargetingAngle = GetTargetingAngle(objectx&, missx&, objectz&, missz&, GameObject(TargetSpot).HeadXZ)
       
        IF TargetingAngle < 640 THEN
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ + 24
        ELSE
                GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ - 24
        END IF
       
        IF GameObject(TargetSpot).Y < GameObject(Destination).Y - 400 THEN
                IF GameObject(TargetSpot).HeadY > -16 THEN GameObject(TargetSpot).HeadY = GameObject(TargetSpot).HeadY - 1
        ELSEIF GameObject(TargetSpot).Y > GameObject(Destination).Y + 400 THEN
                IF GameObject(TargetSpot).HeadY < 16 THEN GameObject(TargetSpot).HeadY = GameObject(TargetSpot).HeadY + 1
        ELSE
                GameObject(TargetSpot).HeadY = 0
        END IF
        IF GameObject(TargetSpot).HeadXZ < 0 THEN GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ + 1280
        IF GameObject(TargetSpot).HeadXZ > 1280 THEN GameObject(TargetSpot).HeadXZ = GameObject(TargetSpot).HeadXZ - 1280
        MoveObject TargetSpot, GameObject(), SineTab(), CosineTab(), AltSine()
        GroundLevel& = GetGroundY(BumpMap&(), GameObject(TargetSpot).X, GameObject(TargetSpot).Z)
        IF GameObject(TargetSpot).Y < GroundLevel& + 256 THEN
                ShowHitSpark GameObject(), GameObject(TargetSpot).X, GameObject(TargetSpot).Z, GameObject(TargetSpot).Y, 1
                KillObject TargetSpot, GameObject()
                EXIT SUB
        END IF

        IF GameObject(Destination).ObjectType = 0 THEN
                GameObject(TargetSpot).ExtraFlag7 = 0
                GameObject(TargetSpot).AIScript = PROJECTILE
                EXIT SUB
        END IF

        GameObject(TargetSpot).ExtraFlag7 = GameObject(TargetSpot).ExtraFlag7 + 1
        IF GameObject(TargetSpot).ExtraFlag7 > 255 THEN KillObject TargetSpot, GameObject(): EXIT SUB
       
        FOR index = 1 TO 379
                IF GameObject(index).ObjectType <> 0 AND GameObject(index).HitPoints <> 0 AND (index <> TargetSpot) AND (GameObject(index).HitPoints <> 0) AND Collision(GameObject(), TargetSpot, index) = TRUE THEN
                ShowHitSpark GameObject(), GameObject(TargetSpot).X, GameObject(TargetSpot).Z, GameObject(TargetSpot).Y, 4
                KillObject TargetSpot, GameObject()
                GameObject(index).HitPoints = GameObject(index).HitPoints - 10
                        IF GameObject(index).HitPoints <= 0 THEN
                        GameObject(index).HitPoints = 0
                                DropDownFlags = TRUE
                                IF GameObject(index).AIScript = FIGHTER THEN
                                        RandomPowerDrop GameObject(), EnemyDrop(), index
                                        DropDownFlags = FALSE
                                        IF RandomPercentage < 75 THEN
                                        Explode GameObject(), NORMALEXPLOSION, FULLSCALE, GameObject(index).X, GameObject(index).Y, GameObject(index).Z
                                        KillObject index, GameObject()
                                        ELSE
                                        GameObject(index).AIScript = DEATHSPIN
                                        END IF
                                ELSEIF GameObject(index).AIScript = FLAKCANNON THEN
                                        Explode GameObject(), MUSHROOMEXPLOSION, QUADSIZE, GameObject(index).X, GameObject(index).Y, GameObject(index).Z
                                ELSEIF GameObject(index).ExtraFlag8 = BUILDING THEN
                                        Explode GameObject(), MUSHROOMEXPLOSION, OCTASIZE, GameObject(index).X, GameObject(index).Y, GameObject(index).Z
                                ELSE
                                        Explode GameObject(), NORMALEXPLOSION, DOUBLESIZE, GameObject(index).X, GameObject(index).Y, GameObject(index).Z
                                END IF
                IF DropDownFlags = TRUE THEN
                        DropRewardedBonus GameObject(), index
                        KillObject index, GameObject()
                END IF
                EXIT SUB
                END IF
                END IF
        NEXT

END SUB

FUNCTION RandomPercentage
a = INT(RND * 100) + 1
RandomPercentage = a
END FUNCTION

SUB RandomPowerDrop (GameObject() AS Object, DropDown() AS DropDownType, TargetSpot)
        IF GameObject(TargetSpot).ObjectType = DropDown(0).ParentObject THEN DropNumber = 0 ELSE DropNumber = 1
        IF RandomPercentage > DropDown(DropNumber).DropDownPossibility THEN EXIT SUB
        AddBonusObject GameObject(), DropDown(DropNumber).DropDownClass, GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z
END SUB

SUB ShowHitSpark (GameObject() AS Object, Xp&, Zp&, Yp&, Sparks%)
FOR index = 0 TO Sparks - 1
CreateParticle GameObject(), Xp&, Yp&, Zp&, RND * 1280, 5 - RND * 40, 0, 2, 4
NEXT
END SUB

SUB SmallParticle (GameObject() AS Object, TargetSpot, SineTab(), CosineTab(), AltSine())
        GameObject(TargetSpot).ExtraFlag1 = GameObject(TargetSpot).ExtraFlag1 + 1
        IF GameObject(TargetSpot).ExtraFlag1 >= GameObject(TargetSpot).ExtraFlag4 THEN
                GameObject(TargetSpot).ObjectType = GameObject(TargetSpot).ObjectType + 1
                GameObject(TargetSpot).ExtraFlag1 = 0
                IF GameObject(TargetSpot).Velocity > 2 THEN GameObject(TargetSpot).Velocity = GameObject(TargetSpot).Velocity - 1
                IF GameObject(TargetSpot).ObjectType >= PARTICLEDIE THEN KillObject TargetSpot, GameObject(): EXIT SUB
        END IF
        IF GameObject(TargetSpot).HeadY < 65 THEN GameObject(TargetSpot).HeadY = GameObject(TargetSpot).HeadY + 6
MoveObject TargetSpot, GameObject(), SineTab(), CosineTab(), AltSine()
END SUB

SUB SpinningDown (GameObject() AS Object, TargetSpot, BumpMap&(), SineTab(), CosineTab(), AltSine())
GameObject(TargetSpot).Tilt = GameObject(TargetSpot).Tilt + 8
IF GameObject(TargetSpot).Tilt > 360 THEN GameObject(TargetSpot).Tilt = 0
        MoveObject TargetSpot, GameObject(), SineTab(), CosineTab(), AltSine()
        IF GameObject(TargetSpot).HeadY < 45 THEN GameObject(TargetSpot).HeadY = GameObject(TargetSpot).HeadY + 2
        CreateParticle GameObject(), GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z, 0, 0, 1, 0, 0
        GroundLevel& = GetGroundY(BumpMap&(), GameObject(TargetSpot).X, GameObject(TargetSpot).Z)
        IF GameObject(TargetSpot).Y < GroundLevel& + 2048 THEN
        Explode GameObject(), MUSHROOMEXPLOSION, DOUBLESIZE, GameObject(TargetSpot).X, GameObject(TargetSpot).Y, GameObject(TargetSpot).Z
        KillObject TargetSpot, GameObject()
        END IF
END SUB

SUB ToggleBoss (GameObject() AS Object, BossType, Switch)
SELECT CASE Switch
        CASE TRUE
                GameObject(1).ObjectType = BossType
        CASE FALSE
                GameObject(1).ObjectType = 0
END SELECT
END SUB

FUNCTION TotalActiveEnemies (GameObject() AS Object)
dumpInt = 0
FOR index = 0 TO 379
        IF GameObject(index).ObjectType <> 0 AND GameObject(index).AIScript = FIGHTER THEN dumpInt = dumpInt + 1
NEXT
TotalActiveEnemies = dumpInt
END FUNCTION

SUB TransportAI (GameObject() AS Object, TargetSpot, SineTab(), CosineTab(), BumpMap&())
IF InSquare(GameObject(0).X, GameObject(TargetSpot).X, GameObject(0).Z, GameObject(TargetSpot).Z, 45000) = FALSE THEN EXIT SUB
        GameObject(TargetSpot).X = GameObject(TargetSpot).X - SineTab(GameObject(TargetSpot).HeadXZ) * GameObject(TargetSpot).Velocity
        GameObject(TargetSpot).Z = GameObject(TargetSpot).Z - CosineTab(GameObject(TargetSpot).HeadXZ) * GameObject(TargetSpot).Velocity
        IF GameObject(TargetSpot).ExtraFlag8 = 1382 THEN
        GroundLevel& = GetGroundY(BumpMap&(), GameObject(TargetSpot).X, GameObject(TargetSpot).Z)
        GameObject(TargetSpot).Y = GroundLevel&
        END IF
END SUB

SUB VictoryFlight (GameObject() AS Object)
        IF GameObject(0).HeadY > -75 THEN GameObject(0).HeadY = GameObject(0).HeadY - 1
        GameObject(0).Velocity = 20
        GameObject(0).ExtraFlag7 = GameObject(0).ExtraFlag7 + 1
        IF GameObject(0).ExtraFlag7 = 256 THEN KillObject 0, GameObject()
END SUB

SUB VolcanoAI (GameObject() AS Object, TargetSpot)
IF ABS(GameObject(0).X - GameObject(TargetSpot).X) > 40000 OR ABS(GameObject(0).Z - GameObject(TargetSpot).Z) > 40000 OR ABS(GameObject(0).Y - GameObject(TargetSpot).Y) > 10000 THEN EXIT SUB
IF GameObject(TargetSpot).ExtraFlag2 = 0 THEN
        IF RandomPercentage = 31 THEN GameObject(TargetSpot).ExtraFlag2 = 1
ELSE
        CreateParticle GameObject(), GameObject(TargetSpot).X, GameObject(TargetSpot).Y + 5512, GameObject(TargetSpot).Z, RND * 1279, -60 - (RND * 25), 3 + RND * 2, 11, 2 + RND * 2
        GameObject(TargetSpot).ExtraFlag2 = GameObject(TargetSpot).ExtraFlag2 + 1
        IF GameObject(TargetSpot).ExtraFlag2 = 28 THEN GameObject(TargetSpot).ExtraFlag2 = 0
END IF
END SUB

