DECLARE SUB HorizonBall (UPPERLAYER&(), Pitch%, PlayerX&, PlayerY&, PlayerZ&, BumpMap&())
DECLARE SUB RenderShadow (Xtrans&, Ytrans%, Ztrans&, yRotAngle%, ObjectPolyCount%, ObjectMesh() AS ANY, VisibleObjectMesh() AS ANY, Sine!(), Cosine!(), BlenderMap%(), LOWERLAYER&())
DECLARE SUB Render3DObject (Xtrans&, Ytrans%, Ztrans&, xrotAngle%, yRotAngle%, zRotAngle%, ObjectPolyCount%, ObjectMesh() AS ANY, VisibleObjectMesh() AS ANY, Fogged%, TextureMap&(), BlenderMap%(), Sine!(), Cosine!(), UPPERLAYER&(), LOWERLAYER&())
DECLARE SUB CrossHairCoords (StartX&, StartY&, StartZ&, FinalX&, FinalY&, FinalZ&, Heading%, Pitch%, BumpMap&(), SineTab%(), CosineTab%(), AltSine%())
DECLARE SUB ToggleBoss (GameObject() AS ANY, BossType%, Switch%)
DECLARE SUB Glow ()
DECLARE SUB VolcanoAI (GameObject() AS ANY, TargetSpot%)
DECLARE SUB FadeToBlack ()
DECLARE SUB FlyHigh (Altitude&, CurrentPalette%, Pal$)
DECLARE SUB AddFighter (TargetSpot%, GameObject() AS ANY, PlayerX&, PlayerZ&, PlayerY&, EnemyFighter() AS ANY)
DECLARE SUB CheckPowerPick (GameObject() AS ANY, Ammo%(), BigMessage%, BigMessageTime%)
DECLARE SUB FlakAI (GameObject() AS ANY, TargetSpot%, SineTab%(), CosineTab%(), BumpMap&())
DECLARE SUB KillObject (TargetSpot%, GameObject() AS ANY)
DECLARE SUB VictoryFlight (GameObject() AS ANY)
DECLARE SUB TransportAI (GameObject() AS ANY, TargetSpot%, SineTab%(), CosineTab%(), BumpMap&())
DECLARE SUB HelicopterAI (GameObject() AS ANY, TargetSpot%, SineTab%(), CosineTab%(), BumpMap&())
DECLARE SUB GenerateTerrainColors (LevelNum%)
DECLARE SUB BuildingCrash (GameObject() AS ANY)
DECLARE SUB AddRadarObject (GameObject() AS ANY, RadarItem() AS ANY, TargetSpot%, ClearFlag%)
DECLARE SUB SmallParticle (GameObject() AS ANY, TargetSpot%, SineTab%(), CosineTab%(), AltSine%())
DECLARE SUB BigExplosion (GameObject() AS ANY, TargetSpot%)

DECLARE FUNCTION SmallMenu% (UPPERLAYER&(), LOWERLAYER&(), InterFaceObject() AS ANY, XMSCache&(), XMSHandles%(), VideoPage%, Ammo%(), LevelNum%, Skill%, Saveable%)
DECLARE FUNCTION RandomPercentage% ()
DECLARE FUNCTION FireACM% (GameObject() AS ANY, MissionPath() AS ANY)
DECLARE FUNCTION ArcTangent% (Y&, X&)
DECLARE FUNCTION GetAmmoTag% (Weapon%)
DECLARE FUNCTION CheckDeath% (Hits%)
DECLARE FUNCTION ChooseSeekerTarget% (GameObject() AS ANY)
DECLARE FUNCTION GetLock% (GameObject() AS ANY, TargetSpot%)
DECLARE FUNCTION GetGroundY% (BumpMap&(), X&, Z&)
DECLARE FUNCTION TotalActiveEnemies% (GameObject() AS ANY)
DECLARE FUNCTION GetFreeObject% (GameObject() AS ANY)

DECLARE SUB FireSeeker (GameObject() AS ANY, Destination%)
DECLARE SUB MoveProjectile (TargetSpot%, GameObject() AS ANY, EnemyDrop() AS ANY, BumpMap&(), SineTab%(), CosineTab%(), AltSine%())
DECLARE SUB Disk2XMS (File$, Handle%)
DECLARE SUB GenerateLevel (LevelNum%, MissionPath() AS ANY, CheckPoint() AS ANY, GameObject() AS ANY, ObjectDimensions() AS ANY, BumpMap&())
DECLARE SUB MoveSeeker (TargetSpot%, GameObject() AS ANY, EnemyDrop() AS ANY, BumpMap&(), SineTab%(), CosineTab%(), AltSine%())
DECLARE SUB ShowHitSpark (GameObject() AS ANY, Xp&, Zp&, Yp&, Sparks%)
DECLARE SUB CreateEnemyProfiles (EnemyFighter() AS ANY, EnemyDrop() AS ANY, LevelNum%)

DECLARE SUB AnimateBitMaps (GameObject() AS ANY)
DECLARE SUB SpinningDown (GameObject() AS ANY, TargetSpot%, BumpMap&(), SineTab%(), CosineTab%(), AltSine%())
DECLARE SUB MoveFighter (TargetSpot%, GameObject() AS ANY, BumpMap&(), SineTab%(), CosineTab%(), AltSine%())
DECLARE SUB FireProjectile (GameObject() AS ANY, X&, Y&, Z&, PROJECTILETYPE%, Heading%, Pitch%, Turn%, Roll%, GunOwner%)
DECLARE SUB GenerateTexTable (TextureTable&(), Level%)
DECLARE SUB ScrollStarField (Stars() AS ANY, Direction%, Amount%)
DECLARE SUB SetStarField (Stars() AS ANY)
DECLARE SUB MellowColors ()
DECLARE SUB CountVoxelPerspective (Altitude&, GroundProjection%())
DECLARE SUB CheckBoss (MissionPath() AS ANY, GameObject() AS ANY, BossType%, BigMessage%, BigMessageTime%)
DECLARE SUB VisitCheckPoint (MissionPath() AS ANY, CheckPoint() AS ANY, GameObject() AS ANY, BigMessage%, BigMessageTime%)
DECLARE SUB CheckTargets (MissionPath() AS ANY, GameObject() AS ANY, BigMessage%, BigMessageTime%)
DECLARE SUB Compass (UPPERLAYER&(), MissionPath() AS ANY, CheckPoint() AS ANY, GameObject() AS ANY, InterFaceObject() AS ANY, XMSHandles%(), XMSCache&(), Sine!(), Cosine!())
DECLARE SUB ShowMessage (UPPERLAYER&(), XMSHandles%(), XMSCache&(), InterFaceObject() AS ANY, MessageNum%)
DECLARE SUB LongRangeRadar (GameObject() AS ANY, UPPERLAYER&(), LOWERLAYER&(), RadarBlendMap%(), RadarBitMap%(), Sine!(), Cosine!())
DECLARE SUB GeneratePrimes (ObjectPrime() AS ANY, InterFaceObject() AS ANY, ObjectDimensions() AS ANY, ShadowPrime() AS ANY, XMSHandles%())
DECLARE SUB SetShadowHooks (ShadowHook%())
DECLARE SUB ResetTrigonometrics (SinTab%(), CosTab%(), MovSinTab%(), MovCosTab%(), AltSine%(), Sine!(), Cosine!(), SkyPerspective%(), TerrainHeights%())
DECLARE SUB InitBlendMaps (RadarBlendMap%(), ShadowBlendMap%(), TransBlendMap%())
DECLARE SUB UpdatePanel (UPPERLAYER&(), LOWERLAYER&(), XMSHandles%(), XMSCache&(), InterFaceObject() AS ANY, Weapon%, Ammo%(), Velo%, HullEnergy%)
DECLARE SUB UpdateRadar (RadarItem() AS ANY, RadarBitMap%(), UPPERLAYER&())
DECLARE SUB GenerateRadarBmps (RadarBitMap%())
DECLARE SUB ShowOffscreen (VideoPage%, UPPERLAYER&(), LOWERLAYER&())
DECLARE SUB SoundInterFace (Command%, Value1%, Value2%, Value3%, Value4%)
'$DYNAMIC
'$INCLUDE: 'objtypes.bi'
'$INCLUDE: 'slivedcx.bi'
DECLARE SUB DrawView CDECL ALIAS "_draw_view" (BYVAL xx&, BYVAL yy&, BYVAL Heading%, SEG SinTable%, SEG CosTable%, BYVAL skyprojseg%, BYVAL mountains%, BYVAL groundproj%, BYVAL hiview%, BYVAL loview%, BYVAL BumpMap%, BYVAL texture%, BYVAL skyon%,  _
BYVAL StarFlag%)
DECLARE SUB DrawStars CDECL ALIAS "_draw_stars" (BYVAL StarSeg%, BYVAL hiview%, BYVAL loview%)
DECLARE SUB SortObjects CDECL ALIAS "_sort_objects" (BYVAL objectslist%, BYVAL ObjectCount%)
DECLARE SUB Radar CDECL (BYVAL offscreen%, BYVAL blendseg%)
DECLARE SUB OctreeBlur CDECL ALIAS "_octree_blur" (BYVAL upper%, BYVAL lower%)
DECLARE SUB BossEnergyBar CDECL ALIAS "_boss_energy" (BYVAL offscreen%, BYVAL blender%, BYVAL Length%)
DECLARE SUB HighSky CDECL ALIAS "_high_sky" (BYVAL offscreen%)
DEFINT A-Z

DECLARE SUB mxMode320x400
DECLARE SUB mxFill (BYVAL Offset%, BYVAL lenn%, BYVAL coll%)

CLEAR , , 1750
ON ERROR GOTO ErrorTrap:
ScaleDivideY = 16
ScaleDivideZ! = 3.29999
ScaleDivideX! = 3.29999 ^ 2
ZEye = -750
REDIM XMSCache&(16384)
REDIM XMSCache2&(16384)
REDIM UPPERLAYER&(16000)
REDIM LOWERLAYER&(16000)
REDIM XMSHandles(8)
REDIM TextureTable&(128)

REDIM TMatrix!(3, 3), Matrix!(3, 3)
REDIM DistanceVector(0) AS Vector3DType
REDIM SkyPerspective(104)

REDIM ObjectFaceVector(0) AS Vector3DType
REDIM ObjectPolyFaces(2) AS Vector3DType
REDIM ObjectPolyScreenCoords(2) AS Vector2DType
REDIM BitMapScaleVector(2) AS Vector3DType
REDIM TranslatedBitMapScale(2) AS Vector3DType
REDIM LockIndicatorCoords(3) AS Vector3DType
REDIM BitMapCorners(2) AS Vector2DType
REDIM BitMapLocation(0) AS Vector3DType
REDIM BitMapTranslated(0) AS Vector3DType
REDIM BitMapCenter(0) AS Vector2DType
REDIM RadarBlendMap(128)
REDIM ShadowBlendMap(128)
REDIM TransBlendMap(128)
REDIM RadarBitMaps(60)
REDIM InterFaceObject(98) AS InterfaceBitMap

REDIM HorizonHeight(0) AS Vector2DType
REDIM HorizonHeightZero(0) AS Vector2DType
REDIM TerrainHeights(10240)
REDIM GroundProjection(160)

REDIM GameObject(379) AS Object
REDIM VisibleGameObject(379) AS VisibleObject
REDIM CheckPoint(15) AS CheckPointType
REDIM MissionPath(33) AS MissionType
REDIM RadarItem(63) AS RadarObject
REDIM PolyCount(0)
REDIM ObjectPrime(128) AS DrawPrimitive
REDIM ObjectDimensions(128) AS ObjectSizeDump
REDIM ShadowPrime(64) AS DrawPrimitive
REDIM ShadowHook(191)
REDIM Ammo(6)
REDIM StartingAmmo(6)

REDIM ObjectMesh(126) AS ObjectPolygon
REDIM VisibleObjectMesh(126) AS VisiblePolygon
REDIM Sine!(360), Cosine!(360)
REDIM LocationVector(0) AS Vector3DType
REDIM CameraVector(0) AS Vector3DType
REDIM Stars(499) AS StarType
REDIM EnemyFighter(1) AS FighterSpawn
REDIM EnemyDrop(1) AS DropDownType
REDIM CosTab(1279)
REDIM SinTab(1279)
REDIM MovSinTab(1279)
REDIM MovCosTab(1279)
REDIM AltSinTab(180)
RANDOMIZE TIMER
'Cmd$ = COMMAND$
'IF INSTR(UCASE$(Cmd$), "/MUSICON") <> 0 THEN MusicOn = TRUE ELSE MusicOn = FALSE
'IF INSTR(UCASE$(Cmd$), "/SOUNDON") <> 0 THEN SoundOn = TRUE ELSE SoundOn = FALSE
ResetTrigonometrics SinTab(), CosTab(), MovSinTab(), MovCosTab(), AltSinTab(), Sine!(), Cosine!(), SkyPerspective(), TerrainHeights()
LoadFlag = FALSE

'PRINT "TerraScape ALPHA Demo"
'PRINT
'a% = CSDetectCPU%
'IF a% = 386 THEN PRINT "386 Processor found!"
'IF a% = 486 THEN PRINT "486 Processor found!"
'IF a% = 586 THEN PRINT "Pentium Processor found!"
'IF a% = 686 THEN PRINT "Pentium Pro Processor found!"
'IF a% = 786 THEN PRINT "Pentium II or better processor found!"

XMS = CSDetectXMS%
IF XMS = 1 THEN
'PRINT "XMS Driver Found!"
        XMSHandles(OBJECTMESHES) = CSAllocateXMS(200)
        XMSHandles(TEXTURES) = CSAllocateXMS(1500)
        XMSHandles(GROUNDTEXTURE) = CSAllocateXMS(130)
        XMSHandles(INTERFACE) = CSAllocateXMS(170)
        XMSHandles(BITMAPS) = CSAllocateXMS(2410)
        XMSHandles(SHADOWS) = CSAllocateXMS(64)
ELSE
CSClose
END
END IF

MMXFound% = CSDetectMMX%

FileHandle = FREEFILE
OPEN "player.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
GET FileHandle, , LevelNum
GET FileHandle, , Skill
GET FileHandle, , StartingAmmo(0)
GET FileHandle, , StartingAmmo(1)
GET FileHandle, , StartingAmmo(2)
GET FileHandle, , StartingAmmo(3)
GET FileHandle, , StartingAmmo(4)
GET FileHandle, , StartingAmmo(5)
GET FileHandle, , StartingAmmo(6)
CLOSE FileHandle
FileHandle = FREEFILE
OPEN "prefs.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
GET FileHandle, , DS4QBActive
GET FileHandle, , AntiAlias
GET FileHandle, , SkyTexture
GET FileHandle, , ShadowsOn
GET FileHandle, , MenuFlip
GET FileHandle, , SFXVol
GET FileHandle, , MusicVol
GET FileHandle, , EAXAudio
CLOSE FileHandle
IF MusicVol > 0 THEN MusicOn = TRUE: LoadMusicFlag = TRUE
IF DS4QBActive = 2 THEN
        LoadMusicFlag = FALSE
        DS4QBActive = TRUE
FileHandle = FREEFILE
OPEN "prefs.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
PUT FileHandle, , DS4QBActive
CLOSE FileHandle
END IF

SoundInterFace 0, DS4QBActive, 0, 0, 0
GenerateRadarBmps RadarBitMaps()
SetShadowHooks ShadowHook()
SetStarField Stars()
mxFill 0, 8000, 0
mxFill 32000, 8000, 0

CSFfix
CSInstallTimer
CSSetTimer 1, 1000
CSSetTimer 0, 40
CSInstallKeyBoard
CSTextureWidth 64

BigScaleRestart:
IF LoadFlag <> FALSE THEN
        OPEN "qsave.db" FOR BINARY AS #1
        SEEK #1, ((LoadFlag - 26) * 20) + 1
        GET #1, , DummyVar
        GET #1, , LevelNum
        GET #1, , Skill
        FOR index = 0 TO 6
        GET #1, , StartingAmmo(index)
        NEXT
        CLOSE #1
END IF
LoadFlag = FALSE
SELECT CASE LevelNum
CASE 1
        BumpMapFile$ = "hfield01.lsg"
        TextureFile$ = "gndtex01.lsg"
        SongNumber = 2
        StarFlag = FALSE
CASE 2
        BumpMapFile$ = "hfield02.lsg"
        TextureFile$ = "gndtex01.lsg"
        SongNumber = 3
        StarFlag = FALSE
CASE 3
        BumpMapFile$ = "hfield03.lsg"
        TextureFile$ = "gndtex03.lsg"
        SongNumber = 4
        StarFlag = FALSE
CASE 4
        BumpMapFile$ = "hfield04.lsg"
        TextureFile$ = "gndtex04.lsg"
        SongNumber = 5
        StarFlag = TRUE
CASE 5
        BumpMapFile$ = "hfield05.lsg"
        TextureFile$ = "gndtex05.lsg"
        SongNumber = 6
        StarFlag = FALSE
CASE 6
        BumpMapFile$ = "hfield06.lsg"
        TextureFile$ = "gndtex06.lsg"
        SongNumber = 7
        StarFlag = TRUE
CASE 7
        BumpMapFile$ = "hfield07.lsg"
        TextureFile$ = "gndtex07.lsg"
        SongNumber = 8
        StarFlag = TRUE
CASE 8
        BumpMapFile$ = "hfield08.lsg"
        TextureFile$ = "gndtex08.lsg"
        SongNumber = 9
        StarFlag = TRUE
END SELECT
SELECT CASE Skill
        CASE 1
        MaxEnemies = 4
        EnemyPossibility = 6
        CASE 2
        MaxEnemies = 6
        EnemyPossibility = 7
        CASE 3
        MaxEnemies = 8
        EnemyPossibility = 7
        CASE 4
        MaxEnemies = 12
        EnemyPossibility = 8
END SELECT

OPEN BumpMapFile$ FOR BINARY AS #1
DEF SEG = VARSEG(XMSCache2&(0))
FOR index& = 0 TO 65535
a$ = INPUT$(1, #1)
POKE index&, ASC(a$)
NEXT
DEF SEG
CLOSE #1
        Disk2XMS "models.dx", XMSHandles(OBJECTMESHES)
        Disk2XMS TextureFile$, XMSHandles(GROUNDTEXTURE)
        Disk2XMS "surfaces.dx", XMSHandles(TEXTURES)
        Disk2XMS "bmp_objs.dx", XMSHandles(BITMAPS)
        Disk2XMS "interfce.dx", XMSHandles(INTERFACE)
        Disk2XMS "shadows.dx", XMSHandles(SHADOWS)
GeneratePrimes ObjectPrime(), InterFaceObject(), ObjectDimensions(), ShadowPrime(), XMSHandles()
GenerateTexTable TextureTable&(), LevelNum
CreateEnemyProfiles EnemyFighter(), EnemyDrop(), LevelNum
        IF MusicOn = TRUE AND LoadMusicFlag = TRUE THEN SoundInterFace 3, SongNumber, 1, 0, 0
        LoadMusicFlag = TRUE
        Pal$ = SPACE$(768)
        index = CSLoadPal("Palette.dat", Pal$)
        CSSetPal Pal$
        GenerateTerrainColors LevelNum
        MellowColors
        CSGetPal Pal$
        InitBlendMaps RadarBlendMap(), ShadowBlendMap(), TransBlendMap()
StartOver:
mxFill 0, 8000, 0
mxFill 32000, 8000, 0
CSClearMMX VARSEG(UPPERLAYER&(0)), 0
CSClearMMX VARSEG(LOWERLAYER&(0)), 0
      
        CurrentPalette = 1
        FOR index = 0 TO 379: KillObject index, GameObject(): NEXT
        AddRadarObject GameObject(), RadarItem(), 0, TRUE
        xx& = 32000
        zz& = 32000
        PivotX& = 32000
        PivotZ& = 32000
        PivotY& = 20480
        eyex& = 0
        eyez& = 0
        Altitude& = 0
        HitPoints = 50
        Heading = 0
        CameraHeading = 0
        RecoverCamera = TRUE
        PlayerX& = 0
        PlayerZ& = 0
        PlayerY& = 0
        Weapon = PULSELASER
        HullEnergy = 50
        LongRangeRadarFlag = FALSE
        VictoryFlags = FALSE
        Velo = 4
        AltScale = 0
        Pitch = 0
        Roll = 0
        CrossHairColor = 47
        CrossHairColorWay = 1
        Maneuvre = 2
        PitchManeuvre = 1
        GunsDelay = 0
        MissilesDelay = 0
        AnimationDelay = 0
        BigMessage = FALSE
        BigMessageTime = 0
        Padlock = 640
        StartAddition = 85
        VictoryCameraAdd = 0
        VictoryPaletteTransDelay = 0
        DeathCounter = 0
VideoPage = 0

        GenerateLevel LevelNum, MissionPath(), CheckPoint(), GameObject(), ObjectDimensions(), XMSCache2&()
        BossType = GameObject(1).ObjectType
        MaxBossLife = GameObject(1).HitPoints
        ToggleBoss GameObject(), BossType, FALSE
        GameObject(0).HitPoints = HullEnergy
        GameObject(0).ObjectType = 1
        FOR index = 0 TO 6: Ammo(index) = StartingAmmo(index): NEXT
        CSResetTicks 1
        SecondTick = FALSE
        CSSetPal Pal$
DO
CSResetTicks 0

IF GameObject(0).ObjectType = 1 OR GameObject(0).ExtraFlag5 > 0 THEN GOSUB MoveFighter
IF GameObject(0).ObjectType = FALSE AND VictoryFlags = TRUE THEN GOTO Victory

IF DeathFlag = TRUE THEN
        VictoryPaletteTransDelay = VictoryPaletteTransDelay + 1
        IF VictoryPaletteTransDelay = 2 THEN VictoryPaletteTransDelay = 0: CSFadeToStep 0, 255, 62, 16, 16
        DeathCounter = DeathCounter + 1
        IF DeathCounter >= 128 THEN GOTO Death
END IF

IF VictoryFlags = FALSE THEN
        BuildingCrash GameObject()
        CheckPowerPick GameObject(), Ammo(), BigMessage, BigMessageTime
        CheckBoss MissionPath(), GameObject(), BossType, BigMessage, BigMessageTime
        VisitCheckPoint MissionPath(), CheckPoint(), GameObject(), BigMessage, BigMessageTime
        DeathFlag = CheckDeath(GameObject(0).HitPoints)
        IF DeathFlag THEN GameObject(0).AIScript = DEATHSPIN: GameObject(0).Velocity = 6
END IF
IF MissionPath(0).Node = NODEVICTORY AND VictoryFlags = FALSE THEN
        GameObject(0).AIScript = VICTORYDANCE
        GameObject(0).HitPoints = 32000
        Velo = 20
        VictoryFlags = TRUE
END IF

IF CrossHairColor >= 47 THEN CrossHairColorWay = 2
IF CrossHairColor <= 40 THEN CrossHairColorWay = 1
IF CrossHairColorWay = 1 THEN CrossHairColor = CrossHairColor + 1
IF CrossHairColorWay = 2 THEN CrossHairColor = CrossHairColor - 1
GunsDelay = GunsDelay + 1: IF GunsDelay = 7 THEN GunsDelay = 6
MissilesDelay = MissilesDelay + 1: IF MissilesDelay = 18 THEN MissilesDelay = 17

CountVoxelPerspective Altitude&, GroundProjection()
IF StarFlag = TRUE THEN UpperColor = 160 ELSE UpperColor = 224
IF StarFlag = FALSE AND SkyTexture = TRUE AND GameObject(0).Y > 80000 THEN LowerColor = 224 ELSE LowerColor = 160
CSClearMMX VARSEG(UPPERLAYER&(0)), UpperColor
CSClearMMX VARSEG(LOWERLAYER&(0)), LowerColor
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(GROUNDTEXTURE), 0, 65536
TempSkyTexture = SkyTexture
IF TempSkyTexture = TRUE AND GameObject(0).Y > 80000 THEN TempSkyTexture = 2
DrawView xx&, zz&, CameraHeading, SinTab(0), CosTab(0), VARSEG(SkyPerspective(0)), VARSEG(TerrainHeights(0)), VARSEG(GroundProjection(0)), VARSEG(UPPERLAYER&(0)), VARSEG(LOWERLAYER&(0)), VARSEG(XMSCache2&(0)), VARSEG(XMSCache&(0)), TempSkyTexture,  _
StarFlag
IF AntiAlias = TRUE THEN OctreeBlur VARSEG(UPPERLAYER&(0)), VARSEG(LOWERLAYER&(0))
IF SkyTexture = TRUE AND StarFlag = FALSE AND GameObject(0).Y > 80000 THEN HighSky VARSEG(UPPERLAYER&(0))
IF StarFlag = TRUE THEN DrawStars VARSEG(Stars(0).X), VARSEG(LOWERLAYER&(0)), VARSEG(UPPERLAYER&(0))
        IF GameObject(0).AIScript = STATICOBJECT THEN
                GOSUB UpdatePlayerObject:
        END IF
AddRadarObject GameObject(), RadarItem(), 0, TRUE
GOSUB GetObjectCoordz
AnimationDelay = AnimationDelay + 1
IF AnimationDelay = 2 THEN
        AnimateBitMaps GameObject()
        AnimationDelay = 0
        IF PitchManeuvre > 1 THEN PitchManeuvre = PitchManeuvre - 1
END IF
CSLine VARSEG(UPPERLAYER&(0)), 1, 0, 1, 199, 2
CSLine VARSEG(LOWERLAYER&(0)), 1, 0, 1, 199, 2
CSLine VARSEG(UPPERLAYER&(0)), 318, 0, 318, 199, 2
CSLine VARSEG(LOWERLAYER&(0)), 318, 0, 318, 199, 2
CSLine VARSEG(UPPERLAYER&(0)), 0, 0, 0, 199, 4
CSLine VARSEG(LOWERLAYER&(0)), 0, 0, 0, 199, 4
CSLine VARSEG(UPPERLAYER&(0)), 319, 0, 319, 199, 4
CSLine VARSEG(LOWERLAYER&(0)), 319, 0, 319, 199, 4

CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(0).StartPoint, InterFaceObject(0).BytesLong
CSMemCopyMMX VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), VARSEG(LOWERLAYER&(0)), VARPTR(LOWERLAYER&(0)) + 44800, 19200

IF DeathFlag = FALSE AND VictoryFlags = FALSE THEN

UpdatePanel UPPERLAYER&(), LOWERLAYER&(), XMSHandles(), XMSCache&(), InterFaceObject(), Weapon, Ammo(), Velo, GameObject(0).HitPoints
IF LongRangeRadarFlag = FALSE THEN
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(19).StartPoint, InterFaceObject(19).BytesLong
        CSSpriteF VARSEG(UPPERLAYER&(0)), 255, 0, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        Radar VARSEG(UPPERLAYER&(0)), VARSEG(RadarBlendMap(0))
        UpdateRadar RadarItem(), RadarBitMaps(), UPPERLAYER&()
        Compass UPPERLAYER&(), MissionPath(), CheckPoint(), GameObject(), InterFaceObject(), XMSHandles(), XMSCache&(), Sine!(), Cosine!()
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(93).StartPoint, InterFaceObject(93).BytesLong
        CSSprite VARSEG(UPPERLAYER&(0)), 2, 0, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        HorizonBall UPPERLAYER&(), Pitch, PlayerX&, PlayerY&, PlayerZ&, XMSCache2&()
ELSE
        LongRangeRadar GameObject(), UPPERLAYER&(), LOWERLAYER&(), RadarBlendMap(), RadarBitMaps(), Sine!(), Cosine!()
END IF
        IF MissionPath(0).Node = NODEBOSS THEN
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(45).StartPoint, InterFaceObject(45).BytesLong
        CSSpriteF VARSEG(LOWERLAYER&(0)), 2, 120, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        Length = (CSNG(GameObject(1).HitPoints) / CSNG(MaxBossLife)) * 280
        IF GameObject(1).HitPoints > 0 THEN BossEnergyBar VARSEG(LOWERLAYER&(0)), VARSEG(RadarBlendMap(0)), Length
        END IF
END IF
IF BigMessage <> FALSE THEN ShowMessage UPPERLAYER&(), XMSHandles(), XMSCache&(), InterFaceObject(), BigMessage
VideoPage = VideoPage + 1
ShowOffscreen VideoPage, UPPERLAYER&(), LOWERLAYER&()
IF VideoPage = 2 THEN VideoPage = 0

        IF CSKey(1) THEN
        IF GameObject(0).AIScript = STATICOBJECT AND GameObject(0).HitPoints > 0 THEN Saveable = TRUE ELSE Saveable = FALSE
        TempPal$ = SPACE$(768)
        CSGetPal TempPal$
        CSSetPal Pal$
        CSMoveToXMS VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0)), XMSHandles(GROUNDTEXTURE), 66000, 64000
        ReturnValue = SmallMenu(UPPERLAYER&(), LOWERLAYER&(), InterFaceObject(), XMSCache&(), XMSHandles(), VideoPage, Ammo(), LevelNum, Skill, Saveable)
        CSSetPal TempPal$
        TempPal$ = ""
                SELECT CASE ReturnValue
                CASE IS > 24
                SoundInterFace 5, 1, 100, 0, 0
                FadeToBlack
                LoadFlag = ReturnValue
                GOTO BigScaleRestart
                CASE 2
                FadeToBlack
                SoundInterFace 5, 1, 100, 0, 0
                GOTO Quit
                END SELECT
        END IF
       
IF DeathFlag = FALSE AND VictoryFlags = FALSE THEN
        IF CSKey(&H1E) THEN
        Velo = Velo + 1
        IF Velo = 11 THEN Velo = 10
        END IF
        IF CSKey(&H2C) THEN
        Velo = Velo - 1
        IF Velo = 0 THEN Velo = 1
        END IF
       
        SteeredFighterHorizontally = FALSE
        SteeredFighterVertically = FALSE
        IF CSKey(&H4B) THEN
                Heading = Heading - Maneuvre
                IF Maneuvre < 16 THEN Maneuvre = Maneuvre + 4
                IF Heading < 0 THEN Heading = Heading + 1280
                IF Roll < 32 THEN Roll = Roll + 4
                SteeredFighterHorizontally = TRUE
                IF StarFlag = TRUE THEN ScrollStarField Stars(), LEFTWARDS, Maneuvre \ 2
                
        END IF
        IF CSKey(&H4D) THEN
                Heading = Heading + Maneuvre
                IF Maneuvre < 16 THEN Maneuvre = Maneuvre + 4
                IF Heading >= 1280 THEN Heading = 0
                IF Roll > -32 THEN Roll = Roll - 4
                SteeredFighterHorizontally = TRUE
                IF StarFlag = TRUE THEN ScrollStarField Stars(), RIGHTWARDS, Maneuvre \ 2
                
        END IF
        IF CSKey(&H48) THEN
                IF PitchManeuvre < 4 THEN PitchManeuvre = PitchManeuvre + 1
                IF Pitch < 36 THEN Pitch = Pitch + PitchManeuvre
                SteeredFighterVertically = TRUE
                
        END IF
        IF CSKey(&H50) AND PivotY& < 200000 THEN
                IF PitchManeuvre < 4 THEN PitchManeuvre = PitchManeuvre + 1
                IF Pitch > -36 THEN Pitch = Pitch - PitchManeuvre
                SteeredFighterVertically = TRUE
                
        END IF
        IF CSKey(KEYSPACE) THEN GOSUB Shoot

        IF CSKey(&H2) THEN Weapon = PULSELASER
        IF CSKey(&H3) AND Ammo(1) > 0 THEN Weapon = ION
        IF CSKey(&H4) AND Ammo(2) > 0 THEN Weapon = TLA
        IF CSKey(&H5) AND Ammo(3) > 0 THEN Weapon = PLASMA
        IF CSKey(&H6) AND Ammo(4) > 0 THEN Weapon = MISSILE
        IF CSKey(&H7) AND Ammo(5) > 0 THEN Weapon = SEEKMISSILE
        IF CSKey(&H8) AND Ammo(6) > 0 THEN Weapon = ACM
        IF CSKey(&HF) AND SecondTick = TRUE THEN
                IF LongRangeRadarFlag = FALSE THEN LongRangeRadarFlag = TRUE ELSE LongRangeRadarFlag = FALSE
                SecondTick = FALSE
        END IF
        IF CSKey(&H53) AND (Padlock > -480) AND RecoverCamera = FALSE THEN
                Padlock = Padlock - 16
                IF StarFlag = TRUE THEN ScrollStarField Stars(), LEFTWARDS, 8
        END IF
        IF CSKey(&H4F) AND (Padlock < 480) AND RecoverCamera = FALSE THEN
                Padlock = Padlock + 16
                IF StarFlag = TRUE THEN ScrollStarField Stars(), RIGHTWARDS, 8
        END IF
        IF CSKey(&H47) AND RecoverCamera = FALSE AND Padlock <> 0 THEN RecoverCamera = TRUE
        IF CSKey(&H19) THEN
                CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(46).StartPoint, InterFaceObject(46).BytesLong
                Xlen = CSPeek16(VARSEG(XMSCache&(0)), 0) \ 16
                Xpos = 160 - Xlen
                CSSprite VARSEG(UPPERLAYER&(0)), Xpos, 160, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
                VideoPage = VideoPage + 1
                ShowOffscreen VideoPage, UPPERLAYER&(), LOWERLAYER&()
                IF VideoPage = 2 THEN VideoPage = 0
                FOR index = 0 TO 12: CSWaitTimer 0: NEXT
                CSWaitKey ANYKEY
        END IF
END IF
IF VictoryFlags = FALSE THEN CheckTargets MissionPath(), GameObject(), BigMessage, BigMessageTime

IF CSElapsedTicks&(0) = 0 THEN CSWaitTimer 0
IF CSElapsedTicks&(1) >= 1 THEN GOSUB OneSecondTimerChunk
IF LevelNum = 6 AND DeathFlag = FALSE AND VictoryFlags = FALSE THEN Glow
IF Maneuvre > 2 THEN Maneuvre = Maneuvre - 1
LOOP

GetObjectCoordz:
VisibleObjects = 0
       
        CameraVector(0).X = SIN((CameraHeading * .28125) * (3.141592 / 180)) * 4096
        CameraVector(0).Y = 0
        CameraVector(0).Z = COS((CameraHeading * .28125) * (3.141592 / 180)) * 4096
       
FOR index = 0 TO 379

IF GameObject(index).ObjectType > 0 THEN
objectx& = GameObject(index).X + 200000000
objectz& = GameObject(index).Z + 200000000
xcomp& = objectx& - (eyex& + 200000000)
zcomp& = objectz& - (eyez& + 200000000)

IF (ABS(xcomp&) < 40000 AND ABS(zcomp&) < 40000) AND (ABS(xcomp&) > 768 OR ABS(zcomp&) > 768) THEN
AddRadarObject GameObject(), RadarItem(), index, FALSE
        LocationVector(0).X = xcomp&
        LocationVector(0).Y = 0
        LocationVector(0).Z = zcomp&
        DotProduct1! = CSVectorDot!(VARSEG(LocationVector(0).X), VARPTR(LocationVector(0).X), VARSEG(LocationVector(0).X), VARPTR(LocationVector(0).X))
        DotProduct2! = CSVectorDot!(VARSEG(CameraVector(0).X), VARPTR(CameraVector(0).X), VARSEG(CameraVector(0).X), VARPTR(CameraVector(0).X))
        DotProduct3! = CSVectorDot!(VARSEG(CameraVector(0).X), VARPTR(CameraVector(0).X), VARSEG(LocationVector(0).X), VARPTR(LocationVector(0).X))
        Length1! = SQR(DotProduct1!)
        IF Length1! = 0 THEN GOTO IgnoreThisVisible
        Length2! = SQR(DotProduct2!)
        VectorCosine! = -(DotProduct3! / (Length1! * Length2!))
        ZCatLen! = (Length1! * VectorCosine!) ^ 2
        XCatLen! = SQR(DotProduct1! - ZCatLen!)
        VectorSine! = ABS(XCatLen! / Length1!)

        IF VectorCosine! > .1 THEN
               
        angle1% = ArcTangent%(zcomp&, xcomp&)
        headfac% = ABS(CameraHeading% - 960)
        IF CameraHeading% > 960 THEN head% = CameraHeading% - (960 + headfac% * 2)
        IF CameraHeading% <= 960 THEN head% = CameraHeading% - (960 - headfac% * 2)
        ObjectXZangle = angle1% - head%
        IF ObjectXZangle >= 1070 THEN ObjectXZangle = (ObjectXZangle - 1280) MOD 1280
        IF ObjectXZangle = 0 THEN
                VectorSine! = 0
        ELSEIF ObjectXZangle < 0 THEN
                VectorSine! = -VectorSine!
        END IF
        'IF ObjectXZangle < -300 OR ObjectXZangle > 300 THEN GOTO IgnoreThisVisible
        
        VisibleGameObject(VisibleObjects).ObjectType = GameObject(index).ObjectType
        VisibleGameObject(VisibleObjects).ObjectDrawClass = GameObject(index).ObjectDrawClass
        VisibleGameObject(VisibleObjects).Scale = GameObject(index).Scale
        IF GameObject(index).ObjectType < 192 THEN IF ShadowHook(GameObject(index).ObjectType) > 0 THEN VisibleGameObject(index).Scale = GetGroundY(XMSCache2&(), GameObject(index).X, GameObject(index).Z)
        LocationVector(0).X = xcomp&
        LocationVector(0).Y = GameObject(index).Y - Altitude&
        LocationVector(0).Z = zcomp&
        DotProduct1! = CSVectorDot!(VARSEG(LocationVector(0).X), VARPTR(LocationVector(0).X), VARSEG(LocationVector(0).X), VARPTR(LocationVector(0).X))
        Dist! = SQR(DotProduct1!)
        IF GameObject(index).ExtraFlag8 = BUILDING THEN Dist! = Dist! - 2000
        IF Dist! < 0 THEN Dist! = 0
        VisibleGameObject(VisibleObjects).Distance = (CINT(Dist! / 2))
                Xtranslate& = -CLNG((Length1! * VectorSine!) / ScaleDivideX! * (VectorCosine! ^ -1))
                Ytranslate = CINT((GameObject(index).Y - Altitude&) / CSNG(ScaleDivideY))
                Ztranslate& = CLNG(((Length1! * VectorCosine!) / ScaleDivideZ!) * (VectorCosine! ^ -1))
                xrotAngle = (GameObject(index).HeadY + 360) MOD 360
                yRotAngle = CINT(CSNG(GameObject(index).HeadXZ - CameraHeading) / 3.555556)' + CSNG(ObjectXZangle%) * .140625)
                yRotAngle = (yRotAngle + 360) MOD 360
                IF yRotAngle < 0 THEN yRotAngle = yRotAngle + 360
        VisibleGameObject(VisibleObjects).LockedFlag = 0
        VisibleGameObject(VisibleObjects).Xangle = xrotAngle
        VisibleGameObject(VisibleObjects).Yangle = yRotAngle
        VisibleGameObject(VisibleObjects).Zangle = GameObject(index).Tilt
        VisibleGameObject(VisibleObjects).Xtrans = Xtranslate&
        VisibleGameObject(VisibleObjects).Ytrans = Ytranslate
        VisibleGameObject(VisibleObjects).Ztrans = Ztranslate&
        VisibleObjects = VisibleObjects + 1
        END IF

END IF
IgnoreThisVisible:
        SELECT CASE GameObject(index).AIScript
        CASE PROJECTILE
                MoveProjectile index, GameObject(), EnemyDrop(), XMSCache2&(), MovSinTab(), MovCosTab(), AltSinTab()
        CASE FIGHTER
                MoveFighter index, GameObject(), XMSCache2&(), MovSinTab(), MovCosTab(), AltSinTab()
        CASE FLAKCANNON
                FlakAI GameObject(), index, MovSinTab(), MovCosTab(), XMSCache2&()
        CASE PARTICLE
                SmallParticle GameObject(), index, MovSinTab(), MovCosTab(), AltSinTab()
        CASE EXPLOSION
                BigExplosion GameObject(), index
        CASE DEATHSPIN
                SpinningDown GameObject(), index, XMSCache2&(), MovSinTab(), MovCosTab(), AltSinTab()
        CASE SEEKMISSILE
                MoveSeeker index, GameObject(), EnemyDrop(), XMSCache2&(), MovSinTab(), MovCosTab(), AltSinTab()
        CASE VICTORYDANCE
                VictoryFlight GameObject()
        CASE HELICOPTER
                HelicopterAI GameObject(), index, MovSinTab(), MovCosTab(), XMSCache2&()
        CASE TRANSPORT
                TransportAI GameObject(), index, MovSinTab(), MovCosTab(), XMSCache2&()
        CASE VOLCANO
                VolcanoAI GameObject(), index
        END SELECT

END IF
NEXT
               
        IF VisibleObjects > 1 THEN SortObjects VARSEG(VisibleGameObject(0).Distance), VisibleObjects
       
        FOR RenderIndex = 0 TO VisibleObjects - 1
        
        xrotAngle = VisibleGameObject(RenderIndex).Xangle
        yRotAngle = VisibleGameObject(RenderIndex).Yangle
        zRotAngle = VisibleGameObject(RenderIndex).Zangle
        Xtranslate& = VisibleGameObject(RenderIndex).Xtrans
        Ytranslate = VisibleGameObject(RenderIndex).Ytrans
        Ztranslate& = VisibleGameObject(RenderIndex).Ztrans

        IF VisibleGameObject(RenderIndex).ObjectDrawClass = POLYGONAL THEN
       
        IF VisibleGameObject(RenderIndex).ObjectType = 1 AND GameObject(0).HitPoints > 0 AND VictoryFlags = FALSE THEN GOSUB DrawCrossHair
       
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(TEXTURES), TextureTable&(VisibleGameObject(RenderIndex).ObjectType - 1), 16400
        Start& = ObjectPrime(VisibleGameObject(RenderIndex).ObjectType - 1).StartPoint
        Length& = ObjectPrime(VisibleGameObject(RenderIndex).ObjectType - 1).BytesLong
        CSMoveFromXMS VARSEG(PolyCount(0)), VARPTR(PolyCount(0)), XMSHandles(OBJECTMESHES), Start&, 2
        CSMoveFromXMS VARSEG(ObjectMesh(0).X1), VARPTR(ObjectMesh(0).X1), XMSHandles(OBJECTMESHES), Start& + 2, Length& - 2
       
        IF Ztranslate& > 10500 THEN Fogged = TRUE ELSE Fogged = FALSE
        Render3DObject Xtranslate&, Ytranslate, Ztranslate&, xrotAngle, yRotAngle, zRotAngle, PolyCount(0), ObjectMesh(), VisibleObjectMesh(), Fogged, XMSCache&(), TransBlendMap(), Sine!(), Cosine!(), UPPERLAYER&(), LOWERLAYER&()
       
                IF ShadowHook(VisibleGameObject(RenderIndex).ObjectType) > 0 AND ShadowsOn = TRUE THEN
                Start& = ShadowPrime(ShadowHook(VisibleGameObject(RenderIndex).ObjectType) - 1).StartPoint
                Length& = ShadowPrime(ShadowHook(VisibleGameObject(RenderIndex).ObjectType) - 1).BytesLong
                CSMoveFromXMS VARSEG(PolyCount(0)), VARPTR(PolyCount(0)), XMSHandles(SHADOWS), Start&, 2
                CSMoveFromXMS VARSEG(ObjectMesh(0).X1), VARPTR(ObjectMesh(0).X1), XMSHandles(SHADOWS), Start& + 2, Length& - 2
                Ytranslate = (VisibleGameObject(RenderIndex).Scale - Altitude&) \ ScaleDivideY
                RenderShadow Xtranslate&, Ytranslate, Ztranslate&, yRotAngle, PolyCount(0), ObjectMesh(), VisibleObjectMesh(), Sine!(), Cosine!(), ShadowBlendMap(), LOWERLAYER&()
                END IF

        ELSE
        BmpHook& = (VisibleGameObject(RenderIndex).ObjectType - 192) * 16388&
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(BITMAPS), BmpHook&, 16388
        GOSUB RenderBitMap
        END IF
        NEXT

RETURN

RenderBitMap:
        BitMapLocation(0).X = 0
        BitMapLocation(0).Y = 0
        BitMapLocation(0).Z = 0
        IF VisibleGameObject(RenderIndex).Scale = QUARTERSIZE THEN
                ScaleMul! = .5
        ELSEIF VisibleGameObject(RenderIndex).Scale = QUADSIZE THEN
                ScaleMul! = 4
        ELSEIF VisibleGameObject(RenderIndex).Scale = DOUBLESIZE THEN
                ScaleMul! = 2
        ELSEIF VisibleGameObject(RenderIndex).Scale = OCTASIZE THEN
                ScaleMul! = 7
        ELSE
                ScaleMul! = 1
        END IF
        BitMapScaleVector(0).X = -32 * ScaleMul!
        BitMapScaleVector(0).Y = 32 * ScaleMul!
        BitMapScaleVector(0).Z = 0
        BitMapScaleVector(1).X = 32 * ScaleMul!
        BitMapScaleVector(1).Y = -32 * ScaleMul!
        BitMapScaleVector(1).Z = 0
        BitMapScaleVector(2).X = -32 * ScaleMul!
        BitMapScaleVector(2).Y = -32 * ScaleMul!
        BitMapScaleVector(2).Z = 0
        CSIdentityMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0))
        CSInitTransMatrix VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0)), Xtranslate&, Ytranslate / 2, Ztranslate&
        CSMatrixMulMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0))
        CSVectorMulMatrix VARSEG(BitMapScaleVector(0).X), VARPTR(BitMapScaleVector(0).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(TranslatedBitMapScale(0).X), VARPTR(TranslatedBitMapScale(0).X)
        CSVectorMulMatrix VARSEG(BitMapScaleVector(1).X), VARPTR(BitMapScaleVector(1).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(TranslatedBitMapScale(1).X), VARPTR(TranslatedBitMapScale(1).X)
        CSVectorMulMatrix VARSEG(BitMapScaleVector(2).X), VARPTR(BitMapScaleVector(2).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(TranslatedBitMapScale(2).X), VARPTR(TranslatedBitMapScale(2).X)
        CSVectorMulMatrix VARSEG(BitMapLocation(0).X), VARPTR(BitMapLocation(0).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(BitMapTranslated(0).X), VARPTR(BitMapTranslated(0).X)
        CSProjectVector VARSEG(TranslatedBitMapScale(0).X), VARPTR(TranslatedBitMapScale(0).X), VARSEG(BitMapCorners(0).X), VARPTR(BitMapCorners(0).X), ZEye
        CSProjectVector VARSEG(TranslatedBitMapScale(1).X), VARPTR(TranslatedBitMapScale(1).X), VARSEG(BitMapCorners(1).X), VARPTR(BitMapCorners(1).X), ZEye
        CSProjectVector VARSEG(TranslatedBitMapScale(2).X), VARPTR(TranslatedBitMapScale(2).X), VARSEG(BitMapCorners(2).X), VARPTR(BitMapCorners(2).X), ZEye
        CSProjectVector VARSEG(BitMapTranslated(0).X), VARPTR(BitMapTranslated(0).X), VARSEG(BitMapCenter(0).X), VARPTR(BitMapCenter(0).X), ZEye
        BitMapCenter(0).Y = BitMapCenter(0).Y * 2
        BitMapCorners(0).Y = BitMapCorners(0).Y * 2
        BitMapCorners(1).Y = BitMapCorners(1).Y * 2
        BitMapCorners(2).Y = BitMapCorners(2).Y * 2
        XSize = CINT(ABS(BitMapCorners(1).X - BitMapCorners(0).X))
        YSize = CINT(ABS(BitMapCorners(2).Y - BitMapCorners(0).Y))
        xpoint = BitMapCenter(0).X - CINT(CSNG(XSize) / 2)
        ypoint = BitMapCenter(0).Y - CINT(CSNG(YSize) / 2)
               
        IF ypoint + YSize < 200 THEN
        CSSpriteS VARSEG(UPPERLAYER&(0)), xpoint, ypoint, XSize, YSize, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        ELSEIF ypoint >= 200 THEN
        CSSpriteS VARSEG(LOWERLAYER&(0)), xpoint, ypoint - 200, XSize, YSize, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        ELSE
        CSSpriteS VARSEG(UPPERLAYER&(0)), xpoint, ypoint, XSize, YSize, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        CSSpriteS VARSEG(LOWERLAYER&(0)), xpoint, ypoint - 200, XSize, YSize, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        END IF
RETURN

DrawCrossHair:
        CrossHairCoords GameObject(0).X, GameObject(0).Y, GameObject(0).Z, objectx&, objecty&, objectz&, Heading, Pitch, XMSCache2&(), MovSinTab(), MovCosTab(), AltSinTab()
        xcomp& = objectx& - eyex&
        zcomp& = objectz& - eyez&
              LocationVector(0).X = xcomp&
              LocationVector(0).Y = 0
              LocationVector(0).Z = zcomp&
              CameraVector(0).X = SinTab(CameraHeading) * 16
              CameraVector(0).Y = 0
              CameraVector(0).Z = CosTab(CameraHeading) * 16
        DotProduct1! = CSVectorDot!(VARSEG(LocationVector(0).X), VARPTR(LocationVector(0).X), VARSEG(LocationVector(0).X), VARPTR(LocationVector(0).X))
        DotProduct2! = CSVectorDot!(VARSEG(CameraVector(0).X), VARPTR(CameraVector(0).X), VARSEG(CameraVector(0).X), VARPTR(CameraVector(0).X))
        DotProduct3! = CSVectorDot!(VARSEG(CameraVector(0).X), VARPTR(CameraVector(0).X), VARSEG(LocationVector(0).X), VARPTR(LocationVector(0).X))
        Length1! = SQR(DotProduct1!)
        Length2! = SQR(DotProduct2!)
        VectorCosine! = -(DotProduct3! / (Length1! * Length2!))
        angle1% = ArcTangent%(zcomp&, xcomp&)
        headfac% = ABS(CameraHeading% - 960)
        IF CameraHeading > 960 THEN head% = CameraHeading - (960 + (headfac% + headfac%))
        IF CameraHeading <= 960 THEN head% = CameraHeading - (960 - (headfac% + headfac%))
        ObjectXZangle% = angle1% - head%
        IF ObjectXZangle% > 1152 THEN ObjectXZangle% = ObjectXZangle% - 1280
               
        Xtrans2 = ObjectXZangle% * -1
        Ytrans2 = (objecty& - Altitude&) \ ScaleDivideY
        Ztrans2 = CINT((Length1! * VectorCosine!) / ScaleDivideZ!)
               
        ObjectFaceVector(0).X = 0
        ObjectFaceVector(0).Y = 0
        ObjectFaceVector(0).Z = 0
        CSIdentityMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0))
        CSInitTransMatrix VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0)), 0, Ytrans2 / 2, Ztrans2
        CSMatrixMulMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0))
        CSVectorMulMatrix VARSEG(ObjectFaceVector(0).X), VARPTR(ObjectFaceVector(0).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(0).X), VARPTR(ObjectPolyFaces(0).X)
        CSProjectVector VARSEG(ObjectPolyFaces(0).X), VARPTR(ObjectPolyFaces(0).X), VARSEG(ObjectPolyScreenCoords(0).X), VARPTR(ObjectPolyScreenCoords(0).X), ZEye

        xpoint = ObjectPolyScreenCoords(0).X + Xtrans2
        ypoint = ObjectPolyScreenCoords(0).Y * 2
        CSTriF VARSEG(UPPERLAYER&(0)), xpoint, ypoint - 1, xpoint - 2, ypoint - 5, xpoint + 2, ypoint - 5, CrossHairColor
        CSTriF VARSEG(UPPERLAYER&(0)), xpoint, ypoint + 1, xpoint - 2, ypoint + 5, xpoint + 2, ypoint + 5, CrossHairColor
        CSTriF VARSEG(UPPERLAYER&(0)), xpoint - 1, ypoint, xpoint - 5, ypoint - 2, xpoint - 5, ypoint + 2, CrossHairColor
        CSTriF VARSEG(UPPERLAYER&(0)), xpoint + 1, ypoint, xpoint + 5, ypoint - 2, xpoint + 5, ypoint + 2, CrossHairColor
        ypoint = ypoint - 200
        CSTriF VARSEG(LOWERLAYER&(0)), xpoint, ypoint - 1, xpoint - 2, ypoint - 5, xpoint + 2, ypoint - 5, CrossHairColor
        CSTriF VARSEG(LOWERLAYER&(0)), xpoint, ypoint + 1, xpoint - 2, ypoint + 5, xpoint + 2, ypoint + 5, CrossHairColor
        CSTriF VARSEG(LOWERLAYER&(0)), xpoint - 1, ypoint, xpoint - 5, ypoint - 2, xpoint - 5, ypoint + 2, CrossHairColor
        CSTriF VARSEG(LOWERLAYER&(0)), xpoint + 1, ypoint, xpoint + 5, ypoint - 2, xpoint + 5, ypoint + 2, CrossHairColor
RETURN

Shoot:
        IF (Weapon = PULSELASER) OR (Weapon = ION) OR (Weapon = TLA) OR (Weapon = PLASMA) THEN
                IF GunsDelay < 6 THEN RETURN
                GunsDelay = 0
        ELSE
                IF MissilesDelay < 16 THEN RETURN
                MissilesDelay = 0
        END IF
SELECT CASE Weapon
CASE ACM
        IF FireACM(GameObject(), MissionPath()) = -1 THEN GOSUB FireSeekerToLocked
CASE SEEKMISSILE
        GOSUB FireSeekerToLocked
CASE ELSE
        X& = GameObject(0).X
        Y& = GameObject(0).Y
        Z& = GameObject(0).Z
        FireProjectile GameObject(), X&, Y&, Z&, Weapon, Heading, Pitch, 0, Roll, PLAYERSHOT
END SELECT
AmmoTag = GetAmmoTag(Weapon)
IF Ammo(AmmoTag) > 0 THEN Ammo(AmmoTag) = Ammo(AmmoTag) - 1
IF Ammo(AmmoTag) = 0 THEN Weapon = PULSELASER
IF Ammo(AmmoTag) < 0 THEN Ammo(AmmoTag) = -1
RETURN

FireSeekerToLocked:
Destination = ChooseSeekerTarget(GameObject())
        IF Destination = -1 THEN
                X& = GameObject(0).X
                Y& = GameObject(0).Y
                Z& = GameObject(0).Z
                FireProjectile GameObject(), X&, Y&, Z&, MISSILE, Heading, Pitch, 0, Roll, PLAYERSHOT
        ELSE
                FireSeeker GameObject(), Destination
        END IF
RETURN

MoveFighter:
IF GameObject(0).AIScript = STATICOBJECT OR GameObject(0).AIScript = VICTORYDANCE THEN
        IF VictoryFlags = TRUE THEN
        Pitch = -8 + GameObject(0).HeadY
        GameObject(0).X = PlayerX&
        GameObject(0).Z = PlayerZ&
        GameObject(0).Y = PlayerY&
        VictoryPaletteTransDelay = VictoryPaletteTransDelay + 1
        IF VictoryPaletteTransDelay = 4 THEN VictoryPaletteTransDelay = 0: CSFadeToStep 0, 255, 60, 54, 54
        END IF
PivotX& = PivotX& - CLNG(SIN((Heading * .28125) * (3.141592 / 180)) * (16 * Velo))
PivotZ& = PivotZ& - CLNG(COS((Heading * .28125) * (3.141592 / 180)) * (16 * Velo))
xfrag& = (eyex& + 6553600) \ 65536
zfrag& = (eyez& + 6553600) \ 65536
xx& = (eyex& + 6553600) - xfrag& * 65536
zz& = (eyez& + 6553600) - zfrag& * 65536
IF PivotX& > 6552600 THEN PivotX& = PivotX& - 13105200
IF PivotX& < -6552600 THEN PivotX& = PivotX& + 13105200
IF PivotZ& > 6552600 THEN PivotZ& = PivotZ& - 13105200
IF PivotZ& < -6552600 THEN PivotZ& = PivotZ& + 13105200

PivotY& = PivotY& - AltSinTab(Pitch + 90) * Velo

PlayerY& = PivotY& - 1024
PlayerX& = PivotX& + CLNG(SIN((Heading * .28125) * (3.141592 / 180)) * 512)
PlayerZ& = PivotZ& + CLNG(COS((Heading * .28125) * (3.141592 / 180)) * 512)
CameraHeading = Heading + Padlock
IF CameraHeading >= 1280 THEN
        CameraHeading = CameraHeading - 1280
ELSEIF CameraHeading < 0 THEN
        CameraHeading = CameraHeading + 1280
END IF
        IF VictoryFlags = TRUE THEN
        VictoryCameraAdd = VictoryCameraAdd + 16
        IF VictoryCameraAdd > 1279 THEN VictoryCameraAdd = VictoryCameraAdd - 1280
        CameraHeading = CameraHeading + VictoryCameraAdd
                IF CameraHeading >= 1280 THEN
                CameraHeading = CameraHeading - 1280
                ELSEIF CameraHeading < 0 THEN
                CameraHeading = CameraHeading + 1280
                END IF
        END IF

TgtHeading = (CameraHeading + 1280) MOD 1280
IF TgtHeading > 1279 THEN TgtHeading = TgtHeading - 1280
IF TgtHeading < 0 THEN TgtHeading = TgtHeading + 1280
       IF PlayerY& < 8976 THEN AddDist = (8976 - PlayerY&) / 16 ELSE AddDist = 0
       AddSine& = CLNG((SIN((TgtHeading * .28125) * (3.141592 / 180)) * (256 * (10 + StartAddition))) + (SIN((TgtHeading * .28125) * (3.141592 / 180)) * (16 * AddDist)))
       AddCosine& = CLNG((COS((TgtHeading * .28125) * (3.141592 / 180)) * (256 * (10 + StartAddition))) + (COS((TgtHeading * .28125) * (3.141592 / 180)) * (16 * AddDist)))
       eyex& = PivotX& + AddSine&'(((SinTab(TgtHeading)) * (10 + StartAddition)) + (MovSinTab(TgtHeading) * AddDist))
       eyez& = PivotZ& + AddCosine&'(((CosTab(TgtHeading)) * (10 + StartAddition)) + (MovCosTab(TgtHeading) * AddDist))
       IF PlayerY& > 8976 THEN Altitude& = PlayerY& + 1024 ELSE Altitude& = 10000

GroundLevel = GetGroundY(XMSCache2&(), PlayerX&, PlayerZ&)
IF PivotY& > 200000 THEN PivotY& = 200000: Pitch = Pitch + 4
IF PlayerY& <= GroundLevel + 256 THEN
Pitch = -36: PlayerY& = PlayerY& + 512
GameObject(0).HitPoints = GameObject(0).HitPoints - 8
IF GameObject(0).HitPoints < 0 THEN GameObject(0).HitPoints = 0
ShowHitSpark GameObject(), PlayerX&, PlayerZ&, CLNG(PlayerY&), 6
END IF

END IF
IF SteeredFighterHorizontally = FALSE THEN
        Roll = Roll - (SGN(Roll) * 2)
END IF
              
        IF RecoverCamera = TRUE THEN
        Padlock = Padlock - (SGN(Padlock) * 8)
        IF Padlock = 0 THEN RecoverCamera = FALSE
        IF StarFlag = TRUE THEN
                IF SGN(Padlock) = -1 THEN ScrollStarField Stars(), LEFTWARDS, 5
                IF SGN(Padlock) = 1 THEN ScrollStarField Stars(), RIGHTWARDS, 5
        END IF
        END IF
        IF StartAddition > 0 THEN StartAddition = StartAddition - 1
        IF SkyTexture = TRUE AND StarFlag = FALSE THEN FlyHigh GameObject(0).Y, CurrentPalette, Pal$
RETURN
       
UpdatePlayerObject:
        yRotAngle = Heading
        xrotAngle = -14 + Pitch
        IF yRotAngle < 0 THEN yRotAngle = yRotAngle + 1280
        IF yRotAngle > 1279 THEN yRotAngle = yRotAngle - 1280
        zRotAngle = Roll
        IF zRotAngle < 0 THEN zRotAngle = zRotAngle + 360
        GameObject(0).X = PlayerX&
        GameObject(0).Z = PlayerZ&
        GameObject(0).Y = PlayerY&
        GameObject(0).Velocity = Velo
        GameObject(0).ObjectDrawClass = POLYGONAL
        GameObject(0).Scale = FULLSCALE
        GameObject(0).Xsiz = 768
        GameObject(0).Ysiz = 540
        GameObject(0).Zsiz = 768
        GameObject(0).HeadXZ = yRotAngle
        GameObject(0).HeadY = xrotAngle
        GameObject(0).Tilt = zRotAngle
        IF GameObject(0).ExtraFlag5 > 0 THEN GameObject(0).ExtraFlag5 = GameObject(0).ExtraFlag5 - 1
        IF GameObject(0).ExtraFlag5 MOD 2 = 0 THEN GameObject(0).ObjectType = 1 ELSE GameObject(0).ObjectType = 0
RETURN

OneSecondTimerChunk:
SecondTick = TRUE
IF BigMessage <> FALSE THEN
        BigMessageTime = BigMessageTime + 1
        IF BigMessageTime >= 3 THEN BigMessage = FALSE: BigMessageTime = 0
END IF
CSResetTicks 1
IF RandomPercentage < EnemyPossibility THEN
        IF TotalActiveEnemies(GameObject()) < MaxEnemies THEN
        Chunk = GetFreeObject(GameObject())
        IF Chunk > -1 THEN
        AddFighter Chunk, GameObject(), GameObject(0).X, GameObject(0).Y, GameObject(0).Z, EnemyFighter()
        END IF
        END IF
END IF
RETURN

Death:
FadeToBlack
GOTO StartOver:

Victory:
SoundInterFace 5, 1, 100, 0, 0
FadeToBlack
LevelNum = LevelNum + 1

FileHandle = FREEFILE
OPEN "player.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
PUT FileHandle, , LevelNum
PUT FileHandle, , Skill
PUT FileHandle, , Ammo(0)
PUT FileHandle, , Ammo(1)
PUT FileHandle, , Ammo(2)
PUT FileHandle, , Ammo(3)
PUT FileHandle, , Ammo(4)
PUT FileHandle, , Ammo(5)
PUT FileHandle, , Ammo(6)
CLOSE FileHandle

CSRemoveKeyBoard
CSRemoveTimer
CSDeallocateXMS XMSHandles(OBJECTMESHES)
CSDeallocateXMS XMSHandles(BITMAPS)
CSDeallocateXMS XMSHandles(TEXTURES)
CSDeallocateXMS XMSHandles(GROUNDTEXTURE)
CSDeallocateXMS XMSHandles(INTERFACE)
CSDeallocateXMS XMSHandles(SHADOWS)

IF LevelNum < 9 THEN
        RUN "scapez03.xbn"
ELSE
        RUN "scapez05.xbn"
END IF

Quit:
CSRemoveKeyBoard
CSRemoveTimer
CSDeallocateXMS XMSHandles(OBJECTMESHES)
CSDeallocateXMS XMSHandles(BITMAPS)
CSDeallocateXMS XMSHandles(TEXTURES)
CSDeallocateXMS XMSHandles(GROUNDTEXTURE)
CSDeallocateXMS XMSHandles(INTERFACE)
CSDeallocateXMS XMSHandles(SHADOWS)
RUN "scapez02.xbn"

ErrorTrap:
CSClose
SoundInterFace 1, 0, 0, 0, 0
CSDeallocateXMS XMSHandles(OBJECTMESHES)
CSDeallocateXMS XMSHandles(BITMAPS)
CSDeallocateXMS XMSHandles(TEXTURES)
CSDeallocateXMS XMSHandles(GROUNDTEXTURE)
CSDeallocateXMS XMSHandles(INTERFACE)
CSDeallocateXMS XMSHandles(SHADOWS)
PRINT "Abnormal Program Termination!"
IF ERR = 7 OR ERR = 14 THEN PRINT "Out of memory!"
DO: LOOP UNTIL INKEY$ = CHR$(27)
END

