DECLARE SUB ShadowedTextW (UPPERLAYER&(), LOWERLAYER&(), x%, y%, TextString$)
DECLARE SUB Update (UPPERLAYER&(), LOWERLAYER&(), VideoPage%)
DECLARE SUB ShadowedText (UPPERLAYER&(), LOWERLAYER&(), x%, y%, TextString$)
DECLARE SUB BlitBackGround (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, ImageNumber%)
DECLARE SUB DrawWindow (UPPERLAYER&(), LOWERLAYER&(), x1%, y1%, x2%, y2%)
DECLARE SUB PrintMenuText (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, TextX%, TextY%, TextBitMap%, Active%)
DECLARE SUB BackGroundGraphics (UPPERLAYER&(), LOWERLAYER&(), XMSHandle%, XMSCache&(), MenuImage() AS ANY)
DECLARE SUB ShowOffscreen (VideoPage%, UPPERLAYER&(), LOWERLAYER&())

DECLARE SUB ShadeRectangle CDECL ALIAS "_shade_rectangle" (BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL hiview%, BYVAL loview%)
DECLARE SUB Darken CDECL (BYVAL hiview%, BYVAL loview%)

DECLARE SUB CSGet (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL Segment%, BYVAL offset&)

'$DYNAMIC
'$INCLUDE: 'slivedcx.bi'
'$INCLUDE: 'modexlib.bi'
DEFINT A-Z
CONST TRUE = 1
CONST FALSE = 0
TYPE MenuBitMap
        StartPoint AS LONG
        BytesLong AS LONG
END TYPE

REM $STATIC
SUB BackGroundGraphics (UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage() AS MenuBitMap)
BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 1
Darken VARSEG(UPPERLAYER&(0)), VARSEG(LOWERLAYER&(0))
END SUB

SUB BlackPalette
FOR index = 0 TO 255
        CSSetCol index, 0, 0, 0
NEXT
END SUB

SUB BlitBackGround (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage() AS MenuBitMap, ImageNumber)
Position& = CLNG(ImageNumber - 1) * 128000
Position& = Position& + MenuImage(0).StartPoint
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandle, Position&, 64000
CSPcopyMMX VARSEG(XMSCache&(0)), VARSEG(UPPERLAYER&(0))
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandle, Position& + 64000, 64000
CSPcopyMMX VARSEG(XMSCache&(0)), VARSEG(LOWERLAYER&(0))
END SUB

SUB Disk2XMS (File$, Handle%)
FileHandle = FREEFILE
OPEN File$ FOR BINARY AS FileHandle
  Bytes& = LOF(FileHandle)
  Tmp = Bytes& / 1024
  Times% = FIX(Tmp) - 1
  restof% = Bytes& MOD 1024
  Tmp$ = SPACE$(1024)
  DIM tempvar(512)

FOR i& = 0 TO Times%
  tmpoffs& = (i& * 1024)
  GET FileHandle, , Tmp$
  CSMemCopy VARSEG(Tmp$), SADD(Tmp$), VARSEG(tempvar(0)), VARPTR(tempvar(0)), 1024
  CSMoveToXMS VARSEG(tempvar(0)), VARPTR(tempvar(0)), Handle%, tmpoffs&, 1024
NEXT i&

IF NOT restof% = 0 THEN
  Tmp$ = SPACE$(restof%)
  tmpoffs& = (i& * 1024)
  GET FileHandle, , Tmp$
  CSMemCopy VARSEG(Tmp$), SADD(Tmp$), VARSEG(tempvar(0)), VARPTR(tempvar(0)), restof%
  CSMoveToXMS VARSEG(tempvar(0)), VARPTR(tempvar(0)), Handle%, tmpoffs&, restof%
END IF
CLOSE FileHandle
END SUB

SUB DisplayGraphicsMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage() AS MenuBitMap, CursorPosition, AntiAlias, SkyTexture, ShadowsOn, MenuFlip)

REDIM Active(4)
        Active(0) = FALSE
        Active(1) = FALSE
        Active(2) = FALSE
        Active(3) = FALSE
        Active(4) = FALSE
        Active(CursorPosition - 1) = TRUE

BackGroundGraphics UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage()
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 42, 80, 278, 264
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 72, 24, 248, 60

DrawWindow UPPERLAYER&(), LOWERLAYER&(), 42, 38, 47, 79
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 42, 28, 71, 38


PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, 26, 4, TRUE
Ypos = 82
IF AntiAlias = TRUE THEN BitMapNumber = 26 ELSE BitMapNumber = 28
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, Ypos, BitMapNumber, Active(0)
IF SkyTexture = TRUE THEN BitMapNumber = 30 ELSE BitMapNumber = 32
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, Ypos + 36, BitMapNumber, Active(1)
IF ShadowsOn = TRUE THEN BitMapNumber = 34 ELSE BitMapNumber = 36
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, Ypos + 72, BitMapNumber, Active(2)
IF MenuFlip = TRUE THEN BitMapNumber = 38 ELSE BitMapNumber = 40
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, Ypos + 108, BitMapNumber, Active(3)
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, Ypos + 144, 24, Active(4)
END SUB

SUB DisplayLoadGameMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage() AS MenuBitMap, CursorPosition, SaveFull(), SaveLevel(), SaveSkill())
REDIM Active(4)
        Active(0) = FALSE
        Active(1) = FALSE
        Active(2) = FALSE
        Active(3) = FALSE
        Active(4) = FALSE
        Active(CursorPosition - 1) = TRUE
BackGroundGraphics UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage()
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 42, 80, 288, 212
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 82, 24, 238, 60
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 42, 38, 47, 79
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 42, 28, 81, 38
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, 26, 6, TRUE
Ypos = 82
FOR index = 0 TO 4

        PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 52, Ypos, 74 + (index * 2), Active(index)
       
                IF SaveFull(index) = 0 THEN
                'CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(67 + Addition).StartPoint, InterFaceObject(67 + Addition).BytesLong
                PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 98, Ypos, 84, Active(index)
                'CSSprite VARSEG(UPPERLAYER&(0)), 98, Ypos, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
                ELSE
                'CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(69 + (SaveLevel(index) - 1) * 2 + Addition).StartPoint, InterFaceObject(69 + (SaveLevel(index) - 1) * 2 + Addition).BytesLong
                'CSSprite VARSEG(UPPERLAYER&(0)), 98, Ypos, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
                PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 98, Ypos, 86 + (SaveLevel(index) - 1) * 2, Active(index)
                'CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(85 + (SaveSkill(index) - 1) * 2 + Addition).StartPoint, InterFaceObject(85 + (SaveSkill(index) - 1) * 2 + Addition).BytesLong
                'CSSprite VARSEG(UPPERLAYER&(0)), 178, Ypos, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
                PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 172, Ypos, 102 + (SaveSkill(index) - 1) * 2, Active(index)
                END IF
Ypos = Ypos + 26
NEXT

END SUB

SUB DisplayMainMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage() AS MenuBitMap, CursorPosition)
REDIM Active(5)
        Active(0) = FALSE
        Active(1) = FALSE
        Active(2) = FALSE
        Active(3) = FALSE
        Active(4) = FALSE
        Active(5) = FALSE
        Active(CursorPosition - 1) = TRUE
BackGroundGraphics UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage()
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 82, 100, 238, 320
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 0, 0, 2, TRUE
Ypos = 102
BitMapNumber = 8
FOR index = 0 TO 5
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, Ypos, BitMapNumber, Active(index)
Ypos = Ypos + 36
BitMapNumber = BitMapNumber + 2
NEXT
END SUB

SUB DisplayOptionsMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage() AS MenuBitMap, CursorPosition)
REDIM Active(2)
        Active(0) = FALSE
        Active(1) = FALSE
        Active(2) = FALSE
        Active(CursorPosition - 1) = TRUE

BackGroundGraphics UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage()
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 72, 80, 248, 192
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 82, 24, 238, 60

DrawWindow UPPERLAYER&(), LOWERLAYER&(), 72, 38, 77, 79
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 72, 28, 81, 38


PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, 26, 3, TRUE

Ypos = 82
BitMapNumber = 20
FOR index = 0 TO 2
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, Ypos, BitMapNumber, Active(index)
Ypos = Ypos + 36
BitMapNumber = BitMapNumber + 2
NEXT

END SUB

SUB DisplaySkillMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage() AS MenuBitMap, CursorPosition)
REDIM Active(3)
       
        Active(0) = FALSE
        Active(1) = FALSE
        Active(2) = FALSE
        Active(3) = FALSE
        Active(CursorPosition - 1) = TRUE

BackGroundGraphics UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage()
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 72, 80, 248, 226
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 82, 24, 238, 60
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 72, 38, 77, 79
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 72, 28, 81, 38
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, 26, 7, TRUE
Ypos = 82
BitMapNumber = 66
FOR index = 0 TO 3
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, Ypos, BitMapNumber, Active(index)
Ypos = Ypos + 36
BitMapNumber = BitMapNumber + 2
NEXT
        
END SUB

SUB DisplaySoundMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage() AS MenuBitMap, CursorPosition, MusicVol, SFXVol, EAXAudio)
REDIM Active(3)
        Active(0) = FALSE
        Active(1) = FALSE
        Active(2) = FALSE
        Active(3) = FALSE
        Active(CursorPosition - 1) = TRUE

BackGroundGraphics UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage()
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 42, 80, 278, 228
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 82, 24, 238, 60

DrawWindow UPPERLAYER&(), LOWERLAYER&(), 42, 38, 47, 79
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 42, 28, 81, 38

PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, 26, 5, TRUE
Ypos = 82
SELECT CASE SFXVol
CASE 100
        BitMapNumber = 42
CASE 75
        BitMapNumber = 44
CASE 50
        BitMapNumber = 46
CASE 25
        BitMapNumber = 48
CASE 0
        BitMapNumber = 50
END SELECT
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, Ypos, BitMapNumber, Active(0)
SELECT CASE MusicVol
CASE 100
        BitMapNumber = 52
CASE 75
        BitMapNumber = 54
CASE 50
        BitMapNumber = 56
CASE 25
        BitMapNumber = 58
CASE 0
        BitMapNumber = 60
END SELECT
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, Ypos + 36, BitMapNumber, Active(1)
IF EAXAudio = TRUE THEN BitMapNumber = 62 ELSE BitMapNumber = 64
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, Ypos + 72, BitMapNumber, Active(2)
PrintMenuText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CENTERED, Ypos + 108, 24, Active(3)
END SUB

SUB DrawWindow (UPPERLAYER&(), LOWERLAYER&(), x1, y1, x2, y2)
        ShadeRectangle x1, y1, x2, y2, VARSEG(UPPERLAYER&(0)), VARSEG(LOWERLAYER&(0))
IF y1 < 200 THEN
        CSLine VARSEG(UPPERLAYER&(0)), x1, y1, x2, y1, 7
        CSLine VARSEG(UPPERLAYER&(0)), x1, y1, x1, y2, 6
        CSLine VARSEG(UPPERLAYER&(0)), x1, y2, x2, y2, 5
        CSLine VARSEG(UPPERLAYER&(0)), x2, y1, x2, y2, 4
        CSPset VARSEG(UPPERLAYER&(0)), x1, y1, 12
        CSPset VARSEG(UPPERLAYER&(0)), x1 + 1, y1, 11
        CSPset VARSEG(UPPERLAYER&(0)), x1, y1 + 1, 11
        CSPset VARSEG(UPPERLAYER&(0)), x1 + 2, y1, 10
        CSPset VARSEG(UPPERLAYER&(0)), x1, y1 + 2, 10
        CSPset VARSEG(UPPERLAYER&(0)), x1 + 3, y1, 9
        CSPset VARSEG(UPPERLAYER&(0)), x1, y1 + 3, 9
        CSPset VARSEG(UPPERLAYER&(0)), x1 + 4, y1, 8
END IF
IF y2 > 199 THEN
        y1 = y1 - 200
        y2 = y2 - 200
        CSLine VARSEG(LOWERLAYER&(0)), x1, y1, x2, y1, 7
        CSLine VARSEG(LOWERLAYER&(0)), x1, y1, x1, y2, 6
        CSLine VARSEG(LOWERLAYER&(0)), x1, y2, x2, y2, 5
        CSLine VARSEG(LOWERLAYER&(0)), x2, y1, x2, y2, 4
        CSPset VARSEG(LOWERLAYER&(0)), x1, y1, 12
        CSPset VARSEG(LOWERLAYER&(0)), x1 + 1, y1, 11
        CSPset VARSEG(LOWERLAYER&(0)), x1, y1 + 1, 11
        CSPset VARSEG(LOWERLAYER&(0)), x1 + 2, y1, 10
        CSPset VARSEG(LOWERLAYER&(0)), x1, y1 + 2, 10
        CSPset VARSEG(LOWERLAYER&(0)), x1 + 3, y1, 9
        CSPset VARSEG(LOWERLAYER&(0)), x1, y1 + 3, 9
        CSPset VARSEG(LOWERLAYER&(0)), x1 + 4, y1, 8
END IF
END SUB

SUB FadeIn (PalString$)
FOR index = 0 TO 63
FOR colorIndex = 0 TO 255
        CSGetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
        TargetRed = ASC(MID$(PalString$, (colorIndex * 3) + 1, 1))
        TargetGreen = ASC(MID$(PalString$, (colorIndex * 3) + 2, 1))
        TargetBlue = ASC(MID$(PalString$, (colorIndex * 3) + 3, 1))
        IF CurrentRed < TargetRed THEN CurrentRed = CurrentRed + 1
        IF CurrentGreen < TargetGreen THEN CurrentGreen = CurrentGreen + 1
        IF CurrentBlue < TargetBlue THEN CurrentBlue = CurrentBlue + 1
        CSSetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
NEXT
        IF index MOD 4 = 0 THEN CSWaitTimer 0
NEXT

END SUB

SUB FadeOut
        FOR index = 0 TO 63
        CSFadeToStep 0, 255, 0, 0, 0
        IF index MOD 4 = 0 THEN CSWaitTimer 0
        NEXT
END SUB

SUB FlipMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, Direction)
Xvelo = 17
IF Direction = 1 THEN Xlen = 160 ELSE Xlen = 1
CSGet VARSEG(UPPERLAYER&(0)), 0, 0, 319, 199, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
CSMoveToXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandle, 819200, 64004
CSGet VARSEG(LOWERLAYER&(0)), 0, 0, 319, 199, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
CSMoveToXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandle, 890880, 64004
DO
CSClearMMX VARSEG(UPPERLAYER&(0)), 0
CSClearMMX VARSEG(LOWERLAYER&(0)), 0
IF Direction = 1 THEN
        Xlen = Xlen - Xvelo
        IF Xlen < 1 THEN EXIT DO
ELSE
        Xlen = Xlen + Xvelo
        IF Xlen > 160 THEN EXIT DO
END IF
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandle, 819200, 64004
CSSpriteS VARSEG(UPPERLAYER&(0)), 160 - Xlen, 0, Xlen * 2, 200, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandle, 890880, 64004
CSSpriteS VARSEG(LOWERLAYER&(0)), 160 - Xlen, 0, Xlen * 2, 200, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
Xvelo = Xvelo - 1
IF Xvelo = 0 THEN Xvelo = 1
CSWaitTimer 0
Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
LOOP
END SUB

SUB HelpPage (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage() AS MenuBitMap, PageNumber)
BackGroundGraphics UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage()
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 6, 28, 314, 370
DrawWindow UPPERLAYER&(), LOWERLAYER&(), 8, 380, 68, 394
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 382, "Page:" + STR$(PageNumber)
SELECT CASE PageNumber
CASE 1
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 34, "instructions"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 54, "terrascape: breakdown velocity is"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 69, "third-person perspective arcade"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 84, "flight shoot'em up game."
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 99, "you fly the avatar, one of the most"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 114, "advanced fighter planes ever. your"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 129, "mission is to fight against evil"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 144, "corporate armies in order to stop"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 159, "their dark onslaught against the"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 174, "free nations."
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 189, "caged in your fighter, with only"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 204, "little hope of survival, you must"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 219, "battle the overwhelming foe,"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 234, "while the true nature of their"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 249, "attack remains unknown..."
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 274, "use the arrow keys to scroll"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 289, "through these help pages and"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 304, "press esc to return to main menu."
CASE 2
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 34, "table of contents"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 20, 54, "1 - game overview and storyline"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 20, 69, "2 - this page"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 20, 84, "3 - controls"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 20, 99, "4 - weapons and powerups"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 20, 114, "5 - missions overview 1/2"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 20, 129, "6 - missions overview 2/2"
CASE 3
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 34, "controls"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 54, "arrow keys - steer fighter"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 69, "space      - fire weapon"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 84, "a/z        - throttle up/down"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 99, "1-7        - select weapon"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 114, "tab        - toggle scanner"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 129, "del/end    - adjust camera"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 144, "home       - reset camera"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 159, "p          - pause"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 174, "esc        - game menu"
CASE 4
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 34, "weapons and powerups"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 54, "game weapons:"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 69, "1 - APL - assault pulse laser"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 84, "2 - ION - isokinetic positron gun"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 99, "3 - TLA - triad laser array"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 114, "4 - PDC - plasma discharge cannon"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 129, "5 - DFM - dumbfire missile"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 144, "6 - SND - guided missile"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 18, 159, "7 - ACM - super missile"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 184, "weapon and shield powerups can"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 199, "be obtained from destroyed"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 214, "enemy bunkers or transports."
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 229, "also, when killed, some of the enemies"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 244, "may drop powerups, mostly shield"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 259, "recharge cores, but some of them,"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 274, "with advanced weapons, can also"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 289, "drop extra ammo for the weapon"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 304, "they were using against you."
CASE 5
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 34, "missions overview 1/2"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 54, "game missions consist of series of"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 69, "different tasks. the compass arrow on"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 84, "the upper right corner of the screen"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 99, "shows your relative direction to the"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 114, "current task location. when it points"

ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 129, "upwards, you're on the course."
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 154, "the green grid in the upper-right"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 169, "corner is the short range scanner,"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 184, "which shows the locations of nearby"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 199, "hostile targets. air targets appear"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 214, "as green dots, structures as yellow"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 229, "and flak weapons as red."
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 244, "above the scanner is the mission"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 259, "status display, which tells your"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 274, "current task and the distance to the"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 289, "task location."
CASE 6
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 34, "missions overview 2/2"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 54, "the tasks are:"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 69, "  DST - Destroy Target"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 84, "  NAV - Navigate"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 99, "  PHI - Level Boss"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 129, "each level has pre-determined task"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 144, "sequence and completing it makes"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 159, "you exit the current level and"
ShadowedTextW UPPERLAYER&(), LOWERLAYER&(), 10, 174, "advance to the next one..."
END SELECT
END SUB

SUB MellowColors (PalString$)
FOR index = 0 TO 255
Red = ASC(MID$(PalString$, (index * 3) + 1, 1))
Green = ASC(MID$(PalString$, (index * 3) + 2, 1))
Blue = ASC(MID$(PalString$, (index * 3) + 3, 1))
GrayValue = (Red + Green + Blue) / 3
TotalRed = (Red * 1.9 + GrayValue * 1.1) / 3
TotalGreen = (Green * 1.9 + GrayValue * 1.1) / 3
TotalBlue = (Blue * 1.9 + GrayValue * 1.1) / 3
MID$(PalString$, (index * 3) + 1, 1) = CHR$(TotalRed)
MID$(PalString$, (index * 3) + 2, 1) = CHR$(TotalGreen)
MID$(PalString$, (index * 3) + 3, 1) = CHR$(TotalBlue)
NEXT
END SUB

SUB PrintMenuText (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage() AS MenuBitMap, TextX, TextY, TextBitMap, Active)
IF Active = FALSE THEN TargetBitMap = TextBitMap + 1 ELSE TargetBitMap = TextBitMap
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandle, MenuImage(TargetBitMap).StartPoint, MenuImage(TargetBitMap).BytesLong
IF TextX = CENTERED THEN
Xlen = CSPeek16(VARSEG(XMSCache&(0)), 0) \ 16
Ylen = CSPeek16(VARSEG(XMSCache&(0)), 2)
Xpos = 160 - Xlen
ELSE
Xpos = TextX
Ylen = CSPeek16(VARSEG(XMSCache&(0)), 2)
END IF
IF TextY + Ylen < 200 THEN
        CSSprite VARSEG(UPPERLAYER&(0)), Xpos, TextY, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
ELSEIF TextY > 199 THEN
        CSSprite VARSEG(LOWERLAYER&(0)), Xpos, TextY - 200, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
ELSE
        CSSprite VARSEG(UPPERLAYER&(0)), Xpos, TextY, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        CSSprite VARSEG(LOWERLAYER&(0)), Xpos, TextY - 200, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
END IF

END SUB

SUB ReleaseCriticalStuff (XMSHandle)
CSDeallocateXMS XMSHandle
CSRemoveTimer
CSRemoveKeyBoard
END SUB

SUB ShadowedText (UPPERLAYER&(), LOWERLAYER&(), x, y, TextString$)
        CSPrint VARSEG(UPPERLAYER&(0)), x, y - 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 3, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 2, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x - 1, y, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x - 1, y + 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x + 1, y, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x + 1, y + 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y, TextString$, 246
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 1, TextString$, 246
        y = y - 200
        CSPrint VARSEG(LOWERLAYER&(0)), x, y - 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 3, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 2, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x - 1, y, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x - 1, y + 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x + 1, y, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x + 1, y + 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y, TextString$, 246
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 1, TextString$, 246
END SUB

SUB ShadowedTextW (UPPERLAYER&(), LOWERLAYER&(), x, y, TextString$)
        CSPrint VARSEG(UPPERLAYER&(0)), x, y - 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 3, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 2, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x - 1, y, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x - 1, y + 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x + 1, y, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x + 1, y + 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y, TextString$, 43
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 1, TextString$, 43
        y = y - 200
        CSPrint VARSEG(LOWERLAYER&(0)), x, y - 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 3, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 2, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x - 1, y, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x - 1, y + 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x + 1, y, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x + 1, y + 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y, TextString$, 43
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 1, TextString$, 43
END SUB

SUB ShowOffscreen (VideoPage, UPPERLAYER&(), LOWERLAYER&())
IF VideoPage = 1 THEN
mxBufferCopy Page2in320x200, VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0))
mxBufferCopy Page3in320x200, VARSEG(LOWERLAYER&(0)), VARPTR(LOWERLAYER&(0))
mxSetDisplayOffset 32000
END IF
IF VideoPage = 2 THEN
mxBufferCopy Page0in320x200, VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0))
mxBufferCopy Page1in320x200, VARSEG(LOWERLAYER&(0)), VARPTR(LOWERLAYER&(0))
mxSetDisplayOffset 0
END IF
END SUB

SUB Update (UPPERLAYER&(), LOWERLAYER&(), VideoPage)
ShowOffscreen VideoPage, UPPERLAYER&(), LOWERLAYER&()
VideoPage = VideoPage + 1
IF VideoPage > 2 THEN VideoPage = 1
END SUB

SUB WaitTicks (Ticks)
FOR index = 0 TO Ticks
CSWaitTimer 0
NEXT
END SUB

