DECLARE SUB SoundInterFace (Command%, Value1%, Value2%, Value3%, Value4%)
DECLARE SUB MellowColors (PalString$)
DECLARE SUB ShadowedText (UPPERLAYER&(), LOWERLAYER&(), x%, y%, TextString$)
DECLARE SUB DisplayText (UPPERLAYER&(), LOWERLAYER&(), TextNumber%)
DECLARE SUB BlitBackGround (UPPERLAYER&(), LOWERLAYER&(), BackGroundHandle%, XMSCache&())
DECLARE SUB Update (UPPERLAYER&(), LOWERLAYER&(), VideoPage%)
DECLARE SUB FadeInStep (PalString$, FadeInFlag%, FadeStep%)
DECLARE SUB FadeOutStep (FadeOutFlag%, FadeStep%)
DECLARE SUB FullFade ()
DECLARE SUB Disk2XMS (File$, Handle%)
DECLARE SUB BlackPalette ()
DECLARE SUB AssimilatePalette (PaletteNumber%, FirstIndex%, ColorsToAssimilate%, PalString$)
DECLARE SUB AssimilateBackGround (XMSHandle%, BackGroundImageHandle%, XMSCache&(), OutroImage() AS ANY, ImageNumber%)
DECLARE SUB GeneratePrime (XMSHandle%, OutroImage() AS ANY)
DECLARE SUB ShowOffscreen (VideoPage%, UPPERLAYER&(), LOWERLAYER&())

DECLARE SUB Darken CDECL (BYVAL hiview%, BYVAL loview%)

'$DYNAMIC
'$INCLUDE: 'slivedcx.bi'
'$INCLUDE: 'modexlib.bi'
TYPE OutroImageBitMap
        StartPoint AS LONG
        BytesLong AS LONG
END TYPE
CONST TRUE = 1
CONST FALSE = 0
DEFINT A-Z

REDIM UPPERLAYER&(16000)
REDIM LOWERLAYER&(16000)
REDIM XMSCache&(16384)

REDIM OutroImage(2) AS OutroImageBitMap
      
        FileHandle = FREEFILE
        OPEN "prefs.db" FOR BINARY AS FileHandle
        SEEK FileHandle, 1
        GET FileHandle, , DS4QBActive
        GET FileHandle, , AntiAlias
        GET FileHandle, , SkyTexture
        GET FileHandle, , ShadowsOn
        GET FileHandle, , MenuFlip
        GET FileHandle, , SFXVol
        GET FileHandle, , MusicVol
        GET FileHandle, , EAXAudio
        CLOSE FileHandle
SoundInterFace 0, DS4QBActive, 0, 0, 0
IF MusicVol > 0 THEN MusicOn = TRUE ELSE MusicOn = FALSE
DarkFlag = TRUE
TextOn = FALSE
TextNumber = 0
IsMMX = CSDetectMMX
IsXMS = CSDetectXMS
IF IsXMS = 1 THEN
        XMSHandle = CSAllocateXMS(400)
        BackGroundImageHandle = CSAllocateXMS(130)
ELSE
        END
END IF

Disk2XMS "outro.dx", XMSHandle
GeneratePrime XMSHandle, OutroImage()

Pal$ = SPACE$(768)
InitialPal$ = SPACE$(768)
Font$ = SPACE$(2048)
OPEN "fontface.db" FOR BINARY AS #1
SEEK #1, 1
GET #1, , Font$
CLOSE #1
CSSetFont Font$
Rfl = CSLoadPal("palette.dat", Pal$)
InitialPal$ = Pal$
AssimilatePalette 13, 128, 128, Pal$
MellowColors Pal$
BlackPalette
mxFill Page0in320x400&, Full320x400, 0
mxFill Page1in320x400&, Full320x400, 0
CSInstallTimer
CSSetTimer 0, 40
CSInstallKeyBoard
        FadeOutFlag = FALSE
        FadeStep = 0: FadeInFlag = TRUE: VideoPage = 2
        NextStep = 24: ImageNum = 0
        Timer1Timer = NextStep
        AssimilateBackGround XMSHandle, BackGroundImageHandle, XMSCache&(), OutroImage(), 0
        IF MusicOn = TRUE THEN SoundInterFace 3, 2, 1, 0, 0

DO
        GOSUB TimerChunk:
        IF FadeInFlag = TRUE THEN FadeInStep Pal$, FadeInFlag, FadeStep
        IF FadeOutFlag = TRUE THEN FadeOutStep FadeOutFlag, FadeStep
        CSWaitTimer 0
        IF CSKey(KEYESC) THEN GOTO Quit
LOOP
Quit:
SoundInterFace 5, 1, 100, 0, 0
FullFade
CSDeallocateXMS XMSHandle
CSDeallocateXMS BackGroundImageHandle
CSRemoveKeyBoard
CSRemoveTimer
RUN "scapez02.xbn"

TimerChunk:
Timer1Timer = Timer1Timer - 1
IF Timer1Timer = 0 THEN GOSUB AddNewScreen:
        
BlitBackGround UPPERLAYER&(), LOWERLAYER&(), BackGroundImageHandle, XMSCache&()
IF DarkFlag = TRUE THEN Darken VARSEG(UPPERLAYER&(0)), VARSEG(LOWERLAYER&(0))
IF TextOn = TRUE THEN DisplayText UPPERLAYER&(), LOWERLAYER&(), TextNumber
Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
RETURN

AddNewScreen:
ImageNum = ImageNum + 1

        SELECT CASE ImageNum
        CASE 1
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 180
        CASE 2
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 180
        CASE 3
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 180
        CASE 4
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 100
        CASE 5
                TextOn = FALSE
                FadeOutFlag = TRUE
                NextStep = 16
                FadeStep = 0
        CASE 6
                AssimilateBackGround XMSHandle, BackGroundImageHandle, XMSCache&(), OutroImage(), 1
                Pal$ = InitialPal$
                AssimilatePalette 14, 128, 128, Pal$
                BlackPalette
                FadeInFlag = TRUE
                NextStep = 25
                DarkFlag = TRUE
        CASE 7
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 120
        CASE 8
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 200
        CASE 9
                TextOn = FALSE
                FadeOutFlag = TRUE
                NextStep = 16
                FadeStep = 0
        CASE 10
                AssimilateBackGround XMSHandle, BackGroundImageHandle, XMSCache&(), OutroImage(), 2
                Pal$ = InitialPal$
                AssimilatePalette 15, 128, 128, Pal$
                BlackPalette
                FadeInFlag = TRUE
                NextStep = 25
                DarkFlag = TRUE
        CASE 11
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 80
        CASE 12
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 200
        CASE 13
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 200
        CASE 14
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 200
        CASE 15
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 200
        CASE 16
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 200
        CASE 17
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 200
        CASE 18
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 140
        CASE 19
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 200
        CASE 20
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 200
        CASE 21
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 160
        CASE 22
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 250
        CASE 23
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 300
        CASE 24
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 200
        CASE 25
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 200
        CASE 26
                TextOn = FASE
                NextStep = 200
        CASE 27
                TextOn = TRUE
                TextNumber = TextNumber + 1
                NextStep = 400
        CASE 28
                GOTO Quit
        END SELECT
Timer1Timer = NextStep
RETURN

REM $STATIC
SUB AssimilateBackGround (XMSHandle, BackGroundImageHandle, XMSCache&(), OutroImage() AS OutroImageBitMap, ImageNumber)
CSMoveXMS XMSHandle, OutroImage(ImageNumber).StartPoint, BackGroundImageHandle, 0, 128000
END SUB

SUB AssimilatePalette (PaletteNumber, FirstIndex, ColorsToAssimilate, PalString$)
FileHandle = FREEFILE
OPEN "coltabs.db" FOR BINARY AS FileHandle
SEEK FileHandle, ((PaletteNumber - 1) * 1536) + 1
PaletteIndex = FirstIndex * 3 + 1
FOR index = 0 TO ColorsToAssimilate - 1
        GET FileHandle, , ColorComponent
        MID$(PalString$, PaletteIndex, 1) = CHR$(ColorComponent)
        GET FileHandle, , ColorComponent
        MID$(PalString$, PaletteIndex + 1, 1) = CHR$(ColorComponent)
        GET FileHandle, , ColorComponent
        MID$(PalString$, PaletteIndex + 2, 1) = CHR$(ColorComponent)
        PaletteIndex = PaletteIndex + 3
NEXT
CLOSE FileHandle
END SUB

SUB BlackPalette
FOR index = 0 TO 255
        CSSetCol index, 0, 0, 0
NEXT
END SUB

SUB BlitBackGround (UPPERLAYER&(), LOWERLAYER&(), BackGroundHandle, XMSCache&())
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), BackGroundHandle, 0, 64000
CSPcopyMMX VARSEG(XMSCache&(0)), VARSEG(UPPERLAYER&(0))
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), BackGroundHandle, 64000, 64000
CSPcopyMMX VARSEG(XMSCache&(0)), VARSEG(LOWERLAYER&(0))
END SUB

SUB Disk2XMS (File$, Handle%)
FileHandle = FREEFILE
OPEN File$ FOR BINARY AS FileHandle
  Bytes& = LOF(FileHandle)
  Tmp = Bytes& / 1024
  Times% = FIX(Tmp) - 1
  restof% = Bytes& MOD 1024
  Tmp$ = SPACE$(1024)
  DIM tempvar(512)

FOR i& = 0 TO Times%
  tmpoffs& = (i& * 1024)
  GET FileHandle, , Tmp$
  CSMemCopy VARSEG(Tmp$), SADD(Tmp$), VARSEG(tempvar(0)), VARPTR(tempvar(0)), 1024
  CSMoveToXMS VARSEG(tempvar(0)), VARPTR(tempvar(0)), Handle%, tmpoffs&, 1024
NEXT i&

IF NOT restof% = 0 THEN
  Tmp$ = SPACE$(restof%)
  tmpoffs& = (i& * 1024)
  GET FileHandle, , Tmp$
  CSMemCopy VARSEG(Tmp$), SADD(Tmp$), VARSEG(tempvar(0)), VARPTR(tempvar(0)), restof%
  CSMoveToXMS VARSEG(tempvar(0)), VARPTR(tempvar(0)), Handle%, tmpoffs&, restof%
END IF
CLOSE FileHandle
END SUB

SUB DisplayText (UPPERLAYER&(), LOWERLAYER&(), TextNumber)
        SELECT CASE TextNumber
        CASE 1
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 60, "gorgeous flash of light dominates"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "your view, as you see the asteroid"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "evaporating..."
        CASE 2
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 60, "you set your throttle at the maximum"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "level, hoping that you can push"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "your ship away from the explosion."
        CASE 3
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 60, "waves of heat and pressure strike on"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "your shields and your ship almost"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "incintrates..."
        CASE 4
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 95, "...but you manage to survive."
        CASE 5
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 85, "as you fly towards earth, your mind"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 105, "fills with peace..."
        CASE 6
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 75, "you have done your part, in this"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 95, "show..."
        CASE 7
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 160, "epilogue:"
        CASE 8
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "the irrah was actually an ancient"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "alien artifact which had lain under"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "the crust of the quaoar asteroid"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 140, "for more than four billion years..."
        CASE 9
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "it was created by the"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "mrthaphakhatkahan race, which had"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "vanished thousands of millennia ago..."
        CASE 10
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "an explorer party discovered the"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "irrah thirty-four years ago, and"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "they managed to activate it."
        CASE 11
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "the irrah started to send some"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "signals for them, and the explorers"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "believed that the signals had a"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 140, "divine meaning."
        CASE 12
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "soon after that, the corporation"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "who sent the explorers, was"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "convinced about these"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 140, "'divine signals'."
        CASE 13
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "the corporation arranged a"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "conference focused on the"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "discovery. some other major"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 140, "corporations were invited..."
        CASE 14
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 140, "the corporate men formed a cult."
        CASE 15
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "and alas, the corporates were"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "born..."
        CASE 16
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "the long range plan of the"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "corporates was to wipe out all"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "of the humans who refuse to"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 140, "worship the irrah."
        CASE 17
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "the process was slow."
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "luckily."
        CASE 18
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "first they stricted up the"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "metropolic laws, reclaiming the"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "death penalty."
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 140, "then they started to assasinate"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 160, "civil-right activists and"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 180, "anti-facists."
        CASE 19
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "the last phase was the missile strike."
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "according to their plan, the missiles"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 140, "should have been launched in two"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 160, "waves. the first wave was the one"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 180, "we suffered, and the second was up"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 200, "to come when the worshippers had"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 220, "been moved to the quaoar asteroid."
        CASE 20
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 80, "if the second wave had been launched,"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 100, "the earth would be now nothing more"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "than molten radioactive waste..."
        CASE 21
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 120, "luckily it failed."
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 160, "we still have the future."
        CASE 22
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 180, "the end"
                ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 220, "thanks for playin'"
        END SELECT
END SUB

SUB FadeInStep (PalString$, FadeInFlag, FadeStep)
FOR colorIndex = 0 TO 255
        CSGetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
        TargetRed = ASC(MID$(PalString$, (colorIndex * 3) + 1, 1))
        TargetGreen = ASC(MID$(PalString$, (colorIndex * 3) + 2, 1))
        TargetBlue = ASC(MID$(PalString$, (colorIndex * 3) + 3, 1))
        CurrentRed = CurrentRed + 4
        CurrentGreen = CurrentGreen + 4
        CurrentBlue = CurrentBlue + 4
        IF CurrentRed > TargetRed THEN CurrentRed = TargetRed
        IF CurrentGreen > TargetGreen THEN CurrentGreen = TargetGreen
        IF CurrentBlue > TargetBlue THEN CurrentBlue = TargetBlue
        CSSetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
NEXT
        FadeStep = FadeStep + 1
        IF FadeStep >= 16 THEN FadeStep = 0: FadeInFlag = FALSE
END SUB

SUB FadeOutStep (FadeOutFlag, FadeStep)
FOR colorIndex = 0 TO 255
        CSGetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
        CurrentRed = CurrentRed - 4
        CurrentGreen = CurrentGreen - 4
        CurrentBlue = CurrentBlue - 4
        IF CurrentRed < 0 THEN CurrentRed = 0
        IF CurrentGreen < 0 THEN CurrentGreen = 0
        IF CurrentBlue < 0 THEN CurrentBlue = 0
        CSSetCol colorIndex, CurrentRed, CurrentGreen, CurrentBlue
NEXT
        FadeStep = FadeStep + 1
        IF FadeStep >= 16 THEN FadeStep = 0: FadeOutFlag = FALSE
END SUB

SUB FullFade
        FOR index = 0 TO 63
        CSFadeToStep 0, 255, 0, 0, 0
        IF index MOD 4 = 0 THEN CSWaitTimer 0
        NEXT
END SUB

SUB GeneratePrime (XMSHandle, OutroImage() AS OutroImageBitMap)
REDIM WordFromXMS(0)
REDIM DWordFromXMS&(0)
        CSMoveFromXMS VARSEG(WordFromXMS(0)), VARPTR(WordFromXMS(0)), XMSHandle, 0, 2
        XMSPos& = 2
        SP& = 0
        TotalIndexes = WordFromXMS(0)
        FOR index = 0 TO TotalIndexes
        OutroImage(index).StartPoint = SP&
        CSMoveFromXMS VARSEG(DWordFromXMS&(0)), VARPTR(DWordFromXMS&(0)), XMSHandle, XMSPos&, 4
        OutroImage(index).BytesLong = DWordFromXMS&(0)
        XMSPos& = XMSPos& + 4
        SP& = SP& + DWordFromXMS&(0)
        NEXT
        FOR index = 0 TO TotalIndexes
        OutroImage(index).StartPoint = OutroImage(index).StartPoint + XMSPos&
        NEXT
END SUB

SUB MellowColors (PalString$)
FOR index = 0 TO 255
Red = ASC(MID$(PalString$, (index * 3) + 1, 1))
Green = ASC(MID$(PalString$, (index * 3) + 2, 1))
Blue = ASC(MID$(PalString$, (index * 3) + 3, 1))
GrayValue = (Red + Green + Blue) / 3
TotalRed = (Red * 1.9 + GrayValue * 1.1) / 3
TotalGreen = (Green * 1.9 + GrayValue * 1.1) / 3
TotalBlue = (Blue * 1.9 + GrayValue * 1.1) / 3
MID$(PalString$, (index * 3) + 1, 1) = CHR$(TotalRed)
MID$(PalString$, (index * 3) + 2, 1) = CHR$(TotalGreen)
MID$(PalString$, (index * 3) + 3, 1) = CHR$(TotalBlue)
NEXT
END SUB

SUB ShadowedText (UPPERLAYER&(), LOWERLAYER&(), x, y, TextString$)
        CSPrint VARSEG(UPPERLAYER&(0)), x, y - 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 3, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 2, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x - 1, y, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x - 1, y + 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x + 1, y, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x + 1, y + 1, TextString$, 0
        CSPrint VARSEG(UPPERLAYER&(0)), x, y, TextString$, 15
        CSPrint VARSEG(UPPERLAYER&(0)), x, y + 1, TextString$, 15
        y = y - 200
        CSPrint VARSEG(LOWERLAYER&(0)), x, y - 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 3, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 2, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x - 1, y, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x - 1, y + 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x + 1, y, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x + 1, y + 1, TextString$, 0
        CSPrint VARSEG(LOWERLAYER&(0)), x, y, TextString$, 15
        CSPrint VARSEG(LOWERLAYER&(0)), x, y + 1, TextString$, 15
END SUB

SUB ShowOffscreen (VideoPage, UPPERLAYER&(), LOWERLAYER&())
IF VideoPage = 1 THEN
mxBufferCopy Page2in320x200, VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0))
mxBufferCopy Page3in320x200, VARSEG(LOWERLAYER&(0)), VARPTR(LOWERLAYER&(0))
mxSetDisplayOffset 32000
END IF
IF VideoPage = 2 THEN
mxBufferCopy Page0in320x200, VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0))
mxBufferCopy Page1in320x200, VARSEG(LOWERLAYER&(0)), VARPTR(LOWERLAYER&(0))
mxSetDisplayOffset 0
END IF
END SUB

SUB Update (UPPERLAYER&(), LOWERLAYER&(), VideoPage)
ShowOffscreen VideoPage, UPPERLAYER&(), LOWERLAYER&()
VideoPage = VideoPage + 1
IF VideoPage > 2 THEN VideoPage = 1
END SUB

