DECLARE SUB ToggleBoss (GameObject() AS ANY, BossType%, Switch%)
DECLARE SUB WaitTicks (Ticks%)
DECLARE FUNCTION LoadSaveMenu% (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandles%(), InterFaceObject() AS ANY, VideoPage%, LoadSave%)
DECLARE FUNCTION SmallMenu% (UPPERLAYER&(), LOWERLAYER&(), InterFaceObject() AS ANY, XMSCache&(), XMSHandles%(), VideoPage%, Ammo%(), LevelNum%, Skill%, Saveable%)
DECLARE SUB ShowOffscreen (VideoPage%, UPPERLAYER&(), LOWERLAYER&())
DECLARE SUB SetAtmosphereColors (Pal$, PaletteNum%)
DECLARE FUNCTION GetDistance& (X1&, Y1&, Z1&, X2&, Y2&, Z2&)
DECLARE SUB InitializeMessage (SEEDVALUE%, BigMessage%, BigMessageTime%)
DECLARE SUB SoundInterFace (Command%, Value1%, Value2%, Value3%, Value4%)

DECLARE SUB RemoveMissionNode (MissionPath() AS ANY, TargetSpot%)
DECLARE FUNCTION GetAmmoTag% (Weapon%)
DECLARE SUB PixelToRadarBmap (Segment%, Offset%, X%, Y%, Col%)
DECLARE FUNCTION GetGroundY% (BumpMap&(), X&, Z&)
DECLARE FUNCTION GetGroundHeight% (BumpMap&(), X&, Z&)
DECLARE FUNCTION Controllable% (Hits%, Otype%)
DECLARE FUNCTION CheckDeath% (Hits%)
DECLARE FUNCTION ArcTangent% (Y&, X&)
DECLARE SUB SortFaces CDECL ALIAS "_sort_polygons" (BYVAL polylist%, BYVAL PolyCount%)
DECLARE SUB GreenScreen CDECL ALIAS "_blend_green" (BYVAL lowscreen%, BYVAL highscreen%, BYVAL blend%)
DECLARE SUB PPBlendTri (BYVAL Layer%, BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, BYVAL X3%, BYVAL Y3%, BYVAL BlendMap%)
DECLARE SUB PPProjectVector (BYVAL Vec3DSeg%, BYVAL Vec3DOff&, BYVAL Vec2DSeg%, BYVAL Vec2DOff&, BYVAL ZEye!)
'$INCLUDE: 'objtypes.bi'
'$INCLUDE: 'modexlib.bi'
'$INCLUDE: 'slivedcx.bi'
DIM SHARED DirectionVector(0) AS Vector3DType

FUNCTION ArcTangent% (Y&, X&)
IF X& = 0 THEN
IF Y& > 0 THEN
ArcTangent% = 320
        EXIT FUNCTION
ELSEIF Y& < 0 THEN
ArcTangent% = 960
        EXIT FUNCTION
END IF
END IF
IF X& > 0 THEN
ArcTangent% = CINT((ATN(Y& / X&) * 203.5872 + 1280) MOD 1280)
EXIT FUNCTION
ELSEIF X& < 0 THEN
ArcTangent% = CINT((ATN(Y& / X&) * 203.5872 + 640))
END IF
END FUNCTION

SUB CheckBoss (MissionPath() AS MissionType, GameObject() AS Object, BossType, BigMessage, BigMessageTime)
        IF MissionPath(0).Node <> NODEBOSS THEN EXIT SUB
        IF GameObject(1).HitPoints <= 0 THEN
                RemoveMissionNode MissionPath(), 0
                InitializeMessage MESSAGEKILLBOSS, BigMessage, BigMessageTime
                EXIT SUB
        END IF
        IF GameObject(1).ObjectType = 0 THEN ToggleBoss GameObject(), BossType, TRUE
END SUB

DEFSNG A-Z
FUNCTION CheckDeath% (Hits%)
IF Hits% = 0 THEN
        CheckDeath% = TRUE
ELSE
        CheckDeath% = FALSE
END IF
END FUNCTION

DEFINT A-Z
SUB CheckTargets (MissionPath() AS MissionType, GameObject() AS Object, BigMessage, BigMessageTime)
REDIM HaveToRemove(31)
        FOR MissionPathIndex = 0 TO 31
        HaveToRemove(MissionPathIndex) = FALSE
        IF MissionPath(MissionPathIndex).Node = NODETARGET THEN
                IF GameObject(MissionPath(MissionPathIndex).NodeHook).ObjectType = 0 OR GameObject(MissionPath(MissionPathIndex).NodeHook).ObjectType > 191 OR GameObject(MissionPath(MissionPathIndex).NodeHook).ObjectType < 8 THEN
                HaveToRemove(MissionPathIndex) = TRUE
                IF MissionPathIndex = 0 THEN
                        InitializeMessage MESSAGETARGET, BigMessage, BigMessageTime
                        SoundInterFace 2, 26, 0, 0, 0
                END IF
                END IF
        END IF
        NEXT
       
        FOR index = 0 TO 31
        IF HaveToRemove(index) = TRUE THEN RemoveMissionNode MissionPath(), index
        NEXT
END SUB

SUB Compass (UPPERLAYER&(), MissionPath() AS MissionType, CheckPoint() AS CheckPointType, GameObject() AS Object, InterFaceObject() AS InterfaceBitMap, XMSHandles(), XMSCache&(), Sine!(), Cosine!())
        REDIM DirectionArrowVector(3) AS Vector2DType
        REDIM DistanceVector(0) AS Vector3DType
        DirectionArrowVector(0).X = 0
        DirectionArrowVector(0).Y = -15
        DirectionArrowVector(1).X = -5
        DirectionArrowVector(1).Y = 10
        DirectionArrowVector(2).X = 0
        DirectionArrowVector(2).Y = 5
        DirectionArrowVector(3).X = 5
        DirectionArrowVector(3).Y = 10
       
        SELECT CASE MissionPath(0).Node
        CASE NODETARGET
                TgtX& = GameObject(MissionPath(0).NodeHook).X + 300000000
                TgtZ& = GameObject(MissionPath(0).NodeHook).Z + 300000000
        CASE NODECHECKPOINT, 5250
                TgtX& = CheckPoint(MissionPath(0).NodeHook).X + 300000000
                TgtZ& = CheckPoint(MissionPath(0).NodeHook).Z + 300000000
        CASE NODEBOSS
                TgtX& = GameObject(1).X + 300000000
                TgtZ& = GameObject(1).Z + 300000000
        END SELECT
        PlayX& = GameObject(0).X + 300000000
        PlayZ& = GameObject(0).Z + 300000000
        DistanceVector(0).X = TgtX& - PlayX&
        DistanceVector(0).Z = TgtZ& - PlayZ&
        DistanceVector(0).Y = 0
        DotProduct! = CSVectorDot!(VARSEG(DistanceVector(0).X), VARPTR(DistanceVector(0).X), VARSEG(DistanceVector(0).X), VARPTR(DistanceVector(0).X))
        Distance = CINT(SQR(DotProduct!) \ 512)
        IF Distance > 999 THEN Distance = 999
        Heading = CINT(CSNG(GameObject(0).HeadXZ) / 3.555556)
        TargetingAngle = ArcTangent(TgtZ& - PlayZ&, TgtX& - PlayX&)
        TargetingAngle = (CINT(CSNG(TargetingAngle) / 3.555556))
        TargetingAngle = (TargetingAngle + Heading + 90) MOD 360
        SELECT CASE MissionPath(0).Node
        CASE NODETARGET
        Chunk = 31
        CASE NODECHECKPOINT
        Chunk = 32
        CASE NODEBOSS
        Chunk = 33
        CASE 5250
        Chunk = 34
        END SELECT
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(Chunk).StartPoint, InterFaceObject(Chunk).BytesLong
        CSSpriteF VARSEG(UPPERLAYER&(0)), 258, 5, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
       
        FOR index = 0 TO 3
                Dx! = CSNG(DirectionArrowVector(index).X)
                Dy! = CSNG(DirectionArrowVector(index).Y)
                DirectionArrowVector(index).X = 287 + CINT(Dx! * Cosine!(TargetingAngle) - Dy! * Sine!(TargetingAngle))
                DirectionArrowVector(index).Y = 83 + CINT(Dy! * Cosine!(TargetingAngle) + Dx! * Sine!(TargetingAngle)) * 2
        NEXT
        CSTriG VARSEG(UPPERLAYER&(0)), DirectionArrowVector(0).X, DirectionArrowVector(0).Y, 4, DirectionArrowVector(1).X, DirectionArrowVector(1).Y, 7, DirectionArrowVector(2).X, DirectionArrowVector(2).Y, 13
        CSTriG VARSEG(UPPERLAYER&(0)), DirectionArrowVector(0).X, DirectionArrowVector(0).Y, 4, DirectionArrowVector(3).X, DirectionArrowVector(3).Y, 7, DirectionArrowVector(2).X, DirectionArrowVector(2).Y, 13
        'CSPrint VARSEG(UPPERLAYER&(0)), 160, 100, STR$(Distance), 2

        IF Distance >= 100 THEN Hundreds = Distance \ 100 ELSE Hundreds = 0
        IF Distance >= 10 THEN Tens = (Distance \ 10) - (Hundreds * 10) ELSE Tens = 0
        Ettans = Distance - (Hundreds * 100 + Tens * 10)

        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(Hundreds + 35).StartPoint, InterFaceObject(Hundreds + 35).BytesLong
        CSSpriteF VARSEG(UPPERLAYER&(0)), 288, 5, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(Tens + 35).StartPoint, InterFaceObject(Tens + 35).BytesLong
        CSSpriteF VARSEG(UPPERLAYER&(0)), 295, 5, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(Ettans + 35).StartPoint, InterFaceObject(Ettans + 35).BytesLong
        CSSpriteF VARSEG(UPPERLAYER&(0)), 302, 5, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))

END SUB

SUB CountVoxelPerspective (Altitude&, GroundProjection())
REDIM LocationVector(0) AS Vector3DType
REDIM HorizonHeight(0) AS Vector2DType
ScaleDivideY = 32
ScaleDivideZ! = 3.29999
ZEye = -750

TargetValue& = 40960
FOR index = 0 TO 159
        LocationVector(0).X = 0
        LocationVector(0).Y = ((5000 - Altitude&) / ScaleDivideY) * 2
        LocationVector(0).Z = TargetValue& / ScaleDivideZ!
        CSProjectVector VARSEG(LocationVector(0).X), VARPTR(LocationVector(0).X), VARSEG(HorizonHeight(0).X), VARPTR(HorizonHeight(0).X), ZEye
        'GroundProjection(index) = HorizonHeight(0).Y * 2 - 200
        GroundProjection(index) = HorizonHeight(0).Y - 100
TargetValue& = TargetValue& - 256
NEXT

END SUB

SUB Disk2XMS (File$, Handle%)
FileHandle = FREEFILE
OPEN File$ FOR BINARY AS FileHandle
  Bytes& = LOF(FileHandle)
  Tmp = Bytes& / 1024
  Times% = FIX(Tmp) - 1
  restof% = Bytes& MOD 1024
  Tmp$ = SPACE$(1024)
  DIM tempvar(512)

FOR i& = 0 TO Times%
  tmpoffs& = (i& * 1024)
  GET FileHandle, , Tmp$
  CSMemCopy VARSEG(Tmp$), SADD(Tmp$), VARSEG(tempvar(0)), VARPTR(tempvar(0)), 1024
  CSMoveToXMS VARSEG(tempvar(0)), VARPTR(tempvar(0)), Handle%, tmpoffs&, 1024
NEXT i&

IF NOT restof% = 0 THEN
  Tmp$ = SPACE$(restof%)
  tmpoffs& = (i& * 1024)
  GET FileHandle, , Tmp$
  CSMemCopy VARSEG(Tmp$), SADD(Tmp$), VARSEG(tempvar(0)), VARPTR(tempvar(0)), restof%
  CSMoveToXMS VARSEG(tempvar(0)), VARPTR(tempvar(0)), Handle%, tmpoffs&, restof%
END IF
CLOSE FileHandle
END SUB

SUB FadeToBlack
        FOR index = 0 TO 7
        FOR index2 = 0 TO 7: CSFadeToStep 0, 255, 0, 0, 0: NEXT
        CSResetTicks 0
        CSWaitTimer 0
        NEXT
END SUB

SUB FlyHigh (Altitude&, CurrentPalette, Pal$)
IF Altitude& < 63616 OR Altitude& > 96348 THEN RequestedPalette = 1: GOTO IgnoreLogics
AltFlag& = 63616
RequestedPalette = 2
PaletteWay = 1
        FOR index = 0 TO 63
                IF Altitude& >= AltFlag& AND Altitude& < AltFlag& + 512 THEN EXIT FOR
        IF PaletteWay = 1 THEN RequestedPalette = RequestedPalette + 1
        IF PaletteWay = 2 THEN RequestedPalette = RequestedPalette - 1
        IF RequestedPalette = 32 THEN PaletteWay = 2
        IF RequestedPalette = 1 THEN PaletteWay = 1
        AltFlag& = AltFlag& + 512
        NEXT
IgnoreLogics:
IF RequestedPalette < 1 THEN RequestedPalette = 1
IF CurrentPalette = RequestedPalette THEN EXIT SUB
IF RequestedPalette = 1 THEN
        CSSetPal Pal$
ELSE
        SetAtmosphereColors Pal$, RequestedPalette
END IF
CurrentPalette = RequestedPalette
END SUB

SUB GeneratePrimes (ObjectPrime() AS DrawPrimitive, InterFaceObject() AS InterfaceBitMap, ObjectDimensions() AS ObjectSizeDump, ShadowPrime() AS DrawPrimitive, XMSHandles())
REDIM WordFromXMS(0)
REDIM DWordFromXMS&(0)
        CSMoveFromXMS VARSEG(WordFromXMS(0)), VARPTR(WordFromXMS(0)), XMSHandles(OBJECTMESHES), 0, 2
        XMSPos& = 2
        SP& = 0
        TotalIndexes = WordFromXMS(0)
        TotalMeshes = TotalIndexes
        FOR index = 0 TO TotalIndexes
        ObjectPrime(index).StartPoint = SP&
        CSMoveFromXMS VARSEG(WordFromXMS(0)), VARPTR(WordFromXMS(0)), XMSHandles(OBJECTMESHES), XMSPos&, 2
        ObjectPrime(index).BytesLong = WordFromXMS(0)
        XMSPos& = XMSPos& + 2
        SP& = SP& + WordFromXMS(0)
        NEXT
        FOR index = 0 TO TotalIndexes
        ObjectPrime(index).StartPoint = ObjectPrime(index).StartPoint + XMSPos&
        NEXT
       
        CSMoveFromXMS VARSEG(WordFromXMS(0)), VARPTR(WordFromXMS(0)), XMSHandles(INTERFACE), 0, 2
        XMSPos& = 2
        SP& = 0
        TotalIndexes = WordFromXMS(0)
       
        FOR index = 0 TO TotalIndexes
        InterFaceObject(index).StartPoint = SP&
        CSMoveFromXMS VARSEG(WordFromXMS(0)), VARPTR(WordFromXMS(0)), XMSHandles(INTERFACE), XMSPos&, 2
        InterFaceObject(index).BytesLong = WordFromXMS(0)
        XMSPos& = XMSPos& + 2
        SP& = SP& + WordFromXMS(0)
        NEXT
        FOR index = 0 TO TotalIndexes
        InterFaceObject(index).StartPoint = InterFaceObject(index).StartPoint + XMSPos&
        NEXT
        
        OPEN "objsizes.db" FOR BINARY AS #1
                SEEK #1, 1
                FOR index = 0 TO TotalMeshes
                        GET #1, , ObjectDimensions(index).Xs
                        GET #1, , ObjectDimensions(index).Ys
                        GET #1, , ObjectDimensions(index).Zs
                NEXT
        CLOSE #1
       
        CSMoveFromXMS VARSEG(WordFromXMS(0)), VARPTR(WordFromXMS(0)), XMSHandles(SHADOWS), 0, 2
        XMSPos& = 2
        SP& = 0
        TotalIndexes = WordFromXMS(0)
        FOR index = 0 TO TotalIndexes
        ShadowPrime(index).StartPoint = SP&
        CSMoveFromXMS VARSEG(WordFromXMS(0)), VARPTR(WordFromXMS(0)), XMSHandles(SHADOWS), XMSPos&, 2
        ShadowPrime(index).BytesLong = WordFromXMS(0)
        XMSPos& = XMSPos& + 2
        SP& = SP& + WordFromXMS(0)
        NEXT
        FOR index = 0 TO TotalIndexes
        ShadowPrime(index).StartPoint = ShadowPrime(index).StartPoint + XMSPos&
        NEXT
        
END SUB

SUB GenerateRadarBmps (RadarBitMap())
CSPoke16 VARSEG(RadarBitMap(0)), 0, 40
CSPoke16 VARSEG(RadarBitMap(0)), 2, 5
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 2, 0, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 1, 1, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 3, 1, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 0, 2, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 4, 2, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 1, 3, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 3, 3, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 2, 4, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 2, 1, 46
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 2, 3, 46
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 1, 2, 46
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 2, 2, 46
PixelToRadarBmap VARSEG(RadarBitMap(0)), 4, 3, 2, 46
CSPoke16 VARSEG(RadarBitMap(0)), 29, 40
CSPoke16 VARSEG(RadarBitMap(0)), 31, 5
PixelToRadarBmap VARSEG(RadarBitMap(0)), 33, 2, 1, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 33, 2, 3, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 33, 1, 2, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 33, 3, 2, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 33, 2, 2, 46
CSPoke16 VARSEG(RadarBitMap(0)), 58, 40
CSPoke16 VARSEG(RadarBitMap(0)), 60, 5
FOR index = 0 TO 4
PixelToRadarBmap VARSEG(RadarBitMap(0)), 62, index, 0, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 62, index, 4, 1
NEXT
PixelToRadarBmap VARSEG(RadarBitMap(0)), 62, 0, 1, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 62, 0, 2, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 62, 0, 3, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 62, 4, 1, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 62, 4, 2, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 62, 4, 3, 1
FOR index = 1 TO 3
PixelToRadarBmap VARSEG(RadarBitMap(0)), 62, index, 1, 29
PixelToRadarBmap VARSEG(RadarBitMap(0)), 62, index, 2, 29
PixelToRadarBmap VARSEG(RadarBitMap(0)), 62, index, 3, 29
NEXT
CSPoke16 VARSEG(RadarBitMap(0)), 87, 40
CSPoke16 VARSEG(RadarBitMap(0)), 89, 5
FOR index = 1 TO 3
PixelToRadarBmap VARSEG(RadarBitMap(0)), 91, index, 1, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 91, index, 3, 1
NEXT
PixelToRadarBmap VARSEG(RadarBitMap(0)), 91, 1, 2, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 91, 3, 2, 1
PixelToRadarBmap VARSEG(RadarBitMap(0)), 91, 2, 2, 25
END SUB

SUB GenerateTerrainColors (LevelNum)
        REDIM GroundRed(4)
        REDIM GroundGreen(4)
        REDIM GroundBlue(4)
        REDIM SkyRed(3)
        REDIM SkyGreen(3)
        REDIM SkyBlue(3)
      
SELECT CASE LevelNum
CASE 1
        AtmosphereRed = 53
        AtmosphereGreen = 48
        AtmosphereBlue = 42

        GroundRed(0) = 29
        GroundGreen(0) = 30
        GroundBlue(0) = 22
        GroundRed(1) = 16
        GroundGreen(1) = 24
        GroundBlue(1) = 8
        GroundRed(2) = 34
        GroundGreen(2) = 35
        GroundBlue(2) = 37
        GroundRed(3) = 54
        GroundGreen(3) = 55
        GroundBlue(3) = 55
        GroundRed(4) = 63
        GroundGreen(4) = 62
        GroundBlue(4) = 60

        SkyRed(0) = 44
        SkyGreen(0) = 44
        SkyBlue(0) = 44
        SkyRed(1) = 58
        SkyGreen(1) = 58
        SkyBlue(1) = 55
        SkyRed(2) = 32
        SkyGreen(2) = 32
        SkyBlue(2) = 40
        SkyRed(3) = 32
        SkyGreen(3) = 44
        SkyBlue(3) = 44

CASE 2
        AtmosphereRed = 53
        AtmosphereGreen = 48
        AtmosphereBlue = 42

        GroundRed(0) = 24
        GroundGreen(0) = 19
        GroundBlue(0) = 18
        GroundRed(1) = 35
        GroundGreen(1) = 27
        GroundBlue(1) = 23
        GroundRed(2) = 43
        GroundGreen(2) = 35
        GroundBlue(2) = 29
        GroundRed(3) = 50
        GroundGreen(3) = 44
        GroundBlue(3) = 38
        GroundRed(4) = 55
        GroundGreen(4) = 50
        GroundBlue(4) = 45

      
        SkyRed(0) = 46
        SkyGreen(0) = 47
        SkyBlue(0) = 54
        SkyRed(1) = 56
        SkyGreen(1) = 57
        SkyBlue(1) = 61
        SkyRed(2) = 36
        SkyGreen(2) = 40
        SkyBlue(2) = 56
        SkyRed(3) = 26
        SkyGreen(3) = 36
        SkyBlue(3) = 60

CASE 3
        AtmosphereRed = 53
        AtmosphereGreen = 48
        AtmosphereBlue = 42
       
        GroundRed(0) = 29
        GroundGreen(0) = 30
        GroundBlue(0) = 22
        GroundRed(1) = 18
        GroundGreen(1) = 24
        GroundBlue(1) = 10
        GroundRed(2) = 38
        GroundGreen(2) = 28
        GroundBlue(2) = 25
        GroundRed(3) = 44
        GroundGreen(3) = 38
        GroundBlue(3) = 33
        GroundRed(4) = 50
        GroundGreen(4) = 42
        GroundBlue(4) = 36
       

        SkyRed(0) = 35
        SkyGreen(0) = 29
        SkyBlue(0) = 29
        SkyRed(1) = 47
        SkyGreen(1) = 34
        SkyBlue(1) = 29
        SkyRed(2) = 52
        SkyGreen(2) = 39
        SkyBlue(2) = 34
        SkyRed(3) = 56
        SkyGreen(3) = 45
        SkyBlue(3) = 40

CASE 4
        AtmosphereRed = 0
        AtmosphereGreen = 0
        AtmosphereBlue = 0

        GroundRed(0) = 14
        GroundGreen(0) = 14
        GroundBlue(0) = 16
        GroundRed(1) = 23
        GroundGreen(1) = 23
        GroundBlue(1) = 27
        GroundRed(2) = 36
        GroundGreen(2) = 36
        GroundBlue(2) = 38
        GroundRed(3) = 49
        GroundGreen(3) = 49
        GroundBlue(3) = 51
        GroundRed(4) = 60
        GroundGreen(4) = 60
        GroundBlue(4) = 62

        SkyRed(0) = 29
        SkyGreen(0) = 29
        SkyBlue(0) = 29
        SkyRed(1) = 47
        SkyGreen(1) = 47
        SkyBlue(1) = 47
        SkyRed(2) = 52
        SkyGreen(2) = 52
        SkyBlue(2) = 52
        SkyRed(3) = 56
        SkyGreen(3) = 40
        SkyBlue(3) = 40

CASE 5
        AtmosphereRed = 52
        AtmosphereGreen = 40
        AtmosphereBlue = 38
      
        GroundRed(0) = 30
        GroundGreen(0) = 16
        GroundBlue(0) = 13
        GroundRed(1) = 40
        GroundGreen(1) = 24
        GroundBlue(1) = 20
        GroundRed(2) = 42
        GroundGreen(2) = 28
        GroundBlue(2) = 22
        GroundRed(3) = 60
        GroundGreen(3) = 40
        GroundBlue(3) = 22
        GroundRed(4) = 63
        GroundGreen(4) = 54
        GroundBlue(4) = 36
      

        SkyRed(0) = 42
        SkyGreen(0) = 29
        SkyBlue(0) = 29
        SkyRed(1) = 56
        SkyGreen(1) = 34
        SkyBlue(1) = 29
        SkyRed(2) = 62
        SkyGreen(2) = 39
        SkyBlue(2) = 34
        SkyRed(3) = 63
        SkyGreen(3) = 45
        SkyBlue(3) = 40

CASE 6
       
        AtmosphereRed = 0
        AtmosphereGreen = 0
        AtmosphereBlue = 0

        GroundRed(0) = 45
        GroundGreen(0) = 15
        GroundBlue(0) = 10
        GroundRed(1) = 20
        GroundGreen(1) = 4
        GroundBlue(1) = 0
        GroundRed(2) = 21
        GroundGreen(2) = 11
        GroundBlue(2) = 8
        GroundRed(3) = 32
        GroundGreen(3) = 24
        GroundBlue(3) = 17
        GroundRed(4) = 47
        GroundGreen(4) = 44
        GroundBlue(4) = 18

        SkyRed(0) = 29
        SkyGreen(0) = 29
        SkyBlue(0) = 29
        SkyRed(1) = 47
        SkyGreen(1) = 47
        SkyBlue(1) = 47
        SkyRed(2) = 52
        SkyGreen(2) = 52
        SkyBlue(2) = 52
        SkyRed(3) = 56
        SkyGreen(3) = 40
        SkyBlue(3) = 40

CASE 7
      
        AtmosphereRed = 0
        AtmosphereGreen = 0
        AtmosphereBlue = 0

        GroundRed(0) = 13
        GroundGreen(0) = 16
        GroundBlue(0) = 8
        GroundRed(1) = 20
        GroundGreen(1) = 23
        GroundBlue(1) = 15
        GroundRed(2) = 20
        GroundGreen(2) = 33
        GroundBlue(2) = 16
        GroundRed(3) = 43
        GroundGreen(3) = 43
        GroundBlue(3) = 32
        GroundRed(4) = 54
        GroundGreen(4) = 57
        GroundBlue(4) = 44

        SkyRed(0) = 29
        SkyGreen(0) = 29
        SkyBlue(0) = 29
        SkyRed(1) = 47
        SkyGreen(1) = 47
        SkyBlue(1) = 47
        SkyRed(2) = 52
        SkyGreen(2) = 52
        SkyBlue(2) = 52
        SkyRed(3) = 56
        SkyGreen(3) = 40
        SkyBlue(3) = 40

CASE 8
        AtmosphereRed = 0
        AtmosphereGreen = 0
        AtmosphereBlue = 0

        'GroundRed(1) = 14
        'GroundGreen(1) = 11
        'GroundBlue(1) = 10
        'GroundRed(0) = 35
        'GroundGreen(0) = 31
        'GroundBlue(0) = 29
        'GroundRed(2) = 32
        'GroundGreen(2) = 32
        'GroundBlue(2) = 32
        'GroundRed(3) = 0
        'GroundGreen(3) = 0
        'GroundBlue(3) = 0
        'GroundRed(4) = 16
        'GroundGreen(4) = 63
        'GroundBlue(4) = 63
       
        GroundRed(0) = 12
        GroundGreen(0) = 10
        GroundBlue(0) = 10
        GroundRed(1) = 40
        GroundGreen(1) = 28
        GroundBlue(1) = 10
        GroundRed(2) = 40
        GroundGreen(2) = 31
        GroundBlue(2) = 17
        GroundRed(3) = 55
        GroundGreen(3) = 39
        GroundBlue(3) = 14
        GroundRed(4) = 62
        GroundGreen(4) = 48
        GroundBlue(4) = 18

        SkyRed(0) = 29
        SkyGreen(0) = 29
        SkyBlue(0) = 29
        SkyRed(1) = 47
        SkyGreen(1) = 47
        SkyBlue(1) = 47
        SkyRed(2) = 52
        SkyGreen(2) = 52
        SkyBlue(2) = 52
        SkyRed(3) = 56
        SkyGreen(3) = 40
        SkyBlue(3) = 40



END SELECT

        CSSetCol 160, AtmosphereRed, AtmosphereGreen, AtmosphereBlue
        CSSetCol 164, GroundRed(0), GroundGreen(0), GroundBlue(0)
        CSSetCol 176, GroundRed(1), GroundGreen(1), GroundBlue(1)
        CSSetCol 184, GroundRed(2), GroundGreen(2), GroundBlue(2)
        CSSetCol 208, GroundRed(3), GroundGreen(3), GroundBlue(3)
        CSSetCol 223, GroundRed(4), GroundGreen(4), GroundBlue(4)
        CSSetCol 224, AtmosphereRed, AtmosphereGreen, AtmosphereBlue
        CSSetCol 240, SkyRed(0), SkyGreen(0), SkyBlue(0)
        CSSetCol 246, SkyRed(1), SkyGreen(1), SkyBlue(1)
        CSSetCol 252, SkyRed(2), SkyGreen(2), SkyBlue(2)
        CSSetCol 255, SkyRed(3), SkyGreen(3), SkyBlue(3)
        CSGradientPal 160, 164
        CSGradientPal 164, 176
        CSGradientPal 176, 184
        CSGradientPal 184, 208
        CSGradientPal 208, 223
        CSGradientPal 224, 240
        CSGradientPal 240, 246
        CSGradientPal 246, 252
        CSGradientPal 252, 255

CSSetCol 128, 0, 0, 0'AtmosphereRed, AtmosphereGreen, AtmosphereBlue
'CSSetCol 129, 28, 16, 0
CSSetCol 136, 63, 32, 0
CSSetCol 148, 63, 52, 16
CSSetCol 152, 63, 63, 44
CSSetCol 159, 63, 63, 63
'CSSetCol 136, 63, 32, 0
'CSSetCol 148, 63, 52, 16
'CSSetCol 152, 63, 63, 44
'CSSetCol 159, 63, 63, 63

CSGradientPal 128, 136
CSGradientPal 136, 148
CSGradientPal 148, 152
CSGradientPal 152, 159


END SUB

SUB GenerateTexTable (TextureTable&(), Level)
TexPointer& = 0
TextureTable&(0) = TexPointer&
TexPointer& = TexPointer& + 16400
TextureTable&(1) = TexPointer&
TextureTable&(2) = TexPointer&
TextureTable&(3) = TexPointer&
TextureTable&(4) = TexPointer&
TextureTable&(5) = TexPointer&

FOR index = 6 TO 94
TexPointer& = TexPointer& + 16400
TextureTable&(index) = TexPointer&
NEXT
SELECT CASE Level
CASE 2
TextureTable&(18) = TextureTable&(30)
CASE 3
TextureTable&(18) = TextureTable&(40)
CASE 4
TextureTable&(18) = TextureTable&(51)
CASE 5
TextureTable&(18) = TextureTable&(63)
CASE 6
TextureTable&(18) = TextureTable&(75)
CASE 7
TextureTable&(18) = TextureTable&(86)
CASE 8
TextureTable&(18) = TextureTable&(94)
END SELECT

END SUB

FUNCTION GetAmmoTag (Weapon)
SELECT CASE Weapon
        CASE PULSELASER
                GetAmmoTag = 0
        CASE ION
                GetAmmoTag = 1
        CASE TLA
                GetAmmoTag = 2
        CASE PLASMA
                GetAmmoTag = 3
        CASE MISSILE
                GetAmmoTag = 4
        CASE SEEKMISSILE
                GetAmmoTag = 5
        CASE ACM
                GetAmmoTag = 6
END SELECT
END FUNCTION

FUNCTION GetDistance& (X1&, Y1&, Z1&, X2&, Y2&, Z2&)
DirectionVector(0).X = X1& - X2&
DirectionVector(0).Y = Y1& - Y2&
DirectionVector(0).Z = Z1& - Z2&
DotProduct1! = CSVectorDot!(VARSEG(DirectionVector(0).X), VARPTR(DirectionVector(0).X), VARSEG(DirectionVector(0).X), VARPTR(DirectionVector(0).X))
Dist! = SQR(DotProduct1!)
Distance& = ABS(CLNG(Dist!))
GetDistance& = Distance&
END FUNCTION

FUNCTION GetGroundY% (BumpMap&(), X&, Z&)
xx& = X& MOD 65536
zz& = Z& MOD 65536
IF xx& < 0 THEN xx& = 65536 + xx&
IF zz& < 0 THEN zz& = 65536 + zz&
xx& = xx& \ 256
zz& = zz& \ 256
AltByte = CSPeek(VARSEG(BumpMap&(0)), zz& * 256 + xx&) \ 2
GetGroundY% = 5000 - (AltByte * 175)
END FUNCTION

SUB Glow STATIC
IF FirstRun = 0 THEN
        GlowPos = 16
        FirstRun = 1
        REDIM GroundRed(1)
        REDIM GroundGreen(1)
        REDIM GroundBlue(1)
        GroundRed(0) = 63
        GroundBlue(0) = 0
        GlowWay = 0
        CSGetCol 176, GroundRed(1), GroundGreen(1), GroundBlue(1)
END IF
IF GlowWay = 0 THEN GlowPos = GlowPos + 1 ELSE GlowPos = GlowPos - 1
IF GlowPos = 32 THEN GlowWay = 1
IF GlowPos = 16 THEN GlowWay = 0
GroundGreen(0) = GlowPos
       
CSSetCol 163, GroundRed(0) / 3, GroundGreen(0) / 3, 0
CSSetCol 164, GroundRed(0) / 2.5, GroundGreen(0) / 2.5, 0
CSSetCol 170, GroundRed(0), GroundGreen(0), GroundBlue(0)
CSSetCol 176, GroundRed(1), GroundGreen(1), GroundBlue(1)
CSGradientPal 160, 163
CSGradientPal 164, 170
CSGradientPal 170, 176
END SUB

SUB HorizonBall (UPPERLAYER&(), Pitch, PlayerX&, PlayerY&, PlayerZ&, BumpMap&())
CSLine VARSEG(UPPERLAYER&(0)), 22, 27, 30, 27, 32
CSLine VARSEG(UPPERLAYER&(0)), 22, 39, 30, 39, 32
CSLine VARSEG(UPPERLAYER&(0)), 15, 33, 37, 33, 34
CSLine VARSEG(UPPERLAYER&(0)), 14, 32, 14, 34, 35
CSLine VARSEG(UPPERLAYER&(0)), 38, 32, 38, 34, 34
Ydiffer = Pitch / 3
CSLine VARSEG(UPPERLAYER&(0)), 26, 33 + Ydiffer, 26, 33, 35
CSLine VARSEG(UPPERLAYER&(0)), 22, 33 + Ydiffer, 30, 33 + Ydiffer, 34
CSLine VARSEG(UPPERLAYER&(0)), 22, 33 + Ydiffer, 26, 33 + (Ydiffer + 2), 36
CSLine VARSEG(UPPERLAYER&(0)), 22, 33 + Ydiffer, 26, 33 + (Ydiffer - 2), 37
CSLine VARSEG(UPPERLAYER&(0)), 30, 33 + Ydiffer, 26, 33 + (Ydiffer + 2), 38
CSLine VARSEG(UPPERLAYER&(0)), 30, 33 + Ydiffer, 26, 33 + (Ydiffer - 2), 39
HeightDifference& = PlayerY& - GetGroundY(BumpMap&(), PlayerX&, PlayerZ&)

IF HeightDifference& < 8208 THEN
        Ydiffer = HeightDifference& \ 684
CSLine VARSEG(UPPERLAYER&(0)), 26, 33 + Ydiffer, 26, 45, 22
CSLine VARSEG(UPPERLAYER&(0)), 24, 33 + Ydiffer, 28, 33 + Ydiffer, 24
CSPset VARSEG(UPPERLAYER&(0)), 24, 33 + Ydiffer, 75
CSPset VARSEG(UPPERLAYER&(0)), 28, 33 + Ydiffer, 19
END IF
END SUB

SUB InitBlendMaps (RadarBlendMap(), ShadowBlendMap(), TransBlendMap())
FOR index = 0 TO 255
        CSGetCol index, r, g, b
        ColorBalance = (r + g + b) / 3
        ColorBalance = ColorBalance / 8
        CSPoke VARSEG(RadarBlendMap(0)), index, 32 + ColorBalance
NEXT
FOR index = 0 TO 159
        CSPoke VARSEG(ShadowBlendMap(0)), index, index
NEXT
FOR index = 160 TO 255
        CSGetCol index, r, g, b
        ColorBalance = (r + g + b) / 3
        ColorBalance = ColorBalance / 6.5
        CSPoke VARSEG(ShadowBlendMap(0)), index, ColorBalance
NEXT
FOR index = 0 TO 255
        SELECT CASE index
        CASE 0 TO 15
        cv = index - 6
        IF cv < 0 THEN cv = 0
        CASE 16 TO 31
        cv = index - 6
        IF cv < 16 THEN cv = 16
        CASE 32 TO 47
        cv = index - 6
        IF cv < 32 THEN cv = 32
        CASE 48 TO 63
        cv = index - 6
        IF cv < 48 THEN cv = 48
        cv = index - 6
        IF cv < 0 THEN cv = 0
        CASE 64 TO 71
        cv = index - 3
        IF cv < 64 THEN cv = 64
        CASE 72 TO 79
        cv = index - 3
        IF cv < 72 THEN cv = 72
        CASE 80 TO 95
        cv = index - 6
        IF cv < 80 THEN cv = 80
        CASE 96 TO 103
        cv = index - 3
        IF cv < 96 THEN cv = 96
        CASE 104 TO 111
        cv = index - 3
        IF cv < 104 THEN cv = 104
        CASE 112 TO 127
        cv = index - 6
        IF cv < 112 THEN cv = 112
        CASE 128 TO 159
        cv = index - 12
        IF cv < 128 THEN cv = 128
        CASE 160 TO 223
        cv = 160 + (index - 160) / 2
        CASE ELSE
        cv = 224 + (index - 224) / 2
        END SELECT
CSPoke VARSEG(TransBlendMap(0)), index, cv
NEXT
END SUB

SUB InitializeMessage (SEEDVALUE, BigMessage, BigMessageTime)
        SoundInterFace 2, 26, 0, 0, 0
        BigMessageTime = 0
        BigMessage = SEEDVALUE
END SUB

FUNCTION LoadSaveMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandles(), InterFaceObject() AS InterfaceBitMap, VideoPage, LoadSave)
REDIM SaveActive(4)
REDIM SaveFull(4)
REDIM SaveLevel(4)
REDIM SaveSkill(4)
CSMoveFromXMS VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0)), XMSHandles(GROUNDTEXTURE), 66000, 64000
SELECT CASE LoadSave
CASE 1
HeaderChunk = 55
CASE 2
HeaderChunk = 56
END SELECT
FileHandle = FREEFILE
        OPEN "qsave.db" FOR BINARY AS FileHandle
        FOR index = 0 TO 4
        GET FileHandle, , SaveFull(index)
        GET FileHandle, , SaveLevel(index)
        GET FileHandle, , SaveSkill(index)
        GET FileHandle, , DummyVar
        GET FileHandle, , DummyVar
        GET FileHandle, , DummyVar
        GET FileHandle, , DummyVar
        GET FileHandle, , DummyVar
        GET FileHandle, , DummyVar
        GET FileHandle, , DummyVar
        NEXT
        CLOSE FileHandle
        CursorPosition = 1
        GOSUB UpdateSaveScreen
WaitTicks 12
DO
        IF CSKey(&H48) THEN
        CursorPosition = CursorPosition - 1
        IF CursorPosition = 0 THEN CursorPosition = 5
        GOSUB UpdateSaveScreen
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
        END IF
        IF CSKey(&H50) THEN
        CursorPosition = CursorPosition + 1
        IF CursorPosition = 6 THEN CursorPosition = 1
        SoundInterFace 2, 28, 0, 0, 0
        GOSUB UpdateSaveScreen
        WaitTicks 3
        END IF
        IF CSKey(&H1C) THEN
        SoundInterFace 2, 29, 0, 0, 0
        IF LoadSave = 2 AND SaveFull(CursorPosition - 1) = 0 THEN ReturnValue = 0 ELSE ReturnValue = CursorPosition
        GOTO Leave
        END IF
        IF CSKey(1) THEN
        SoundInterFace 2, 30, 0, 0, 0
        ReturnValue = 0
        GOTO Leave
        END IF
LOOP
UpdateSaveScreen:
        SaveActive(0) = FALSE
        SaveActive(1) = FALSE
        SaveActive(2) = FALSE
        SaveActive(3) = FALSE
        SaveActive(4) = FALSE
        SaveActive(CursorPosition - 1) = TRUE
       
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(HeaderChunk).StartPoint, InterFaceObject(HeaderChunk).BytesLong
        Xlen = CSPeek16(VARSEG(XMSCache&(0)), 0) \ 16
        Xpos = 160 - Xlen
        CSSprite VARSEG(UPPERLAYER&(0)), Xpos, 12, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
Ypos = 48
FOR index = 0 TO 4
        SELECT CASE SaveActive(index)
        CASE TRUE
        Addition = 0
        CASE FALSE
        Addition = 1
        END SELECT
       
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(57 + index * 2 + Addition).StartPoint, InterFaceObject(57 + index * 2 + Addition).BytesLong
        CSSprite VARSEG(UPPERLAYER&(0)), 32, Ypos, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
              
                IF SaveFull(index) = 0 THEN
                CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(67 + Addition).StartPoint, InterFaceObject(67 + Addition).BytesLong
                CSSprite VARSEG(UPPERLAYER&(0)), 98, Ypos, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
                ELSE
                CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(69 + (SaveLevel(index) - 1) * 2 + Addition).StartPoint, InterFaceObject(69 + (SaveLevel(index) - 1) * 2 + Addition).BytesLong
                CSSprite VARSEG(UPPERLAYER&(0)), 98, Ypos, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
                CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(85 + (SaveSkill(index) - 1) * 2 + Addition).StartPoint, InterFaceObject(85 + (SaveSkill(index) - 1) * 2 + Addition).BytesLong
                CSSprite VARSEG(UPPERLAYER&(0)), 178, Ypos, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
                END IF

Ypos = Ypos + 26
NEXT
        VideoPage = VideoPage + 1
        ShowOffscreen VideoPage, UPPERLAYER&(), LOWERLAYER&()
        IF VideoPage = 2 THEN VideoPage = 0
RETURN
Leave:
CSMoveFromXMS VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0)), XMSHandles(GROUNDTEXTURE), 66000, 64000
LoadSaveMenu = ReturnValue
END FUNCTION

SUB LongRangeRadar (GameObject() AS Object, UPPERLAYER&(), LOWERLAYER&(), RadarBlendMap(), RadarBitMap(), Sine!(), Cosine!())
REDIM DirectionArrowVector(3) AS Vector2DType
        DirectionArrowVector(0).X = 0
        DirectionArrowVector(0).Y = -15
        DirectionArrowVector(1).X = -5
        DirectionArrowVector(1).Y = 10
        DirectionArrowVector(2).X = 0
        DirectionArrowVector(2).Y = 5
        DirectionArrowVector(3).X = 5
        DirectionArrowVector(3).Y = 10
CSLine VARSEG(LOWERLAYER&(0)), 1, 0, 318, 0, 4
CSLine VARSEG(LOWERLAYER&(0)), 1, 40, 318, 40, 4
CSLine VARSEG(LOWERLAYER&(0)), 1, 80, 318, 80, 4
CSLine VARSEG(LOWERLAYER&(0)), 1, 120, 318, 120, 4
CSLine VARSEG(LOWERLAYER&(0)), 0, 0, 0, 139, 4
CSLine VARSEG(LOWERLAYER&(0)), 63, 0, 63, 139, 4
CSLine VARSEG(LOWERLAYER&(0)), 127, 0, 127, 139, 4
CSLine VARSEG(LOWERLAYER&(0)), 191, 0, 191, 139, 4
CSLine VARSEG(LOWERLAYER&(0)), 255, 0, 255, 139, 4
CSLine VARSEG(LOWERLAYER&(0)), 319, 0, 319, 139, 4
CSLine VARSEG(UPPERLAYER&(0)), 1, 0, 318, 0, 4
CSLine VARSEG(UPPERLAYER&(0)), 1, 40, 318, 40, 4
CSLine VARSEG(UPPERLAYER&(0)), 1, 80, 318, 80, 4
CSLine VARSEG(UPPERLAYER&(0)), 1, 120, 318, 120, 4
CSLine VARSEG(UPPERLAYER&(0)), 1, 160, 318, 160, 4
CSLine VARSEG(UPPERLAYER&(0)), 0, 0, 0, 199, 4
CSLine VARSEG(UPPERLAYER&(0)), 63, 0, 63, 199, 4
CSLine VARSEG(UPPERLAYER&(0)), 127, 0, 127, 199, 4
CSLine VARSEG(UPPERLAYER&(0)), 191, 0, 191, 199, 4
CSLine VARSEG(UPPERLAYER&(0)), 255, 0, 255, 199, 4
CSLine VARSEG(UPPERLAYER&(0)), 319, 0, 319, 199, 4
     
       
        FOR index = 1 TO 379
                IF GameObject(index).ObjectType THEN
                RadarNode = 0
                xfrag& = GameObject(index).X - GameObject(0).X
                zfrag& = GameObject(0).Z - GameObject(index).Z
                Xscreen = 160 - (xfrag& \ 1024)
                Yscreen = 200 - (zfrag& \ 1024)
                IF Xscreen > -2 AND Xscreen < 320 AND Yscreen > -2 AND Yscreen < 335 THEN
                        IF GameObject(index).AIScript = FIGHTER OR GameObject(index).AIScript = HELICOPTER OR GameObject(index).AIScript = TRANSPORT THEN
                                IF GameObject(index).Y < PlayerY THEN RadarNode = AIRTARGETBELOW ELSE RadarNode = AIRTARGETABOVE
                        ELSEIF GameObject(index).AIScript = FLAKCANNON THEN
                                RadarNode = FLAKCANNON
                        ELSEIF GameObject(index).ExtraFlag8 = BUILDING THEN
                                RadarNode = BUILDING
                        END IF
                END IF
                        SELECT CASE RadarNode
                        CASE AIRTARGETABOVE
                        CSSprite VARSEG(UPPERLAYER&(0)), Xscreen, Yscreen, VARSEG(RadarBitMap(0)), 0
                        CSSprite VARSEG(LOWERLAYER&(0)), Xscreen, Yscreen - 200, VARSEG(RadarBitMap(0)), 0
                        CASE AIRTARGETBELOW
                        CSSprite VARSEG(UPPERLAYER&(0)), Xscreen, Yscreen, VARSEG(RadarBitMap(0)), 29
                        CSSprite VARSEG(LOWERLAYER&(0)), Xscreen, Yscreen - 200, VARSEG(RadarBitMap(0)), 29
                        CASE FLAKCANNON
                        CSSprite VARSEG(UPPERLAYER&(0)), Xscreen, Yscreen, VARSEG(RadarBitMap(0)), 87
                        CSSprite VARSEG(LOWERLAYER&(0)), Xscreen, Yscreen - 200, VARSEG(RadarBitMap(0)), 87
                        CASE BUILDING
                        CSSprite VARSEG(UPPERLAYER&(0)), Xscreen, Yscreen, VARSEG(RadarBitMap(0)), 58
                        CSSprite VARSEG(LOWERLAYER&(0)), Xscreen, Yscreen - 200, VARSEG(RadarBitMap(0)), 58
                        END SELECT
                END IF
                NEXT
        RotationAngle = (CINT((CSNG(GameObject(0).HeadXZ) / 3.55555)) + 360) MOD 360
        FOR index = 0 TO 3
                Dx! = CSNG(DirectionArrowVector(index).X)
                Dy! = CSNG(DirectionArrowVector(index).Y)
                DirectionArrowVector(index).X = 160 + CINT(Dx! * Cosine!(RotationAngle) - Dy! * Sine!(RotationAngle))
                DirectionArrowVector(index).Y = 200 + CINT(Dy! * Cosine!(RotationAngle) + Dx! * Sine!(RotationAngle)) * 2
        NEXT
        GreenScreen VARSEG(LOWERLAYER&(0)), VARSEG(UPPERLAYER&(0)), VARSEG(RadarBlendMap(0))
        CSTriG VARSEG(UPPERLAYER&(0)), DirectionArrowVector(0).X, DirectionArrowVector(0).Y, 33, DirectionArrowVector(1).X, DirectionArrowVector(1).Y, 37, DirectionArrowVector(2).X, DirectionArrowVector(2).Y, 41
        CSTriG VARSEG(UPPERLAYER&(0)), DirectionArrowVector(0).X, DirectionArrowVector(0).Y, 33, DirectionArrowVector(3).X, DirectionArrowVector(3).Y, 37, DirectionArrowVector(2).X, DirectionArrowVector(2).Y, 41
        DirectionArrowVector(0).Y = DirectionArrowVector(0).Y - 200
        DirectionArrowVector(1).Y = DirectionArrowVector(1).Y - 200
        DirectionArrowVector(2).Y = DirectionArrowVector(2).Y - 200
        DirectionArrowVector(3).Y = DirectionArrowVector(3).Y - 200
        CSTriG VARSEG(LOWERLAYER&(0)), DirectionArrowVector(0).X, DirectionArrowVector(0).Y, 33, DirectionArrowVector(1).X, DirectionArrowVector(1).Y, 37, DirectionArrowVector(2).X, DirectionArrowVector(2).Y, 41
        CSTriG VARSEG(LOWERLAYER&(0)), DirectionArrowVector(0).X, DirectionArrowVector(0).Y, 33, DirectionArrowVector(3).X, DirectionArrowVector(3).Y, 37, DirectionArrowVector(2).X, DirectionArrowVector(2).Y, 41
       

END SUB

SUB MellowColors
FOR index = 0 TO 255
CSGetCol index, Red, Green, Blue
GrayValue = (Red + Green + Blue) / 3
TotalRed = (Red * 1.9 + GrayValue * 1.1) / 3
TotalGreen = (Green * 1.9 + GrayValue * 1.1) / 3
TotalBlue = (Blue * 1.9 + GrayValue * 1.1) / 3
CSSetCol index, TotalRed, TotalGreen, TotalBlue
NEXT
END SUB

SUB PixelToRadarBmap (Segment, Offset, X, Y, Col)
CSPoke Segment, (Y * 5 + X) + Offset, Col
END SUB

SUB RemoveMissionNode (MissionPath() AS MissionType, TargetSpot)
FOR index = (TargetSpot + 1) TO 31
        MissionPath(index - 1).Node = MissionPath(index).Node
        MissionPath(index - 1).NodeHook = MissionPath(index).NodeHook
NEXT
        MissionPath(31).Node = 0
        MissionPath(31).NodeHook = 0
END SUB

SUB Render3DObject (Xtrans&, Ytrans, Ztrans&, xrotAngle, yRotAngle, zRotAngle, ObjectPolyCount, ObjectMesh() AS ObjectPolygon, VisibleObjectMesh() AS VisiblePolygon, Fogged, TextureMap&(), BlenderMap(), Sine!(), Cosine!(), UPPERLAYER&(),  _
LOWERLAYER&())
ZEye = -750

REDIM TMatrix!(3, 3), Matrix!(3, 3)
REDIM ObjectFaceVector(0) AS Vector3DType
REDIM ObjectPolyFaces(2) AS Vector3DType
REDIM ObjectPolyScreenCoords(2) AS Vector2DType

CSIdentityMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0))
CSInitRotYMatrix VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0)), Cosine!(yRotAngle), Sine!(yRotAngle)
CSMatrixMulMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0))
CSInitRotXMatrix VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0)), Cosine!(xrotAngle), Sine!(xrotAngle)
CSMatrixMulMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0))
CSInitRotZMatrix VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0)), Cosine!(zRotAngle), Sine!(zRotAngle)
CSMatrixMulMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0))

FOR index = 0 TO ObjectPolyCount - 1
                ObjectFaceVector(0).X = ObjectMesh(index).X1
                ObjectFaceVector(0).Y = ObjectMesh(index).Y1
                ObjectFaceVector(0).Z = ObjectMesh(index).Z1
                CSVectorMulMatrix VARSEG(ObjectFaceVector(0).X), VARPTR(ObjectFaceVector(0).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(0).X), VARPTR(ObjectPolyFaces(0).X)
                ObjectMesh(index).X1 = ObjectPolyFaces(0).X
                ObjectMesh(index).Y1 = ObjectPolyFaces(0).Y * 2
                ObjectMesh(index).Z1 = ObjectPolyFaces(0).Z
                ObjectFaceVector(0).X = ObjectMesh(index).X2
                ObjectFaceVector(0).Y = ObjectMesh(index).Y2
                ObjectFaceVector(0).Z = ObjectMesh(index).Z2
                CSVectorMulMatrix VARSEG(ObjectFaceVector(0).X), VARPTR(ObjectFaceVector(0).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(1).X), VARPTR(ObjectPolyFaces(1).X)
                ObjectMesh(index).X2 = ObjectPolyFaces(1).X
                ObjectMesh(index).Y2 = ObjectPolyFaces(1).Y * 2
                ObjectMesh(index).Z2 = ObjectPolyFaces(1).Z
                ObjectFaceVector(0).X = ObjectMesh(index).X3
                ObjectFaceVector(0).Y = ObjectMesh(index).Y3
                ObjectFaceVector(0).Z = ObjectMesh(index).Z3
                CSVectorMulMatrix VARSEG(ObjectFaceVector(0).X), VARPTR(ObjectFaceVector(0).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(2).X), VARPTR(ObjectPolyFaces(2).X)
                ObjectMesh(index).X3 = ObjectPolyFaces(2).X
                ObjectMesh(index).Y3 = ObjectPolyFaces(2).Y * 2
                ObjectMesh(index).Z3 = ObjectPolyFaces(2).Z
NEXT

        CSIdentityMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0))
        CSInitTransMatrix VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0)), CSNG(Xtrans&), CSNG(Ytrans), CSNG(Ztrans&)
        CSMatrixMulMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0))
        Visibles = 0
                FOR index = 0 TO ObjectPolyCount - 1
                ObjectFaceVector(0).X = ObjectMesh(index).X1
                ObjectFaceVector(0).Y = ObjectMesh(index).Y1
                ObjectFaceVector(0).Z = ObjectMesh(index).Z1
                CSVectorMulMatrix VARSEG(ObjectFaceVector(0).X), VARPTR(ObjectFaceVector(0).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(0).X), VARPTR(ObjectPolyFaces(0).X)
                ObjectFaceVector(0).X = ObjectMesh(index).X2
                ObjectFaceVector(0).Y = ObjectMesh(index).Y2
                ObjectFaceVector(0).Z = ObjectMesh(index).Z2
                CSVectorMulMatrix VARSEG(ObjectFaceVector(0).X), VARPTR(ObjectFaceVector(0).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(1).X), VARPTR(ObjectPolyFaces(1).X)
                ObjectFaceVector(0).X = ObjectMesh(index).X3
                ObjectFaceVector(0).Y = ObjectMesh(index).Y3
                ObjectFaceVector(0).Z = ObjectMesh(index).Z3
                CSVectorMulMatrix VARSEG(ObjectFaceVector(0).X), VARPTR(ObjectFaceVector(0).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(2).X), VARPTR(ObjectPolyFaces(2).X)
                PPProjectVector VARSEG(ObjectPolyFaces(0).X), VARPTR(ObjectPolyFaces(0).X), VARSEG(ObjectPolyScreenCoords(0).X), VARPTR(ObjectPolyScreenCoords(0).X), ZEye
                PPProjectVector VARSEG(ObjectPolyFaces(1).X), VARPTR(ObjectPolyFaces(1).X), VARSEG(ObjectPolyScreenCoords(1).X), VARPTR(ObjectPolyScreenCoords(1).X), ZEye
                PPProjectVector VARSEG(ObjectPolyFaces(2).X), VARPTR(ObjectPolyFaces(2).X), VARSEG(ObjectPolyScreenCoords(2).X), VARPTR(ObjectPolyScreenCoords(2).X), ZEye
             
                IF ObjectMesh(index).TwoSided <> 1 THEN
                Visibility = CSPolyFacing(VARSEG(ObjectPolyScreenCoords(0).X), VARPTR(ObjectPolyScreenCoords(0).X), VARSEG(ObjectPolyScreenCoords(1).X), VARPTR(ObjectPolyScreenCoords(1).X), VARSEG(ObjectPolyScreenCoords(2).X), VARPTR( _
ObjectPolyScreenCoords(2).X))
                IF ObjectMesh(index).FlippedNormals THEN Visibility = -Visibility
                ELSE
                Visibility = 1
                END IF
              
                IF Visibility > 0 THEN
                VisibleObjectMesh(Visibles).X1 = ObjectPolyScreenCoords(0).X
                VisibleObjectMesh(Visibles).Y1 = ObjectPolyScreenCoords(0).Y
                VisibleObjectMesh(Visibles).X2 = ObjectPolyScreenCoords(1).X
                VisibleObjectMesh(Visibles).Y2 = ObjectPolyScreenCoords(1).Y
                VisibleObjectMesh(Visibles).X3 = ObjectPolyScreenCoords(2).X
                VisibleObjectMesh(Visibles).Y3 = ObjectPolyScreenCoords(2).Y
                VisibleObjectMesh(Visibles).Shade = ObjectMesh(index).Shade
                VisibleObjectMesh(Visibles).AvgZ = CINT((ObjectPolyFaces(0).Z + ObjectPolyFaces(1).Z + ObjectPolyFaces(2).Z) / 3)
                Visibles = Visibles + 1
                END IF
              
                NEXT
                IF Fogged = FALSE THEN
                SortFaces VARSEG(VisibleObjectMesh(0).X1), Visibles
                FOR index = 0 TO Visibles - 1
                        trip1x = VisibleObjectMesh(index).X1' + Xtrans
                        trip2x = VisibleObjectMesh(index).X2' + Xtrans
                        trip3x = VisibleObjectMesh(index).X3' + Xtrans
                        trip1y = VisibleObjectMesh(index).Y1' * 2
                        trip2y = VisibleObjectMesh(index).Y2' * 2
                        trip3y = VisibleObjectMesh(index).Y3' * 2
                IF VisibleObjectMesh(index).Shade <> 0 THEN
                        IF VisibleObjectMesh(index).Shade > 15 THEN
                                U1% = 0: V1% = 0
                                U2% = 63: V2% = 0
                                U3% = 63: V3% = 63
                                TexturePointer = VisibleObjectMesh(index).Shade - 16
                                ELSE
                                U1% = 0: V1% = 0
                                U2% = 63: V2% = 63
                                U3% = 0: V3% = 63
                                TexturePointer = VisibleObjectMesh(index).Shade - 1
                        END IF
                                                              
                        IF trip1y < 200 AND trip2y < 200 AND trip3y < 200 THEN
                        CSTriT VARSEG(UPPERLAYER&(0)), trip1x, trip1y, trip2x, trip2y, trip3x, trip3y, U1%, V1%, U2%, V2%, U3%, V3%, VARSEG(TextureMap&(0)), TexturePointer * 4100
                        ELSEIF trip1y > 200 AND trip2y > 200 AND trip3y > 200 THEN
                        CSTriT VARSEG(LOWERLAYER&(0)), trip1x, trip1y - 200, trip2x, trip2y - 200, trip3x, trip3y - 200, U1%, V1%, U2%, V2%, U3%, V3%, VARSEG(TextureMap&(0)), TexturePointer * 4100
                        ELSE
                        CSTriT VARSEG(UPPERLAYER&(0)), trip1x, trip1y, trip2x, trip2y, trip3x, trip3y, U1%, V1%, U2%, V2%, U3%, V3%, VARSEG(TextureMap&(0)), TexturePointer * 4100
                        CSTriT VARSEG(LOWERLAYER&(0)), trip1x, trip1y - 200, trip2x, trip2y - 200, trip3x, trip3y - 200, U1%, V1%, U2%, V2%, U3%, V3%, VARSEG(TextureMap&(0)), TexturePointer * 4100
                        END IF
                ELSE
                        IF trip1y < 200 AND trip2y < 200 AND trip3y < 200 THEN
                        PPBlendTri VARSEG(UPPERLAYER&(0)), trip1x, trip1y, trip2x, trip2y, trip3x, trip3y, VARSEG(BlenderMap(0))
                        ELSEIF trip1y > 200 AND trip2y > 200 AND trip3y > 200 THEN
                        PPBlendTri VARSEG(LOWERLAYER&(0)), trip1x, trip1y - 200, trip2x, trip2y - 200, trip3x, trip3y - 200, VARSEG(BlenderMap(0))
                        ELSE
                        PPBlendTri VARSEG(UPPERLAYER&(0)), trip1x, trip1y, trip2x, trip2y, trip3x, trip3y, VARSEG(BlenderMap(0))
                        PPBlendTri VARSEG(LOWERLAYER&(0)), trip1x, trip1y - 200, trip2x, trip2y - 200, trip3x, trip3y - 200, VARSEG(BlenderMap(0))
                        END IF
               
                END IF
                NEXT
        ELSE
                FOR index = 0 TO Visibles - 1
                        trip1x = VisibleObjectMesh(index).X1 + Xtrans
                        trip2x = VisibleObjectMesh(index).X2 + Xtrans
                        trip3x = VisibleObjectMesh(index).X3 + Xtrans
                        trip1y = VisibleObjectMesh(index).Y1
                        trip2y = VisibleObjectMesh(index).Y2
                        trip3y = VisibleObjectMesh(index).Y3
                                                             
                        IF trip1y < 200 AND trip2y < 200 AND trip3y < 200 THEN
                        CSTriF VARSEG(UPPERLAYER&(0)), trip1x, trip1y, trip2x, trip2y, trip3x, trip3y, 162
                        ELSEIF trip1y > 200 AND trip2y > 200 AND trip3y > 200 THEN
                        CSTriF VARSEG(LOWERLAYER&(0)), trip1x, trip1y - 200, trip2x, trip2y - 200, trip3x, trip3y - 200, 162
                        ELSE
                        CSTriF VARSEG(UPPERLAYER&(0)), trip1x, trip1y, trip2x, trip2y, trip3x, trip3y, 162
                        CSTriF VARSEG(LOWERLAYER&(0)), trip1x, trip1y - 200, trip2x, trip2y - 200, trip3x, trip3y - 200, 162
                        END IF
                NEXT
                END IF
END SUB

SUB RenderShadow (Xtrans&, Ytrans, Ztrans&, yRotAngle, ObjectPolyCount, ObjectMesh() AS ObjectPolygon, VisibleObjectMesh() AS VisiblePolygon, Sine!(), Cosine!(), BlenderMap(), LOWERLAYER&())
ZEye = -750
REDIM TMatrix!(3, 3), Matrix!(3, 3)
REDIM ObjectFaceVector(0) AS Vector3DType
REDIM ObjectPolyFaces(2) AS Vector3DType
REDIM ObjectPolyScreenCoords(2) AS Vector2DType
       
        CSIdentityMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0))
        CSInitTransMatrix VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0)), Xtrans&, Ytrans / 2, Ztrans&
        CSMatrixMulMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0))
        CSInitRotYMatrix VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0)), Cosine!(yRotAngle), Sine!(yRotAngle)
        CSMatrixMulMatrix VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(Matrix!(0, 0)), VARPTR(Matrix!(0, 0))
        Visibles = 0
                FOR index = 0 TO ObjectPolyCount - 1
                ObjectFaceVector(0).X = ObjectMesh(index).X1
                ObjectFaceVector(0).Y = ObjectMesh(index).Y1
                ObjectFaceVector(0).Z = ObjectMesh(index).Z1
                CSVectorMulMatrix VARSEG(ObjectFaceVector(0).X), VARPTR(ObjectFaceVector(0).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(0).X), VARPTR(ObjectPolyFaces(0).X)
                ObjectFaceVector(0).X = ObjectMesh(index).X2
                ObjectFaceVector(0).Y = ObjectMesh(index).Y2
                ObjectFaceVector(0).Z = ObjectMesh(index).Z2
                CSVectorMulMatrix VARSEG(ObjectFaceVector(0).X), VARPTR(ObjectFaceVector(0).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(1).X), VARPTR(ObjectPolyFaces(1).X)
                ObjectFaceVector(0).X = ObjectMesh(index).X3
                ObjectFaceVector(0).Y = ObjectMesh(index).Y3
                ObjectFaceVector(0).Z = ObjectMesh(index).Z3
                CSVectorMulMatrix VARSEG(ObjectFaceVector(0).X), VARPTR(ObjectFaceVector(0).X), VARSEG(TMatrix!(0, 0)), VARPTR(TMatrix!(0, 0)), VARSEG(ObjectPolyFaces(2).X), VARPTR(ObjectPolyFaces(2).X)
                CSProjectVector VARSEG(ObjectPolyFaces(0).X), VARPTR(ObjectPolyFaces(0).X), VARSEG(ObjectPolyScreenCoords(0).X), VARPTR(ObjectPolyScreenCoords(0).X), ZEye
                CSProjectVector VARSEG(ObjectPolyFaces(1).X), VARPTR(ObjectPolyFaces(1).X), VARSEG(ObjectPolyScreenCoords(1).X), VARPTR(ObjectPolyScreenCoords(1).X), ZEye
                CSProjectVector VARSEG(ObjectPolyFaces(2).X), VARPTR(ObjectPolyFaces(2).X), VARSEG(ObjectPolyScreenCoords(2).X), VARPTR(ObjectPolyScreenCoords(2).X), ZEye
                VisibleObjectMesh(Visibles).X1 = ObjectPolyScreenCoords(0).X
                VisibleObjectMesh(Visibles).Y1 = ObjectPolyScreenCoords(0).Y
                VisibleObjectMesh(Visibles).X2 = ObjectPolyScreenCoords(1).X
                VisibleObjectMesh(Visibles).Y2 = ObjectPolyScreenCoords(1).Y
                VisibleObjectMesh(Visibles).X3 = ObjectPolyScreenCoords(2).X
                VisibleObjectMesh(Visibles).Y3 = ObjectPolyScreenCoords(2).Y
                VisibleObjectMesh(Visibles).Shade = ObjectMesh(index).Shade
                VisibleObjectMesh(Visibles).AvgZ = CINT((ObjectPolyFaces(0).Z + ObjectPolyFaces(1).Z + ObjectPolyFaces(2).Z) / 3)
                Visibles = Visibles + 1
               
                NEXT
               
                FOR index = 0 TO Visibles - 1
                        trip1x = VisibleObjectMesh(index).X1
                        trip2x = VisibleObjectMesh(index).X2
                        trip3x = VisibleObjectMesh(index).X3
                        trip1y = VisibleObjectMesh(index).Y1 * 2
                        trip2y = VisibleObjectMesh(index).Y2 * 2
                        trip3y = VisibleObjectMesh(index).Y3 * 2
                        IF trip1y > 200 AND trip2y > 200 AND trip3y > 200 THEN
                        PPBlendTri VARSEG(LOWERLAYER&(0)), trip1x, trip1y - 200, trip2x, trip2y - 200, trip3x, trip3y - 200, VARSEG(BlenderMap(0))
                        END IF
                NEXT
END SUB

SUB ResetTrigonometrics (SinTab(), CosTab(), MovSinTab(), MovCosTab(), AltSine(), Sine!(), Cosine!(), SkyPerspective(), TerrainHeights())
REDIM LocationVector(0) AS Vector3DType
REDIM HorizonHeight(0) AS Vector2DType
ScaleDivideY = 32
ScaleDivideZ! = 3.29999
ZEye = -750
FOR index = 0 TO 1279
        SinTab(index) = CINT(SIN((index * .28125) * (3.141592 / 180)) * 256)
        CosTab(index) = CINT(COS((index * .28125) * (3.141592 / 180)) * 256)
        MovSinTab(index) = CINT(SIN((index * .28125) * (3.141592 / 180)) * 16)
        MovCosTab(index) = CINT(COS((index * .28125) * (3.141592 / 180)) * 16)
NEXT
FOR index = 0 TO 180
        AltSine(index) = CINT(SIN(((index - 90)) * (3.141593 / 180)) * 32)
NEXT
PerspectiveTransForm = 1560
FOR index = 0 TO 104
        SkyPerspective(index) = CINT(240000! / CSNG(PerspectiveTransForm))
        PerspectiveTransForm = PerspectiveTransForm - 8
NEXT
Offset = 0
TargetValue& = 65536
FOR index2 = 0 TO 32
        FOR index = 0 TO 127
                LocationVector(0).X = 0
                LocationVector(0).Z = TargetValue& / ScaleDivideZ!
                LocationVector(0).Y = ((-3000) - (index * 350&)) / ScaleDivideY
                CSProjectVector VARSEG(LocationVector(0).X), VARPTR(LocationVector(0).X), VARSEG(HorizonHeight(0).X), VARPTR(HorizonHeight(0).X), ZEye
                IF index = 0 THEN StartValue = HorizonHeight(0).Y
                CurrentValue = HorizonHeight(0).Y - StartValue
                IF CurrentValue > 255 THEN CurrentValue = 255
                CSPoke VARSEG(TerrainHeights(0)), Offset, CurrentValue
                Offset = Offset + 1
        NEXT
TargetValue& = TargetValue& - 1024
NEXT
FOR index2 = 33 TO 159
        FOR index = 0 TO 127
                LocationVector(0).X = 0
                LocationVector(0).Z = TargetValue& / ScaleDivideZ!
                LocationVector(0).Y = ((-3000) - (index * 350&)) / ScaleDivideY
                CSProjectVector VARSEG(LocationVector(0).X), VARPTR(LocationVector(0).X), VARSEG(HorizonHeight(0).X), VARPTR(HorizonHeight(0).X), ZEye
                IF index = 0 THEN StartValue = HorizonHeight(0).Y
                CurrentValue = HorizonHeight(0).Y - StartValue
                IF CurrentValue > 255 THEN CurrentValue = 255
                CSPoke VARSEG(TerrainHeights(0)), Offset, CurrentValue
                'TerrainHeights(Offset) = CurrentValue
                Offset = Offset + 1
        NEXT
TargetValue& = TargetValue& - 256
NEXT
 
  FOR i% = 0 TO 360
    Ang! = i% * (3.141592 / 180)
    Sine!(i%) = SIN(Ang!)
    Cosine!(i%) = COS(Ang!)
  NEXT

END SUB

SUB ScrollStarField (Stars() AS StarType, Direction, Amount)
        FOR index = 0 TO 499
                SELECT CASE Direction
                        CASE RIGHTWARDS
                                Stars(index).X = Stars(index).X - Amount
                                IF Stars(index).X < 0 THEN Stars(index).X = Stars(index).X + 320
                        CASE LEFTWARDS
                                Stars(index).X = Stars(index).X + Amount
                                IF Stars(index).X > 319 THEN Stars(index).X = Stars(index).X - 320
                END SELECT
        NEXT
END SUB

SUB SetAtmosphereColors (Pal$, PaletteNum)
CSGetCol 160, AtmosphereRed, AtmosphereGreen, AtmosphereBlue
FOR index = 0 TO 255
        PaletteIndex = (index * 3) + 1
        RedValue = ASC(MID$(Pal$, PaletteIndex, 1))
        GreenValue = ASC(MID$(Pal$, PaletteIndex + 1, 1))
        BlueValue = ASC(MID$(Pal$, PaletteIndex + 2, 1))
        
        IF RedValue < AtmosphereRed THEN
                AddRed = 1
        ELSEIF RedValue > AtmosphereRed THEN
                AddRed = -1
        ELSE
                AddRed = 0
        END IF
        IF GreenValue < AtmosphereGreen THEN
                AddGreen = 1
        ELSEIF GreenValue > AtmosphereGreen THEN
                AddGreen = -1
        ELSE
                AddGreen = 0
        END IF
        IF BlueValue < AtmosphereBlue THEN
                AddBlue = 1
        ELSEIF BlueValue > AtmosphereBlue THEN
                AddBlue = -1
        ELSE
                AddBlue = 0
        END IF
        RedStep! = ABS(AtmosphereRed - RedValue) / 32
        GreenStep! = ABS(AtmosphereGreen - GreenValue) / 32
        BlueStep! = ABS(AtmosphereBlue - BlueValue) / 32
        FinalRed = RedValue + (CINT(CSNG(PaletteNum) * RedStep!) * AddRed)
        FinalGreen = GreenValue + (CINT(CSNG(PaletteNum) * GreenStep!) * AddGreen)
        FinalBlue = BlueValue + (CINT(CSNG(PaletteNum) * BlueStep!) * AddBlue)
        CSSetCol index, FinalRed, FinalGreen, FinalBlue
NEXT
END SUB

SUB SetShadowHooks (ShadowHook())
FOR index = 0 TO 191
ShadowHook(index) = 0
NEXT
ShadowHook(1) = 1
ShadowHook(8) = 5
ShadowHook(9) = 4
ShadowHook(20) = 2
ShadowHook(21) = 3
ShadowHook(22) = 6
ShadowHook(32) = 7
ShadowHook(33) = 8
ShadowHook(40) = 9
ShadowHook(42) = 10
ShadowHook(43) = 11
ShadowHook(53) = 12
ShadowHook(54) = 13
ShadowHook(55) = 14
ShadowHook(58) = 16
ShadowHook(63) = 15
ShadowHook(65) = 17
ShadowHook(66) = 18
ShadowHook(67) = 19
ShadowHook(68) = 20
ShadowHook(69) = 21
ShadowHook(75) = 22
ShadowHook(77) = 23
ShadowHook(78) = 24
ShadowHook(79) = 25
ShadowHook(88) = 26
ShadowHook(89) = 27
END SUB


SUB SetStarField (Stars() AS StarType)
FOR index = 0 TO 499
        Stars(index).X = RND * 320
        Stars(index).Y = RND * 340
        Stars(index).StarColor = 224 + RND * 32
NEXT
END SUB

SUB ShowMessage (UPPERLAYER&(), XMSHandles(), XMSCache&(), InterFaceObject() AS InterfaceBitMap, MessageNum)
Chunk = (19 + MessageNum)
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(Chunk).StartPoint, InterFaceObject(Chunk).BytesLong
Xlen = CSPeek16(VARSEG(XMSCache&(0)), 0) \ 16
Xpos = 160 - Xlen
CSSprite VARSEG(UPPERLAYER&(0)), Xpos, 160, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
END SUB

SUB ShowOffscreen (VideoPage, UPPERLAYER&(), LOWERLAYER&())
IF VideoPage = 1 THEN
mxBufferCopy Page2in320x200, VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0))
mxBufferCopy Page3in320x200, VARSEG(LOWERLAYER&(0)), VARPTR(LOWERLAYER&(0))
mxSetDisplayOffset 32000
END IF
IF VideoPage = 2 THEN
mxBufferCopy Page0in320x200, VARSEG(UPPERLAYER&(0)), VARPTR(UPPERLAYER&(0))
mxBufferCopy Page1in320x200, VARSEG(LOWERLAYER&(0)), VARPTR(LOWERLAYER&(0))
mxSetDisplayOffset 0
END IF
END SUB

FUNCTION SmallMenu (UPPERLAYER&(), LOWERLAYER&(), InterFaceObject() AS InterfaceBitMap, XMSCache&(), XMSHandles(), VideoPage, Ammo(), LevelNum, Skill, Saveable)
REDIM Chunks(3)
CurrentSelection = 1
GOSUB UpdateScreen
DO
        IF CSKey(&H48) THEN
        CurrentSelection = CurrentSelection - 1
        IF CurrentSelection = 0 THEN CurrentSelection = 4
        GOSUB UpdateScreen
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
        END IF
        IF CSKey(&H50) THEN
        CurrentSelection = CurrentSelection + 1
        IF CurrentSelection = 5 THEN CurrentSelection = 1
        GOSUB UpdateScreen
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
        END IF
        IF CSKey(&H1C) THEN
        SoundInterFace 2, 29, 0, 0, 0
        GOSUB PressedEnter:
        END IF
LOOP
UpdateScreen:
        SELECT CASE CurrentSelection
        CASE 1
                Chunks(0) = 47
                Chunks(1) = 50
                Chunks(2) = 52
                Chunks(3) = 54
        CASE 2
                Chunks(0) = 48
                Chunks(1) = 49
                Chunks(2) = 52
                Chunks(3) = 54
        CASE 3
                Chunks(0) = 48
                Chunks(1) = 50
                Chunks(2) = 51
                Chunks(3) = 54
        CASE 4
                Chunks(0) = 48
                Chunks(1) = 50
                Chunks(2) = 52
                Chunks(3) = 53
        END SELECT

Ypos = 32
FOR index = 0 TO 3
        CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(Chunks(index)).StartPoint, InterFaceObject(Chunks(index)).BytesLong
        Xlen = CSPeek16(VARSEG(XMSCache&(0)), 0) \ 16
        Xpos = 160 - Xlen
        CSSprite VARSEG(UPPERLAYER&(0)), Xpos, Ypos, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
        Ypos = Ypos + 28
NEXT
        VideoPage = VideoPage + 1
        ShowOffscreen VideoPage, UPPERLAYER&(), LOWERLAYER&()
        IF VideoPage = 2 THEN VideoPage = 0
RETURN
PressedEnter:
        SELECT CASE CurrentSelection
        CASE 1
        IF Saveable = TRUE THEN
                ReturnValue = LoadSaveMenu(UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandles(), InterFaceObject(), VideoPage, 1)
        IF ReturnValue <> 0 THEN
                FileHandle = FREEFILE
                OPEN "qsave.db" FOR BINARY AS FileHandle
                SEEK FileHandle, ((ReturnValue - 1) * 20) + 1
                ActiveFlag = 1
                PUT FileHandle, , ActiveFlag
                PUT FileHandle, , LevelNum
                PUT FileHandle, , Skill
                FOR index = 0 TO 6
                PUT FileHandle, , Ammo(index)
                NEXT
                CLOSE FileHandle
                SmallMenu = 0
                EXIT FUNCTION
        ELSE
                GOSUB UpdateScreen
                WaitTicks 12
        END IF
        ELSE
        SmallMenu = 0
        EXIT FUNCTION
        END IF
        CASE 2
        ReturnValue = LoadSaveMenu(UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandles(), InterFaceObject(), VideoPage, 2)
        IF ReturnValue <> 0 THEN
        SmallMenu = ReturnValue + 25
        EXIT FUNCTION
        ELSE
                GOSUB UpdateScreen
                WaitTicks 12
        END IF
        CASE 3
        SmallMenu = 0
        EXIT FUNCTION
        CASE 4
        SmallMenu = 2
        EXIT FUNCTION
END SELECT
RETURN
END FUNCTION

SUB UpdateMissionTree
END SUB

SUB UpdatePanel (UPPERLAYER&(), LOWERLAYER&(), XMSHandles(), XMSCache&(), InterFaceObject() AS InterfaceBitMap, Weapon, Ammo(), Velo, HullEnergy)
SELECT CASE Weapon
        CASE PULSELASER
                WepnNumber = 12
        CASE ION
                WepnNumber = 13
        CASE TLA
                WepnNumber = 14
        CASE PLASMA
                WepnNumber = 15
        CASE MISSILE
                WepnNumber = 16
        CASE SEEKMISSILE
                WepnNumber = 17
        CASE ACM
                WepnNumber = 18
END SELECT
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(WepnNumber).StartPoint, InterFaceObject(WepnNumber).BytesLong
CSSpriteF VARSEG(LOWERLAYER&(0)), 211, 157, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
AmmoCase = GetAmmoTag(Weapon)
IF Ammo(AmmoCase) >= 0 AND Ammo(AmmoCase) < 1000 THEN

IF Ammo(AmmoCase) >= 100 THEN Hundreds = Ammo(AmmoCase) \ 100 ELSE Hundreds = 0
IF Ammo(AmmoCase) >= 10 THEN Tens = (Ammo(AmmoCase) \ 10) - (Hundreds * 10) ELSE Tens = 0
Ettans = Ammo(AmmoCase) - (Hundreds * 100 + Tens * 10)
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(Hundreds + 1).StartPoint, InterFaceObject(Hundreds + 1).BytesLong
CSSpriteF VARSEG(LOWERLAYER&(0)), 211, 183, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(Tens + 1).StartPoint, InterFaceObject(Tens + 1).BytesLong
CSSpriteF VARSEG(LOWERLAYER&(0)), 221, 183, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(Ettans + 1).StartPoint, InterFaceObject(Ettans + 1).BytesLong
CSSpriteF VARSEG(LOWERLAYER&(0)), 231, 183, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
ELSE
CSMoveFromXMS VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0)), XMSHandles(INTERFACE), InterFaceObject(11).StartPoint, InterFaceObject(11).BytesLong
CSSpriteF VARSEG(LOWERLAYER&(0)), 211, 183, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
CSSpriteF VARSEG(LOWERLAYER&(0)), 221, 183, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))
CSSpriteF VARSEG(LOWERLAYER&(0)), 231, 183, VARSEG(XMSCache&(0)), VARPTR(XMSCache&(0))

END IF

CSBoxF VARSEG(LOWERLAYER&(0)), 20, 182, (20 + Velo * 10), 194, 35
CSBoxF VARSEG(LOWERLAYER&(0)), 20, 184, (20 + Velo * 10), 192, 37
CSBoxF VARSEG(LOWERLAYER&(0)), 20, 186, (20 + Velo * 10), 190, 39
CSBoxF VARSEG(LOWERLAYER&(0)), 20, 187, (20 + Velo * 10), 189, 41
CSBoxF VARSEG(LOWERLAYER&(0)), 20, 156, (20 + HullEnergy * 2), 168, 35
CSBoxF VARSEG(LOWERLAYER&(0)), 20, 158, (20 + HullEnergy * 2), 166, 37
CSBoxF VARSEG(LOWERLAYER&(0)), 20, 160, (20 + HullEnergy * 2), 164, 39
CSBoxF VARSEG(LOWERLAYER&(0)), 20, 161, (20 + HullEnergy * 2), 163, 41

END SUB

SUB UpdateRadar (RadarItem() AS RadarObject, RadarBitMap(), UPPERLAYER&())
'49
'286
FOR index = 0 TO 63
        SELECT CASE RadarItem(index).ObjectType
        CASE AIRTARGETABOVE
        CSSprite VARSEG(UPPERLAYER&(0)), 284 - RadarItem(index).X, 78 - RadarItem(index).Y, VARSEG(RadarBitMap(0)), 0
        CASE AIRTARGETBELOW
        CSSprite VARSEG(UPPERLAYER&(0)), 284 - RadarItem(index).X, 78 - RadarItem(index).Y, VARSEG(RadarBitMap(0)), 29
        CASE FLAKCANNON
        CSSprite VARSEG(UPPERLAYER&(0)), 284 - RadarItem(index).X, 78 - RadarItem(index).Y, VARSEG(RadarBitMap(0)), 87
        CASE BUILDING
        CSSprite VARSEG(UPPERLAYER&(0)), 284 - RadarItem(index).X, 78 - RadarItem(index).Y, VARSEG(RadarBitMap(0)), 58
        END SELECT
NEXT
END SUB

SUB VisitCheckPoint (MissionPath() AS MissionType, CheckPoint() AS CheckPointType, GameObject() AS Object, BigMessage, BigMessageTime)
IF MissionPath(0).Node <> NODECHECKPOINT THEN EXIT SUB
xfrag& = ABS(GameObject(0).X - CheckPoint(MissionPath(0).NodeHook).X)
zfrag& = ABS(GameObject(0).Z - CheckPoint(MissionPath(0).NodeHook).Z)
IF xfrag& < 8192 AND zfrag& < 8192 THEN
        InitializeMessage MESSAGECHECKPOINT, BigMessage, BigMessageTime
        RemoveMissionNode MissionPath(), 0
END IF
END SUB

SUB WaitTicks (Ticks)
FOR index = 0 TO Ticks
CSWaitTimer 0
NEXT
END SUB

