DECLARE SUB SoundInterFace (Command%, Value1%, Value2%, Value3%, Value4%)
DECLARE SUB ReleaseCriticalStuff (XMSHandle%)
DECLARE SUB FlipMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, VideoPage%, Direction%)
DECLARE SUB LoadGameMenuAction (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, MenuFlip%, VideoPage%, Pal$)
DECLARE SUB DisplayLoadGameMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, CursorPosition%, SaveFull%(), SaveLevel%(), SaveSkill%())
DECLARE SUB SkillMenuAction (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, MenuFlip%, VideoPage%, Pal$)
DECLARE SUB DisplaySkillMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, CursorPosition%)
DECLARE SUB HelpText (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, Pal$, VideoPage%, MenuFlip%)
DECLARE SUB HelpPage (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, PageNumber%)
DECLARE SUB ShadowedText (UPPERLAYER&(), LOWERLAYER&(), x%, y%, TextString$)
DECLARE SUB CreditsScreen (UPPERLAYER&(), LOWERLAYER&(), XMSHandle%, XMSCache&(), MenuImage() AS ANY, Pal$, VideoPage%)
DECLARE SUB SoundMenuAction (UPPERLAYER&(), LOWERLAYER&(), XMSHandle%, XMSCache&(), MenuImage() AS ANY, MenuFlip%, VideoPage%, Pal$)
DECLARE SUB DisplaySoundMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, CursorPosition%, MusicVol%, SFXVol%, EAXAudio%)
DECLARE SUB DisplayGraphicsMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, CursorPosition%, AntiAlias%, SkyTexture%, ShadowsOn%, MenuFlip%)
DECLARE SUB GraphicsMenuAction (UPPERLAYER&(), LOWERLAYER&(), XMSHandle%, XMSCache&(), MenuImage() AS ANY, MenuFlip%, VideoPage%, Pal$)
DECLARE SUB OptionsMenuAction (UPPERLAYER&(), LOWERLAYER&(), XMSHandle%, XMSCache&(), MenuImage() AS ANY, MenuFlip%, VideoPage%, Pal$)
DECLARE SUB DisplayOptionsMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, CursorPosition%)
DECLARE SUB FadeIn (PalString$)
DECLARE SUB WaitTicks (Ticks%)
DECLARE SUB MellowColors (PalString$)
DECLARE SUB FadeOut ()
DECLARE SUB BlackPalette ()
DECLARE SUB Update (UPPERLAYER&(), LOWERLAYER&(), VideoPage%)
DECLARE SUB BackGroundGraphics (UPPERLAYER&(), LOWERLAYER&(), XMSHandle%, XMSCache&(), MenuImage() AS ANY)
DECLARE SUB DisplayMainMenu (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, CursorPosition%)
DECLARE SUB PrintMenuText (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, TextX%, TextY%, TextBitMap%, Active%)
DECLARE SUB BlitBackGround (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle%, MenuImage() AS ANY, ImageNumber%)
DECLARE SUB ShowOffscreen (VideoPage%, UPPERLAYER&(), LOWERLAYER&())
DECLARE SUB AssimilatePalette (PaletteNumber%, FirstIndex%, ColorsToAssimilate%, PalString$)
DECLARE SUB CreateShadow (PalString$)
DECLARE SUB GeneratePrime (XMSHandle%, MenuImage() AS ANY)
DECLARE SUB Disk2XMS (File$, Handle%)


'$DYNAMIC
'$INCLUDE: 'slivedcx.bi'
'$INCLUDE: 'modexlib.bi'
DEFINT A-Z
CONST TRUE = 1
CONST FALSE = 0
TYPE MenuBitMap
        StartPoint AS LONG
        BytesLong AS LONG
END TYPE

        REDIM UPPERLAYER&(16000)
        REDIM LOWERLAYER&(16000)
        REDIM XMSCache&(16384)
        REDIM MenuImage(200) AS MenuBitMap
        
XMS = CSDetectXMS%
IF XMS = 1 THEN
        XMSHandle = CSAllocateXMS(940)
ELSE
END
END IF
CSSetTextSpacing 8
MMXFound% = CSDetectMMX%

Disk2XMS "mmenu.dx", XMSHandle
GeneratePrime XMSHandle, MenuImage()
FileHandle = FREEFILE
OPEN "prefs.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
GET FileHandle, , DS4QBActive
GET FileHandle, , AntiAlias
GET FileHandle, , SkyTexture
GET FileHandle, , ShadowsOn
GET FileHandle, , MenuFlip
GET FileHandle, , SFXVol
GET FileHandle, , MusicVol
GET FileHandle, , EAXAudio
CLOSE FileHandle
SoundInterFace 0, DS4QBActive, 0, 0, 0

Pal$ = SPACE$(768)
Font$ = SPACE$(2048)
OPEN "fontface.db" FOR BINARY AS #1
SEEK #1, 1
GET #1, , Font$
CLOSE #1
CSSetFont Font$
Rfl = CSLoadPal("palette.dat", Pal$)
AssimilatePalette 1, 128, 64, Pal$
CreateShadow Pal$
MellowColors Pal$
BlackPalette
mxFill Page0in320x400&, Full320x400, 0
mxFill Page1in320x400&, Full320x400, 0

CSInstallTimer
CSSetTimer 0, 40
CSSetTimer 1, 1500
CSInstallKeyBoard
CursorPosition = 1
DisplayMainMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
VideoPage = 2
Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
SoundInterFace 3, 1, 1, 0, 0
FadeIn Pal$
DO
IF CSKey(KEYUP) THEN
        CursorPosition = CursorPosition - 1
        IF CursorPosition = 0 THEN CursorPosition = 6
        DisplayMainMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYDOWN) THEN
        CursorPosition = CursorPosition + 1
        IF CursorPosition = 7 THEN CursorPosition = 1
        DisplayMainMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYENTER) THEN
        SoundInterFace 2, 29, 0, 0, 0
        GOSUB ProcessEnter
END IF
IF CSKey(KEYESC) THEN EXIT DO
LOOP
TerminateProgram:
SoundInterFace 5, 1, 100, 0, 0
FadeOut
CSDeallocateXMS XMSHandle
CSClose
CSInitText
SoundInterFace 1, 0, 0, 0, 0
END

ProcessEnter:
        FlipNo = FALSE
        SELECT CASE CursorPosition
        CASE 1
                IF MenuFlip = FALSE THEN FadeOut ELSE FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 1
                SkillMenuAction UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), MenuFlip, VideoPage, Pal$
        CASE 2
                IF MenuFlip = FALSE THEN FadeOut ELSE FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 1
                LoadGameMenuAction UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), MenuFlip, VideoPage, Pal$
        CASE 3
                IF MenuFlip = FALSE THEN FadeOut ELSE FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 1
                OptionsMenuAction UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage(), MenuFlip, VideoPage, Pal$
        CASE 4
                IF MenuFlip = FALSE THEN FadeOut ELSE FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 1
                HelpText UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), Pal$, VideoPage, MenuFlip
        CASE 5
                IF MenuFlip = FALSE THEN FadeOut ELSE FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 1
                CreditsScreen UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage(), Pal$, VideoPage
                FlipNo = TRUE
        CASE 6
        GOTO TerminateProgram
        END SELECT
       
        IF MenuFlip = FALSE OR FlipNo = TRUE THEN FadeOut: DisplayMainMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
        IF MenuFlip = TRUE AND FlipNo = FALSE THEN
                FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 1
                DisplayMainMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
                FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 2
                DisplayMainMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
        END IF
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        IF MenuFlip = FALSE OR FlipNo = TRUE THEN FadeIn Pal$
RETURN

REM $STATIC
SUB AssimilatePalette (PaletteNumber, FirstIndex, ColorsToAssimilate, PalString$)
FileHandle = FREEFILE
OPEN "coltabs.db" FOR BINARY AS FileHandle
SEEK FileHandle, ((PaletteNumber - 1) * 1536) + 1
PaletteIndex = FirstIndex * 3 + 1
FOR index = 0 TO ColorsToAssimilate - 1
        GET FileHandle, , ColorComponent
        MID$(PalString$, PaletteIndex, 1) = CHR$(ColorComponent)
        GET FileHandle, , ColorComponent
        MID$(PalString$, PaletteIndex + 1, 1) = CHR$(ColorComponent)
        GET FileHandle, , ColorComponent
        MID$(PalString$, PaletteIndex + 2, 1) = CHR$(ColorComponent)
        PaletteIndex = PaletteIndex + 3
NEXT
CLOSE FileHandle
END SUB

SUB CreateShadow (PalString$)
FOR index = 0 TO 63
        PaletteIndex = ((128 + index) * 3) + 1
        RedValue = ASC(MID$(PalString$, PaletteIndex, 1))
        GreenValue = ASC(MID$(PalString$, PaletteIndex + 1, 1))
        BlueValue = ASC(MID$(PalString$, PaletteIndex + 2, 1))
        RedValue = RedValue / 3
        GreenValue = GreenValue / 3
        BlueValue = BlueValue / 3
        PaletteIndex = ((192 + index) * 3) + 1
        MID$(PalString$, PaletteIndex, 1) = CHR$(RedValue)
        MID$(PalString$, PaletteIndex + 1, 1) = CHR$(GreenValue)
        MID$(PalString$, PaletteIndex + 2, 1) = CHR$(BlueValue)
NEXT
END SUB

SUB CreditsScreen (UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage() AS MenuBitMap, Pal$, VideoPage)
ExitFlags = FALSE
BlackPalette
AssimilatePalette 2, 0, 255, Pal$
MellowColors Pal$
BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 2
Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
FadeIn Pal$
CSResetTicks 1
SecondsElapsed = 0
DO
IF CSElapsedTicks&(1) >= 1 THEN GOSUB Timer1:
IF ExitFlags = TRUE THEN EXIT DO
IF CSKey(KEYENTER) THEN EXIT DO
IF CSKey(KEYSPACE) THEN EXIT DO
IF CSKey(KEYESC) THEN EXIT DO
LOOP
ExitCredits:
        Rfl = CSLoadPal("palette.dat", Pal$)
        AssimilatePalette 1, 128, 64, Pal$
        CreateShadow Pal$
        MellowColors Pal$
EXIT SUB

Timer1:
SecondsElapsed = SecondsElapsed + 1
UpdateScreenFlags = FALSE
        SELECT CASE SecondsElapsed
        CASE 2
        BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 2
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 196, "TerraScape: Breakdown Velocity"
        UpdateScreenFlags = TRUE
        CASE 7
        BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 2
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 196, "designed and programmed by:"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 226, "Pauli Merilainen"
        UpdateScreenFlags = TRUE
        CASE 12
        BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 2
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 196, "Music and sound effects by:"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 226, "Pauli Merilainen"
        UpdateScreenFlags = TRUE
        CASE 16
        BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 2
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 186, "3D-Models by:"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 216, "Pauli Merilainen"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 236, "Matti Salomaki"
        UpdateScreenFlags = TRUE
        CASE 21
        BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 2
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 196, "Graphic art and animation by:"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 226, "Pauli Merilainen"
        UpdateScreenFlags = TRUE
        CASE 26
        BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 2
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 130, "CosmoX game programming library by:"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 150, "CosmoSoft"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 190, "Mode X library by:"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 210, "Danny Gump"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 250, "DS4QB2 sound engine by:"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 270, "David Schnur"
        UpdateScreenFlags = TRUE
        CASE 34
        BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 2
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 176, "Special Thanks to:"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 206, "Tim Clarke"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 226, "Alex Champandard"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 246, "R-5"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 266, "www.programmersheaven.com"
        UpdateScreenFlags = TRUE
        CASE 40
        BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 2
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 186, "Beta Testers:"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 216, "Roel Tempelaar"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 236, "Oskari Ikonen"
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 256, "Olli-Pekka Talja"
        UpdateScreenFlags = TRUE
        CASE 45
        BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 2
        ShadowedText UPPERLAYER&(), LOWERLAYER&(), CENTERED, 196, "2003 Pieslice Productions"
        UpdateScreenFlags = TRUE
        CASE 48
        BlitBackGround UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), 2
        UpdateScreenFlags = TRUE
        ExitFlags = TRUE
        END SELECT
IF UpdateScreenFlags = TRUE THEN Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
CSResetTicks 1
RETURN
END SUB

SUB GeneratePrime (XMSHandle, MenuImage() AS MenuBitMap)
REDIM WordFromXMS(0)
REDIM DWordFromXMS&(0)
        CSMoveFromXMS VARSEG(WordFromXMS(0)), VARPTR(WordFromXMS(0)), XMSHandle, 0, 2
        XMSPos& = 2
        SP& = 0
        TotalIndexes = WordFromXMS(0)
        FOR index = 0 TO TotalIndexes
        MenuImage(index).StartPoint = SP&
        CSMoveFromXMS VARSEG(DWordFromXMS&(0)), VARPTR(DWordFromXMS&(0)), XMSHandle, XMSPos&, 4
        MenuImage(index).BytesLong = DWordFromXMS&(0)
        XMSPos& = XMSPos& + 4
        SP& = SP& + DWordFromXMS&(0)
        NEXT
        FOR index = 0 TO TotalIndexes
        MenuImage(index).StartPoint = MenuImage(index).StartPoint + XMSPos&
        NEXT
END SUB

SUB GraphicsMenuAction (UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage() AS MenuBitMap, MenuFlip, VideoPage, Pal$)
FileHandle = FREEFILE
OPEN "prefs.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
GET FileHandle, , DS4QBActive
GET FileHandle, , AntiAlias
GET FileHandle, , SkyTexture
GET FileHandle, , ShadowsOn
GET FileHandle, , MenuFlip
GET FileHandle, , SFXVol
GET FileHandle, , MusicVol
GET FileHandle, , EAXAudio
CLOSE FileHandle

CursorPosition = 1
DisplayGraphicsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, AntiAlias, SkyTexture, ShadowsOn, MenuFlip
IF MenuFlip = FALSE THEN
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        FadeIn Pal$
ELSE
        FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 2
        DisplayGraphicsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, AntiAlias, SkyTexture, ShadowsOn, MenuFlip
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
END IF


DO
IF CSKey(KEYUP) THEN
        CursorPosition = CursorPosition - 1
        IF CursorPosition = 0 THEN CursorPosition = 5
        DisplayGraphicsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, AntiAlias, SkyTexture, ShadowsOn, MenuFlip
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYDOWN) THEN
        CursorPosition = CursorPosition + 1
        IF CursorPosition = 6 THEN CursorPosition = 1
        DisplayGraphicsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, AntiAlias, SkyTexture, ShadowsOn, MenuFlip
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYENTER) THEN
        SoundInterFace 2, 29, 0, 0, 0
        GOSUB ProcessEnter3:
END IF
IF CSKey(KEYESC) THEN
        SoundInterFace 2, 30, 0, 0, 0
        EXIT DO
END IF
LOOP
ExitFromSubMenu2:
FileHandle = FREEFILE
OPEN "prefs.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
PUT FileHandle, , DS4QBActive
PUT FileHandle, , AntiAlias
PUT FileHandle, , SkyTexture
PUT FileHandle, , ShadowsOn
PUT FileHandle, , MenuFlip
PUT FileHandle, , SFXVol
PUT FileHandle, , MusicVol
PUT FileHandle, , EAXAudio
CLOSE FileHandle
EXIT SUB
ProcessEnter3:
        SELECT CASE CursorPosition
        CASE 1
        IF AntiAlias = FALSE THEN AntiAlias = TRUE ELSE AntiAlias = FALSE
        DisplayGraphicsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, AntiAlias, SkyTexture, ShadowsOn, MenuFlip
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        WaitTicks 3
        CASE 2
        IF SkyTexture = FALSE THEN SkyTexture = TRUE ELSE SkyTexture = FALSE
        DisplayGraphicsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, AntiAlias, SkyTexture, ShadowsOn, MenuFlip
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        WaitTicks 3
        CASE 3
        IF ShadowsOn = FALSE THEN ShadowsOn = TRUE ELSE ShadowsOn = FALSE
        DisplayGraphicsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, AntiAlias, SkyTexture, ShadowsOn, MenuFlip
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        WaitTicks 3
        CASE 4
        IF MenuFlip = FALSE THEN MenuFlip = TRUE ELSE MenuFlip = FALSE
        DisplayGraphicsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, AntiAlias, SkyTexture, ShadowsOn, MenuFlip
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        WaitTicks 3
        CASE 5
        GOTO ExitFromSubMenu2:
        END SELECT
RETURN
END SUB

SUB HelpText (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage() AS MenuBitMap, Pal$, VideoPage, MenuFlip)
PageNumber = 1
HelpPage UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), PageNumber
IF MenuFlip = FALSE THEN
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        FadeIn Pal$
ELSE
        FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 2
        HelpPage UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), PageNumber
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
END IF

DO
IF CSKey(KEYUP) THEN
        PageNumber = PageNumber - 1
        IF PageNumber = 0 THEN PageNumber = 1
        HelpPage UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), PageNumber
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYDOWN) THEN
        PageNumber = PageNumber + 1
        IF PageNumber = 7 THEN PageNumber = 6
        HelpPage UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), PageNumber
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYESC) THEN
SoundInterFace 2, 30, 0, 0, 0
EXIT DO
END IF
LOOP

END SUB

SUB LoadGameMenuAction (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage() AS MenuBitMap, MenuFlip, VideoPage, Pal$)
REDIM SaveFull(4)
REDIM SaveLevel(4)
REDIM SaveSkill(4)
REDIM Ammo(6)
FileHandle = FREEFILE
        OPEN "qsave.db" FOR BINARY AS FileHandle
        FOR index = 0 TO 4
        GET FileHandle, , SaveFull(index)
        GET FileHandle, , SaveLevel(index)
        GET FileHandle, , SaveSkill(index)
        GET FileHandle, , DummyVar
        GET FileHandle, , DummyVar
        GET FileHandle, , DummyVar
        GET FileHandle, , DummyVar
        GET FileHandle, , DummyVar
        GET FileHandle, , DummyVar
        GET FileHandle, , DummyVar
        NEXT
        CLOSE FileHandle
CursorPosition = 1
DisplayLoadGameMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, SaveFull(), SaveLevel(), SaveSkill()
IF MenuFlip = FALSE THEN
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        FadeIn Pal$
ELSE
        FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 2
        DisplayLoadGameMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, SaveFull(), SaveLevel(), SaveSkill()
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
END IF

DO
IF CSKey(KEYUP) THEN
        CursorPosition = CursorPosition - 1
        IF CursorPosition = 0 THEN CursorPosition = 5
        DisplayLoadGameMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, SaveFull(), SaveLevel(), SaveSkill()
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYDOWN) THEN
        CursorPosition = CursorPosition + 1
        IF CursorPosition = 6 THEN CursorPosition = 1
        DisplayLoadGameMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, SaveFull(), SaveLevel(), SaveSkill()
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYENTER) THEN
        SoundInterFace 2, 29, 0, 0, 0
        GOSUB ProcessEnter6:
END IF
IF CSKey(KEYESC) THEN
SoundInterFace 2, 30, 0, 0, 0
EXIT DO
END IF
LOOP
EXIT SUB
ProcessEnter6:
IF SaveFull(CursorPosition - 1) = FALSE THEN RETURN
FadeOut
SoundInterFace 5, 1, 100, 0, 0
        LoadFlag = CursorPosition - 1
        FileHandle = FREEFILE
        OPEN "qsave.db" FOR BINARY AS FileHandle
        SEEK FileHandle, (LoadFlag * 20) + 1
        GET FileHandle, , DummyVar
        GET FileHandle, , LevelNum
        GET FileHandle, , Skill
        FOR index = 0 TO 6
        GET FileHandle, , Ammo(index)
        NEXT
        CLOSE FileHandle
FileHandle = FREEFILE
OPEN "player.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
PUT FileHandle, , LevelNum
PUT FileHandle, , Skill
PUT FileHandle, , Ammo(0)
PUT FileHandle, , Ammo(1)
PUT FileHandle, , Ammo(2)
PUT FileHandle, , Ammo(3)
PUT FileHandle, , Ammo(4)
PUT FileHandle, , Ammo(5)
PUT FileHandle, , Ammo(6)
CLOSE FileHandle
ReleaseCriticalStuff XMSHandle
RUN "scapez01.xbn"
END SUB

SUB OptionsMenuAction (UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage() AS MenuBitMap, MenuFlip, VideoPage, Pal$)
CursorPosition = 1
DisplayOptionsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition

IF MenuFlip = FALSE THEN
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        FadeIn Pal$
ELSE
        FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 2
        DisplayOptionsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
END IF
DO
IF CSKey(KEYUP) THEN
        CursorPosition = CursorPosition - 1
        IF CursorPosition = 0 THEN CursorPosition = 3
        DisplayOptionsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYDOWN) THEN
        CursorPosition = CursorPosition + 1
        IF CursorPosition = 4 THEN CursorPosition = 1
        DisplayOptionsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYENTER) THEN
        SoundInterFace 2, 29, 0, 0, 0
        GOSUB ProcessEnter2:
END IF
IF CSKey(KEYESC) THEN
SoundInterFace 2, 30, 0, 0, 0
EXIT DO
END IF
LOOP
ExitFromSubMenu:
EXIT SUB

ProcessEnter2:
        SELECT CASE CursorPosition
        CASE 1
        IF MenuFlip = FALSE THEN FadeOut ELSE FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 1
        GraphicsMenuAction UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage(), MenuFlip, VideoPage, Pal$
        CASE 2
        IF MenuFlip = FALSE THEN FadeOut ELSE FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 1
        SoundMenuAction UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage(), MenuFlip, VideoPage, Pal$
        CASE 3
        GOTO ExitFromSubMenu:
        END SELECT
       
IF MenuFlip = FALSE THEN FadeOut: DisplayOptionsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
        IF MenuFlip = TRUE THEN
                FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 1
                DisplayOptionsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
                FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 2
                DisplayOptionsMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
        END IF
Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
IF MenuFlip = FALSE THEN FadeIn Pal$

RETURN

END SUB

SUB SkillMenuAction (UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage() AS MenuBitMap, MenuFlip, VideoPage, Pal$)
REDIM Ammo(6)
CursorPosition = 1
DisplaySkillMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
IF MenuFlip = FALSE THEN
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        FadeIn Pal$
ELSE
        FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 2
        DisplaySkillMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
END IF
DO
IF CSKey(KEYUP) THEN
        CursorPosition = CursorPosition - 1
        IF CursorPosition = 0 THEN CursorPosition = 4
        DisplaySkillMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYDOWN) THEN
        CursorPosition = CursorPosition + 1
        IF CursorPosition = 5 THEN CursorPosition = 1
        DisplaySkillMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYENTER) THEN
        SoundInterFace 2, 29, 0, 0, 0
        GOTO ProcessEnter5:
END IF
IF CSKey(KEYESC) THEN
SoundInterFace 2, 30, 0, 0, 0
EXIT DO
END IF
LOOP
EXIT SUB
ProcessEnter5:
FadeOut
SoundInterFace 5, 1, 100, 0, 0
LevelNum = 1
        Skill = CursorPosition
        Ammo(0) = -1
        Ammo(1) = 0
        Ammo(2) = 0
        Ammo(3) = 0
        Ammo(4) = 0
        Ammo(5) = 0
        Ammo(6) = 0
FileHandle = FREEFILE
OPEN "player.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
PUT FileHandle, , LevelNum
PUT FileHandle, , Skill
PUT FileHandle, , Ammo(0)
PUT FileHandle, , Ammo(1)
PUT FileHandle, , Ammo(2)
PUT FileHandle, , Ammo(3)
PUT FileHandle, , Ammo(4)
PUT FileHandle, , Ammo(5)
PUT FileHandle, , Ammo(6)
CLOSE FileHandle
ReleaseCriticalStuff XMSHandle
RUN "scapez03.xbn"

END SUB

SUB SoundMenuAction (UPPERLAYER&(), LOWERLAYER&(), XMSHandle, XMSCache&(), MenuImage() AS MenuBitMap, MenuFlip, VideoPage, Pal$)
FileHandle = FREEFILE
OPEN "prefs.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
GET FileHandle, , DS4QBActive
GET FileHandle, , AntiAlias
GET FileHandle, , SkyTexture
GET FileHandle, , ShadowsOn
GET FileHandle, , MenuFlip
GET FileHandle, , SFXVol
GET FileHandle, , MusicVol
GET FileHandle, , EAXAudio
CLOSE FileHandle

CursorPosition = 1
DisplaySoundMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, MusicVol, SFXVol, EAXAudio
IF MenuFlip = FALSE THEN
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        FadeIn Pal$
ELSE
        FlipMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, VideoPage, 2
        DisplaySoundMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, MusicVol, SFXVol, EAXAudio
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
END IF
EnterSoundFlag = FALSE
DO
IF CSKey(KEYUP) THEN
        CursorPosition = CursorPosition - 1
        IF CursorPosition = 0 THEN CursorPosition = 4
        DisplaySoundMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, MusicVol, SFXVol, EAXAudio
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYDOWN) THEN
        CursorPosition = CursorPosition + 1
        IF CursorPosition = 5 THEN CursorPosition = 1
        DisplaySoundMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, MusicVol, SFXVol, EAXAudio
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 2, 28, 0, 0, 0
        WaitTicks 3
END IF
IF CSKey(KEYENTER) THEN
        GOSUB ProcessEnter4:
        SoundInterFace 2, 29, 0, 0, 0
END IF
IF CSKey(KEYESC) THEN
SoundInterFace 2, 30, 0, 0, 0
EXIT DO
END IF
LOOP
ExitFromSubMenu3:
IF EnterSoundFlag = TRUE THEN SoundInterFace 2, 29, 0, 0, 0
FileHandle = FREEFILE
OPEN "prefs.db" FOR BINARY AS FileHandle
SEEK FileHandle, 1
PUT FileHandle, , DS4QBActive
PUT FileHandle, , AntiAlias
PUT FileHandle, , SkyTexture
PUT FileHandle, , ShadowsOn
PUT FileHandle, , MenuFlip
PUT FileHandle, , SFXVol
PUT FileHandle, , MusicVol
PUT FileHandle, , EAXAudio
CLOSE FileHandle

EXIT SUB
ProcessEnter4:
SELECT CASE CursorPosition
CASE 1
        SFXVol = SFXVol + 25
        IF SFXVol > 100 THEN SFXVol = 0
        DisplaySoundMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, MusicVol, SFXVol, EAXAudio
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 4, SFXVol, MusicVol, 0, 0
        WaitTicks 3
CASE 2
        MusicVol = MusicVol + 25
        IF MusicVol > 100 THEN MusicVol = 0
        DisplaySoundMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, MusicVol, SFXVol, EAXAudio
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        SoundInterFace 4, SFXVol, MusicVol, 0, 0
        WaitTicks 3
CASE 3
        IF EAXAudio = FALSE THEN EAXAudio = TRUE ELSE EAXAudio = FALSE
        DisplaySoundMenu UPPERLAYER&(), LOWERLAYER&(), XMSCache&(), XMSHandle, MenuImage(), CursorPosition, MusicVol, SFXVol, EAXAudio
        Update UPPERLAYER&(), LOWERLAYER&(), VideoPage
        IF EAXAudio = TRUE THEN EaxCode = 10 ELSE EaxCode = 0
        SoundInterFace 6, EaxCode, 0, 0, 0
        WaitTicks 3
CASE 4
        EnterSoundFlag = TRUE
        GOTO ExitFromSubMenu3
END SELECT
RETURN

END SUB


