;----------------------------------------------------------------------------
;
;  CosmoX 3D Module
;
;  Part of the CosmoX Library v2.0
;  by bobby - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 p386
.model use16 medium, basic
.stack 200h

locals @@

.data

align 2

EndU                dw  200 dup(?)      ;  Used by Gouraud and Texture
EndV                dw  200 dup(?)      ;  Used by Gouraud and Texture
EndX                dw  200 dup(?)      ;  Last X in scanline
StartU              dw  200 dup(?)      ;  Used by Goraud and Texture
StartV              dw  200 dup(?)      ;  Used by Goraud and Texture
StartX              dw  200 dup(?)      ;  First X in scanline
FirstY              dw  ?               ;  First ScanLine
LastY               dw  ?               ;  Last ScanLine
TextureWrap         dw  63              ;  Used to wrap the texture
TextureAdd          dw  4               ;  Used to skip GET-PUT header
Counter             dw  ?               ;  Used in texture-mapping subs
TextureSize         db  6               ;  Texture size (in bits to shift)

.code

public  PPBlendTri, PPProjectVector

PPBlendTri proc
  push bp
  mov bp, sp
  mov ax, [bp+20]
  mov es, ax
  mov ax, [bp+16]
  mov bx, [bp+12]
  cmp ax, bx
  jle @@BSwap12
  mov [bp+16], bx
  mov [bp+12], ax
  mov bx, [bp+14]
  mov ax, [bp+18]
  mov [bp+18], bx
  mov [bp+14], ax
@@BSwap12:
  mov ax, [bp+16]
  mov bx, [bp+08]
  cmp ax, bx
  jle @@BSwap13
  mov [bp+16], bx
  mov [bp+08], ax
  mov bx, [bp+10]
  mov ax, [bp+18]
  mov [bp+18], bx
  mov [bp+10], ax
@@BSwap13:
  mov ax, [bp+12]
  mov bx, [bp+08]
  cmp ax, bx
  jle @@BEndSwaps1
  mov [bp+12], bx
  mov [bp+08], ax
  mov bx, [bp+10]
  mov ax, [bp+14]
  mov [bp+14], bx
  mov [bp+10], ax
@@BEndSwaps1:
  mov ax, 8000H
  xor si, si
@@BInitTriFX:
  mov StartX[si], ax
  add si, 2
  cmp si, 400
  jl  @@BInitTriFX
  mov ax, 0
  mov FirstY, ax
  mov bx, [bp+16]
  cmp bx, 199
  jg  @@EndTriFB
  cmp bx, ax
  jl  @@BClipFY
  mov FirstY, bx
@@BClipFY:
  mov ax, 199
  mov LastY, ax
  mov bx, [bp+08]
  cmp bx, 0
  jl  @@EndTriFB
  cmp bx, ax
  jg  @@BClipLY
  mov LastY, bx
@@BClipLY:
  xor ecx, ecx
  mov bx, [bp+16]
  mov cx, [bp+12]
  sub cx, bx
  jnz @@BConnect11
  cmp bx, 0
  jl  @@BEnd11
  cmp bx, 199
  jg  @@BEnd11
  shl bx, 1
  mov ax, [bp+18]
  mov StartX[bx], ax
  jmp @@BEnd11
@@BConnect11:
  mov ax, [bp+14]
  sub ax, [bp+18]
  shl eax, 16
  mov edx, eax
  sar edx, 31
  idiv ecx
  mov dx, [bp+18]
  shl edx, 16
  mov bx, [bp+16]
@@BNext11:
  cmp bx, 0
  jl  @@BSkip11
  cmp bx, 199
  jg  @@BSkip11
  mov si, bx
  shl si, 1
  mov ecx, edx
  shr ecx, 16
  mov StartX[si], cx
@@BSkip11:
  add edx, eax
  inc bx
  cmp bx, [bp+12]
  jle @@BNext11
@@BEnd11:
  xor ecx, ecx
  mov bx, [bp+12]
  mov cx, [bp+08]
  sub cx, bx
  jnz @@BConnect12
  cmp bx, 0
  jl  @@BEnd12
  cmp bx, 199
  JG  @@BEnd12
  shl bx, 1
  mov ax, [bp+14]
  mov StartX[bx], ax
  jmp @@BEnd12
@@BConnect12:
  mov ax, [bp+10]
  sub ax, [bp+14]
  shl eax, 16
  mov edx, eax
  sar edx, 31
  idiv ecx
  mov dx, [bp+14]
  shl edx, 16
  mov bx, [bp+12]
@@BNext12:
  cmp bx, 0
  jl  @@BSkip12
  cmp bx, 199
  jg  @@BSkip12
  mov si, bx
  shl si, 1
  mov ecx, edx
  shr ecx, 16
  mov StartX[si], cx
@@BSkip12:
  add edx, eax
  inc bx
  cmp bx, [bp+08]
  jle @@BNext12
@@BEnd12:
  xor ecx, ecx
  mov bx, [bp+16]
  mov cx, [bp+08]
  sub cx, bx
  jnz @@BConnect13
  cmp bx, 0
  jl  @@BEnd13
  cmp bx, 199
  jg  @@BEnd13
  shl bx, 1
  mov ax, [bp+18]
  mov EndX[bx], ax
  mov dx, StartX[bx]
  cmp dx, ax
  jl  @@BEnd13
  mov StartX[bx], ax
  mov EndX[bx], ax
  jmp @@BEnd13
@@BConnect13:
  mov ax, [bp+10]
  sub ax, [bp+18]
  shl eax, 16
  mov edx, eax
  sar edx, 31
  idiv ecx
  mov dx, [bp+18]
  shl edx, 16
  mov bx, [bp+16]
@@BNext13:
  cmp bx, 0
  jl  @@BSkip13
  cmp bx, 199
  jg  @@BSkip13
  mov si, bx
  shl si, 1
  mov ecx, edx
  shr ecx, 16
  mov EndX[si], cx
  mov di, StartX[si]
  cmp di, cx
  jl  @@BSkip13
  mov StartX[si], cx
  mov EndX[si], di
@@BSkip13:
  add edx, eax
  inc bx
  cmp bx, [bp+08]
  jle @@BNext13
@@BEnd13:
  mov ax, [bp+6]
  mov fs, ax
  mov cx, FirstY
  xor dh, dh
  mov di, cx
  mov bx, di
  shl bx, 8
  shl di, 6
  add di, bx
@@BDrawTriF:
  mov si, cx
  shl si, 1
  mov bx, StartX[si]
  cmp bx, 8000h
  je  @@BSkipTriFLine
@@BDrawTriFLine:
  cmp bx, 1
  jl  @@BSkipTriFPixel
  cmp bx, 318
  jg  @@BSkipTriFPixel
  mov dl, es:[di+bx]
  mov bp, bx
  mov bx, dx
  mov al, fs:[bx]
  mov bx, bp
  mov es:[di+bx], al
@@BSkipTriFPixel:
  inc bx
  cmp bx, EndX[si]
  jle @@BDrawTriFLine
@@BSkipTriFLine:
  add di, 320
  inc cx
  cmp cx, LastY
  jle @@BDrawTriF
@@EndTriFB:
  pop bp
  ret 16
PPBlendTri endp

PPProjectVector proc
  push bp
  push ds
  mov bp, sp
  mov ax, [bp+22]
  mov bx, [bp+16]
  mov ds, ax
  mov es, bx
  mov si, [bp+18]
  mov di, [bp+12]
  fld dword ptr [si]
  fld dword ptr [si+8]
  fsubr dword ptr [bp+08]
  fdivr dword ptr [bp+08]
  fmulp
  fistp word ptr es:[di]
  fld dword ptr [si+4]
  fld dword ptr [si+8]
  fsubr dword ptr [bp+08]
  fdivr dword ptr [bp+08]
  fmulp
  fchs
  fistp word ptr es:[di+2]
  fwait
  mov ax, es:[di]
  mov bx, es:[di+2]
  
  add ax, 160
  add bx, 200
  mov es:[di], ax
  mov es:[di+2], bx
  pop ds
  pop bp
  ret 16
PPProjectVector endp

end
