# Get the URL from the configuration
URL=`cat ${PWD}/../input/config.json | grep -ohe '"url":\s*"[^"]\+"' | sed 's;[^:]\+:\s*";;' | sed 's;"$;;'`
NAME=`cat ${PWD}/../input/config.json | grep -ohe '"name":\s*"[^"]\+"' | sed 's;[^:]\+:\s*";;' | sed 's;"$;;'`

SHORT_URL=`echo "${URL}" | sed 's;http[s]\?://;;'`

if [[ "${NAME}" == "" ]]; then
  NAME="${SHORT_URL} Git Repository"
fi

echo 'config.json:'
cat ${PWD}/../input/config.json

# Craft the object
mkdir -p ../output
cd ../output

echo '{' > object.json
echo "\"name\": \"${NAME}\"," >> object.json
echo '"type":"git-repository","install":[{"type":"resource","subtype":"git",' >> object.json
echo "\"source\":\"${URL}\"," >> object.json
echo '"to":"repository",' >> object.json
echo "\"name\":\"${SHORT_URL} Git Repository\"" >> object.json
echo '}]' >> object.json
echo '}' >> object.json

echo
echo 'object.json:'
cat object.json
